/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.util.LinkedHashSet;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class BlockListController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlockListController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private BanList banList;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)this.webContainer.javalin().get("/blocklist/ip", this::blocklistIp)).get("/blocklist/p2p-plain-format", this::blocklistP2pPlain, new RouteRole[]{Role.ANYONE})).get("/blocklist/dat-emule", this::blocklistDatEmule, new RouteRole[]{Role.ANYONE});
    }

    private void blocklistDatEmule(@NotNull Context ctx) {
        LinkedHashSet<IPAddress> remappedIps = new LinkedHashSet<IPAddress>();
        for (IPAddress ipAddress : this.banList.copyKeySet()) {
            if (ipAddress == null) continue;
            ipAddress = IPAddressUtil.remapBanListAddress(ipAddress);
            remappedIps.add(ipAddress);
        }
        StringBuilder builder = new StringBuilder();
        for (IPAddress ipAddress : remappedIps) {
            String start = ipAddress.toPrefixBlock().getLower().withoutPrefixLength().toNormalizedString();
            String end = ipAddress.toPrefixBlock().getUpper().withoutPrefixLength().toNormalizedString();
            builder.append(start).append(" - ").append(end).append(" , 000 , ").append(ipAddress.toNormalizedString()).append("\n");
        }
        ctx.result(builder.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void blocklistP2pPlain(@NotNull Context ctx) {
        void var4_9;
        LinkedHashSet<IPAddress> remappedIps = new LinkedHashSet<IPAddress>();
        for (IPAddress iPAddress : this.banList.copyKeySet()) {
            IPAddress iPAddress2 = IPAddressUtil.remapBanListAddress(iPAddress);
            remappedIps.add(iPAddress2);
        }
        StringBuilder builder = new StringBuilder();
        for (IPAddress iPAddress : remappedIps) {
            String ruleName = UUID.randomUUID().toString().replace("-", "");
            String start = iPAddress.toPrefixBlock().getLower().withoutPrefixLength().toNormalizedString();
            String end = iPAddress.toPrefixBlock().getUpper().withoutPrefixLength().toNormalizedString();
            builder.append(ruleName).append(":").append(start).append("-").append(end).append("\n");
        }
        String string = builder.toString();
        String string2 = ctx.userAgent();
        if (string.isBlank() && string2 != null && string2.startsWith("Transmission")) {
            String string3 = "TransmissionWorkaround:127.127.127.127-127.127.127.127";
        }
        ctx.result((String)var4_9);
    }

    private void blocklistIp(@NotNull Context ctx) {
        LinkedHashSet<IPAddress> remappedIps = new LinkedHashSet<IPAddress>();
        for (IPAddress ipAddress : this.banList.copyKeySet()) {
            ipAddress = IPAddressUtil.remapBanListAddress(ipAddress);
            remappedIps.add(ipAddress);
        }
        StringBuilder builder = new StringBuilder();
        for (IPAddress ipAddress : remappedIps) {
            builder.append(ipAddress.toPrefixBlock().toNormalizedString()).append("\n");
        }
        ctx.result(builder.toString());
    }

    @Override
    public void onDisable() {
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Downloader CIDR Blocklist";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-downloader-cidr-blocklist";
    }
}

