/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.rule.matcher;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.ghostchu.peerbanhelper.util.rule.RuleMatcher;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerNameMatcher
extends RuleMatcher<List<Map.Entry<Pattern, String>>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerNameMatcher.class);
    private List<Map.Entry<Pattern, String>> patterns;

    public PeerNameMatcher(String ruleId, String ruleName, List<List<Map.Entry<Pattern, String>>> ruleData) {
        super(ruleId, ruleName, ruleData);
        this.patterns = ruleData.isEmpty() ? List.of() : ruleData.getFirst();
    }

    @Override
    public void setData(String ruleName, List<List<Map.Entry<Pattern, String>>> ruleData) {
        this.setRuleName(ruleName);
        this.patterns = ruleData.isEmpty() ? List.of() : ruleData.getFirst();
    }

    public long size() {
        return this.patterns.size();
    }

    @Override
    @NotNull
    public MatchResult match0(@NotNull String content) {
        if (this.patterns == null || this.patterns.isEmpty()) {
            return new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent("Patterns set is empty"));
        }
        for (Map.Entry<Pattern, String> entry : this.patterns) {
            Pattern pattern = entry.getKey();
            String comment = entry.getValue();
            try {
                if (!pattern.matcher(content).find()) continue;
                return new MatchResult(MatchResultEnum.TRUE, new TranslationComponent(comment != null ? comment : pattern.pattern()));
            }
            catch (Exception e) {
                log.error("Error matching pattern: {}", (Object)pattern.pattern(), (Object)e);
            }
        }
        return new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent("Given PeerName not matched any pattern"));
    }

    @Override
    public TranslationComponent matcherName() {
        return new TranslationComponent(Lang.RULE_MATCHER_SUB_RULE, this.getRuleName());
    }

    @Override
    public String matcherIdentifier() {
        return "peerbanhelper:peernamematcher";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerNameMatcher)) {
            return false;
        }
        PeerNameMatcher other = (PeerNameMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Map.Entry<Pattern, String>> this$patterns = this.patterns;
        List<Map.Entry<Pattern, String>> other$patterns = other.patterns;
        return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PeerNameMatcher;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Map.Entry<Pattern, String>> $patterns = this.patterns;
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PeerNameMatcher(super=" + super.toString() + ", patterns=" + String.valueOf(this.patterns) + ")";
    }
}

