/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.time;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.time.RestrictedExecResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestrictedExecutor.class);

    public static <T> RestrictedExecResult<T> execute(String name, long timeout, Supplier<T> target) {
        CompletableFuture<T> sandbox = CompletableFuture.supplyAsync(target, Executors.newThreadPerTaskExecutor(Thread.ofPlatform().name("Restricted Executor [" + name + "]").factory()));
        try {
            return new RestrictedExecResult<T>(false, sandbox.get(timeout, TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException e) {
            return new RestrictedExecResult<Object>(true, null);
        }
        catch (InterruptedException e) {
            log.warn(TextManager.tlUI(Lang.THREAD_INTERRUPTED, new Object[0]), (Throwable)e);
            Thread.currentThread().interrupt();
            return new RestrictedExecResult<Object>(false, null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

