/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.Collector;
import java.util.Collection;
import java.util.Map;

public class SeqAddAllFunction
extends AbstractFunction {
    private static final long serialVersionUID = -4406740199823615336L;

    @Override
    public String getName() {
        return "seq.add_all";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object coll1 = arg1.getValue(env);
        Object coll2 = arg2.getValue(env);
        if (coll1 == null) {
            throw new NullPointerException("null seq");
        }
        if (coll2 == null) {
            return arg1;
        }
        Class<?> clazz = coll1.getClass();
        for (Object element : RuntimeUtils.seq(coll2, env)) {
            if (Collection.class.isAssignableFrom(clazz)) {
                ((Collection)coll1).add(element);
                continue;
            }
            if (Map.class.isAssignableFrom(clazz) && element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                ((Map)coll1).put(entry.getKey(), entry.getValue());
                continue;
            }
            if (Collector.class.isAssignableFrom(clazz)) {
                ((Collector)coll1).add(element);
                continue;
            }
            throw new IllegalArgumentException("Can't add value: " + element + " into " + arg1.desc(env));
        }
        return arg1;
    }
}

