/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class BeeTransactionIsolationNames {
    public static final String TRANSACTION_NONE = "NONE";
    public static final String TRANSACTION_READ_COMMITTED = "READ_COMMITTED";
    public static final String TRANSACTION_READ_UNCOMMITTED = "READ_UNCOMMITTED";
    public static final String TRANSACTION_REPEATABLE_READ = "REPEATABLE_READ";
    public static final String TRANSACTION_SERIALIZABLE = "SERIALIZABLE";
    static final String TRANS_ISOLATION_CODE_LIST = "0,2,1,4,8";
    private static final Map<String, Integer> IsolationNameToCodeMap = new HashMap<String, Integer>(5);

    private BeeTransactionIsolationNames() {
    }

    static Integer getTransactionIsolationCode(String name) {
        return IsolationNameToCodeMap.get(name.toUpperCase(Locale.US));
    }

    static {
        IsolationNameToCodeMap.put(TRANSACTION_NONE, 0);
        IsolationNameToCodeMap.put(TRANSACTION_READ_COMMITTED, 2);
        IsolationNameToCodeMap.put(TRANSACTION_READ_UNCOMMITTED, 1);
        IsolationNameToCodeMap.put(TRANSACTION_REPEATABLE_READ, 4);
        IsolationNameToCodeMap.put(TRANSACTION_SERIALIZABLE, 8);
    }
}

