/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import javax.transaction.xa.XAResource;
import org.stone.beecp.BeeConnectionPredicate;
import org.stone.beecp.exception.ConnectionRecycledException;
import org.stone.beecp.pool.ConnectionCreatingInfo;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.FastConnectionPool;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyStatementBase;
import org.stone.tools.CommonUtil;

final class PooledConnection {
    private static final boolean[] Default_Reset_Flags = new boolean[6];
    private final FastConnectionPool pool;
    boolean defaultAutoCommit;
    int defaultTransactionIsolation;
    boolean defaultReadOnly;
    String defaultCatalog;
    String defaultSchema;
    int defaultNetworkTimeout;
    boolean forceDirtyWhenSetSchema;
    boolean forceDirtyWhenSetCatalog;
    volatile ConnectionCreatingInfo creatingInfo;
    Connection rawConn;
    XAResource rawXaRes;
    volatile int state;
    volatile long lastAccessTime;
    int openStmSize;
    boolean curAutoCommit;
    boolean commitDirtyInd;
    ProxyConnectionBase proxyInUsing;
    private int resetCnt;
    private boolean[] resetFlags;
    private ProxyStatementBase[] openStatements;
    private boolean enableDefaultCatalog;
    private boolean enableDefaultSchema;
    private boolean enableDefaultReadOnly;
    private boolean enableDefaultAutoCommit;
    private boolean enableDefaultTransactionIsolation;
    private boolean supportNetworkTimeoutInd;
    private ThreadPoolExecutor networkTimeoutExecutor;
    private List<Integer> sqlExceptionCodeList;
    private List<String> sqlExceptionStateList;
    private BeeConnectionPredicate predicate;

    PooledConnection(FastConnectionPool pool) {
        this.pool = pool;
    }

    void init(boolean useDefaultAutoCommit, boolean defaultAutoCommit, boolean useDefaultTransactionIsolation, int defaultTransactionIsolation, boolean useDefaultReadOnly, boolean defaultReadOnly, boolean useDefaultCatalog, String defaultCatalog, boolean forceDirtyWhenSetCatalog, boolean useDefaultSchema, String defaultSchema, boolean forceDirtyWhenSetSchema, boolean supportNetworkTimeoutInd, int defaultNetworkTimeout, ThreadPoolExecutor networkTimeoutExecutor, List<Integer> sqlExceptionCodeList, List<String> sqlExceptionStateList, BeeConnectionPredicate predicate) {
        this.enableDefaultAutoCommit = useDefaultAutoCommit;
        this.defaultAutoCommit = defaultAutoCommit;
        this.enableDefaultTransactionIsolation = useDefaultTransactionIsolation;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.enableDefaultReadOnly = useDefaultReadOnly;
        this.defaultReadOnly = defaultReadOnly;
        this.enableDefaultCatalog = useDefaultCatalog;
        this.defaultCatalog = defaultCatalog;
        this.forceDirtyWhenSetCatalog = forceDirtyWhenSetCatalog;
        this.enableDefaultSchema = useDefaultSchema;
        this.defaultSchema = defaultSchema;
        this.forceDirtyWhenSetSchema = forceDirtyWhenSetSchema;
        this.supportNetworkTimeoutInd = supportNetworkTimeoutInd;
        this.defaultNetworkTimeout = defaultNetworkTimeout;
        this.networkTimeoutExecutor = networkTimeoutExecutor;
        this.sqlExceptionCodeList = sqlExceptionCodeList;
        this.sqlExceptionStateList = sqlExceptionStateList;
        this.predicate = predicate;
    }

    void setRawConnection(int state, Connection rawConn, XAResource rawXaRes) throws SQLException {
        if (this.enableDefaultAutoCommit && this.defaultAutoCommit != rawConn.getAutoCommit()) {
            rawConn.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.enableDefaultTransactionIsolation && this.defaultTransactionIsolation - rawConn.getTransactionIsolation() != 0) {
            rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.enableDefaultReadOnly && this.defaultReadOnly != rawConn.isReadOnly()) {
            rawConn.setReadOnly(this.defaultReadOnly);
        }
        if (this.enableDefaultCatalog && !Objects.equals(this.defaultCatalog, rawConn.getCatalog())) {
            rawConn.setCatalog(this.defaultCatalog);
        }
        if (this.enableDefaultSchema && !Objects.equals(this.defaultSchema, rawConn.getSchema())) {
            rawConn.setSchema(this.defaultSchema);
        }
        this.setRawConnection2(state, rawConn, rawXaRes);
    }

    void setRawConnection2(int state, Connection rawConn, XAResource rawXaRes) {
        this.rawConn = rawConn;
        this.rawXaRes = rawXaRes;
        this.resetFlags = new boolean[6];
        this.curAutoCommit = this.defaultAutoCommit;
        this.openStatements = new ProxyStatementBase[10];
        this.state = state;
        this.lastAccessTime = System.currentTimeMillis();
    }

    void abortSelf() {
        this.pool.abort(this, "abort");
    }

    void recycleSelf() throws SQLException {
        try {
            this.proxyInUsing = null;
            this.resetRawConn();
            this.pool.recycle(this);
        }
        catch (Throwable e) {
            this.pool.abort(this, "bad");
            throw e instanceof SQLException ? (SQLException)e : new ConnectionRecycledException(e);
        }
    }

    void onRemove(String msg) {
        this.pool.logPrinter.info("BeeCP({})-begin to remove a pooled connection:{} for cause:{}", this.pool.poolName, this, msg);
        try {
            this.resetRawConn();
        }
        catch (Throwable e) {
            this.pool.logPrinter.warn("BeeCP({})-resetting connection failed", this.pool.poolName, e);
        }
        finally {
            ConnectionPoolStatics.oclose(this.rawConn);
            this.rawConn = null;
            this.rawXaRes = null;
            this.proxyInUsing = null;
            this.resetFlags = null;
            this.openStatements = null;
            this.state = 0;
        }
    }

    void registerStatement(ProxyStatementBase s) {
        if (this.openStmSize == this.openStatements.length) {
            ProxyStatementBase[] array = new ProxyStatementBase[this.openStmSize << 1];
            System.arraycopy(this.openStatements, 0, array, 0, this.openStmSize);
            this.openStatements = array;
        }
        this.openStatements[this.openStmSize++] = s;
    }

    void unregisterStatement(ProxyStatementBase s) {
        for (int i = this.openStmSize - 1; i >= 0; --i) {
            if (s != this.openStatements[i]) continue;
            int m = this.openStmSize - i - 1;
            if (m > 0) {
                System.arraycopy(this.openStatements, i + 1, this.openStatements, i, m);
            }
            this.openStatements[--this.openStmSize] = null;
            return;
        }
    }

    void clearStatement() {
        for (int i = 0; i < this.openStmSize; ++i) {
            ProxyStatementBase s = this.openStatements[i];
            if (s == null) continue;
            s.unregister = true;
            this.openStatements[i] = null;
            ConnectionPoolStatics.oclose(s);
        }
        this.openStmSize = 0;
    }

    void updateAccessTime() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    void checkSQLException(SQLException e) {
        ProxyConnectionBase proxyInUsing = this.proxyInUsing;
        if (proxyInUsing == null) {
            return;
        }
        if (this.predicate != null) {
            String msg = this.predicate.evictionTest(e);
            if (CommonUtil.isNotBlank(msg)) {
                this.pool.logPrinter.warn("BeeCP({})-connection has been broken because of predicate result({})", this.pool.poolName, msg);
                proxyInUsing.abort(null);
            }
        } else {
            int code = e.getErrorCode();
            if (code != 0 && this.sqlExceptionCodeList != null && this.sqlExceptionCodeList.contains(code)) {
                this.pool.logPrinter.warn("BeeCP({})-connection has been broken because of error code({})", this.pool.poolName, code);
                proxyInUsing.abort(null);
                return;
            }
            String state = e.getSQLState();
            if (state != null && this.sqlExceptionStateList != null && this.sqlExceptionStateList.contains(state)) {
                this.pool.logPrinter.warn("BeeCP({})-connection has been broken because of SQL state({})", this.pool.poolName, state);
                proxyInUsing.abort(null);
            }
        }
    }

    boolean supportNetworkTimeoutSet() {
        return this.supportNetworkTimeoutInd;
    }

    void setResetInd(int i, boolean changed) {
        if (this.resetFlags[i] != changed) {
            this.resetFlags[i] = changed;
            this.resetCnt += changed ? 1 : -1;
        }
    }

    private void resetRawConn() throws SQLException {
        if (this.commitDirtyInd) {
            this.rawConn.rollback();
            this.commitDirtyInd = false;
        }
        if (this.resetCnt > 0) {
            if (this.resetFlags[0]) {
                this.rawConn.setAutoCommit(this.defaultAutoCommit);
                this.curAutoCommit = this.defaultAutoCommit;
            }
            if (this.resetFlags[1]) {
                this.rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
            }
            if (this.resetFlags[2]) {
                this.rawConn.setReadOnly(this.defaultReadOnly);
            }
            if (this.resetFlags[3]) {
                this.rawConn.setCatalog(this.defaultCatalog);
            }
            if (this.resetFlags[4]) {
                this.rawConn.setSchema(this.defaultSchema);
            }
            if (this.resetFlags[5]) {
                this.rawConn.setNetworkTimeout(this.networkTimeoutExecutor, this.defaultNetworkTimeout);
            }
            this.resetCnt = 0;
            System.arraycopy(Default_Reset_Flags, 0, this.resetFlags, 0, 6);
        }
        this.rawConn.clearWarnings();
    }
}

