/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper;

import com.ghostchu.peerbanhelper.CrashManager;
import com.ghostchu.peerbanhelper.DownloaderServerImpl;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.databasent.DatabaseDriver;
import com.ghostchu.peerbanhelper.downloader.DownloaderManager;
import com.ghostchu.peerbanhelper.event.program.PBHServerStartedEvent;
import com.ghostchu.peerbanhelper.event.program.webserver.WebServerStartedEvent;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.gui.TaskbarState;
import com.ghostchu.peerbanhelper.module.FeatureModule;
import com.ghostchu.peerbanhelper.module.ModuleManager;
import com.ghostchu.peerbanhelper.module.impl.monitor.ActiveMonitoringModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.PeerRecodingServiceModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.SessionAnalyseServiceModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.SwarmTrackingModule;
import com.ghostchu.peerbanhelper.module.impl.rule.AntiVampire;
import com.ghostchu.peerbanhelper.module.impl.rule.AutoRangeBan;
import com.ghostchu.peerbanhelper.module.impl.rule.BtnNetworkOnline;
import com.ghostchu.peerbanhelper.module.impl.rule.ClientNameBlacklist;
import com.ghostchu.peerbanhelper.module.impl.rule.ExpressionRule;
import com.ghostchu.peerbanhelper.module.impl.rule.IPBlackList;
import com.ghostchu.peerbanhelper.module.impl.rule.IPBlackRuleList;
import com.ghostchu.peerbanhelper.module.impl.rule.IdleConnectionDosProtection;
import com.ghostchu.peerbanhelper.module.impl.rule.MultiDialingBlocker;
import com.ghostchu.peerbanhelper.module.impl.rule.PeerIdBlacklist;
import com.ghostchu.peerbanhelper.module.impl.rule.ProgressCheatBlocker;
import com.ghostchu.peerbanhelper.module.impl.webapi.BlockListController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHAlertController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHAuthenticateController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHAutoStunController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHBackgroundTaskController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHBanController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHChartController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHDownloaderController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHEasterEggController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHGeneralController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHLabController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHLogsController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHMetadataController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHMetricsController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHOOBEController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHPeerController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHPlusController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHPushController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHTorrentController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHUtilitiesController;
import com.ghostchu.peerbanhelper.module.impl.webapi.RuleSubController;
import com.ghostchu.peerbanhelper.platform.Platform;
import com.ghostchu.peerbanhelper.platform.types.EcoQosAPI;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.umami.UmamiHelper;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import io.sentry.Sentry;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeerBanHelper
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerBanHelper.class);
    @Autowired
    private DownloaderManager downloaderManager;
    @Autowired
    private DownloaderServerImpl downloaderServer;
    private int httpdPort;
    @Autowired
    private ModuleManager moduleManager;
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private AlertManager alertManager;
    @Autowired
    private CrashManager crashManager;
    @Autowired
    private IPDBManager iPDBManager;
    @Autowired
    private UmamiHelper telemetry;
    @Autowired
    private DatabaseDriver databaseDriver;

    public PeerBanHelper() {
        this.reloadConfig();
    }

    private void reloadConfig() {
        this.httpdPort = ExternalSwitch.parseInt("pbh.port", Main.getMainConfig().getInt("server.http"));
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        this.moduleManager.reloadModuleStates();
        return super.reloadModule();
    }

    public void start() {
        this.loadPlatformFeatures();
        this.checkKnownCrashes();
        this.postCompatibilityCheck();
        Main.getReloadManager().register((Reloadable)this);
        this.registerModules();
        this.sendSnapshotAlert();
        this.downloaderServer.load();
        this.downloaderServer.loadBanListToMemory();
        Main.getGuiManager().taskbarControl().updateProgress(null, TaskbarState.OFF, 0.0f);
        this.crashManager.putRunningFlag();
        Main.getEventBus().post((Object)new PBHServerStartedEvent());
        this.registerHttpServer();
        Main.getGuiManager().onPBHFullyStarted(this);
        if (this.webContainer.getToken() == null || this.webContainer.getToken().isBlank()) {
            for (int i = 0; i < 50; ++i) {
                log.error(TextManager.tlUI(Lang.PBH_OOBE_REQUIRED, "http://127.0.0.1:" + this.webContainer.javalin().port()));
            }
            Main.getGuiManager().openUrlInBrowser("http://127.0.0.1:" + this.webContainer.javalin().port());
        }
        this.runTestCode();
        this.telemetry.sendBootEvent();
        CommonUtil.getScheduler().scheduleWithFixedDelay(this.telemetry::sendHeartbeatEvent, 1L, 1L, TimeUnit.HOURS);
    }

    private void loadPlatformFeatures() {
        Thread.startVirtualThread(() -> {
            Platform platform = Main.getPlatform();
            if (platform == null) {
                return;
            }
            EcoQosAPI ecoQosAPI = platform.getEcoQosAPI();
            if (ecoQosAPI != null && Main.getMainConfig().getBoolean("performance.windows-ecoqos-api")) {
                ecoQosAPI.apply();
            }
        });
    }

    private void checkKnownCrashes() {
        RuntimeMXBean bean;
        this.crashManager.checkCrashRecovery();
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.startsWith("win") && Main.getGuiManager().isGuiAvailable() && !(bean = ManagementFactory.getRuntimeMXBean()).getVmVendor().contains("JetBrains") && !this.alertManager.identifierAlertExistsIncludeRead("incompatibility-jre-windows-liberica")) {
            this.alertManager.publishAlert(false, AlertLevel.WARN, "incompatibility-jre-windows-liberica", new TranslationComponent(Lang.JBR_REQUIRED_TITLE), new TranslationComponent(Lang.JBR_REQUIRED_DESCRIPTION, bean.getVmVendor(), bean.getVmVersion()));
            Main.getGuiManager().createDialog(Level.WARN, TextManager.tlUI(new TranslationComponent(Lang.JBR_REQUIRED_TITLE)), TextManager.tlUI(new TranslationComponent(Lang.JBR_REQUIRED_DESCRIPTION, bean.getVmVendor(), bean.getVmVersion())), () -> {});
        }
    }

    private void postCompatibilityCheck() {
        if (ExternalSwitch.parseBoolean("pbh.forceBitnessCheckFail")) {
            ExchangeMap.UNSUPPORTED_PLATFORM = true;
            ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("unsupported-platform", 10, TextManager.tlUI(Lang.TITLE_INCOMPATIBLE_PLATFORM, new Object[0])));
            log.warn(TextManager.tlUI(Lang.INCOMPATIBLE_BITNESS_LOG, new Object[0]));
            if (!this.alertManager.identifierAlertExistsIncludeRead("incomaptible-bitness")) {
                this.alertManager.publishAlert(false, AlertLevel.WARN, "incomaptible-bitness", new TranslationComponent(Lang.INCOMPATIBLE_BITNESS_TITLE), new TranslationComponent(Lang.INCOMPATIBLE_BITNESS_DESCRIPTION));
                Main.getGuiManager().createNotification(Level.WARN, TextManager.tlUI(Lang.INCOMPATIBLE_BITNESS_TITLE, new Object[0]), TextManager.tlUI(Lang.INCOMPATIBLE_BITNESS_DESCRIPTION, new Object[0]));
            }
        }
        if (ExternalSwitch.parseBoolean("pbh.app-v")) {
            ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("app-v", 10, TextManager.tlUI(Lang.TITLE_APP_V_CONTAINER, new Object[0])));
        }
    }

    private void runTestCode() {
        if (!Main.getMeta().isSnapshotOrBeta()) {
            return;
        }
        ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("debug-mode", 20, TextManager.tlUI(Lang.GUI_TITLE_DEBUG, new Object[0])));
    }

    private void sendSnapshotAlert() {
        if (Main.getMeta().isSnapshotOrBeta()) {
            this.alertManager.publishAlert(false, AlertLevel.INFO, "unstable-alert", new TranslationComponent(Lang.ALERT_SNAPSHOT), new TranslationComponent(Lang.ALERT_SNAPSHOT_DESCRIPTION));
        } else {
            this.alertManager.markAlertAsRead("unstable-alert");
        }
    }

    public void shutdown() {
        this.downloaderServer.close();
        this.moduleManager.unregisterAll();
        try {
            this.downloaderManager.close();
        }
        catch (Exception e) {
            log.warn("Unable to safe shutdown downloader manager", (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
        try {
            this.databaseDriver.close();
        }
        catch (Exception e) {
            log.warn("Unable to safe shutdown database driver", (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
        Main.getReloadManager().unregister((Reloadable)this);
        log.info(TextManager.tlUI(Lang.SHUTDOWN_DONE, new Object[0]));
    }

    private void registerHttpServer() {
        this.webContainer.setSpaHandlerToReady();
        Main.getEventBus().post((Object)new WebServerStartedEvent());
    }

    private void registerModules() {
        log.info(TextManager.tlUI(Lang.WAIT_FOR_MODULES_STARTUP, new Object[0]));
        ArrayList<Class> moduleClasses = new ArrayList<Class>();
        moduleClasses.add(PBHGeneralController.class);
        moduleClasses.add(IPBlackList.class);
        moduleClasses.add(PeerIdBlacklist.class);
        moduleClasses.add(ClientNameBlacklist.class);
        moduleClasses.add(ExpressionRule.class);
        moduleClasses.add(ProgressCheatBlocker.class);
        moduleClasses.add(MultiDialingBlocker.class);
        moduleClasses.add(AutoRangeBan.class);
        moduleClasses.add(BtnNetworkOnline.class);
        moduleClasses.add(BlockListController.class);
        moduleClasses.add(IPBlackRuleList.class);
        moduleClasses.add(PBHBackgroundTaskController.class);
        moduleClasses.add(PBHMetricsController.class);
        moduleClasses.add(PBHBanController.class);
        moduleClasses.add(PBHMetadataController.class);
        moduleClasses.add(PBHDownloaderController.class);
        moduleClasses.add(RuleSubController.class);
        moduleClasses.add(PBHAuthenticateController.class);
        moduleClasses.add(ActiveMonitoringModule.class);
        moduleClasses.add(PBHPlusController.class);
        moduleClasses.add(PBHOOBEController.class);
        moduleClasses.add(PBHChartController.class);
        moduleClasses.add(PBHTorrentController.class);
        moduleClasses.add(PBHPeerController.class);
        moduleClasses.add(PBHAlertController.class);
        moduleClasses.add(PBHLogsController.class);
        moduleClasses.add(PBHPushController.class);
        moduleClasses.add(PBHLabController.class);
        moduleClasses.add(PBHEasterEggController.class);
        moduleClasses.add(PBHUtilitiesController.class);
        moduleClasses.add(SwarmTrackingModule.class);
        moduleClasses.add(PBHAutoStunController.class);
        moduleClasses.add(IdleConnectionDosProtection.class);
        moduleClasses.add(SessionAnalyseServiceModule.class);
        moduleClasses.add(PeerRecodingServiceModule.class);
        moduleClasses.add(AntiVampire.class);
        moduleClasses.parallelStream().forEach(moduleClass -> this.moduleManager.register((Class<? extends FeatureModule>)moduleClass));
    }

    @Deprecated(forRemoval=true)
    public IPDBManager.IPDBResponse queryIPDB(InetAddress address) {
        return this.iPDBManager.queryIPDB(address);
    }

    @Nullable
    public JavalinWebContainer getWebContainer() {
        return this.webContainer;
    }

    @Generated
    public DownloaderManager getDownloaderManager() {
        return this.downloaderManager;
    }

    @Generated
    public DownloaderServerImpl getDownloaderServer() {
        return this.downloaderServer;
    }

    @Generated
    public int getHttpdPort() {
        return this.httpdPort;
    }
}

