/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.config;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.config.UpdateScript;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.configuration.InvalidConfigurationException;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfileUpdateScript {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileUpdateScript.class);
    private final YamlConfiguration conf;

    public ProfileUpdateScript(YamlConfiguration conf) {
        this.conf = conf;
    }

    @UpdateScript(version=37)
    public void analyseModulesCacheStuff(YamlConfiguration bundled) {
        this.conf.set("module.peer-analyse-service.swarm-tracking.data-flush-interval", bundled.get("module.peer-analyse-service.swarm-tracking.data-flush-interval"));
        if (this.conf.getLong("module.peer-analyse-service.peer-recording.data-flush-interval") == 20000L) {
            this.conf.set("module.peer-analyse-service.peer-recording.data-flush-interval", bundled.get("module.peer-analyse-service.peer-recording.data-flush-interval"));
        }
    }

    @UpdateScript(version=36)
    public void antiVampire(YamlConfiguration bundled) {
        this.conf.set("module.anti-vampire", bundled.get("module.anti-vampire"));
    }

    @UpdateScript(version=35)
    public void removeXunleiRules() {
        List peerIdList = this.conf.getStringList("module.peer-id-blacklist.banned-peer-id");
        peerIdList.removeIf(s -> "{\"method\":\"STARTS_WITH\",\"content\":\"-xl\"}".equals(s));
        this.conf.set("module.peer-id-blacklist.banned-peer-id", (Object)peerIdList);
        List clientNameList = this.conf.getStringList("module.client-name-blacklist.banned-client-name");
        clientNameList.removeIf(s -> "{\"method\":\"CONTAINS\",\"content\":\"xunlei\"}".equals(s));
        clientNameList.removeIf(s -> "{\"method\":\"STARTS_WITH\",\"content\":\"-XL\"}".equals(s));
        this.conf.set("module.client-name-blacklist.banned-client-name", (Object)clientNameList);
    }

    @UpdateScript(version=34)
    public void analyseServiceSection(YamlConfiguration bundled) {
        this.conf.set("module.peer-analyse-service", bundled.get("module.peer-analyse-service"));
        this.conf.set("module.peer-analyse-service.peer-recording.data-retention-time", this.conf.get("module.active-monitoring.data-retention-time"));
        this.conf.set("module.peer-analyse-service.peer-recording.data-cleanup-interval", this.conf.get("module.active-monitoring.data-cleanup-interval"));
        this.conf.set("module.active-monitoring.data-retention-time", null);
        this.conf.set("module.active-monitoring.data-cleanup-interval", null);
        this.conf.set("module.peer-analyse-service.swarm-tracking.enabled", this.conf.get("module.swarm-tracking.enabled"));
        this.conf.set("module.swarm-tracking", null);
    }

    @UpdateScript(version=32)
    public void fixSwarmTracking(YamlConfiguration bundled) {
        this.conf.set("module.swarm-tracking", bundled.get("module.swarm-tracking"));
    }

    @UpdateScript(version=31)
    public void idleConnectionDosProtectionUpdate(YamlConfiguration bundled) {
        this.conf.set("module.idle-connection-dos-protection", bundled.get("module.idle-connection-dos-protection"));
    }

    @UpdateScript(version=30)
    public void idleConnectionDosProtection(YamlConfiguration bundled) {
        this.conf.set("module.idle-connection-dos-protection", bundled.get("module.idle-connection-dos-protection"));
    }

    @UpdateScript(version=29)
    public void ipAddressBlockerNetType() {
        ConfigurationSection section = this.conf.getConfigurationSection("module.ip-address-blocker.net-type");
        if (section == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (section.getBoolean("wideband")) {
            keys.add("wideband");
        }
        if (section.getBoolean("base-station")) {
            keys.add("baseStation");
        }
        if (section.getBoolean("government-and-enterprise-line")) {
            keys.add("governmentAndEnterpriseLine");
        }
        if (section.getBoolean("business-platform")) {
            keys.add("businessPlatform");
        }
        if (section.getBoolean("backbone-network")) {
            keys.add("backboneNetwork");
        }
        if (section.getBoolean("ip-private-network")) {
            keys.add("ipPrivateNetwork");
        }
        if (section.getBoolean("internet-cafe")) {
            keys.add("internetCafe");
        }
        if (section.getBoolean("iot")) {
            keys.add("iot");
        }
        if (section.getBoolean("datacenter")) {
            keys.add("dataCenter");
        }
        this.conf.set("module.ip-address-blocker.net-type", keys);
    }

    @UpdateScript(version=28)
    public void swarmTrackingEnabled(YamlConfiguration bundled) {
        this.conf.set("module.swarm-tracking.enabled", (Object)true);
    }

    @UpdateScript(version=27)
    public void trafficSpeedLimiter(YamlConfiguration bundled) {
        this.conf.set("module.active-monitoring.traffic-capping", null);
        this.conf.set("module.active-monitoring.traffic-sliding-capping.enabled", (Object)false);
        this.conf.set("module.active-monitoring.traffic-sliding-capping.daily-max-allowed-upload-traffic", (Object)0xC80000000L);
        this.conf.set("module.active-monitoring.traffic-sliding-capping.max-speed", (Object)0xA00000);
        this.conf.set("module.active-monitoring.traffic-sliding-capping.min-speed", (Object)0);
    }

    @UpdateScript(version=25)
    public void removeIPFS(YamlConfiguration bundled) {
        this.conf.set("decentralized", null);
    }

    @UpdateScript(version=24)
    public void ptrBlacklistAndUpdateTorExitNodeList(YamlConfiguration bundled) {
        this.conf.set("module.ptr-blacklist", bundled.get("module.ptr-blacklist"));
        if ("https://cdn.jsdelivr.net/gh/platformcosmo/Tor-IP-Addresses/tor-exit-nodes.lst".equals(this.conf.getString("module.ip-address-blocker-rules.rules.tor-exit-nodes.url"))) {
            this.conf.set("module.ip-address-blocker-rules.rules.tor-exit-nodes.url", (Object)"https://cdn.jsdelivr.net/gh/7c/torfilter/lists/txt/torfilter-1d-flat.txt");
        }
    }

    @UpdateScript(version=22)
    public void workaroundForBadWebUI() {
        if (this.conf.getInt("module.auto-range-ban.ipv6") == 32) {
            this.conf.set("module.auto-range-ban.ipv6", (Object)60);
        }
    }

    @UpdateScript(version=21)
    public void dailyTrafficAlert() {
        this.conf.set("module.active-monitoring.traffic-monitoring.daily", (Object)-1);
    }

    @UpdateScript(version=20)
    public void v4v6Tolerate() {
        this.conf.set("module.multi-dialing-blocker.tolerate-num-ipv4", (Object)2);
        this.conf.set("module.multi-dialing-blocker.tolerate-num-ipv6", (Object)5);
        this.conf.set("module.multi-dialing-blocker.tolerate-num", null);
    }

    @UpdateScript(version=19)
    public void fastPcbTesting() {
        this.conf.set("module.progress-cheat-blocker.fast-pcb-test-percentage", (Object)0.1);
        this.conf.set("module.progress-cheat-blocker.fast-pcb-test-block-duration", (Object)15000);
    }

    @UpdateScript(version=18)
    public void banDelayWait() {
        this.conf.set("module.progress-cheat-blocker.max-wait-duration", (Object)30000);
    }

    @UpdateScript(version=17)
    public void updateProfiles() {
        List bannedPeerIds = this.conf.getStringList("module.peer-id-blacklist.banned-peer-id");
        bannedPeerIds.add("{\"method\":\"CONTAINS\",\"content\":\"-rn0.0.0\"}");
        this.conf.set("module.peer-id-blacklist.banned-peer-id", (Object)bannedPeerIds);
        List bannedClientNames = this.conf.getStringList("module.client-name-blacklist.banned-client-name");
        bannedClientNames.add("{\"method\":\"CONTAINS\",\"content\":\"rain 0.0.0\"}");
        bannedClientNames.add("{\"method\":\"CONTAINS\",\"content\":\"gopeed dev\"}");
        this.conf.set("module.client-name-blacklist.banned-client-name", (Object)bannedClientNames);
        this.conf.set("module.active-monitoring.enabled", (Object)true);
    }

    @UpdateScript(version=16)
    public void progressCheckerIPv6PrefixLength() {
        ConfigurationSection section = this.conf.getConfigurationSection("module.progress-cheat-blocker");
        if (section.getInt("ipv6-prefix-length") == 128) {
            this.conf.set("module.progress-cheat-blocker.ipv6-prefix-length", (Object)60);
        }
    }

    @UpdateScript(version=15)
    public void addCitiesBanningRule() {
        this.conf.set("module.ip-address-blocker.cities", List.of("\u793a\u4f8b\u6d77\u5357"));
        ConfigurationSection section = this.conf.getConfigurationSection("module.ip-address-blocker-rules.rules");
        for (String key : section.getKeys(false)) {
            ConfigurationSection rule = section.getConfigurationSection(key);
            String url = rule.getString("url", "");
            if (!"https://cdn.jsdelivr.net/gh/PBH-BTN/BTN-Collected-Rules@master/combine/all.txt".equals(url) && !"https://fastly.jsdelivr.net/gh/PBH-BTN/BTN-Collected-Rules@master/combine/all.txt".equals(url)) continue;
            rule.set("url", (Object)"https://bcr.pbh-btn.ghorg.ghostchu-services.top/combine/all.txt");
        }
    }

    @UpdateScript(version=14)
    public void activeMonitoringAndNetTypeAndPCBPersist() {
        this.conf.set("module.active-monitoring.enabled", (Object)false);
        this.conf.set("module.active-monitoring.data-retention-time", (Object)5184000000L);
        this.conf.set("module.active-monitoring.data-cleanup-interval", (Object)604800000L);
        this.conf.set("module.ip-address-blocker.net-type.wideband", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.base-station", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.government-and-enterprise-line", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.business-platform", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.backbone-network", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.ip-private-network", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.internet-cafe", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.iot", (Object)false);
        this.conf.set("module.ip-address-blocker.net-type.datacenter", (Object)false);
        this.conf.set("module.progress-cheat-blocker.enable-persist", (Object)true);
        this.conf.set("module.progress-cheat-blocker.persist-duration", (Object)1209600000);
    }

    @UpdateScript(version=13)
    public void skip() {
    }

    @UpdateScript(version=12)
    public void patchProgressCheckBlocker() {
        this.conf.set("module.progress-cheat-blocker.ban-duration", (Object)"default");
    }

    @UpdateScript(version=11)
    public void reAddXL0019() {
        List bannedPeerIds = this.conf.getStringList("module.peer-id-blacklist.banned-peer-id");
        bannedPeerIds.removeIf(s -> s.contains("-xl0019"));
        this.conf.set("module.peer-id-blacklist.banned-peer-id", (Object)bannedPeerIds);
        List bannedClientNames = this.conf.getStringList("module.client-name-blacklist.banned-client-name");
        bannedClientNames.removeIf(s -> s.contains("xunlei 0019") || s.contains("xunlei 0.0.1.9"));
        this.conf.set("module.client-name-blacklist.banned-client-name", (Object)bannedClientNames);
        File scripts = new File(Main.getDataDirectory(), "scripts");
        File thunderCheckScript = new File(scripts, "thunder-check.av");
        if (thunderCheckScript.exists()) {
            thunderCheckScript.delete();
        }
    }

    @UpdateScript(version=10)
    public void addBanDuration() {
        ConfigurationSection module = this.conf.getConfigurationSection("module");
        if (module != null) {
            for (String key : module.getKeys(false)) {
                ConfigurationSection mSec = module.getConfigurationSection(key);
                if (mSec == null) continue;
                mSec.set("ban-duration", (Object)"default");
            }
        }
    }

    @UpdateScript(version=9)
    public void updateXmRules() {
        List bannedPeerIds = this.conf.getStringList("module.peer-id-blacklist.banned-peer-id");
        bannedPeerIds.add("{\"method\":\"STARTS_WITH\",\"content\":\"-xm\"}");
        this.conf.set("module.peer-id-blacklist.banned-peer-id", (Object)bannedPeerIds);
        List bannedClientNames = this.conf.getStringList("module.client-name-blacklist.banned-client-name");
        bannedClientNames.add("{\"method\":\"STARTS_WITH\",\"content\":\"xm/torrent\"}");
        this.conf.set("module.client-name-blacklist.banned-client-name", (Object)bannedClientNames);
    }

    @UpdateScript(version=8)
    public void bigUpdate() {
        this.conf.set("ignore-peers-from-addresses", List.of("10.0.0.0/8", "172.16.0.0/12", "192.168.0.0/16", "fc00::/7", "fd00::/8", "100.64.0.0/10", "169.254.0.0/16", "127.0.0.0/8", "fe80::/10"));
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.getOptions().setParseComments(true);
        try (InputStream in = Main.class.getResourceAsStream("/profile.yml");){
            if (in == null) {
                log.error("Failed to upgrade configuration, no resources");
                System.exit(1);
                return;
            }
            String str = new String(in.readAllBytes(), StandardCharsets.UTF_8);
            configuration.loadFromString(str);
            this.conf.set("module.expression-engine", configuration.get("module.expression-engine"));
        }
        catch (IOException | InvalidConfigurationException e) {
            log.error("Failed to upgrade configuration", e);
            System.exit(1);
        }
    }

    @UpdateScript(version=7)
    public void progressCheckerIPPrefixLength() {
        this.conf.set("module.progress-cheat-blocker.ipv4-prefix-length", (Object)32);
        this.conf.set("module.progress-cheat-blocker.ipv6-prefix-length", (Object)64);
    }

    @UpdateScript(version=5)
    public void subModule() {
        this.conf.set("module.ip-address-blocker-rules.enabled", (Object)false);
        this.conf.set("module.ip-address-blocker-rules.check-interval", (Object)86400000);
        this.conf.set("module.ip-address-blocker-rules.rules.example-rule.enabled", (Object)false);
        this.conf.set("module.ip-address-blocker-rules.rules.example-rule.name", (Object)"Example");
        this.conf.set("module.ip-address-blocker-rules.rules.example-rule.url", (Object)"https://example.com/example.txt");
    }

    @UpdateScript(version=4)
    public void ipDatabase() {
        this.conf.set("module.ip-address-blocker.asns", new ArrayList());
        this.conf.set("module.ip-address-blocker.regions", new ArrayList());
    }

    @UpdateScript(version=3)
    public void multiDialingBlocker() {
        this.conf.set("module.multi-dialing-blocker.enabled", (Object)false);
        this.conf.set("module.multi-dialing-blocker.subnet-mask-length", (Object)24);
        this.conf.set("module.multi-dialing-blocker.subnet-mask-v6-length", (Object)64);
        this.conf.set("module.multi-dialing-blocker.tolerate-num", (Object)3);
        this.conf.set("module.multi-dialing-blocker.cache-lifespan", (Object)86400);
        this.conf.set("module.multi-dialing-blocker.keep-hunting", (Object)true);
        this.conf.set("module.multi-dialing-blocker.keep-hunting-time", (Object)2592000);
    }

    @UpdateScript(version=2)
    public void newRuleSyntax() {
        List<String> peerId = this.conf.getStringList("module.peer-id-blacklist.exclude-peer-id");
        List<String> clientName = this.conf.getStringList("module.client-name-blacklist.exclude-client-name");
        peerId = this.convertRuleStringExclude(peerId);
        clientName = this.convertRuleStringExclude(clientName);
        peerId.addAll(this.convertRuleString(this.conf.getStringList("module.peer-id-blacklist.banned-peer-id")));
        clientName.addAll(this.convertRuleString(this.conf.getStringList("module.client-name-blacklist.banned-client-name")));
        this.conf.set("module.peer-id-blacklist.banned-peer-id", peerId);
        this.conf.set("module.client-name-blacklist.banned-client-name", clientName);
        this.conf.set("module.peer-id-blacklist.exclude-peer-id", null);
        this.conf.set("module.client-name-blacklist.exclude-client-name", null);
        this.conf.set("module.active-probing-removed", this.conf.get("module.active-probing"));
        this.conf.set("module.active-probing", null);
    }

    @UpdateScript(version=1)
    public void addExcludeLists() {
        this.conf.set("module.peer-id-blacklist.exclude-peer-id", Collections.emptyList());
        this.conf.set("module.client-name-blacklist.exclude-client-name", Collections.emptyList());
    }

    private List<String> convertRuleStringExclude(List<String> oldRules) {
        ArrayList<String> newRules = new ArrayList<String>();
        for (String oldRule : oldRules) {
            JsonObject newRuleObj;
            String[] ruleExploded = (oldRule = oldRule.toLowerCase(Locale.ROOT)).split("@", 2);
            if (ruleExploded.length != 2) {
                log.error(TextManager.tlUI(Lang.ERR_INVALID_RULE_SYNTAX, oldRule));
                continue;
            }
            String matchMethod = ruleExploded[0];
            String ruleBody = ruleExploded[1];
            if ((newRuleObj = (switch (matchMethod) {
                case "contains" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "CONTAINS");
                    object.addProperty("content", ruleBody);
                    object.addProperty("hit", "FALSE");
                    yield object;
                }
                case "startswith" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "STARTS_WITH");
                    object.addProperty("content", ruleBody);
                    object.addProperty("hit", "FALSE");
                    yield object;
                }
                case "endswith" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "ENDS_WITH");
                    object.addProperty("content", ruleBody);
                    object.addProperty("hit", "FALSE");
                    yield object;
                }
                case "length" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "LENGTH");
                    object.addProperty("min", (Number)Integer.parseInt(ruleBody));
                    object.addProperty("max", (Number)Integer.parseInt(ruleBody));
                    object.addProperty("hit", "FALSE");
                    yield object;
                }
                case "equals" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "EQUALS");
                    object.addProperty("content", ruleBody);
                    object.addProperty("success", "FALSE");
                    yield object;
                }
                case "regex" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "REGEX");
                    object.addProperty("content", ruleBody);
                    object.addProperty("success", "NEGATIVE");
                    yield object;
                }
                default -> null;
            })) == null) continue;
            newRules.add(newRuleObj.toString());
        }
        return newRules;
    }

    private List<String> convertRuleString(List<String> oldRules) {
        ArrayList<String> newRules = new ArrayList<String>();
        for (String oldRule : oldRules) {
            JsonObject newRuleObj;
            String[] ruleExploded = (oldRule = oldRule.toLowerCase(Locale.ROOT)).split("@", 2);
            if (ruleExploded.length != 2) {
                log.error(TextManager.tlUI(Lang.ERR_INVALID_RULE_SYNTAX, oldRule));
                continue;
            }
            String matchMethod = ruleExploded[0];
            String ruleBody = ruleExploded[1];
            if ((newRuleObj = (switch (matchMethod) {
                case "contains" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "CONTAINS");
                    object.addProperty("content", ruleBody);
                    yield object;
                }
                case "startswith" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "STARTS_WITH");
                    object.addProperty("content", ruleBody);
                    yield object;
                }
                case "endswith" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "ENDS_WITH");
                    object.addProperty("content", ruleBody);
                    yield object;
                }
                case "length" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "LENGTH");
                    object.addProperty("min", (Number)Integer.parseInt(ruleBody));
                    object.addProperty("max", (Number)Integer.parseInt(ruleBody));
                    yield object;
                }
                case "equals" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "EQUALS");
                    object.addProperty("content", ruleBody);
                    yield object;
                }
                case "regex" -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("method", "REGEX");
                    object.addProperty("content", ruleBody);
                    yield object;
                }
                default -> null;
            })) == null) continue;
            newRules.add(newRuleObj.toString());
        }
        return newRules;
    }
}

