/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver;

import com.ghostchu.peerbanhelper.databasent.DatabaseDriver;
import javax.sql.DataSource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stone.beecp.BeeDataSource;

public abstract class AbstractDatabaseDriver
implements DatabaseDriver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabaseDriver.class);
    private DataSource readDataSource;
    private DataSource writeDataSource;

    @Override
    @NotNull
    public String getMapperXmlPath() {
        return "mapper/" + this.getType().getMapperType() + "/**/*.xml";
    }

    @Override
    public void close() throws Exception {
        BeeDataSource beeDataSource;
        DataSource dataSource = this.readDataSource;
        if (dataSource instanceof BeeDataSource) {
            beeDataSource = (BeeDataSource)dataSource;
            if (!beeDataSource.isClosed()) {
                beeDataSource.close();
            }
        } else {
            log.warn("Given DataSource is not an instance of BeeDataSource, cannot close it properly.");
        }
        if ((dataSource = this.writeDataSource) instanceof BeeDataSource) {
            beeDataSource = (BeeDataSource)dataSource;
            if (!beeDataSource.isClosed()) {
                beeDataSource.close();
            }
        } else {
            log.warn("Given DataSource is not an instance of BeeDataSource, cannot close it properly.");
        }
    }

    @Override
    @NotNull
    public DataSource getReadDataSource() {
        if (this.readDataSource != null) {
            return this.readDataSource;
        }
        this.readDataSource = this.createReadDataSource();
        return this.readDataSource;
    }

    @Override
    @NotNull
    public DataSource getWriteDataSource() {
        if (this.writeDataSource != null) {
            return this.writeDataSource;
        }
        this.writeDataSource = this.createWriteDataSource();
        return this.writeDataSource;
    }

    @NotNull
    protected abstract DataSource createReadDataSource();

    @NotNull
    protected abstract DataSource createWriteDataSource();
}

