/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.h2;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.stone.beecp.BeeDataSource;

public class H2DatabaseDriver
extends AbstractDatabaseDriver {
    private final File dbFile;
    private final String dbPath;
    private final ConfigurationSection section;
    private final AtomicBoolean requestCompactOnShutdown = new AtomicBoolean(false);
    private final BeeDataSource dataSource;

    public H2DatabaseDriver(@NotNull ConfigurationSection section) throws IOException {
        this.section = section;
        File persistDir = new File(Main.getDataDirectory(), "persist");
        if (!persistDir.exists() && !persistDir.mkdirs()) {
            throw new IOException("Unable to create persist directory at " + persistDir.getAbsolutePath() + ", permission denied?");
        }
        this.dbFile = new File(persistDir, "peerbanhelper-nt");
        this.dbPath = this.dbFile.getAbsolutePath();
        BeeDataSource beeDataSource = new BeeDataSource();
        beeDataSource.setJdbcUrl("jdbc:h2:" + this.dbPath + ";MODE=MySQL;DB_CLOSE_ON_EXIT=FALSE;DB_CLOSE_DELAY=-1;LOCK_TIMEOUT=60000;RETENTION_TIME=5000;MAX_LOG_SIZE=8");
        beeDataSource.setDriverClassName("org.h2.Driver");
        beeDataSource.setMaxActive(10);
        beeDataSource.setMaxWait(30000L);
        beeDataSource.setIntervalOfClearTimeout(600000L);
        beeDataSource.setAliveTestSql("SELECT 1");
        beeDataSource.setFairMode(true);
        this.dataSource = beeDataSource;
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.H2;
    }

    @Override
    @NotNull
    public DataSource createWriteDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    protected DataSource createReadDataSource() {
        return this.dataSource;
    }

    @Override
    public void close() throws Exception {
        try (Connection connection = this.getReadDataSource().getConnection();){
            if (this.requestCompactOnShutdown.get()) {
                connection.createStatement().execute("SHUTDOWN COMPACT");
            } else {
                connection.createStatement().execute("SHUTDOWN");
            }
        }
        super.close();
    }
}

