/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.postgres;

import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import java.io.IOException;
import javax.sql.DataSource;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.stone.beecp.BeeDataSource;

public class PostgresDatabaseDriver
extends AbstractDatabaseDriver {
    private final ConfigurationSection section;
    private final BeeDataSource dataSource;

    public PostgresDatabaseDriver(@NotNull ConfigurationSection section) throws IOException {
        this.section = section;
        String host = section.getString("host");
        int port = section.getInt("port");
        String database = section.getString("database");
        String username = section.getString("username");
        String password = section.getString("password");
        BeeDataSource beeDataSource = new BeeDataSource();
        beeDataSource.setJdbcUrl("jdbc:postgresql://" + host + ":" + port + "/" + database);
        beeDataSource.setUsername(username);
        beeDataSource.setPassword(password);
        beeDataSource.setDriverClassName("org.postgresql.Driver");
        beeDataSource.setMaxActive(10);
        beeDataSource.setMaxWait(30000L);
        beeDataSource.setIntervalOfClearTimeout(600000L);
        beeDataSource.setAliveTestSql("SELECT 1");
        beeDataSource.setFairMode(true);
        beeDataSource.setForceDirtyWhenSetSchema(true);
        beeDataSource.addConnectionFactoryProperty("ApplicationName", (Object)"PeerBanHelper");
        beeDataSource.addConnectionFactoryProperty("tcpKeepAlive", (Object)"true");
        beeDataSource.addConnectionFactoryProperty("reWriteBatchedInserts", (Object)"true");
        this.dataSource = beeDataSource;
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.POSTGRES;
    }

    @Override
    @NotNull
    protected DataSource createWriteDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    protected DataSource createReadDataSource() {
        return this.dataSource;
    }
}

