/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.sqlite;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.Statement;
import java.time.Duration;
import javax.sql.DataSource;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteOpenMode;
import org.stone.beecp.BeeDataSource;

public class SQLiteDatabaseDriver
extends AbstractDatabaseDriver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLiteDatabaseDriver.class);
    private final File dbFile;
    private final String dbPath;
    private final ConfigurationSection section;

    public SQLiteDatabaseDriver(@NotNull ConfigurationSection section) throws IOException {
        this.section = section;
        File persistDir = new File(Main.getDataDirectory(), "persist");
        if (!persistDir.exists() && !persistDir.mkdirs()) {
            throw new IOException("Unable to create persist directory at " + persistDir.getAbsolutePath() + ", permission denied?");
        }
        this.dbFile = new File(persistDir, "peerbanhelper-nt.db");
        this.dbPath = this.dbFile.getAbsolutePath();
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.SQLITE;
    }

    @Override
    @NotNull
    protected DataSource createReadDataSource() {
        BeeDataSource dataSource = this.createDefaultBeeDataSource();
        dataSource.setMaxActive(Runtime.getRuntime().availableProcessors());
        SQLiteConfig sqLiteConfig = new SQLiteConfig();
        sqLiteConfig.setOpenMode(SQLiteOpenMode.OPEN_URI);
        sqLiteConfig.setOpenMode(SQLiteOpenMode.FULLMUTEX);
        dataSource.addConnectionFactoryProperty(SQLiteConfig.Pragma.OPEN_MODE.getPragmaName(), (Object)String.valueOf(sqLiteConfig.getOpenModeFlags()));
        return dataSource;
    }

    @Override
    @NotNull
    protected DataSource createWriteDataSource() {
        BeeDataSource dataSource = this.createDefaultBeeDataSource();
        dataSource.setMaxActive(1);
        SQLiteConfig sqLiteConfig = new SQLiteConfig();
        sqLiteConfig.setOpenMode(SQLiteOpenMode.OPEN_URI);
        sqLiteConfig.setOpenMode(SQLiteOpenMode.NOMUTEX);
        dataSource.addConnectionFactoryProperty(SQLiteConfig.Pragma.OPEN_MODE.getPragmaName(), (Object)String.valueOf(sqLiteConfig.getOpenModeFlags()));
        return dataSource;
    }

    private BeeDataSource createDefaultBeeDataSource() {
        BeeDataSource dataSource = new BeeDataSource();
        dataSource.setJdbcUrl("jdbc:sqlite:" + this.dbPath);
        dataSource.setDriverClassName("org.sqlite.JDBC");
        dataSource.setMaxActive(4);
        dataSource.setMaxWait(30000L);
        dataSource.setIntervalOfClearTimeout(600000L);
        dataSource.setAliveTestSql("SELECT 1");
        dataSource.setFairMode(true);
        dataSource.addConnectionFactoryProperty(SQLiteConfig.Pragma.JOURNAL_MODE.getPragmaName(), (Object)SQLiteConfig.JournalMode.WAL.getValue());
        dataSource.addConnectionFactoryProperty(SQLiteConfig.Pragma.SYNCHRONOUS.getPragmaName(), (Object)SQLiteConfig.SynchronousMode.NORMAL.getValue());
        dataSource.addConnectionFactoryProperty(SQLiteConfig.Pragma.JOURNAL_SIZE_LIMIT.getPragmaName(), (Object)String.valueOf(0x4000000));
        dataSource.addConnectionFactoryProperty(SQLiteConfig.Pragma.MMAP_SIZE.getPragmaName(), (Object)String.valueOf(0x8000000));
        return dataSource;
    }

    @Override
    public void close() throws Exception {
        if (ExternalSwitch.parse("pbh.database.disableSQLiteVacuum") == null) {
            this.performVacuumIfNeeded();
        }
        super.close();
    }

    private void performVacuumIfNeeded() {
        block15: {
            try {
                File maintenanceFile = new File(this.dbFile.getParentFile(), "peerbanhelper-nt.db.maintenance");
                long lastMaintenance = 0L;
                if (maintenanceFile.exists()) {
                    String content = Files.readString(maintenanceFile.toPath());
                    lastMaintenance = Long.parseLong(content.trim());
                }
                long vacuumIntervalDays = Main.getMainConfig().getInt("persist.vacuum-interval-days", 7);
                long timeSinceLastMaintenance = System.currentTimeMillis() - lastMaintenance;
                if (timeSinceLastMaintenance < Duration.ofDays(vacuumIntervalDays).toMillis()) break block15;
                log.debug("Performing SQLite VACUUM maintenance (last performed {} days ago)", (Object)(timeSinceLastMaintenance / 86400000L));
                try (Connection conn = this.getReadDataSource().getConnection();
                     Statement stmt = conn.createStatement();){
                    stmt.execute("VACUUM");
                    Files.writeString(maintenanceFile.toPath(), (CharSequence)String.valueOf(System.currentTimeMillis()), new OpenOption[0]);
                    log.info("SQLite database VACUUM completed successfully");
                }
            }
            catch (Exception e) {
                log.warn("Failed to perform SQLite VACUUM", (Throwable)e);
            }
        }
    }
}

