/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.HistoryService;
import com.ghostchu.peerbanhelper.databasent.table.HistoryEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.common.reflect.TypeToken;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoryMigrator.class);
    private final HistoryService historyService;

    public HistoryMigrator(HistoryService historyService) {
        this.historyService = historyService;
    }

    @Override
    public String getTableName() {
        return "history";
    }

    @Override
    public int getMigrationOrder() {
        return 50;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='history'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT\n    h.id, h.banAt, h.unbanAt, h.ip, h.port, h.peerId, h.peerClientName,\n    h.peerUploaded, h.peerDownloaded, h.peerProgress, h.downloaderProgress,\n    h.torrent_id, h.rule_id, h.description, h.flags, h.downloader,\n    h.structuredData,\n    m.name as module_name,\n    r.rule as rule_name\nFROM history h\nLEFT JOIN rules r ON h.rule_id = r.id\nLEFT JOIN modules m ON r.module_id = m.id\nORDER BY h.id\n";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<HistoryEntity> batch = new ArrayList<HistoryEntity>();
            while (rs.next()) {
                try {
                    HistoryEntity entity = this.mapResultSetToEntity(rs, context);
                    batch.add(entity);
                    if (batch.size() < context.getBatchSize()) continue;
                    this.historyService.getBaseMapper().insertOrUpdate(batch);
                    batch.clear();
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count += (long)batch.size(), totalCount, "history", MigrationContext.formatProgress(count, totalCount)));
                }
                catch (Exception e) {
                    log.error("Failed to migrate history record at row: {}", (Object)rs.getLong("id"), (Object)e);
                }
            }
            if (!batch.isEmpty()) {
                this.historyService.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "history"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM history");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for history table", (Throwable)e);
        }
        return 0L;
    }

    private HistoryEntity mapResultSetToEntity(ResultSet rs, MigrationContext context) throws Exception {
        String descriptionStr;
        HistoryEntity entity = new HistoryEntity();
        Timestamp banAt = rs.getTimestamp("banAt");
        Timestamp unbanAt = rs.getTimestamp("unbanAt");
        entity.setBanAt(banAt != null ? OffsetDateTime.ofInstant(banAt.toInstant(), ZoneId.systemDefault()) : null);
        entity.setUnbanAt(unbanAt != null ? OffsetDateTime.ofInstant(unbanAt.toInstant(), ZoneId.systemDefault()) : null);
        String ipStr = rs.getString("ip");
        InetAddress ip = InetAddress.getByName(ipStr);
        entity.setIp(ip);
        entity.setPort(rs.getInt("port"));
        entity.setPeerId(rs.getString("peerId"));
        entity.setPeerClientName(rs.getString("peerClientName"));
        Long peerUploaded = rs.getObject("peerUploaded") != null ? Long.valueOf(rs.getLong("peerUploaded")) : null;
        Long peerDownloaded = rs.getObject("peerDownloaded") != null ? Long.valueOf(rs.getLong("peerDownloaded")) : null;
        entity.setPeerUploaded(peerUploaded);
        entity.setPeerDownloaded(peerDownloaded);
        entity.setPeerProgress(rs.getDouble("peerProgress"));
        Double downloaderProgress = rs.getObject("downloaderProgress") != null ? rs.getDouble("downloaderProgress") : 0.0;
        entity.setDownloaderProgress(downloaderProgress);
        long oldTorrentId = rs.getLong("torrent_id");
        Long newTorrentId = this.findTorrentId(oldTorrentId, context);
        entity.setTorrentId(newTorrentId);
        String moduleName = rs.getString("module_name");
        String ruleNameStr = rs.getString("rule_name");
        entity.setModuleName(moduleName);
        if (ruleNameStr != null && !ruleNameStr.isEmpty()) {
            try {
                TranslationComponent ruleName = (TranslationComponent)JsonUtil.standard().fromJson(ruleNameStr, TranslationComponent.class);
                entity.setRuleName(ruleName);
            }
            catch (Exception e) {
                log.warn("Failed to parse rule name as TranslationComponent: {}", (Object)ruleNameStr, (Object)e);
                entity.setRuleName(new TranslationComponent(ruleNameStr));
            }
        }
        if ((descriptionStr = rs.getString("description")) != null && !descriptionStr.isEmpty()) {
            try {
                TranslationComponent description = (TranslationComponent)JsonUtil.standard().fromJson(descriptionStr, TranslationComponent.class);
                entity.setDescription(description);
            }
            catch (Exception e) {
                log.warn("Failed to parse description as TranslationComponent: {}", (Object)descriptionStr, (Object)e);
                entity.setDescription(new TranslationComponent(descriptionStr));
            }
        }
        entity.setFlags(rs.getString("flags"));
        entity.setDownloader(rs.getString("downloader"));
        String structuredDataStr = rs.getString("structuredData");
        if (structuredDataStr != null && !structuredDataStr.isEmpty() && !"{}".equals(structuredDataStr)) {
            try {
                Map structuredData = (Map)JsonUtil.standard().fromJson(structuredDataStr, new TypeToken<Map<String, Object>>(this){
                    final /* synthetic */ HistoryMigrator this$0;
                    {
                        HistoryMigrator historyMigrator = this$0;
                        Objects.requireNonNull(historyMigrator);
                        this.this$0 = historyMigrator;
                    }
                }.getType());
                entity.setStructuredData(structuredData);
            }
            catch (Exception e) {
                log.warn("Failed to parse structured data: {}", (Object)structuredDataStr, (Object)e);
                entity.setStructuredData(new HashMap<String, Object>());
            }
        }
        if (!context.isSkipGeoIP() && context.getIpdbManager() != null) {
            try {
                IPDBManager.IPDBResponse ipdbResponse = context.getIpdbManager().queryIPDB(ip);
                if (ipdbResponse != null && ipdbResponse.geoData() != null) {
                    IPGeoData geoData = ipdbResponse.geoData().get();
                    entity.setPeerGeoIp(geoData);
                }
            }
            catch (Exception e) {
                log.debug("Failed to generate GeoIP for IP {}: {}", (Object)ipStr, (Object)e.getMessage());
            }
        }
        return entity;
    }

    private Long findTorrentId(long oldTorrentId, MigrationContext context) {
        if (context.getTorrentIdMap().containsKey(oldTorrentId)) {
            return context.getTorrentIdMap().get(oldTorrentId);
        }
        return oldTorrentId;
    }
}

