/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.MetadataService;
import com.ghostchu.peerbanhelper.databasent.table.MetadataEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataMigrator.class);
    private final MetadataService metadataService;

    public MetadataMigrator(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public String getTableName() {
        return "metadata";
    }

    @Override
    public int getMigrationOrder() {
        return 1;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='metadata'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT \"key\", \"value\" FROM metadata";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<MetadataEntity> batch = new ArrayList<MetadataEntity>();
            while (rs.next()) {
                String key = rs.getString("key");
                String value = rs.getString("value");
                if ("version".equals(key)) continue;
                MetadataEntity entity = new MetadataEntity();
                entity.setK(key);
                entity.setV(value);
                batch.add(entity);
                if (batch.size() < context.getBatchSize()) continue;
                this.saveBatch(batch);
                batch.clear();
                if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "metadata", MigrationContext.formatProgress(count, totalCount)));
                lastLogged = count;
            }
            if (!batch.isEmpty()) {
                this.saveBatch(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "metadata"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM metadata WHERE \"key\" != 'version'");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for metadata table", (Throwable)e);
        }
        return 0L;
    }

    private void saveBatch(List<MetadataEntity> batch) {
        for (MetadataEntity entity : batch) {
            MetadataEntity existing = (MetadataEntity)this.metadataService.getOne((Wrapper)new LambdaQueryWrapper().eq(MetadataEntity::getK, (Object)entity.getK()));
            if (existing != null) {
                existing.setV(entity.getV());
                this.metadataService.updateById(existing);
                continue;
            }
            this.metadataService.save(entity);
        }
    }
}

