/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.routing.DataSourceContext;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import java.lang.reflect.Method;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class DataSourceAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceAspect.class);

    @Pointcut(value="@annotation(com.ghostchu.peerbanhelper.databasent.routing.ReadDataSource) || @within(com.ghostchu.peerbanhelper.databasent.routing.ReadDataSource)")
    public void readDataSourcePointcut() {
    }

    @Pointcut(value="@annotation(com.ghostchu.peerbanhelper.databasent.routing.WriteDataSource) || @within(com.ghostchu.peerbanhelper.databasent.routing.WriteDataSource)")
    public void writeDataSourcePointcut() {
    }

    @Around(value="readDataSourcePointcut()")
    public Object aroundReadDataSource(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.executeWithDataSource(joinPoint, DataSourceType.READ);
    }

    @Around(value="writeDataSourcePointcut()")
    public Object aroundWriteDataSource(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.executeWithDataSource(joinPoint, DataSourceType.WRITE);
    }

    private Object executeWithDataSource(ProceedingJoinPoint joinPoint, DataSourceType requestedType) throws Throwable {
        DataSourceType effectiveType = DataSourceContext.getEffectiveType(requestedType);
        if (DataSourceContext.isBound() && DataSourceContext.getDataSourceType() == effectiveType) {
            if (log.isTraceEnabled()) {
                log.trace("Already in {} datasource context, proceeding directly", (Object)effectiveType);
            }
            return joinPoint.proceed();
        }
        if (log.isDebugEnabled()) {
            String methodName = this.getMethodName(joinPoint);
            if (effectiveType != requestedType) {
                log.debug("Method [{}] requested {} but using {} due to nesting rules", new Object[]{methodName, requestedType, effectiveType});
            } else {
                log.debug("Method [{}] using {} datasource", (Object)methodName, (Object)effectiveType);
            }
        }
        try {
            return ScopedValue.where(DataSourceContext.getScopedValue(), effectiveType).call(() -> {
                try {
                    return joinPoint.proceed();
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    private String getMethodName(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        return method.getDeclaringClass().getSimpleName() + "." + method.getName();
    }
}

