/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceContext.class);
    private static final ScopedValue<DataSourceType> DATASOURCE_TYPE = ScopedValue.newInstance();

    public static DataSourceType getDataSourceType() {
        return DATASOURCE_TYPE.orElse(DataSourceType.READ);
    }

    public static boolean isBound() {
        return DATASOURCE_TYPE.isBound();
    }

    public static ScopedValue<DataSourceType> getScopedValue() {
        return DATASOURCE_TYPE;
    }

    public static boolean isValidSwitch(DataSourceType newType) {
        if (!DATASOURCE_TYPE.isBound()) {
            return true;
        }
        DataSourceType current = DATASOURCE_TYPE.get();
        if (current == DataSourceType.WRITE && newType == DataSourceType.READ) {
            log.warn("Prevented illegal datasource switch from WRITE to READ in nested context");
            return false;
        }
        return true;
    }

    public static DataSourceType getEffectiveType(DataSourceType requestedType) {
        if (!DATASOURCE_TYPE.isBound()) {
            return requestedType;
        }
        DataSourceType current = DATASOURCE_TYPE.get();
        if (current == DataSourceType.WRITE && requestedType == DataSourceType.READ) {
            log.debug("Keeping WRITE datasource due to nesting rules (requested: READ)");
            return DataSourceType.WRITE;
        }
        return requestedType;
    }
}

