/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ghostchu.peerbanhelper.databasent.mapper.java.PCBRangeMapper;
import com.ghostchu.peerbanhelper.databasent.routing.WriteTransactionTemplate;
import com.ghostchu.peerbanhelper.databasent.service.PCBRangeService;
import com.ghostchu.peerbanhelper.databasent.table.PCBRangeEntity;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PCBRangeServiceImpl
extends ServiceImpl<PCBRangeMapper, PCBRangeEntity>
implements PCBRangeService {
    @Autowired
    private WriteTransactionTemplate writeTransactionTemplate;

    @Override
    public List<PCBRangeEntity> fetchFromDatabase(@NotNull String torrentId, @NotNull String downloader) {
        return ((PCBRangeMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBRangeEntity::getTorrentId, (Object)torrentId)).eq(PCBRangeEntity::getDownloader, (Object)downloader));
    }

    @Override
    public PCBRangeEntity fetchFromDatabase(@NotNull String torrentId, @NotNull String range, @NotNull String downloader) {
        return (PCBRangeEntity)((PCBRangeMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBRangeEntity::getTorrentId, (Object)torrentId)).eq(PCBRangeEntity::getRange, (Object)range)).eq(PCBRangeEntity::getDownloader, (Object)downloader));
    }

    @Override
    public int deleteEntry(@NotNull String torrentId, @NotNull String range) {
        return ((PCBRangeMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBRangeEntity::getTorrentId, (Object)torrentId)).eq(PCBRangeEntity::getRange, (Object)range));
    }

    @Override
    public int cleanupDatabase(OffsetDateTime timestamp) {
        Integer changes;
        int deleted = 0;
        while ((changes = (Integer)this.writeTransactionTemplate.execute(status -> ((PCBRangeMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().lt(PCBRangeEntity::getLastTimeSeen, (Object)timestamp)).last("LIMIT 150")))) != null && changes > 0) {
            deleted += changes.intValue();
        }
        return deleted;
    }
}

