/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.qbittorrent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.bittorrent.tracker.TrackerImpl;
import com.ghostchu.peerbanhelper.downloader.AbstractDownloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderLastStatus;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.QBittorrentConfig;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrentMainData;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrentPeer;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrentPreferences;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrentTorrent;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrentTorrentTrackers;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.vdurmont.semver4j.Semver;
import inet.ipaddr.IPAddress;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQbittorrent
extends AbstractDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractQbittorrent.class);
    protected final String apiEndpoint;
    protected final OkHttpClient httpClient;
    protected final QBittorrentConfig config;
    protected final Cache<String, TorrentProperties> torrentPropertiesCache;
    protected final ExecutorService parallelService = Executors.newWorkStealingPool();

    public AbstractQbittorrent(String id, QBittorrentConfig config, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        super(id, alertManager, natAddressProvider);
        this.config = config;
        this.apiEndpoint = config.getEndpoint() + "/api/v2";
        OkHttpClient.Builder builder = httpUtil.newBuilderForDownloader().connectionPool(new ConnectionPool(this.getMaxConcurrentPeerRequestSlots() + 10, 5L, TimeUnit.MINUTES)).connectTimeout(Duration.of(10L, ChronoUnit.SECONDS)).readTimeout(Duration.of(30L, ChronoUnit.SECONDS)).writeTimeout(Duration.of(30L, ChronoUnit.SECONDS)).authenticator((route, response) -> {
            if (HTTPUtil.responseCount(response) > 1) {
                return null;
            }
            String credential = Credentials.basic((String)config.getBasicAuth().getUser(), (String)config.getBasicAuth().getPass());
            return response.request().newBuilder().header("Authorization", credential).build();
        });
        httpUtil.disableSSLVerify(builder, !config.isVerifySsl());
        this.httpClient = builder.build();
        YamlConfiguration profileConfig = Main.getProfileConfig();
        this.torrentPropertiesCache = CacheBuilder.newBuilder().expireAfterAccess(profileConfig.getLong("check-interval", 5000L) + 60000L, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public int getMaxConcurrentPeerRequestSlots() {
        return ExternalSwitch.parseInt("pbh.downloader.qBittorrent.maxConcurrentPeerRequestSlots", 128);
    }

    @Override
    @NotNull
    public String getName() {
        return this.config.getName();
    }

    @Override
    @NotNull
    public JsonObject saveDownloaderJson() {
        return JsonUtil.getGson().toJsonTree((Object)this.config).getAsJsonObject();
    }

    @Override
    @NotNull
    public YamlConfiguration saveDownloader() {
        return this.config.saveToYaml();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DownloaderLoginResult login0() {
        if (this.isLoggedIn()) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.SUCCESS, new TranslationComponent(Lang.STATUS_TEXT_OK));
        }
        try {
            FormBody formBody = new FormBody.Builder().add("username", this.config.getUsername()).add("password", this.config.getPassword()).build();
            Request request = new Request.Builder().url(this.apiEndpoint + "/auth/login").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful() && this.isLoggedIn()) {
                    this.updatePreferences();
                    Semver semver = this.getDownloaderVersion();
                    if (!semver.isGreaterThanOrEqualTo(new Semver("4.5.0")) && !ExternalSwitch.parseBoolean("pbh.downloader.qBittorrent.bypassVersionCheck", false)) {
                        DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.REQUIRE_TAKE_ACTIONS, new TranslationComponent(Lang.DOWNLOADER_VERSION_INCOMPATIBLE, semver.toString(), ">= 4.5.0"));
                        return downloaderLoginResult;
                    }
                    DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.SUCCESS, new TranslationComponent(Lang.STATUS_TEXT_OK));
                    return downloaderLoginResult;
                }
                DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.INCORRECT_CREDENTIAL, new TranslationComponent(Lang.DOWNLOADER_LOGIN_EXCEPTION, response.body().string()));
                return downloaderLoginResult;
            }
        }
        catch (Exception e) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_IO_EXCEPTION, e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Semver getDownloaderVersion() {
        try (Response response = this.httpClient.newCall(new Request.Builder().url(this.apiEndpoint + "/app/version").get().build()).execute();){
            if (!response.isSuccessful()) throw new IllegalStateException("Failed to get qBittorrent version: statusCode=" + response.code());
            String versionStr = response.body().string().trim();
            if (versionStr.startsWith("v")) {
                versionStr = versionStr.substring(1);
            }
            Semver semver = new Semver(versionStr);
            return semver;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get qBittorrent version", e);
        }
    }

    public void updatePreferences() {
        FormBody.Builder formBody = new FormBody.Builder();
        try {
            if (ExternalSwitch.parseBoolean("pbh.downloader.qbittorrent.disableSameIpMultiConnection", true)) {
                formBody.add("json", JsonUtil.getGson().toJson(Map.of("enable_multi_connections_from_same_ip", false)));
            }
            Request request = new Request.Builder().url(this.apiEndpoint + "/app/setPreferences").post((RequestBody)formBody.build()).header("Content-Type", "application/x-www-form-urlencoded").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_DISABLE_SAME_IP_MULTI_CONNECTION_FAILED, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body().string()));
                    throw new IllegalStateException("Save qBittorrent preferences error: statusCode=" + response.code());
                }
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_DISABLE_SAME_IP_MULTI_CONNECTION_FAILED, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public String getEndpoint() {
        return this.apiEndpoint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLoggedIn() {
        try {
            Request request = new Request.Builder().url(this.apiEndpoint + "/app/buildInfo").get().build();
            try (Response response = this.httpClient.newCall(request).execute();){
                boolean loggedIn;
                if (!response.isSuccessful()) {
                    boolean bl = false;
                    return bl;
                }
                QBittorrentBuildInfo info = (QBittorrentBuildInfo)JsonUtil.getGson().fromJson(response.body().string(), QBittorrentBuildInfo.class);
                if (info == null) {
                    boolean bl = false;
                    return bl;
                }
                if (info.getLibtorrent() == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = loggedIn = !info.getLibtorrent().isBlank();
                if (loggedIn && this.getLastStatus() != DownloaderLastStatus.HEALTHY) {
                    this.updatePreferences();
                }
                boolean bl2 = loggedIn;
                return bl2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setBanList(@NotNull Collection<IPAddress> fullList, @Nullable Collection<BanMetadata> added, @Nullable Collection<BanMetadata> removed, boolean applyFullList) {
        if (removed != null && removed.isEmpty() && added != null && this.config.isIncrementBan() && !applyFullList) {
            this.setBanListIncrement(added);
        } else {
            this.setBanListFull(fullList);
        }
    }

    @Override
    @NotNull
    public List<Torrent> getTorrents() {
        return this.fetchTorrents(true, !this.config.isIgnorePrivate());
    }

    @Override
    @NotNull
    public List<Torrent> getAllTorrents() {
        return this.fetchTorrents(false, true);
    }

    /*
     * Unable to fully structure code
     */
    private List<Torrent> fetchTorrents(boolean onlyActive, boolean includePrivate) {
        block15: {
            allTorrents = new ArrayList<QBittorrentTorrent>();
            seenHashes = new HashSet<String>();
            pageSize = 100;
            offset = 0;
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    url = this.apiEndpoint + "/torrents/info";
                    if (onlyActive) {
                        url = url + "?filter=active";
                    }
                    url = url + (url.contains("?") != false ? "&" : "?") + "limit=" + pageSize + "&offset=" + offset;
                    request = new Request.Builder().url(url).get().build();
                    response = this.httpClient.newCall(request).execute();
                    try {
                        if (!response.isSuccessful()) {
                            throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_REQUEST_TORRENT_LIST, new Object[]{response.code(), response.body() != null ? response.body().string() : "null"}));
                        }
                        responseBody = response.body().string();
                        pageTorrents = (List)JsonUtil.getGson().fromJson(responseBody, new TypeToken<List<QBittorrentTorrent>>(this){
                            {
                                Objects.requireNonNull(this$0);
                            }
                        }.getType());
                        if (pageTorrents != null && !pageTorrents.isEmpty()) {
                            hasNew = false;
                            for (QBittorrentTorrent t : pageTorrents) {
                                if (!seenHashes.add(t.getHash())) continue;
                                allTorrents.add(t);
                                hasNew = true;
                            }
                            if (hasNew && pageTorrents.size() >= pageSize) {
                                offset += pageSize;
                            }
                        }
                        break block15;
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            ** GOTO lbl-1000
        }
        this.fillTorrentProperties(allTorrents);
        return allTorrents.stream().map((Function<QBittorrentTorrent, Torrent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fetchTorrents$0(com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrentTorrent ), (Lcom/ghostchu/peerbanhelper/downloader/impl/qbittorrent/impl/QBittorrentTorrent;)Lcom/ghostchu/peerbanhelper/bittorrent/torrent/Torrent;)()).filter((Predicate<Torrent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fetchTorrents$1(boolean com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent ), (Lcom/ghostchu/peerbanhelper/bittorrent/torrent/Torrent;)Z)((boolean)includePrivate)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<DownloaderFeatureFlag> getFeatureFlags() {
        return List.of(DownloaderFeatureFlag.UNBAN_IP, DownloaderFeatureFlag.TRAFFIC_STATS, DownloaderFeatureFlag.LIVE_UPDATE_BT_PROTOCOL_PORT);
    }

    @Override
    @NotNull
    public List<Tracker> getTrackers(@NotNull Torrent torrent) {
        ArrayList<Tracker> arrayList;
        block10: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/torrents/trackers?hash=" + torrent.getId()).get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_FAILED_REQUEST_TRACKER_LIST_ON_TORRENT, torrent.getHash(), response.code(), response.body() != null ? response.body().string() : "null"));
                }
                String responseBody = response.body().string();
                List<QBittorrentTorrentTrackers> qbTorrentTrackers = (List<QBittorrentTorrentTrackers>)JsonUtil.getGson().fromJson(responseBody, new TypeToken<List<QBittorrentTorrentTrackers>>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }
                }.getType());
                qbTorrentTrackers = qbTorrentTrackers.stream().filter(t -> !t.getUrl().startsWith("**")).sorted(Comparator.comparingInt(QBittorrentTorrentTrackers::getTier)).toList();
                HashMap<Integer, List> trackerMap = new HashMap<Integer, List>();
                for (QBittorrentTorrentTrackers qbTorrentTracker : qbTorrentTrackers) {
                    trackerMap.computeIfAbsent(qbTorrentTracker.getTier(), k -> new ArrayList()).add(qbTorrentTracker.getUrl());
                }
                ArrayList<Tracker> trackers = new ArrayList<Tracker>();
                trackerMap.forEach((k, v) -> trackers.add(new TrackerImpl((List<String>)v)));
                arrayList = trackers;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    @Override
    public void setTrackers(@NotNull Torrent torrent, @NotNull List<Tracker> trackers) {
        List<Tracker> trackerList = this.getTrackers(torrent);
        this.removeTracker(torrent, trackerList);
        this.addTracker(torrent, trackers);
    }

    @Override
    @Nullable
    public DownloaderSpeedLimiter getSpeedLimiter() {
        DownloaderSpeedLimiter downloaderSpeedLimiter;
        block9: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/app/preferences").get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException("Request failed with code: " + response.code());
                }
                String responseBody = response.body().string();
                QBittorrentPreferences preferences = (QBittorrentPreferences)JsonUtil.getGson().fromJson(responseBody, QBittorrentPreferences.class);
                long downloadLimit = preferences.getDlLimit();
                long uploadLimit = preferences.getUpLimit();
                downloaderSpeedLimiter = new DownloaderSpeedLimiter(uploadLimit, downloadLimit);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return downloaderSpeedLimiter;
    }

    @Override
    public void setSpeedLimiter(@NotNull DownloaderSpeedLimiter speedLimiter) {
        long downloadLimit = speedLimiter.isDownloadUnlimited() ? 0L : speedLimiter.download();
        long uploadLimit = speedLimiter.isUploadUnlimited() ? 0L : speedLimiter.upload();
        Map<String, Boolean> requestParam = Map.of("up_limit", uploadLimit, "dl_limit", downloadLimit, "alt_up_limit", uploadLimit, "alt_dl_limit", downloadLimit, "limit_utp_rate", true, "limit_lan_peers", true, "scheduler_enabled", false);
        FormBody formBody = new FormBody.Builder().add("json", JsonUtil.getGson().toJson(requestParam)).build();
        try {
            Request request = new Request.Builder().url(this.apiEndpoint + "/app/setPreferences").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_SAVE_SPEED_LIMITER, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body() != null ? response.body().string() : "null"));
                    throw new IllegalStateException("Save qBittorrent shadow banlist error: statusCode=" + response.code());
                }
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_SAVE_SPEED_LIMITER, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private void addTracker(Torrent torrent, List<Tracker> newAdded) {
        StringJoiner joiner = new StringJoiner("\n");
        newAdded.forEach(t -> t.getTrackersInGroup().forEach(joiner::add));
        FormBody formBody = new FormBody.Builder().add("hash", torrent.getId()).add("urls", joiner.toString()).build();
        try {
            Request request = new Request.Builder().url(this.apiEndpoint + "/torrents/addTrackers").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IllegalStateException("Add qBittorrent tracker error: statusCode=" + response.code());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void removeTracker(Torrent torrent, List<Tracker> trackers) throws IllegalStateException {
        StringJoiner joiner = new StringJoiner("|");
        trackers.forEach(t -> t.getTrackersInGroup().forEach(joiner::add));
        FormBody formBody = new FormBody.Builder().add("hash", torrent.getId()).add("urls", joiner.toString()).build();
        try {
            Request request = new Request.Builder().url(this.apiEndpoint + "/torrents/removeTrackers").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IllegalStateException("Remove qBittorrent tracker error: statusCode=" + response.code());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void fillTorrentProperties(List<QBittorrentTorrent> qbTorrent) {
        for (CompletableFuture future : qbTorrent.stream().map(detail -> CompletableFuture.runAsync(() -> {
            try {
                TorrentProperties properties = this.getTorrentProperties((QBittorrentTorrent)detail);
                if (properties == null) {
                    log.warn("Failed to retrieve properties for torrent: {}", (Object)detail.getHash());
                    return;
                }
                if (detail.getCompleted() != properties.completed) {
                    this.torrentPropertiesCache.invalidate((Object)detail.getHash());
                    properties = this.getTorrentProperties((QBittorrentTorrent)detail);
                    if (properties == null) {
                        log.warn("Failed to retrieve properties after cache invalidation for torrent: {}", (Object)detail.getHash());
                        return;
                    }
                }
                if (this.config.isIgnorePrivate() && detail.getPrivateTorrent() == null) {
                    log.debug("Field is_private is not present, querying from properties API, hash: {}", (Object)detail.getHash());
                    detail.setPrivateTorrent(properties.isPrivate);
                }
                if (detail.getPieceSize() <= 0L || detail.getPiecesHave() <= 0L) {
                    log.debug("Field piece_size or pieces_have is not present, querying from properties API, hash: {}", (Object)detail.getHash());
                    detail.setPieceSize(properties.pieceSize);
                    detail.setPiecesHave(properties.piecesHave);
                }
            }
            catch (Exception e) {
                log.debug("Failed to load properties cache", (Throwable)e);
            }
        }, this.parallelService)).toList()) {
            future.join();
        }
    }

    protected TorrentProperties getTorrentProperties(QBittorrentTorrent torrent) {
        try {
            return (TorrentProperties)this.torrentPropertiesCache.get((Object)torrent.getHash(), () -> {
                log.debug("torrent properties cache miss, query from properties api, hash: {}", (Object)torrent.getHash());
                Request request = new Request.Builder().url(this.apiEndpoint + "/torrents/properties?hash=" + torrent.getHash()).get().build();
                try (Response response = this.httpClient.newCall(request).execute();){
                    if (response.isSuccessful()) {
                        String responseBody = response.body().string();
                        QBittorrentTorrent newDetail = (QBittorrentTorrent)JsonUtil.getGson().fromJson(responseBody, QBittorrentTorrent.class);
                        TorrentProperties torrentProperties = new TorrentProperties(newDetail.getPrivateTorrent(), torrent.getCompleted(), newDetail.getPieceSize(), newDetail.getPiecesHave());
                        return torrentProperties;
                    }
                    throw new IllegalStateException(String.format("Error fetching properties for torrent hash: %s, status: %d", torrent.getHash(), response.code()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @NotNull
    public DownloaderStatistics getStatistics() {
        DownloaderStatistics downloaderStatistics;
        block9: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/sync/maindata").get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_FAILED_REQUEST_STATISTICS, response.code(), response.body() != null ? response.body().string() : "null"));
                }
                String responseBody = response.body().string();
                QBittorrentMainData mainData = (QBittorrentMainData)JsonUtil.getGson().fromJson(responseBody, QBittorrentMainData.class);
                downloaderStatistics = new DownloaderStatistics(mainData.getServerState().getAlltimeUl(), mainData.getServerState().getAlltimeDl());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return downloaderStatistics;
    }

    @Override
    @NotNull
    public List<Peer> getPeers(@NotNull Torrent torrent) {
        ArrayList<QBittorrentPeer> arrayList;
        block12: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/sync/torrentPeers?hash=" + torrent.getId()).get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_REQUEST_PEERS_LIST_IN_TORRENT, response.code(), response.body() != null ? response.body().string() : "null"));
                }
                String responseBody = response.body().string();
                JsonObject object = JsonParser.parseString((String)responseBody).getAsJsonObject();
                JsonObject peers = object.getAsJsonObject("peers");
                ArrayList<QBittorrentPeer> peersList = new ArrayList<QBittorrentPeer>();
                for (String s : peers.keySet()) {
                    JsonObject singlePeerObject = peers.getAsJsonObject(s);
                    QBittorrentPeer qbPeer = (QBittorrentPeer)JsonUtil.getGson().fromJson(singlePeerObject.toString(), QBittorrentPeer.class);
                    if ("HTTP".equalsIgnoreCase(qbPeer.getConnection()) || "HTTPS".equalsIgnoreCase(qbPeer.getConnection()) || "Web".equalsIgnoreCase(qbPeer.getConnection()) || qbPeer.getPeerAddress().getIp() == null || qbPeer.getPeerAddress().getIp().isBlank() || s.contains(".onion") || s.contains(".i2p")) continue;
                    if (qbPeer.getPeerId() == null || "Unknown".equals(qbPeer.getPeerId()) || "\u672a\u77e5".equals(qbPeer.getPeerId())) {
                        qbPeer.setPeerIdClient("");
                    }
                    if (qbPeer.getClientName() != null && qbPeer.getClientName().startsWith("Unknown [") && qbPeer.getClientName().endsWith("]")) {
                        String mid = qbPeer.getClientName().substring("Unknown [".length(), qbPeer.getClientName().length() - 1);
                        qbPeer.setClient(mid);
                    }
                    qbPeer.getPeerAddress().setRawIp(s);
                    qbPeer.setPeerAddress(this.natTranslate(qbPeer.getPeerAddress()));
                    peersList.add(qbPeer);
                }
                arrayList = peersList;
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    protected void setBanListIncrement(Collection<BanMetadata> added) {
        HashMap<String, StringJoiner> banTasks = new HashMap<String, StringJoiner>();
        added.forEach(p -> {
            StringJoiner joiner = banTasks.getOrDefault(p.getTorrent().getHash(), new StringJoiner("|"));
            joiner.add(p.getPeer().getRawIp());
            banTasks.put(p.getTorrent().getHash(), joiner);
        });
        banTasks.forEach((hash, peers) -> {
            FormBody formBody = new FormBody.Builder().add("hash", hash).add("peers", peers.toString()).build();
            try {
                Request request = new Request.Builder().url(this.apiEndpoint + "/transfer/banPeers").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
                try (Response response = this.httpClient.newCall(request).execute();){
                    if (!response.isSuccessful()) {
                        log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_INCREAMENT_BAN_FAILED, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body() != null ? response.body().string() : "null"));
                        throw new IllegalStateException("Save qBittorrent banlist error: statusCode=" + response.code());
                    }
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_INCREAMENT_BAN_FAILED, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
                throw new IllegalStateException(e);
            }
        });
    }

    protected void setBanListFull(Collection<IPAddress> bannedAddresses) {
        StringJoiner joiner = new StringJoiner("\n");
        bannedAddresses.stream().distinct().forEach(ipAddr -> {
            IPv4Address ipv4;
            IPv6Address ipv6;
            joiner.add(ipAddr.toNormalizedString());
            if (ipAddr.isIPv4() && ipAddr.isIPv6Convertible() && (ipv6 = ipAddr.toIPv6()) != null) {
                joiner.add(ipv6.toNormalizedString());
            }
            if (ipAddr.isIPv6() && ipAddr.isIPv4Convertible() && (ipv4 = ipAddr.toIPv4()) != null) {
                joiner.add(ipv4.toNormalizedString());
            }
        });
        FormBody formBody = new FormBody.Builder().add("json", JsonUtil.getGson().toJson(Map.of("banned_IPs", joiner.toString()))).build();
        try {
            Request request = new Request.Builder().url(this.apiEndpoint + "/app/setPreferences").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body() != null ? response.body().string() : "null"));
                    throw new IllegalStateException("Save qBittorrent banlist error: statusCode=" + response.code());
                }
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_QB_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setBTProtocolPort(int port) {
        Map<String, Integer> requestParam = Map.of("listen_port", port);
        FormBody formBody = new FormBody.Builder().add("json", JsonUtil.getGson().toJson(requestParam)).build();
        try {
            Request request = new Request.Builder().url(this.apiEndpoint + "/app/setPreferences").post((RequestBody)formBody).header("Content-Type", "application/x-www-form-urlencoded").build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SAVE_BT_PROTOCOL_PORT, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body() != null ? response.body().string() : "null"));
                    throw new IllegalStateException("Save qBittorrent BTProtocolPort failed: statusCode=" + response.code());
                }
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SAVE_BT_PROTOCOL_PORT, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getBTProtocolPort() {
        int n;
        block9: {
            Request request = new Request.Builder().url(this.apiEndpoint + "/app/preferences").get().build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException("Request failed with code: " + response.code());
                }
                String responseBody = response.body().string();
                QBittorrentPreferences preferences = (QBittorrentPreferences)JsonUtil.getGson().fromJson(responseBody, QBittorrentPreferences.class);
                n = preferences.getListenPort();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return n;
    }

    @Override
    public void close() {
        if (!this.parallelService.isShutdown()) {
            this.parallelService.shutdownNow();
        }
    }

    private static /* synthetic */ boolean lambda$fetchTorrents$1(boolean includePrivate, Torrent t) {
        return includePrivate || !t.isPrivate();
    }

    private static /* synthetic */ Torrent lambda$fetchTorrents$0(QBittorrentTorrent t) {
        return t;
    }

    public static class QBittorrentBuildInfo {
        @JsonProperty(value="bitness")
        private Integer bitness;
        @JsonProperty(value="boost")
        private String boost;
        @JsonProperty(value="libtorrent")
        private String libtorrent;
        @JsonProperty(value="openssl")
        private String openssl;
        @JsonProperty(value="platform")
        private String platform;
        @JsonProperty(value="qt")
        private String qt;
        @JsonProperty(value="zlib")
        private String zlib;

        @Generated
        public QBittorrentBuildInfo(Integer bitness, String boost, String libtorrent, String openssl, String platform, String qt, String zlib) {
            this.bitness = bitness;
            this.boost = boost;
            this.libtorrent = libtorrent;
            this.openssl = openssl;
            this.platform = platform;
            this.qt = qt;
            this.zlib = zlib;
        }

        @Generated
        public QBittorrentBuildInfo() {
        }

        @Generated
        public Integer getBitness() {
            return this.bitness;
        }

        @Generated
        public String getBoost() {
            return this.boost;
        }

        @Generated
        public String getLibtorrent() {
            return this.libtorrent;
        }

        @Generated
        public String getOpenssl() {
            return this.openssl;
        }

        @Generated
        public String getPlatform() {
            return this.platform;
        }

        @Generated
        public String getQt() {
            return this.qt;
        }

        @Generated
        public String getZlib() {
            return this.zlib;
        }

        @Generated
        public void setBitness(Integer bitness) {
            this.bitness = bitness;
        }

        @Generated
        public void setBoost(String boost) {
            this.boost = boost;
        }

        @Generated
        public void setLibtorrent(String libtorrent) {
            this.libtorrent = libtorrent;
        }

        @Generated
        public void setOpenssl(String openssl) {
            this.openssl = openssl;
        }

        @Generated
        public void setPlatform(String platform) {
            this.platform = platform;
        }

        @Generated
        public void setQt(String qt) {
            this.qt = qt;
        }

        @Generated
        public void setZlib(String zlib) {
            this.zlib = zlib;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QBittorrentBuildInfo)) {
                return false;
            }
            QBittorrentBuildInfo other = (QBittorrentBuildInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$bitness = this.getBitness();
            Integer other$bitness = other.getBitness();
            if (this$bitness == null ? other$bitness != null : !((Object)this$bitness).equals(other$bitness)) {
                return false;
            }
            String this$boost = this.getBoost();
            String other$boost = other.getBoost();
            if (this$boost == null ? other$boost != null : !this$boost.equals(other$boost)) {
                return false;
            }
            String this$libtorrent = this.getLibtorrent();
            String other$libtorrent = other.getLibtorrent();
            if (this$libtorrent == null ? other$libtorrent != null : !this$libtorrent.equals(other$libtorrent)) {
                return false;
            }
            String this$openssl = this.getOpenssl();
            String other$openssl = other.getOpenssl();
            if (this$openssl == null ? other$openssl != null : !this$openssl.equals(other$openssl)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$qt = this.getQt();
            String other$qt = other.getQt();
            if (this$qt == null ? other$qt != null : !this$qt.equals(other$qt)) {
                return false;
            }
            String this$zlib = this.getZlib();
            String other$zlib = other.getZlib();
            return !(this$zlib == null ? other$zlib != null : !this$zlib.equals(other$zlib));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QBittorrentBuildInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $bitness = this.getBitness();
            result = result * 59 + ($bitness == null ? 43 : ((Object)$bitness).hashCode());
            String $boost = this.getBoost();
            result = result * 59 + ($boost == null ? 43 : $boost.hashCode());
            String $libtorrent = this.getLibtorrent();
            result = result * 59 + ($libtorrent == null ? 43 : $libtorrent.hashCode());
            String $openssl = this.getOpenssl();
            result = result * 59 + ($openssl == null ? 43 : $openssl.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $qt = this.getQt();
            result = result * 59 + ($qt == null ? 43 : $qt.hashCode());
            String $zlib = this.getZlib();
            result = result * 59 + ($zlib == null ? 43 : $zlib.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractQbittorrent.QBittorrentBuildInfo(bitness=" + this.getBitness() + ", boost=" + this.getBoost() + ", libtorrent=" + this.getLibtorrent() + ", openssl=" + this.getOpenssl() + ", platform=" + this.getPlatform() + ", qt=" + this.getQt() + ", zlib=" + this.getZlib() + ")";
        }
    }

    public record TorrentProperties(boolean isPrivate, long completed, long pieceSize, long piecesHave) {
    }
}

