/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.extras.components.FlatButton;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.databasent.table.AlertEntity;
import com.ghostchu.peerbanhelper.event.program.webserver.WebServerStartedEvent;
import com.ghostchu.peerbanhelper.gui.PBHGuiBridge;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.SwingMainWindow;
import com.ghostchu.peerbanhelper.gui.impl.swing.toolwindow.AboutWindow;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.google.common.eventbus.Subscribe;
import io.sentry.Sentry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class WindowMenuBar {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowMenuBar.class);
    private final SwingMainWindow parent;
    private PBHGuiBridge bridge;

    public WindowMenuBar(SwingMainWindow parent) {
        this.parent = parent;
        this.updateMenuBar();
        Main.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onWebServerStarted(WebServerStartedEvent event) {
        this.bridge = (PBHGuiBridge)Main.getApplicationContext().getBean(PBHGuiBridge.class);
        this.updateMenuBar();
    }

    private void updateMenuBar() {
        SwingUtilities.invokeLater(() -> this.parent.setJMenuBar(this.setupMenuBar()));
    }

    private JMenuBar setupMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.generateProgramMenu());
        menuBar.add(this.generateWebUIMenu());
        if (ExternalSwitch.parseBoolean("pbh.app-v") || ExternalSwitch.parseBoolean("pbh.gui.debug-tools", Main.getMeta().isSnapshotOrBeta() || "LiveDebug".equalsIgnoreCase(ExternalSwitch.parse("pbh.release")))) {
            // empty if block
        }
        menuBar.add(this.generateHelpAbout());
        this.parent.add((Component)menuBar, "North");
        return menuBar;
    }

    private Component generateAlertsButton() {
        FlatButton alertButton = new FlatButton();
        alertButton.setButtonType(FlatButton.ButtonType.toolBarButton);
        alertButton.setFocusable(false);
        alertButton.addActionListener(event -> this.bridge.getWebUiUrl().ifPresent(uri -> this.parent.getSwingGUI().openWebpage((URI)uri)));
        CommonUtil.getScheduler().scheduleAtFixedRate(() -> {
            if (this.bridge == null) {
                alertButton.setEnabled(false);
                return;
            }
            List<AlertEntity> alerts = this.bridge.getAlerts();
            String text = alerts.isEmpty() ? "" : String.valueOf(alerts.size());
            AlertLevel highestLevel = alerts.stream().map(AlertEntity::getLevel).max(Enum::compareTo).orElse(null);
            SwingUtilities.invokeLater(() -> {
                alertButton.setText(text);
                if (highestLevel == null || alerts.isEmpty()) {
                    alertButton.setBackground(new Color(0, 0, 0, 1));
                    alertButton.setForeground(null);
                    alertButton.setIcon((Icon)new FlatSVGIcon(Main.class.getResource("/assets/icon/common/alert.svg")));
                    alertButton.setEnabled(false);
                } else {
                    alertButton.setEnabled(true);
                    alertButton.setIcon((Icon)new FlatSVGIcon(Main.class.getResource("/assets/icon/common/alert_white.svg")));
                    Color bgColor = switch (highestLevel) {
                        default -> throw new MatchException(null, null);
                        case AlertLevel.INFO -> Color.decode("#0969da");
                        case AlertLevel.WARN -> Color.decode("#bc4c00");
                        case AlertLevel.ERROR, AlertLevel.FATAL -> Color.decode("#cf222e");
                        case AlertLevel.TIP -> Color.decode("#1f883d");
                    };
                    alertButton.setBackground(bgColor);
                    alertButton.setForeground(Color.WHITE);
                }
            });
        }, 0L, 1L, TimeUnit.SECONDS);
        return alertButton;
    }

    private Component generateHelpAbout() {
        JMenu menu = new JMenu(TextManager.tlUI(Lang.GUI_MENU_ABOUT, new Object[0]));
        JMenuItem creditMenu = new JMenuItem(TextManager.tlUI(Lang.ABOUT_VIEW_CREDIT, new Object[0]));
        creditMenu.addActionListener(e -> {
            HashMap<String, String> replaces = new HashMap<String, String>();
            replaces.put("{version}", Main.getMeta().getVersion());
            replaces.put("{username}", System.getProperty("user.name"));
            replaces.put("{worldEndingCounter}", "365");
            Calendar future = Calendar.getInstance();
            future.add(1, 400);
            replaces.put("{lastLogin}", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(future.getTime()));
            AboutWindow window = new AboutWindow(replaces);
        });
        JMenuItem viewOnGithub = new JMenuItem(TextManager.tlUI(Lang.ABOUT_VIEW_GITHUB, new Object[0]));
        viewOnGithub.addActionListener(e -> this.parent.getSwingGUI().openWebpage(URI.create(TextManager.tlUI(Lang.GITHUB_PAGE, new Object[0]))));
        menu.add(viewOnGithub);
        menu.add(creditMenu);
        return menu;
    }

    private Component generateProgramMenu() {
        JMenu menu = new JMenu(TextManager.tlUI(Lang.GUI_MENU_PROGRAM, new Object[0]));
        JMenuItem openDataDirectory = new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_OPEN_DATA_DIRECTORY, new Object[0]));
        openDataDirectory.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(Main.getDataDirectory());
            }
            catch (IOException ex) {
                log.warn("Unable to open data directory {} in desktop env.", (Object)Main.getDataDirectory().getPath());
                Sentry.captureException((Throwable)ex);
            }
        });
        if (!ExternalSwitch.parseBoolean("pbh.app-v")) {
            menu.add(openDataDirectory);
        }
        menu.addSeparator();
        JMenuItem quit = new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_QUIT, new Object[0]));
        quit.addActionListener(e -> System.exit(0));
        menu.add(quit);
        return menu;
    }

    private JMenu generateWebUIMenu() {
        JMenu webUIMenu = new JMenu(TextManager.tlUI(Lang.GUI_MENU_WEBUI, new Object[0]));
        JMenuItem openWebUIMenuItem = new JMenuItem(TextManager.tlUI(Lang.GUI_MENU_WEBUI_OPEN, new Object[0]));
        openWebUIMenuItem.addActionListener(e -> this.parent.openWebUI());
        openWebUIMenuItem.setEnabled(this.bridge != null && this.bridge.getWebUiUrl().isPresent());
        webUIMenu.add(openWebUIMenuItem);
        JMenuItem copyWebUIToken = new JMenuItem(TextManager.tlUI(Lang.GUI_COPY_WEBUI_TOKEN, new Object[0]));
        copyWebUIToken.setEnabled(this.bridge != null && this.bridge.getWebUiToken().isPresent());
        copyWebUIToken.addActionListener(e -> this.bridge.getWebUiToken().ifPresent(content -> {
            SwingMainWindow.copyText(content);
            this.parent.getSwingGUI().createDialog(Level.INFO, TextManager.tlUI(Lang.GUI_COPY_TO_CLIPBOARD_TITLE, new Object[0]), String.format(TextManager.tlUI(Lang.GUI_COPY_TO_CLIPBOARD_DESCRIPTION, content), new Object[0]), () -> {});
        }));
        webUIMenu.add(copyWebUIToken);
        return webUIMenu;
    }
}

