/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.toolwindow;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.util.MIDIPlayer;
import io.sentry.Sentry;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutWindow {
    private static final Logger log = LoggerFactory.getLogger(AboutWindow.class);
    private JFrame frame;
    private final Map<String, String> replaces;
    private JTextPane textPane;
    private List<Object> contentItems;
    private int currentIndex = 0;
    private Timer printTimer;
    private Timer cursorTimer;
    private boolean cursorVisible = false;
    private int delay = 100;
    private Color fgColor = new Color(238, 205, 86);
    private Color bgColor = Color.BLACK;
    private String currentString = "";
    private int charIndex = 0;
    private boolean processingString = false;
    private boolean cursorLock = false;
    private final MIDIPlayer midiPlayer = new MIDIPlayer(Main.class.getResourceAsStream("/assets/midi/ABOUT-MiSide-MusicMenu.mid"), Main.class.getResourceAsStream("/assets/midi/ABOUT-MiSide-MusicMenu-Update.mid"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AboutWindow(Map<String, String> replaces) {
        this.initializeUI();
        this.replaces = replaces;
        String content = "Missing no";
        try {
            InputStream is = Main.class.getResourceAsStream("/assets/credit.txt");
            try {
                if (is != null) {
                    content = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                }
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to load credit.txt", (Throwable)e);
        }
        this.loadContent(content);
        this.setupTimers();
        try {
            this.playMidi();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    private void playMidi() throws MidiUnavailableException {
        this.midiPlayer.play();
    }

    private void initializeUI() {
        this.frame = new JFrame(this, "[>_] PeerBanHelper Repair Terminal (Mode: Credit)"){
            final /* synthetic */ AboutWindow this$0;
            {
                AboutWindow aboutWindow = this$0;
                Objects.requireNonNull(aboutWindow);
                this.this$0 = aboutWindow;
                super(arg0);
            }

            @Override
            public void dispose() {
                super.dispose();
                if (this.this$0.midiPlayer != null) {
                    this.this$0.midiPlayer.close();
                }
            }
        };
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(1000, 500);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setBackground(this.bgColor);
        this.textPane.setForeground(this.fgColor);
        this.textPane.setFont(new Font("Consolas", 0, 14));
        this.textPane.setCaret(new DefaultCaret(this){
            final /* synthetic */ AboutWindow this$0;
            {
                AboutWindow aboutWindow = this$0;
                Objects.requireNonNull(aboutWindow);
                this.this$0 = aboutWindow;
            }

            @Override
            public boolean isVisible() {
                return false;
            }
        });
        this.frame.add(new JScrollPane(this.textPane));
        this.frame.setVisible(true);
    }

    private void loadContent(String content) {
        this.contentItems = new ArrayList<Object>();
        try (BufferedReader br = new BufferedReader(new StringReader(content));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("[speed:")) {
                    this.handleSpeedCommand(line);
                    continue;
                }
                if (line.startsWith("[f:") && line.contains(",b:")) {
                    this.handleColorCommand(line);
                    continue;
                }
                if ("[clear]".equals(line)) {
                    this.contentItems.add(new ClearCommand());
                    continue;
                }
                if ("[window_maximized]".equals(line)) {
                    this.contentItems.add(new WindowMaximizedCommand());
                    continue;
                }
                for (Map.Entry<String, String> entry : this.replaces.entrySet()) {
                    line = line.replace(entry.getKey(), entry.getValue());
                }
                this.contentItems.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Sentry.captureException((Throwable)e);
        }
    }

    private void handleSpeedCommand(String line) {
        Matcher m = Pattern.compile("\\[speed:(\\d+)\\]").matcher(line);
        if (m.find()) {
            this.contentItems.add(new SpeedCommand(Integer.parseInt(m.group(1))));
        }
    }

    private void handleColorCommand(String line) {
        Matcher m = Pattern.compile("\\[f:(#\\w{6}),b:(#\\w{6})\\]").matcher(line);
        if (m.find()) {
            this.contentItems.add(new ColorCommand(Color.decode(m.group(1)), Color.decode(m.group(2))));
        }
    }

    private void cleanupTimers() {
        if (this.printTimer != null) {
            this.printTimer.stop();
            this.printTimer = null;
        }
        if (this.cursorTimer != null) {
            this.cursorTimer.stop();
            this.cursorTimer = null;
        }
    }

    private void setupTimers() {
        this.cleanupTimers();
        this.printTimer = new Timer(this.delay, e -> this.processContent());
        this.cursorTimer = new Timer(500, evt -> {
            if (this.cursorLock) {
                return;
            }
            try {
                StyledDocument doc = this.textPane.getStyledDocument();
                int len = doc.getLength();
                if (this.cursorVisible && len > 0) {
                    this.removeLastCursor(doc);
                } else if (!this.processingString) {
                    this.addNewCursor(doc);
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
                Sentry.captureException((Throwable)ex);
            }
        });
        this.printTimer.start();
        this.cursorTimer.start();
    }

    private void processContent() {
        if (this.currentIndex >= this.contentItems.size()) {
            this.printTimer.stop();
            return;
        }
        Object item = this.contentItems.get(this.currentIndex);
        if (item instanceof String) {
            this.processString((String)item);
        } else {
            this.processCommand(item);
            ++this.currentIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processString(String text) {
        if (!this.processingString) {
            this.currentString = text;
            this.charIndex = 0;
            this.processingString = true;
        }
        this.cursorLock = true;
        try {
            StyledDocument doc = this.textPane.getStyledDocument();
            if (this.cursorVisible) {
                this.removeLastCursor(doc);
            }
            if (this.charIndex < this.currentString.length()) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, this.fgColor);
                doc.insertString(doc.getLength(), String.valueOf(this.currentString.charAt(this.charIndex)), attr);
                ++this.charIndex;
            }
            if (this.charIndex < this.currentString.length()) {
                this.addNewCursor(doc);
            } else {
                doc.insertString(doc.getLength(), "\n", null);
                this.processingString = false;
                ++this.currentIndex;
            }
            this.textPane.setCaretPosition(doc.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            Sentry.captureException((Throwable)ex);
        }
        finally {
            this.cursorLock = false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCommand(Object item) {
        try {
            if (item instanceof SpeedCommand) {
                int speed;
                int n;
                SpeedCommand speedCommand = (SpeedCommand)item;
                try {
                    int n2 = n = speedCommand.speed();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                this.delay = speed = n;
                this.printTimer.setDelay(this.delay);
                return;
            }
            if (item instanceof ColorCommand) {
                ColorCommand colorCommand = (ColorCommand)item;
                {
                    Color color;
                    Color fg = color = colorCommand.fg();
                    Color bg = color = colorCommand.bg();
                    this.fgColor = fg;
                    this.bgColor = bg;
                }
                this.textPane.setForeground(this.fgColor);
                this.textPane.setBackground(this.bgColor);
                return;
            }
            if (item instanceof ClearCommand) {
                this.textPane.setText("");
                return;
            }
            if (!(item instanceof WindowMaximizedCommand)) return;
            SwingUtilities.invokeLater(() -> this.frame.setExtendedState(6));
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Sentry.captureException((Throwable)ex);
        }
    }

    private synchronized void removeLastCursor(StyledDocument doc) throws BadLocationException {
        int len = doc.getLength();
        if (len > 0 && this.cursorVisible) {
            doc.remove(len - 1, 1);
            this.cursorVisible = false;
        }
    }

    private synchronized void addNewCursor(StyledDocument doc) throws BadLocationException {
        if (!this.cursorVisible) {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, this.fgColor);
            doc.insertString(doc.getLength(), "\u2589", attr);
            this.cursorVisible = true;
        }
    }

    static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new AboutWindow(Map.of("{version}", "1.0.0", "{username}", System.getProperty("user.name"))));
    }

    private static class ClearCommand {
        private ClearCommand() {
        }
    }

    private static class WindowMaximizedCommand {
        private WindowMaximizedCommand() {
        }
    }

    private record SpeedCommand(int speed) {
    }

    private record ColorCommand(Color fg, Color bg) {
    }
}

