/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.monitor;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsService;
import com.ghostchu.peerbanhelper.databasent.service.PeerConnectionMetricsTrackService;
import com.ghostchu.peerbanhelper.databasent.table.PeerConnectionMetricsEntity;
import com.ghostchu.peerbanhelper.databasent.table.PeerConnectionMetricsTrackEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.MonitorFeatureModule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskManager;
import com.ghostchu.peerbanhelper.util.backgroundtask.FunctionalBackgroundTask;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import io.sentry.Sentry;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionAnalyseServiceModule
extends AbstractFeatureModule
implements Reloadable,
MonitorFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionAnalyseServiceModule.class);
    @Autowired
    private PeerConnectionMetricsTrackService connectionMetricsTrackDao;
    @Autowired
    private PeerConnectionMetricsService connectionMetricDao;
    private long cleanupInterval;
    private long dataRetentionTime;
    private long dataFlushInterval;
    @Autowired
    private BackgroundTaskManager backgroundTaskManager;

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onTorrentPeersRetrieved(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull List<Peer> peers) {
        try {
            this.connectionMetricsTrackDao.syncPeers(downloader, torrent, peers);
        }
        catch (ExecutionException e) {
            log.warn("Failed to record torrent peers for session analyse", (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "Session Analyse Service";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "peer-analyse-service.session-analyse";
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        this.cleanupInterval = this.getConfig().getLong("cleanup-interval");
        this.dataFlushInterval = this.getConfig().getLong("data-flush-interval");
        CommonUtil.getBgCleanupScheduler().scheduleWithFixedDelay(this::cleanup, 0L, this.cleanupInterval, TimeUnit.MILLISECONDS);
        this.registerScheduledTask(this::flushData, 0L, this.dataFlushInterval, TimeUnit.MILLISECONDS);
        Main.getReloadManager().register((Reloadable)this);
    }

    private void flushData() {
        long deleted = 0L;
        this.connectionMetricsTrackDao.flushAll();
        OffsetDateTime startOfToday = TimeUtil.getStartOfToday(System.currentTimeMillis());
        List listNotInTheDay = this.connectionMetricsTrackDao.list((Wrapper)new LambdaQueryWrapper().ne(PeerConnectionMetricsTrackEntity::getTimeframeAt, (Object)startOfToday));
        List<PeerConnectionMetricsEntity> aggNotInTheDayList = this.connectionMetricDao.aggregating(listNotInTheDay);
        this.connectionMetricDao.saveAggregating(aggNotInTheDayList, true);
        deleted += (long)this.connectionMetricsTrackDao.deleteEntries(listNotInTheDay);
        List listInTheDay = this.connectionMetricsTrackDao.list((Wrapper)new LambdaQueryWrapper().eq(PeerConnectionMetricsTrackEntity::getTimeframeAt, (Object)startOfToday));
        List<PeerConnectionMetricsEntity> aggInTheDayList = this.connectionMetricDao.aggregating(listInTheDay);
        this.connectionMetricDao.saveAggregating(aggInTheDayList, false);
        deleted += (long)this.connectionMetricsTrackDao.deleteEntries(listInTheDay);
    }

    private void cleanup() {
        this.backgroundTaskManager.addTaskAsync(new FunctionalBackgroundTask(new TranslationComponent(Lang.MODULE_PEER_ANALYSING_DELETING_EXPIRED_DATA), (task, callback) -> this.connectionMetricDao.removeOutdatedData(OffsetDateTime.now().minus(this.dataRetentionTime, ChronoUnit.MILLIS)))).join();
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() {
        this.dataRetentionTime = this.getConfig().getLong("data-retention-time");
    }

    @Override
    public void onDisable() {
        this.flushData();
    }
}

