/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import inet.ipaddr.Address;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class IPBlackList
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IPBlackList.class);
    private Set<IPAddress> ips;
    private Set<Integer> ports;
    private Set<Long> asns;
    private Set<String> regions;
    private Set<String> networkType;
    @Autowired
    private JavalinWebContainer webContainer;
    private long banDuration;
    private Set<String> cities;
    @Autowired
    private IPDBManager iPDBManager;

    @Override
    @NotNull
    public String getName() {
        return "IP Blacklist";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "ip-address-blocker";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        ((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/modules/ipblacklist/{ruleType}", this::handleWebAPI, new RouteRole[]{Role.USER_READ})).post("/api/modules/ipblacklist/ip/test", this::handleIPTest, new RouteRole[]{Role.USER_WRITE})).put("/api/modules/ipblacklist/ip", this::handleIPPut, new RouteRole[]{Role.USER_WRITE})).delete("/api/modules/ipblacklist/ip", this::handleIPDelete, new RouteRole[]{Role.USER_WRITE})).put("/api/modules/ipblacklist/port", this::handlePort, new RouteRole[]{Role.USER_WRITE})).delete("/api/modules/ipblacklist/port", this::handlePortDelete, new RouteRole[]{Role.USER_WRITE})).put("/api/modules/ipblacklist/asn", this::handleASN, new RouteRole[]{Role.USER_WRITE})).delete("/api/modules/ipblacklist/asn", this::handleASNDelete, new RouteRole[]{Role.USER_WRITE})).put("/api/modules/ipblacklist/region", this::handleRegion, new RouteRole[]{Role.USER_WRITE})).delete("/api/modules/ipblacklist/region", this::handleRegionDelete, new RouteRole[]{Role.USER_WRITE})).put("/api/modules/ipblacklist/city", this::handleCities, new RouteRole[]{Role.USER_WRITE})).delete("/api/modules/ipblacklist/city", this::handleCitiesDelete, new RouteRole[]{Role.USER_WRITE})).put("/api/modules/ipblacklist/netType", this::handleNetTypePut, new RouteRole[]{Role.USER_WRITE});
        Main.getReloadManager().register((Reloadable)this);
    }

    private void handleNetTypePut(@NotNull Context context) {
        String[] inputNetTypes = (String[])context.bodyAsClass(String[].class);
        this.networkType = new HashSet<String>(Arrays.asList(inputNetTypes));
        try {
            this.saveConfig();
            this.getCache().invalidateAll();
            context.status(HttpStatus.OK);
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        }
        catch (IOException e) {
            log.error("Unable to save config file", (Throwable)e);
            context.status(HttpStatus.INTERNAL_SERVER_ERROR);
            context.json((Object)new StdResp(false, "Unable to save config file", null));
        }
    }

    private void handleCitiesDelete(Context context) throws IOException {
        if (this.cities.removeIf(city -> city.equals(((UserCityRequest)context.bodyAsClass(UserCityRequest.class)).city()))) {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        } else {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        }
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleCities(Context context) throws IOException {
        String city = ((UserCityRequest)context.bodyAsClass(UserCityRequest.class)).city();
        if (city == null || city.isBlank()) {
            throw new IllegalArgumentException("Argument city cannot be null or blank");
        }
        this.cities.add(city);
        context.status(HttpStatus.CREATED);
        context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleRegionDelete(Context context) throws IOException {
        if (this.regions.removeIf(region -> region.equals(((UserRegionRequest)context.bodyAsClass(UserRegionRequest.class)).region()))) {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        } else {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        }
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleASNDelete(Context context) throws IOException {
        if (this.asns.removeIf(p -> p.longValue() == ((UserASNRequest)context.bodyAsClass(UserASNRequest.class)).asn())) {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        } else {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        }
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handlePortDelete(Context context) throws IOException {
        if (this.ports.removeIf(p -> p.intValue() == ((UserPortRequest)context.bodyAsClass(UserPortRequest.class)).port())) {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        } else {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        }
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleIPDelete(Context context) throws IOException {
        IPAddress parsed = IPAddressUtil.getIPAddress(((UserIPRequest)context.bodyAsClass(UserIPRequest.class)).ip());
        if (parsed == null) {
            throw new IllegalArgumentException("Argument ip parse failed");
        }
        if (this.ips.removeIf(ipAddress -> ipAddress.equals((Object)parsed))) {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        } else {
            context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        }
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleRegion(Context ctx) throws IOException {
        String region = ((UserRegionRequest)ctx.bodyAsClass(UserRegionRequest.class)).region();
        if (region == null || region.isBlank()) {
            throw new IllegalArgumentException("Argument region cannot be null or blank");
        }
        this.regions.add(region);
        ctx.status(HttpStatus.CREATED);
        ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleASN(Context ctx) throws IOException {
        UserASNRequest asn = (UserASNRequest)ctx.bodyAsClass(UserASNRequest.class);
        this.asns.add(asn.asn());
        ctx.status(HttpStatus.CREATED);
        ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handlePort(Context ctx) throws IOException {
        UserPortRequest req = (UserPortRequest)ctx.bodyAsClass(UserPortRequest.class);
        this.ports.add(req.port());
        ctx.status(HttpStatus.CREATED);
        ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleIPPut(Context context) throws IOException {
        IPAddress ipAddress = this.parseIPAddressFromReq(context);
        this.ips.add(ipAddress);
        context.status(HttpStatus.CREATED);
        context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.OPERATION_EXECUTE_SUCCESSFULLY, new Object[0]), null));
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private void handleIPTest(Context context) throws IOException {
        IPAddress ipAddress = this.parseIPAddressFromReq(context);
        IPAddress lower = ipAddress.getLower().withoutPrefixLength();
        IPAddress upper = ipAddress.getUpper().withoutPrefixLength();
        UserIPTestResult testResult = new UserIPTestResult(lower.toFullString(), upper.toFullString(), ipAddress.toNormalizedString(), ipAddress.getCount().toString());
        context.json((Object)new StdResp(true, null, testResult));
        this.saveConfig();
        this.getCache().invalidateAll();
    }

    private IPAddress parseIPAddressFromReq(Context ctx) throws IllegalArgumentException {
        UserIPRequest req = (UserIPRequest)ctx.bodyAsClass(UserIPRequest.class);
        IPAddress ipAddress = IPAddressUtil.getIPAddress(req.ip());
        if (ipAddress == null) {
            throw new IllegalArgumentException(TextManager.tl(this.locale(ctx), Lang.IP_BLACKLIST_PUT_IP_INVALID_IP, new Object[0]));
        }
        return ipAddress;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    private void handleWebAPI(Context ctx) {
        LinkedHashMap<String, Collection<Object>> map = new LinkedHashMap<String, Collection<Object>>();
        switch (ctx.pathParam("ruleType")) {
            case "ip": {
                map.put("ip", this.ips.stream().map(Address::toString).toList());
                break;
            }
            case "port": {
                map.put("port", this.ports);
                break;
            }
            case "asn": {
                map.put("asn", this.asns);
                break;
            }
            case "region": {
                map.put("region", this.regions);
                break;
            }
            case "city": {
                map.put("city", this.cities);
                break;
            }
            case "netType": {
                map.put("netType", this.networkType);
                break;
            }
            default: {
                ctx.status(HttpStatus.NOT_FOUND);
                ctx.json((Object)new StdResp(false, "Illegal pathParams: ruleType not acceptable.", null));
                return;
            }
        }
        ctx.status(HttpStatus.OK);
        ctx.json((Object)new StdResp(true, null, map));
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    @Override
    public void saveConfig() throws IOException {
        this.getConfig().set("ips", this.ips.stream().map(Address::toString).toList());
        this.getConfig().set("ports", List.copyOf(this.ports));
        this.getConfig().set("asns", List.copyOf(this.asns));
        this.getConfig().set("regions", List.copyOf(this.regions));
        this.getConfig().set("cities", List.copyOf(this.cities));
        this.getConfig().set("net-type", List.copyOf(this.networkType));
        super.saveConfig();
    }

    private void reloadConfig() {
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.ips = new HashSet<IPAddress>();
        for (String s : this.getConfig().getStringList("ips")) {
            IPAddress ipAddress = IPAddressUtil.getIPAddress(s);
            this.ips.add(ipAddress);
        }
        this.ports = new HashSet<Integer>(this.getConfig().getIntList("ports"));
        this.regions = new HashSet<String>(this.getConfig().getStringList("regions"));
        this.asns = new HashSet<Long>(this.getConfig().getLongList("asns"));
        this.cities = new HashSet<String>(this.getConfig().getStringList("cities"));
        this.networkType = new HashSet<String>(this.getConfig().getStringList("net-type"));
        this.getCache().invalidateAll();
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        if (this.isHandShaking(peer)) {
            return this.handshaking();
        }
        return this.getCache().readCacheButWritePassOnly(this, peer.getPeerAddress().getIp(), () -> {
            PeerAddress peerAddress = peer.getPeerAddress();
            if (this.ports.contains(peerAddress.getPort())) {
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.IP_BLACKLIST_PORT_RULE), new TranslationComponent(Lang.MODULE_IBL_MATCH_PORT, String.valueOf(peerAddress.getPort())), StructuredData.create().add("type", "port").add("rule", peerAddress.getPort()));
            }
            IPAddress pa = IPAddressUtil.getIPAddress(peerAddress.getIp());
            for (IPAddress ra : this.ips) {
                if (!ra.equals((Object)pa) && !ra.contains(pa)) continue;
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.IP_BLACKLIST_CIDR_RULE, ra.toString()), new TranslationComponent(Lang.MODULE_IBL_MATCH_IP, ra.toString()), StructuredData.create().add("type", "ip").add("rule", ra.toNormalizedString()));
            }
            try {
                CheckResult ipdbResult = this.checkIPDB(peer.getPeerAddress().getAddress().toInetAddress());
                if (ipdbResult.action() != PeerAction.NO_ACTION) {
                    return ipdbResult;
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.MODULE_IBL_EXCEPTION_GEOIP, new Object[0]), (Throwable)e);
            }
            return this.pass();
        }, true);
    }

    private CheckResult checkIPDB(InetAddress addr) {
        String iso;
        Long asn;
        if (this.regions.isEmpty() && this.asns.isEmpty()) {
            return this.pass();
        }
        IPGeoData geoData = this.iPDBManager.queryIPDB(addr).geoData().get();
        if (geoData == null) {
            return this.pass();
        }
        if (!this.asns.isEmpty() && geoData.getAs() != null && this.asns.contains(asn = geoData.getAs().getNumber())) {
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.IP_BLACKLIST_ASN_RULE, String.valueOf(asn)), new TranslationComponent(Lang.MODULE_IBL_MATCH_ASN, String.valueOf(asn)), StructuredData.create().add("type", "asn").add("rule", asn));
        }
        if (!this.regions.isEmpty() && geoData.getCountry() != null && this.regions.contains(iso = geoData.getCountry().getIso())) {
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.IP_BLACKLIST_REGION_RULE, iso), new TranslationComponent(Lang.MODULE_IBL_MATCH_REGION, iso), StructuredData.create().add("type", "iso").add("rule", iso));
        }
        if (this.networkType != null && geoData.getNetwork() != null && geoData.getNetwork().getNetType() != null) {
            boolean hit;
            String netType;
            switch (netType = geoData.getNetwork().getNetType()) {
                case "\u5bbd\u5e26": {
                    boolean bl = this.networkType.contains("wideband");
                    break;
                }
                case "\u57fa\u7ad9": {
                    boolean bl = this.networkType.contains("baseStation");
                    break;
                }
                case "\u653f\u4f01\u4e13\u7ebf": {
                    boolean bl = this.networkType.contains("governmentAndEnterpriseLine");
                    break;
                }
                case "\u4e1a\u52a1\u5e73\u53f0": {
                    boolean bl = this.networkType.contains("businessPlatform");
                    break;
                }
                case "\u9aa8\u5e72\u7f51": {
                    boolean bl = this.networkType.contains("backboneNetwork");
                    break;
                }
                case "IP \u4e13\u7f51": 
                case "IP\u4e13\u7f51": {
                    boolean bl = this.networkType.contains("ipPrivateNetwork");
                    break;
                }
                case "\u7f51\u5427": {
                    boolean bl = this.networkType.contains("internetCafe");
                    break;
                }
                case "\u7269\u8054\u7f51": {
                    boolean bl = this.networkType.contains("iot");
                    break;
                }
                case "\u6570\u636e\u4e2d\u5fc3": {
                    boolean bl;
                    if (this.networkType.contains("dataCenter") || this.networkType.contains("datacenter")) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = hit = false;
                }
            }
            if (hit) {
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.IP_BLACKLIST_NETTYPE_RULE, netType), new TranslationComponent(Lang.MODULE_IBL_MATCH_IP, netType), StructuredData.create().add("type", "netTypes").add("rule", netType));
            }
        }
        if (!this.cities.isEmpty() && geoData.getCity() != null && geoData.getCity().getName() != null) {
            String fullCityName = geoData.getCity().getName();
            for (String s : this.cities) {
                if (!fullCityName.contains(s)) continue;
                return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.IP_BLACKLIST_CITY_RULE, s), new TranslationComponent(Lang.MODULE_IBL_MATCH_IP, s), StructuredData.create().add("type", "city").add("rule", s));
            }
        }
        return this.pass();
    }

    public record UserCityRequest(String city) {
    }

    public record UserIPRequest(String ip) {
    }

    public record UserRegionRequest(String region) {
    }

    public record UserASNRequest(long asn) {
    }

    public record UserPortRequest(int port) {
    }

    public record UserIPTestResult(String from, String to, String generatedCidr, String count) {
    }

    public record UserIPRuleAddRequestIpRange(String from, String to) {
    }
}

