/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.bittorrent.tracker.TrackerImpl;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.ReplaceTrackerDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHUtilitiesController
extends AbstractFeatureModule {
    private static final Logger log = LoggerFactory.getLogger(PBHUtilitiesController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private DownloaderManagerImpl downloaderManager;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Utilities";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-utilities";
    }

    @Override
    public void onEnable() {
        this.webContainer.javalin().post("/api/utilities/replaceTracker", this::handleReplaceTracker, new RouteRole[]{Role.USER_WRITE});
    }

    private void handleReplaceTracker(Context context) {
        ReplaceTrackerDTO dto = (ReplaceTrackerDTO)context.bodyAsClass(ReplaceTrackerDTO.class);
        if (dto == null || dto.from() == null || dto.to() == null || dto.from().isEmpty() || dto.to().isEmpty()) {
            context.status(400);
            return;
        }
        AtomicInteger count = new AtomicInteger(0);
        for (Downloader downloader : this.downloaderManager.getDownloaders()) {
            if (dto.downloaders() != null && !dto.downloaders().isEmpty() && !dto.downloaders().contains(downloader.getId()) || !downloader.login().success()) continue;
            try {
                ExecutorService executor = Executors.newWorkStealingPool();
                try {
                    for (Torrent torrent : downloader.getAllTorrents()) {
                        executor.submit(() -> {
                            try {
                                List<Tracker> liveTrackers = downloader.getTrackers(torrent);
                                List<Tracker> newTrackers = this.createTrackerListForReplace(dto.from(), dto.to(), liveTrackers);
                                if (newTrackers != null) {
                                    downloader.setTrackers(torrent, newTrackers);
                                    count.incrementAndGet();
                                }
                            }
                            catch (Exception e) {
                                log.error("Failed to replace tracker for torrent: {}", (Object)torrent.getName(), (Object)e);
                            }
                        });
                    }
                }
                finally {
                    if (executor == null) continue;
                    executor.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to replace tracker for downloader, unable to retrieve all torrents: {}", (Object)downloader.getName(), (Object)e);
            }
        }
        context.json((Object)new StdResp(true, TextManager.tl(this.locale(context), Lang.UTILITIES_TRACKER_REPLACED, count.get()), count.get()));
    }

    @Nullable
    private List<Tracker> createTrackerListForReplace(String from, String to, List<Tracker> trackers) {
        boolean anyModification = false;
        ArrayList<Tracker> newTrackers = new ArrayList<Tracker>();
        for (Tracker tracker : trackers) {
            ArrayList<String> newTrackerGroup = new ArrayList<String>();
            for (String trackerUrl : tracker.getTrackersInGroup()) {
                if (trackerUrl.contains(from)) {
                    newTrackerGroup.add(trackerUrl.replace(from, to));
                    anyModification = true;
                    continue;
                }
                newTrackerGroup.add(trackerUrl);
            }
            newTrackers.add(new TrackerImpl(newTrackerGroup));
        }
        if (anyModification) {
            return newTrackers;
        }
        return null;
    }

    @Override
    public void onDisable() {
    }
}

