/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.pbhplus.LicenseParser;
import com.ghostchu.peerbanhelper.pbhplus.backend.LicenseBackend;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.hash.Hashing;
import io.sentry.Sentry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class LicenseManager
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private final LicenseBackend licenseBackend;
    private final LicenseParser licenseParser;

    public LicenseManager(@Qualifier(value="revolvableLicenseBackend") LicenseBackend licenseBackend, LicenseParser parser) {
        this.licenseBackend = licenseBackend;
        this.licenseParser = parser;
        this.load();
    }

    private void load() {
        List keyTexts = Main.getMainConfig().getStringList("pbh-plus-key");
        LinkedHashMap<String, License> licenseList = new LinkedHashMap<String, License>();
        Iterator keyIterator = keyTexts.iterator();
        while (keyIterator.hasNext()) {
            String key = ((String)keyIterator.next()).trim();
            try {
                License license = this.licenseParser.fromLicense(key);
                licenseList.put(Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).toString(), license);
            }
            catch (Exception e) {
                log.warn(TextManager.tlUI(Lang.PBH_LICENSE_PARSE_FAILED, e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                keyIterator.remove();
                Sentry.captureException((Throwable)e);
            }
        }
        Main.getMainConfig().set("pbh-plus-key", (Object)keyTexts);
        try {
            Main.getMainConfig().save(Main.getMainConfigFile());
        }
        catch (IOException e) {
            log.error("Unable to save main configuration file!", (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
        this.licenseBackend.setLicenses(licenseList);
        if (this.isFeatureEnabled("basic")) {
            ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("pbh-plus", 0, TextManager.tlUI(Lang.PBH_PLUS_THANKS_FOR_DONATION_GUI_TITLE, new Object[0])));
            ExchangeMap.PBH_PLUS_ACTIVATED = true;
        } else {
            ExchangeMap.PBH_PLUS_ACTIVATED = false;
            ExchangeMap.GUI_DISPLAY_FLAGS.removeIf(displayFlag -> "pbh-plus".equals(displayFlag.getId()));
        }
    }

    public boolean isFeatureEnabled(@NotNull String feature) {
        return this.licenseBackend.isFeatureEnabled(feature);
    }

    @NotNull
    public LicenseBackend getLicenseBackend() {
        return this.licenseBackend;
    }

    @NotNull
    public LicenseParser getLicenseParser() {
        return this.licenseParser;
    }

    public ReloadResult reloadModule() throws Exception {
        this.load();
        return super.reloadModule();
    }
}

