/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus.backend;

import com.ghostchu.peerbanhelper.pbhplus.backend.BasicLicenseBackend;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.pbhplus.data.LicenseStatus;
import com.ghostchu.peerbanhelper.pbhplus.validator.LicenseRevokeValidator;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.spotify.futures.CompletableFutures;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RevolvableLicenseBackend
extends BasicLicenseBackend {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RevolvableLicenseBackend.class);
    private final Set<License> revokedLicenses = Collections.synchronizedSet(new LinkedHashSet());
    private final List<LicenseRevokeValidator> revokeValidators;

    public RevolvableLicenseBackend(List<LicenseRevokeValidator> revokeValidators) {
        this.revokeValidators = revokeValidators;
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::checkRevokedLicenses, 0L, 1L, TimeUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkRevokedLicenses() {
        try {
            Set revoked = Collections.synchronizedSet(new HashSet());
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (LicenseRevokeValidator validator : this.revokeValidators) {
                futures.add(CompletableFuture.runAsync(() -> revoked.addAll(validator.checkRevoked(this.licenses.values()))));
            }
            CompletableFutures.allAsList(futures).join();
            Set<License> set = this.revokedLicenses;
            synchronized (set) {
                this.revokedLicenses.clear();
                this.revokedLicenses.addAll(revoked);
            }
        }
        catch (Exception e) {
            log.debug("Error checking revoked licenses: {}", (Object)e.getMessage(), (Object)e);
            Sentry.captureException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean checkRevokedLicense(License license) {
        try {
            Set revoked = Collections.synchronizedSet(new HashSet());
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (LicenseRevokeValidator validator : this.revokeValidators) {
                futures.add(CompletableFuture.runAsync(() -> revoked.addAll(validator.checkRevoked(this.licenses.values()))));
            }
            CompletableFutures.allAsList(futures).join();
            Set<License> set = this.revokedLicenses;
            synchronized (set) {
                this.revokedLicenses.clear();
                this.revokedLicenses.addAll(revoked);
            }
            return revoked.contains(license);
        }
        catch (Exception e) {
            log.debug("Error checking revoked licenses: {}", (Object)e.getMessage(), (Object)e);
            Sentry.captureException((Throwable)e);
            return false;
        }
    }

    @Override
    @NotNull
    public LicenseStatus getLicenseStatus(@NotNull License license) {
        if (this.revokedLicenses.contains(license)) {
            return LicenseStatus.REVOKED;
        }
        if (!this.licenses.containsValue(license) && this.checkRevokedLicense(license)) {
            return LicenseStatus.REVOKED;
        }
        return super.getLicenseStatus(license);
    }

    @Override
    public void setLicenses(@NotNull Map<String, License> in) {
        super.setLicenses(in);
    }
}

