/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import io.sentry.ScopesAdapter;
import io.sentry.SentryOptions;
import io.sentry.SentryStackTraceFactory;
import io.sentry.protocol.SentryStackTrace;
import io.sentry.protocol.SentryThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SentryUtils {
    @NotNull
    public static List<SentryThread> getSentryThreads() {
        SentryOptions options = ScopesAdapter.getInstance().getOptions();
        SentryStackTraceFactory stackFactory = new SentryStackTraceFactory(options);
        ArrayList<SentryThread> sentryThreads = new ArrayList<SentryThread>();
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stackTrace = entry.getValue();
            SentryThread sentryThread = new SentryThread();
            sentryThread.setName(thread.getName());
            sentryThread.setId(Long.valueOf(thread.threadId()));
            sentryThread.setState(thread.getState().name());
            sentryThread.setCrashed(Boolean.valueOf(false));
            sentryThread.setCurrent(Boolean.valueOf(Thread.currentThread() == thread));
            if (stackTrace.length > 0) {
                SentryStackTrace sentryStackTrace = new SentryStackTrace(stackFactory.getStackFrames(stackTrace, false));
                sentryThread.setStacktrace(sentryStackTrace);
            }
            sentryThreads.add(sentryThread);
        }
        return sentryThreads;
    }
}

