/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.SentryUtils;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.protocol.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WatchDog
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WatchDog.class);
    private final String name;
    private final long timeout;
    private final AtomicLong lastFeedAt = new AtomicLong(System.currentTimeMillis());
    private final ScheduledExecutorService service;
    private final Runnable hungry;
    private final Runnable good;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private String lastOperation = "N/A";
    private boolean isDownloaderIO;

    public WatchDog(String name, long timeout, @NotNull Runnable hungry, @Nullable Runnable good) {
        this.name = name;
        this.timeout = timeout;
        this.hungry = hungry;
        this.good = good;
        this.service = Executors.newScheduledThreadPool(1, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("PBH-Watchdog-" + name);
            return thread;
        });
    }

    public void start() {
        this.service.scheduleAtFixedRate(this::watchDogCheck, 1L, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.service.shutdown();
    }

    public void feed() {
        this.lastFeedAt.set(System.currentTimeMillis());
    }

    private void watchDogCheck() {
        try {
            CompletableFuture.runAsync(() -> {
                if (System.currentTimeMillis() - this.lastFeedAt.get() > this.timeout) {
                    this.hungry();
                } else {
                    this.good();
                }
            }, executor).get(10L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            log.error(TextManager.tlUI(Lang.WATCH_DOG_CALLBACK_BLOCKED, new Object[0]), e);
            Sentry.captureException((Throwable)e);
        }
    }

    private void good() {
        if (this.good != null) {
            this.good.run();
        }
    }

    private void hungry() {
        if (this.isDownloaderIO) {
            log.warn(TextManager.tlUI(Lang.WATCH_DOG_HUNGRY_IN_DOWNLOADER_IO, this.name, this.timeout + "ms", this.lastOperation));
        } else {
            log.warn(TextManager.tlUI(Lang.WATCH_DOG_HUNGRY, this.name, this.timeout + "ms", this.lastOperation));
        }
        Message message = new Message();
        message.setMessage("Detected dead-lock or long-time running thread, watchdog triggered.");
        SentryEvent event = new SentryEvent();
        event.setLevel(SentryLevel.WARNING);
        event.setMessage(message);
        event.setTag("watchdog.name", this.name);
        event.setTag("watchdog.timeout", String.valueOf(this.timeout));
        event.setTag("watchdog.last_operation", this.lastOperation);
        event.setTag("watchdog.in_downloader_io", String.valueOf(this.isDownloaderIO));
        event.setThreads(SentryUtils.getSentryThreads());
        Sentry.captureEvent((SentryEvent)event);
        if (this.hungry != null) {
            this.hungry.run();
        }
    }

    public void setLastOperation(String lastOperation, boolean isDownloaderIO) {
        this.lastOperation = lastOperation;
        this.isDownloaderIO = isDownloaderIO;
    }

    @Generated
    public String getLastOperation() {
        return this.lastOperation;
    }

    @Generated
    public boolean isDownloaderIO() {
        return this.isDownloaderIO;
    }
}

