/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.json;

import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;

public final class LocalDateTimeTypeAdapter
implements JsonSerializer<LocalDateTime>,
JsonDeserializer<LocalDateTime> {
    public static final LocalDateTimeTypeAdapter INSTANCE = new LocalDateTimeTypeAdapter();

    public JsonElement serialize(LocalDateTime ts, Type t, JsonSerializationContext jsc) {
        return new JsonPrimitive((Number)ts.toInstant(TimeUtil.getSystemZoneOffset()).toEpochMilli());
    }

    public LocalDateTime deserialize(JsonElement json, Type t, JsonDeserializationContext jsc) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a number value");
        }
        return Instant.ofEpochMilli(json.getAsLong()).atOffset(TimeUtil.getSystemZoneOffset()).toLocalDateTime();
    }
}

