/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.traversal.btstun;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.util.portmapper.PBHPortMapper;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.util.traversal.btstun.BTStunManager;
import com.ghostchu.peerbanhelper.util.traversal.forwarder.Forwarder;
import com.ghostchu.peerbanhelper.util.traversal.forwarder.TCPForwarderImpl;
import com.ghostchu.peerbanhelper.util.traversal.stun.StunListener;
import com.ghostchu.peerbanhelper.util.traversal.stun.tunnel.StunTcpTunnel;
import com.ghostchu.peerbanhelper.util.traversal.stun.tunnel.StunTcpTunnelImpl;
import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BTStunInstance
implements StunListener,
AutoCloseable,
NatAddressProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BTStunInstance.class);
    private final Downloader downloader;
    private final PBHPortMapper portMapper;
    private final BTStunManager manager;
    private final BanList banList;
    private final Laboratory laboratory;
    private final IPDBManager ipdb;
    private StunTcpTunnel tunnel;
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1, Thread.ofVirtual().factory());
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    @Nullable
    private Forwarder tcpForwarder;
    @Nullable
    private TranslationComponent shutdownReason = null;

    public BTStunInstance(BanList banList, PBHPortMapper portMapper, Downloader downloader, BTStunManager manager, Laboratory laboratory, IPDBManager ipdb) {
        this.banList = banList;
        this.portMapper = portMapper;
        this.downloader = downloader;
        this.manager = manager;
        this.laboratory = laboratory;
        this.ipdb = ipdb;
        if (!downloader.getFeatureFlags().contains((Object)DownloaderFeatureFlag.LIVE_UPDATE_BT_PROTOCOL_PORT)) {
            throw new IllegalArgumentException(TextManager.tlUI(Lang.AUTOSTUN_DOWNLOADER_NOT_SUPPORT_LIVE_UPDATE_PORT, downloader.getName()));
        }
        this.sched.scheduleWithFixedDelay(() -> {
            try {
                if (this.shutdown.get()) {
                    return;
                }
                this.restart();
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.BTSTUN_RESTART_FAILED, downloader.getName()), (Throwable)e);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    private synchronized void restart() {
        if (this.tunnel != null) {
            if (this.tunnel.isValid()) {
                return;
            }
            try {
                this.tunnel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info(TextManager.tlUI(Lang.BTSTUN_RESTART, this.downloader.getName()));
        this.tunnel = new StunTcpTunnelImpl(this.portMapper, this);
        try {
            this.tunnel.createMapping(ExternalSwitch.parseInt("pbh.btstun.localPort." + this.downloader.getId(), 0));
        }
        catch (IOException e) {
            log.warn(TextManager.tlUI(Lang.BTSTUN_UNABLE_START, this.downloader.getName()), (Throwable)e);
            try {
                this.tunnel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onCreate(@NotNull InetSocketAddress inter, @NotNull InetSocketAddress outer) {
        IPAddress ipAddrObj;
        log.info(TextManager.tlUI(Lang.BTSTUN_ON_TUNNEL_CREATED, this.downloader.getName(), inter.getHostString() + ":" + inter.getPort(), outer.getHostString() + ":" + outer.getPort()));
        int forwarderServerPort = inter.getPort();
        int downloaderShouldListenOn = outer.getPort();
        String downloaderHost = URI.create(this.downloader.getEndpoint()).getHost();
        log.info(TextManager.tlUI(Lang.BTSTUN_FORWARDER_CREATING, this.downloader.getName()));
        String hostAddress = null;
        HostName hostName = new HostName(downloaderHost);
        if (hostName.isAddress()) {
            hostAddress = hostName.getAddress().toNormalizedString();
        } else {
            try {
                hostAddress = InetAddress.getByName(hostName.getHost()).getHostAddress();
            }
            catch (UnknownHostException e) {
                log.debug(TextManager.tlUI(Lang.AUTOSTUN_DOWNLOADER_UNABLE_RESOLVE_DOWNLOADER_HOST, this.downloader.getName(), e));
            }
        }
        if (!(hostAddress == null || (ipAddrObj = IPAddressUtil.getIPAddress(hostAddress)).isLocal() || ipAddrObj.isAnyLocal() || ipAddrObj.isLoopback() || ipAddrObj.isLinkLocal() || ipAddrObj.isZeroHost() || ipAddrObj.isMulticast() || ExternalSwitch.parseBoolean("pbh.btstun.allowPublicIpAsDownloaderHost", false))) {
            this.manager.unregister(this.downloader);
            this.close();
            this.shutdownReason = new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_HOST_NOT_LAN_ADDRESS, downloaderHost);
            log.warn(TextManager.tlUI(Lang.AUTOSTUN_DOWNLOADER_HOST_NOT_LAN_ADDRESS, downloaderHost));
            return;
        }
        this.tcpForwarder = new TCPForwarderImpl(this.banList, ExternalSwitch.parseBoolean("pbh.btstun.ipv6support", true) ? "[::]" : "0.0.0.0", forwarderServerPort, downloaderHost, downloaderShouldListenOn, this.ipdb);
        this.tcpForwarder.start();
        try {
            if (this.downloader.getBTProtocolPort() != downloaderShouldListenOn) {
                log.info(TextManager.tlUI(Lang.BTSTUN_MODIFY_DOWNLOADER_BT_PORT, this.downloader.getName(), downloaderShouldListenOn));
                this.downloader.setBTProtocolPort(downloaderShouldListenOn);
                log.info(TextManager.tlUI(Lang.BTSTUN_TUNNEL_CREATE_SUCCESSFULLY, this.downloader.getName(), downloaderHost + ":" + downloaderShouldListenOn, inter.getHostString() + ":" + inter.getPort(), outer.getHostString() + ":" + outer.getPort()));
            }
        }
        catch (Exception e) {
            log.warn(TextManager.tlUI(Lang.AUTOSTUN_DOWNLOADER_TUNNEL_UPDATE_PORT_FAILED, this.downloader.getName()), (Throwable)e);
            try {
                this.manager.unregister(this.downloader);
            }
            catch (Exception ex) {
                log.debug(TextManager.tlUI(Lang.AUTOSTUN_DOWNLOADER_UNABLE_TO_CLOSE_UNCAUGHT, this.downloader.getName()), (Throwable)ex);
            }
        }
    }

    @Override
    public void onClose(@Nullable Throwable throwable) {
        log.warn(TextManager.tlUI(Lang.BTSTUN_ON_TUNNEL_CLOSE, this.downloader.getName()), throwable);
        this.shutdownReason = throwable == null ? null : new TranslationComponent(Lang.AUTOSTUN_DOWNLOADER_TUNNEL_ERRORED, throwable.getClass().getName() + ": " + throwable.getMessage());
    }

    @Override
    public void onNotApplicable(@NotNull TranslationComponent reason) {
        try {
            this.close();
            this.shutdownReason = reason;
            log.warn(TextManager.tlUI(Lang.BTSTUN_ON_TUNNEL_CLOSE_WITH_REASON, this.downloader.getName(), reason));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.AUTOSTUN_DOWNLOADER_UNABLE_TO_SHUTDOWN, new Object[0]), (Throwable)e);
        }
    }

    @Nullable
    public TranslationComponent getShutdownReason() {
        return this.shutdownReason;
    }

    @Nullable
    public Forwarder getTcpForwarder() {
        return this.tcpForwarder;
    }

    @Override
    public void close() {
        this.shutdown.set(true);
        this.sched.shutdown();
        if (this.tunnel != null) {
            try {
                this.tunnel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (!this.sched.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.sched.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.sched.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    @Nullable
    public InetSocketAddress translate(@Nullable InetSocketAddress nattedAddress) {
        if (this.tcpForwarder != null) {
            return this.tcpForwarder.translate(nattedAddress);
        }
        return null;
    }

    @Generated
    public StunTcpTunnel getTunnel() {
        return this.tunnel;
    }
}

