/*
 * Decompiled with CFR 0.152.
 */
package cordelia.client;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import cordelia.client.RawResponse;
import cordelia.client.Session;
import cordelia.client.SessionStore;
import cordelia.client.TransmissionIOException;
import cordelia.client.TypedResponse;
import cordelia.rpc.RqArguments;
import cordelia.rpc.RsArguments;
import cordelia.rpc.types.Status;
import java.io.IOException;
import java.net.Proxy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrClient.class);
    private final String url;
    private final SessionStore sessionStore = new SessionStore();
    private final Gson om = new GsonBuilder().registerTypeAdapter(Status.class, (Object)new TypeAdapter<Status>(this){
        {
            Objects.requireNonNull(this$0);
        }

        public void write(JsonWriter out, Status value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.value((long)value.getIdx());
        }

        public Status read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return Status.STOPPED;
            }
            return Status.fromIdx(in.nextInt());
        }
    }).create();
    private final OkHttpClient httpClient;

    public TrClient(HTTPUtil httpUtil, String url, String user, String password, boolean verifySSL) {
        this.url = url;
        OkHttpClient.Builder builder = httpUtil.newBuilder().proxy(Proxy.NO_PROXY).connectionPool(new ConnectionPool(24, 5L, TimeUnit.MINUTES)).connectTimeout(Duration.of(10L, ChronoUnit.SECONDS)).readTimeout(Duration.of(30L, ChronoUnit.SECONDS)).writeTimeout(Duration.of(30L, ChronoUnit.SECONDS)).addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("User-Agent", Main.getUserAgent());
            return chain.proceed(requestBuilder.build());
        }).authenticator((route, response) -> {
            if (HTTPUtil.responseCount(response) > 1) {
                return null;
            }
            String credential = Credentials.basic((String)user, (String)(password == null ? "" : password));
            return response.request().newBuilder().header("Authorization", credential).build();
        });
        httpUtil.disableSSLVerify(builder, !verifySSL);
        this.httpClient = builder.build();
    }

    public <E extends RqArguments, S extends RsArguments> TypedResponse<S> execute(E req) {
        return this.execute(req, null);
    }

    public <E extends RqArguments, S extends RsArguments> TypedResponse<S> execute(E req, Long tag) {
        TypedResponse typedResponse;
        block10: {
            RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson((Object)req.toReq(tag)), (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(this.url).post(requestBody).header("X-Transmission-Session-Id", this.session(false).id()).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (response.code() == 409) {
                    this.session(true);
                    throw new IllegalStateException("Session invalid, re-created, please try again.");
                }
                String responseBody = response.body().string();
                RawResponse raw = (RawResponse)this.om.fromJson(responseBody, RawResponse.class);
                String json = this.om.toJson(raw.getArguments());
                typedResponse = new TypedResponse(raw.getTag(), raw.getResult(), (RsArguments)this.om.fromJson(json, req.answerClass()));
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_TR_INVALID_RESPONSE, new Object[]{"<?>", jsonSyntaxException}));
                    throw new TransmissionIOException("Invalid response", jsonSyntaxException);
                }
                catch (IOException e) {
                    log.debug("Request Transmission JsonRPC failure", (Throwable)e);
                    throw new TransmissionIOException("IOException", e);
                }
            }
            response.close();
        }
        return typedResponse;
    }

    public void shutdown() {
    }

    private Session session(boolean forceUpdate) {
        if (this.sessionStore.isEmpty() || forceUpdate) {
            try {
                Request request = new Request.Builder().url(this.url).get().build();
                try (Response response = this.httpClient.newCall(request).execute();){
                    String sessionId = response.header("X-Transmission-Session-Id");
                    if (sessionId == null) {
                        throw new IllegalStateException("No session ID found in response headers, check your credentials.");
                    }
                    this.sessionStore.set(new Session(sessionId));
                }
            }
            catch (IOException e) {
                log.error(TextManager.tlUI(Lang.TRCLIENT_API_ERROR, e.getClass().getName()), (Object)e.getMessage());
                throw new TransmissionIOException(e.getMessage());
            }
        }
        return this.sessionStore.get();
    }
}

