/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge;

import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.DelugeRequest;
import raccoonfink.deluge.requests.ConfigRequest;
import raccoonfink.deluge.responses.CheckSessionResponse;
import raccoonfink.deluge.responses.ConfigResponse;
import raccoonfink.deluge.responses.ConnectedResponse;
import raccoonfink.deluge.responses.DeleteSessionResponse;
import raccoonfink.deluge.responses.DelugeListMethodsResponse;
import raccoonfink.deluge.responses.DelugeResponse;
import raccoonfink.deluge.responses.EventsResponse;
import raccoonfink.deluge.responses.HostResponse;
import raccoonfink.deluge.responses.LoginResponse;
import raccoonfink.deluge.responses.PBHActiveTorrentsResponse;
import raccoonfink.deluge.responses.PBHBannedPeersResponse;
import raccoonfink.deluge.responses.PBHStatisticsResponse;

public final class DelugeServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelugeServer.class);
    private final String m_url;
    private final String m_password;
    private final OkHttpClient client;
    private int m_counter = 0;

    public DelugeServer(String url, String password, boolean verifySSL, HTTPUtil httpUtil, String baUser, String baPassword) {
        this.m_url = url;
        this.m_password = password;
        this.client = httpUtil.disableSSLVerify(httpUtil.newBuilderForDownloader().connectionPool(new ConnectionPool(24, 5L, TimeUnit.MINUTES)).authenticator((route, response) -> {
            if (HTTPUtil.responseCount(response) > 1) {
                return null;
            }
            String credential = Credentials.basic((String)baUser, (String)baPassword);
            return response.request().newBuilder().header("Authorization", credential).build();
        }), !verifySSL).build();
    }

    public DelugeResponse makeRequest(DelugeRequest delugeRequest) throws DelugeException {
        JsonObject jsonResponse;
        int connectionResponseCode;
        String postData = delugeRequest.toPostData(this.m_counter++);
        Request.Builder request = new Request.Builder().url(this.m_url);
        request = postData != null ? request.post(RequestBody.create((String)postData, (MediaType)MediaType.parse((String)"application/json"))) : request.post(RequestBody.create((String)"", null));
        try (Response resp = this.client.newCall(request.build()).execute();){
            connectionResponseCode = resp.code();
            if (!resp.isSuccessful()) {
                throw new DelugeException(resp.code() + " - " + resp.body().string());
            }
            jsonResponse = JsonParser.parseString((String)resp.body().string()).getAsJsonObject();
        }
        catch (IOException e) {
            throw new DelugeException(e);
        }
        if (jsonResponse.has("error") && !jsonResponse.get("error").isJsonNull()) {
            JsonObject error = jsonResponse.getAsJsonObject("error");
            String message = error.has("message") ? error.get("message").getAsString() : null;
            int code = error.has("code") ? error.get("code").getAsInt() : -1;
            StringBuilder builder = new StringBuilder("Error");
            if (code >= 0) {
                builder.append(" ").append(code);
            }
            if (message != null) {
                builder.append(": ").append(message);
            }
            throw new DelugeException(builder.toString());
        }
        return new DelugeResponse(connectionResponseCode, jsonResponse);
    }

    public DelugeListMethodsResponse listMethods() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("system.listMethods", new Object[0]));
        return new DelugeListMethodsResponse(response.getResponseCode(), response.getResponseData());
    }

    public CheckSessionResponse checkSession() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("auth.check_session", new Object[0]));
        return new CheckSessionResponse(response.getResponseCode(), response.getResponseData());
    }

    public LoginResponse login() throws DelugeException {
        DelugeRequest request = new DelugeRequest("auth.login", this.m_password);
        DelugeResponse response = this.makeRequest(request);
        return new LoginResponse(response.getResponseCode(), response.getResponseData());
    }

    public DeleteSessionResponse deleteSession() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("auth.delete_session", new Object[0]));
        return new DeleteSessionResponse(response.getResponseCode(), response.getResponseData());
    }

    public void registerEventListeners() throws DelugeException {
        List<String> events = Arrays.asList("ConfigValueChangedEvent", "NewVersionAvailableEvent", "PluginDisabledEvent", "PluginEnabledEvent", "PreTorrentRemovedEvent", "SessionPausedEvent", "SessionResumedEvent", "SessionStartedEvent", "TorrentAddedEvent", "TorrentFileRenamedEvent", "TorrentFinishedEvent", "TorrentFolderRenamedEvent", "TorrentQueueChangedEvent", "TorrentRemovedEvent", "TorrentResumedEvent", "TorrentStateChangedEvent");
        for (String event : events) {
            this.makeRequest(new DelugeRequest("web.register_event_listener", event));
        }
    }

    public ConnectedResponse isConnected() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("web.connected", new Object[0]));
        return new ConnectedResponse(response.getResponseCode(), response.getResponseData());
    }

    public HostResponse getHosts() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("web.get_hosts", new Object[0]));
        return new HostResponse(response.getResponseCode(), response.getResponseData(), false);
    }

    public HostResponse getHostStatus(String id) throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("web.get_host_status", id));
        return new HostResponse(response.getResponseCode(), response.getResponseData(), true);
    }

    public ConnectedResponse connect(String id) throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("web.connect", id));
        if (!response.getResponseData().has("result") || response.getResponseData().get("result").isJsonNull()) {
            return new ConnectedResponse(response.getResponseCode(), response.getResponseData(), true);
        }
        return new ConnectedResponse(response.getResponseCode(), response.getResponseData());
    }

    public ConnectedResponse disconnect() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("web.disconnect", new Object[0]));
        if (!response.getResponseData().has("result") || response.getResponseData().get("result").isJsonNull()) {
            return new ConnectedResponse(response.getResponseCode(), response.getResponseData(), false);
        }
        return new ConnectedResponse(response.getResponseCode(), response.getResponseData(), true);
    }

    public EventsResponse getEvents() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("web.get_events", new Object[0]));
        return new EventsResponse(response.getResponseCode(), response.getResponseData());
    }

    public ConfigResponse getConfig() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("core.get_config", new Object[0]));
        return new ConfigResponse(response.getResponseCode(), response.getResponseData());
    }

    public boolean setConfig(ConfigRequest configRequest) throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("core.set_config", configRequest.toRequestJSON()));
        return !this.determineResponseError(response);
    }

    public PBHActiveTorrentsResponse getActiveTorrents() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("peerbanhelperadapter.get_active_torrents_info", new Object[0]));
        return new PBHActiveTorrentsResponse(response.getResponseCode(), response.getResponseData());
    }

    public PBHBannedPeersResponse getBannedPeers() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("peerbanhelperadapter.get_blocklist", new Object[0]));
        return new PBHBannedPeersResponse(response.getResponseCode(), response.getResponseData());
    }

    public boolean banPeers(List<String> ips) throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("peerbanhelperadapter.ban_ips", ips));
        return !this.determineResponseError(response);
    }

    public boolean unbanPeers(List<String> ips) throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("peerbanhelperadapter.unban_ips", ips));
        return !this.determineResponseError(response);
    }

    public boolean replaceBannedPeers(List<String> ips) throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("peerbanhelperadapter.replace_blocklist", ips));
        return !this.determineResponseError(response);
    }

    public PBHStatisticsResponse queryStatistics() throws DelugeException {
        DelugeResponse response = this.makeRequest(new DelugeRequest("peerbanhelperadapter.get_session_totals", new Object[0]));
        return new PBHStatisticsResponse(response.getResponseCode(), response.getResponseData());
    }

    private boolean determineResponseError(DelugeResponse response) {
        if (!response.getResponseData().has("error") || response.getResponseData().get("error").isJsonNull()) {
            return false;
        }
        JsonElement error = response.getResponseData().get("error");
        if (error instanceof Boolean && !((Boolean)error).booleanValue()) {
            return false;
        }
        this.printError(response);
        return true;
    }

    private void printError(DelugeResponse response) {
        JsonObject object = response.getResponseData().getAsJsonObject("error");
        log.info("Error when call Deluge RPC: message={}, code={}", (Object)object.get("message").getAsString(), (Object)object.get("code").getAsInt());
    }
}

