/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge;

import com.google.gson.JsonObject;

public final class Statistics {
    private final int m_dhtNodes;
    private final int m_downloadProtocolRate;
    private final int m_downloadRate;
    private final int m_freeSpace;
    private final boolean m_incomingConnections;
    private final double m_maxDownload;
    private final int m_maxNumConnections;
    private final double m_maxUpload;
    private final int m_numConnections;
    private final int m_uploadProtocolRate;
    private final int m_uploadRate;

    public Statistics(JsonObject stats) {
        this.m_dhtNodes = stats.has("dht_nodes") ? stats.get("dht_nodes").getAsInt() : 0;
        this.m_downloadProtocolRate = stats.has("download_protocol_rate") ? stats.get("download_protocol_rate").getAsInt() : 0;
        this.m_downloadRate = stats.has("download_rate") ? stats.get("download_rate").getAsInt() : 0;
        this.m_freeSpace = stats.has("free_space") ? stats.get("free_space").getAsInt() : 0;
        this.m_incomingConnections = stats.has("has_incoming_connections") && stats.get("has_incoming_connections").getAsBoolean();
        this.m_maxDownload = stats.has("max_download") ? stats.get("max_download").getAsDouble() : 0.0;
        this.m_maxNumConnections = stats.has("max_num_connections") ? stats.get("max_num_connections").getAsInt() : 0;
        this.m_maxUpload = stats.has("max_upload") ? stats.get("max_upload").getAsDouble() : 0.0;
        this.m_numConnections = stats.has("num_connections") ? stats.get("num_connections").getAsInt() : 0;
        this.m_uploadProtocolRate = stats.has("upload_protocol_rate") ? stats.get("upload_protocol_rate").getAsInt() : 0;
        this.m_uploadRate = stats.has("upload_rate") ? stats.get("upload_rate").getAsInt() : 0;
    }

    public int getDHTNodes() {
        return this.m_dhtNodes;
    }

    public int getDownloadProtocolRate() {
        return this.m_downloadProtocolRate;
    }

    public int getDownloadRate() {
        return this.m_downloadRate;
    }

    public int getFreeSpace() {
        return this.m_freeSpace;
    }

    public boolean hasIncomingConnections() {
        return this.m_incomingConnections;
    }

    public double getMaxDownload() {
        return this.m_maxDownload;
    }

    public int getMaxNumConnections() {
        return this.m_maxNumConnections;
    }

    public double getMaxUpload() {
        return this.m_maxUpload;
    }

    public int getNumConnections() {
        return this.m_numConnections;
    }

    public int getUploadProtocolRate() {
        return this.m_uploadProtocolRate;
    }

    public int getUploadRate() {
        return this.m_uploadRate;
    }

    public JsonObject toJSON() {
        JsonObject ret = new JsonObject();
        ret.addProperty("dht_nodes", (Number)this.m_dhtNodes);
        ret.addProperty("download_protocol_rate", (Number)this.m_downloadProtocolRate);
        ret.addProperty("download_rate", (Number)this.m_downloadRate);
        ret.addProperty("free_space", (Number)this.m_freeSpace);
        ret.addProperty("incoming_connections", Boolean.valueOf(this.m_incomingConnections));
        ret.addProperty("max_download", (Number)this.m_maxDownload);
        ret.addProperty("max_num_connections", (Number)this.m_maxNumConnections);
        ret.addProperty("max_upload", (Number)this.m_maxUpload);
        ret.addProperty("num_connections", (Number)this.m_numConnections);
        ret.addProperty("upload_protocol_rate", (Number)this.m_uploadProtocolRate);
        ret.addProperty("upload_rate", (Number)this.m_uploadRate);
        return ret;
    }
}

