/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.Statistics;
import raccoonfink.deluge.Torrent;
import raccoonfink.deluge.responses.DelugeResponse;

public final class UIResponse
extends DelugeResponse {
    private boolean m_connected = false;
    private Statistics m_statistics;
    private final Set<Torrent> m_torrents = new TreeSet<Torrent>();

    public UIResponse(Integer httpResponseCode, JsonObject response) throws DelugeException {
        super(httpResponseCode, response);
        if (response == null) {
            return;
        }
        if (!response.has("result")) {
            return;
        }
        JsonObject result = response.getAsJsonObject("result");
        this.m_connected = result.has("connected") && result.get("connected").getAsBoolean();
        this.m_statistics = new Statistics(result.getAsJsonObject("stats"));
        if (result.has("torrents") && !result.get("torrents").isJsonNull()) {
            JsonObject torrents = result.getAsJsonObject("torrents");
            for (Map.Entry entry : torrents.entrySet()) {
                String key = (String)entry.getKey();
                this.m_torrents.add(new Torrent(key, ((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        }
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public Statistics getStatistics() {
        return this.m_statistics;
    }

    public Set<Torrent> getTorrents() {
        return this.m_torrents;
    }

    @Override
    public JsonObject toResponseJSON() {
        JsonObject ret = super.toResponseJSON();
        ret.addProperty("connected", Boolean.valueOf(this.m_connected));
        ret.add("statistics", (JsonElement)this.m_statistics.toJSON());
        JsonObject torrents = new JsonObject();
        ret.add("torrents", (JsonElement)torrents);
        for (Torrent torrent : this.m_torrents) {
            torrents.add(torrent.getKey(), (JsonElement)torrent.toJSON());
        }
        return ret;
    }
}

