
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(Se lasciato vuoto, il proprietario sar\u00e0 admin)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(almeno {passwordMinLength} caratteri e includere  {passwordStrengthLevel} dei seguenti caratteri: numeri, lettere maiuscole, lettere minuscole e altri simboli speciali)",
    "(at least {placeholder} characters)": "(almeno {placeholder} caratteri)",
    "(current notification)": "(notifica corrente)",
    "(current version)": "(versione corrente)",
    "(deleted)": "eliminato",
    "1 Hidden property": "1 propriet\u00e0 nascosta",
    "1 Year": "1 Anno",
    "1 cell copied": "1 cella copiata",
    "1 cell cut": "1 cella tagliata",
    "1 filter": "1 filtro",
    "1 hidden property": "1 propriet\u00e0 nascosta",
    "1 month ago": "1 mese fa",
    "1 preset hidden property": "1 propriet\u00e0 nascosta preimpostata",
    "1 record selected": "1 record selezionato",
    "1 row is copied.": "1 riga tagliata.",
    "1 sort": "1 ordinamento",
    "1 week ago": "1 settimana fa",
    "3 days ago": "3 giorni fa",
    "30 Days": "30 Giorni",
    "7 Days": "7 Giorni",
    "A file is being uploaded. Are you sure you want to leave this page?": "Un file \u00e8 in fase di caricamento. Sei sicuro di voler lasciare questa pagina?",
    "A file named {upload_file_link} is uploaded to {uploaded_link}.": "A file named {upload_file_link} is uploaded to {uploaded_link}.",
    "A file named {upload_file_link} is uploaded.": "A file named {upload_file_link} is uploaded.",
    "A file with the same name already exists in this folder.": "Un file con lo stesso nome esiste gi\u00e0 in questa cartella.",
    "A folder named {upload_folder_link} is uploaded to {uploaded_link}.": "A folder named {upload_folder_link} is uploaded to {uploaded_link}.",
    "A folder named {upload_folder_link} is uploaded.": "A folder named {upload_folder_link} is uploaded.",
    "AI": "AI",
    "AI credit used this month": "Crediti AI utilizzati questo mese",
    "AI credit used:": "Crediti AI utilizzati:",
    "API Token": "Token API",
    "API token is copied to the clipboard.": "Il token API viene copiato negli appunti.",
    "About": "Informazioni su",
    "About Us": "Informazioni su di noi",
    "Abuse Content": "Contenuto abusivo",
    "Abuse Reports": "Segnalazioni di abuso",
    "Abuse Type": "Tipo Abuso",
    "Abuse report added": "Segnalazione abusi aggiunta",
    "Accept": "Accettare",
    "Accepted": "Accettato",
    "Accepted at": "Accettato il",
    "Accepter": "Approvatore",
    "Access Log": "Log degli accessi",
    "Access scope": "Ambito di accesso",
    "Accurate to minute": "Preciso al minuto",
    "Action": "Azioni",
    "Actions": "Azioni",
    "Activate after registration": "Attiva dopo la registrazione",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Attiva l'utente immediatamente dopo la registrazione. Se deselezionato, un utente deve essere attivato dall'amministratore o tramite l'email di attivazione",
    "Activated": "Attivato",
    "Activated Users": "Utenti attivati",
    "Active": "Attivo",
    "Active Users": "Utenti attivi",
    "Active users": "Utenti attivi",
    "Activities": "Attivit\u00e0",
    "Actual size": "Dimensione reale",
    "Add": "Aggiungi",
    "Add Admin": "Aggiungi Amministratore",
    "Add Folder": "Aggiungi Cartella",
    "Add Institution": "Aggiungi istituzione",
    "Add Library": "Aggiungi Libreria",
    "Add Member": "Aggiungi un membro",
    "Add Organization": "Aggiungi Organizzazione",
    "Add Terms and Conditions": "Aggiungi termini e condizioni",
    "Add User": "Aggiungi utente",
    "Add User to Group": "Aggiungi utente al gruppo",
    "Add Wiki": "Aggingi Wiki",
    "Add admin": "Aggiungi amministratore",
    "Add auto expiration": "Aggiungi la scadenza automatica",
    "Add column": "Aggiungi colonna",
    "Add cover": "Aggiungi copertina",
    "Add custom permission": "Aggiungi autorizzazione personalizzata",
    "Add department at": "Aggiungi dipartimento a",
    "Add filter": "Aggiungi filtro",
    "Add group": "Aggiungi raggruppamento",
    "Add group member": "Aggiungi membro al gruppo",
    "Add icon": "Aggiungi icona",
    "Add institution": "Aggiungi istituzione",
    "Add member": "Aggiungi membro",
    "Add members": "Aggiungi membri",
    "Add new notification": "Aggiungi nuova notifica",
    "Add option": "Aggiungi opzione",
    "Add option: %s": "Aggiungi opzione: %s",
    "Add page": "Aggiungi pagina",
    "Add page above": "Aggiungi pagina sopra",
    "Add page below": "Aggiungi pagina sotto",
    "Add page inside": "Aggiungi pagina all'interno",
    "Add password protection": "Aggiungi la protezione password",
    "Add permission": "Aggiungi autorizzazione",
    "Add sort": "Aggiungi ordinamento",
    "Add sub-department": "Aggiungi sottodipartimento",
    "Add tag": "Aggiungi tag",
    "Add to groups": "Aggiungi a gruppi",
    "Add user": "Aggiungi utente",
    "Add view": "Aggiungi vista",
    "Added": "Aggiunto",
    "Added a new comment in document {sdoc_link}:": "Aggiunto nuovo commento nel documento {sdoc_link}:",
    "Added a new reply in document {sdoc_link}:": "Nuova risposta in documento {sdoc_link}:",
    "Added user {user}": "Utente {user} aggiunto",
    "Added user {user} to group {group}": "Utente {user} aggiunto al gruppo {group}",
    "Address": "Indirizzo",
    "Admin": "Amministratore",
    "Admin Login Logs": "Log degli accessi come amministratore",
    "Admin Logs": "Admin Logs",
    "Admin Operation Logs": "Log delle operazioni come amministratore",
    "Admin access": "Accesso amministratore",
    "Admin updated": "Amministratore {placeholder} aggiornato.",
    "Admins": "Amministratori",
    "Advanced": "Avanzato",
    "After": "Dopo",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "Dopo aver abilitato le propriet\u00e0 estese per i file, puoi aggiungere diverse propriet\u00e0 ai file, come collaboratori, data di scadenza del file, descrizione del file. \u00c8 inoltre possibile creare viste diverse per le propriet\u00e0 estese basate su file.",
    "After exceeding the traffic limit, the file download speed will be restricted.": "Dopo superare il limite di traffico, la velocit\u00e0 di download dei file verr\u00e0 limitata.",
    "All": "Tutto",
    "All Activities": "Tutte le attivit\u00e0",
    "All Groups": "Tutti i Gruppi",
    "All Notifications": "Tutte le notifiche",
    "All Public Links": "Tutti i collegamenti pubblici",
    "All comments": "Tutti i commenti",
    "All files uploaded": "Tutti i File caricati",
    "All tags": "Tutti i tag",
    "Allow new registrations": "Consenti nuove registrazioni utente",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Consenti nuove registrazioni utente. Deseleziona questa opzione per impedire a chiunque di creare un nuovo account.",
    "Allow users to change library history settings": "Consenti agli utenti di cambiare le impostazioni di storico libreria",
    "Allow users to clean library trash": "Consenti agli utenti di pulire il cestino della libreria",
    "Allow users to create encrypted libraries": "Consenti agli utenti di creare librerie crittografate",
    "An integer that is greater than 0 or equal to -2.": "Un numero intero maggiore di 0 o uguale a -2.",
    "An integer that is greater than or equal to 0.": "Un numero intero maggiore o uguale a 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Un collegamento interno \u00e8 un collegamento a un file o una cartella a cui gli utenti possono accedere con autorizzazione di lettura al file o alla cartella.",
    "And": "E",
    "Anonymous User": "Utente Anonimo",
    "Another property has this property type": "Esiste gi\u00e0 una propriet\u00e0 con questo tipo di propriet\u00e0",
    "Another user is editing this file!": "Altri utenti stanno modificando questo file!",
    "Anyone with the link": "Chiunque abbia il collegamento",
    "App Name": "Nome dell'app",
    "Are you sure to change group {placeholder} to department ?": "Sei sicuro di cambiare il gruppo {placeholder} in dipartimento?",
    "Are you sure to delete": "Sei sicuro di cancellare",
    "Are you sure to delete ": "Sei sicuro di eliminare?",
    "Are you sure to delete this comment?": "Sei sicuro di eliminare questo commento?",
    "Are you sure to delete this reply?": "Sei sicuro di eliminare questa risposta?",
    "Are you sure to revoke access of user {placeholder} ?": "Sei sicuro di voler revocare l'accesso dell'utente {placeholder}?",
    "Are you sure you want to clean invalid share links?": "Sei sicuro di voler pulire i cestini condivisi non validi?",
    "Are you sure you want to clean invalid upload links?": "Sei sicuro di voler pulire i cestini caricamenti non validi?",
    "Are you sure you want to clear trash?": "Sei sicuro di voler svuotare il cestino?",
    "Are you sure you want to delete": "Sei sicuro di voler eliminare?",
    "Are you sure you want to delete WebDAV password?": "Sei sicuro di voler eliminare la password WebDAV?",
    "Are you sure you want to delete Wiki": "Sei sicuro di voler eliminare il Wiki",
    "Are you sure you want to delete the notification ?": "Sei sicuro di voler cancellare la notifica?",
    "Are you sure you want to delete the selected share link(s) ?": "Sei sicuro di voler eliminare il/i collegamento(i) di condivisione selezionati?",
    "Are you sure you want to delete the selected upload link(s) ?": "Sei sicuro di voler eliminare il/i collegamento(i) di caricamento selezionati?",
    "Are you sure you want to delete the selected user(s) ?": "Sei sicuro di voler eliminare gli utenti selezionati?",
    "Are you sure you want to delete the share link?": "Sei sicuro di voler eliminare il link di condivisione?",
    "Are you sure you want to delete this option?": "Sei sicuro di voler eliminare questa opzione?",
    "Are you sure you want to delete this page?": "Sei sicuro di voler eliminare questa pagina?",
    "Are you sure you want to delete {placeholder} ?": "Sei sicuro di voler eliminare {placeholder}?",
    "Are you sure you want to delete {placeholder} completely?": "Sei sicuro di voler eliminare {placeholder} completamente?",
    "Are you sure you want to disconnect?": "Sei sicuro di volerti disconnettere?",
    "Are you sure you want to leave share Wiki": "Sei sicuro di voler abbandonare la condivisione del Wiki",
    "Are you sure you want to remove {placeholder} ?": "Sei sicuro di voler rimuovere {placeholder} ?",
    "Are you sure you want to reset the password of {placeholder} ?": "Sei sicuro di voler reimpostare la password di {placeholder}?",
    "Are you sure you want to restore this library?": "Sei sicuro di ripristinare questa libreria?",
    "Are you sure you want to restore {placeholder}?": "Sei sicuro di voler ripristinare {placeholder}?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "Sei sicuro di voler revocare il permesso di amministratore di {placeholder} ?",
    "Are you sure you want to set {placeholder} as Admin?": "Sei sicuro di voler impostare {placeholder} come amministratore?",
    "Are you sure you want to set {user_placeholder} inactive?": "Sei sicuro di voler impostare {user_placeholder} inattivo?",
    "Are you sure you want to unlink this device?": "Sei sicuro di voler scollegare questo dispositivo?",
    "Are you sure you want to unpublish Wiki": "Sei sicuro di voler annullare la pubblicazione del Wiki?",
    "Are you sure you want to unshare {placeholder} ?": "Sei sicuro di voler annullare la condivisione di {placeholder} ?",
    "Ascending by count": "Crescente per conteggio",
    "Ascending by creation time": "Ordina per data di creazione (in ordine ascendente)",
    "Ascending by name": "Ordina in ordine alfabetico",
    "Ascending by role": "Ordinare per ruolo (crescente)",
    "Ascending by size": "Ordina in ordine di dimensione",
    "Ascending by space used": "Ordina per spazio utilizzato in ordine ascendente",
    "Ascending by time": "Ordina in ordine di data",
    "Ascending by visit count": "Ordina per conteggio visiti (in ordine ascendente)",
    "At server": "Al server",
    "Audio": "Audio",
    "Auth Token created": "Token di autenticazione creato",
    "Auth Token deleted": "Token di autenticazione eliminato",
    "Authenticated emails": "E-mail autenticate",
    "Authenticated users": "Utenti autenticati",
    "Auto deletion": "Cancellazione automatica",
    "Automatically delete files that are not modified within certain days:": "Elimina automaticamente i file che non vengono modificati entro determinati giorni:",
    "Avatar": "Avatar",
    "Avatar updated": "Avatar aggiornato",
    "Avatar:": "Avatar:",
    "Back": "Indietro",
    "Basic": "Filtri base",
    "Before": "Prima",
    "Bell Icon": "Icona del segnalino",
    "Besides Write permission, user can also share the library.": "Oltre all'autorizzazione alla scrittura, l'utente pu\u00f2 anche condividere la libreria.",
    "Billing": "Fatturazione",
    "Branding": "Marcare",
    "Broken (please contact your administrator to fix this library)": "Interrotto (contattare l'amministratore per correggere questa libreria)",
    "Broken ({repo_id_placeholder})": "Ripristinato ({repo_id_placeholder})",
    "By child tags count ascending": "Ordinare per numero di tag figli ascendente",
    "By child tags count descending": "Ordinare per numero di tag figli discendente",
    "By day": "Per giorno",
    "By file count ascending": "Ordinare per numero di file ascendente",
    "By file count descending": "Ordinare per numero di file discendente",
    "By month": "Per mese",
    "By name ascending": "Per nome ascendente",
    "By name descending": "Per nome discendente",
    "By quarter": "Per trimestre",
    "By size ascending": "Per dimensione crescente",
    "By size descending": "Per dimensione decrescente",
    "By tag name ascending": "Ordinare per nome tag ascendente",
    "By tag name descending": "Ordinare per nome tag discendente",
    "By time ascending": "Per orario ascendente",
    "By time descending": "Per orario discendente",
    "By week": "Per settimana",
    "By year": "Per anno",
    "Can not copy folder %(src)s to its subfolder %(des)s": "Impossibile copiare la cartella%(src)s alla sua sottocartella %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "Impossibile spostare la cartella %(src)s nella relativa sottocartella %(des)s",
    "Can only copy files that are in the same folder": "\u00c8 possibile copiare solo file presenti nella stessa cartella",
    "Can only download files that are in the same folder": "\u00c8 possibile scaricare solo file presenti nella stessa cartella",
    "Can only move files that are in the same folder": "\u00c8 possibile spostare solo file presenti nella stessa cartella",
    "Cancel": "Annulla",
    "Cancel All": "Cancella tutto",
    "Cannot move parent page to child page": "Impossibile spostare la pagina genitore nella pagina figlia",
    "Capture information": "Informazioni di cattura",
    "Capture time": "Ora di cattura",
    "Card": "Scheda",
    "Certificate": "Certificato",
    "Change": "Cambia",
    "Change Password": "Cambia Password",
    "Change Password of Library {placeholder}": "Modifica password della libreria {placeholder}",
    "Change cover": "Cambia copertina",
    "Change group to department": "Cambia gruppo in dipartimento",
    "Change to department": "Cambia in dipartimento",
    "Change view type": "Cambia tipo di visualizzazione",
    "Changes": "Modifiche",
    "Checkbox": "Checkbox",
    "Child tags count": "Numero di tag figli",
    "Choose date": "Scegli una data",
    "Clean": "Svuota",
    "Clean invalid share links": "Pulisci cestini condivisi non validi",
    "Clean invalid upload links": "Pulisci cestini caricamenti non validi",
    "Clean succeeded.": "Svuotato con successo.",
    "Cleaned trash": "Cestino pulito",
    "Clear": "Cancella",
    "Clear Trash": "Svuota il Cestino",
    "Clear files in trash and history\uff1a": "Cancella i file nel cestino e nella cronologia:",
    "Clear search": "Cancella ricerca",
    "Clear selected": "Cancella selezionati",
    "Clients": "Clients",
    "Close": "Chiudi",
    "Close (Esc)": "Chiudi (Esc)",
    "Close the panel": "Chiudi la finestra",
    "Code": "Codice",
    "Collaborator": "Collaboratore",
    "Collaborators": "Partecipanti",
    "Collapse all": "Collassa tutto",
    "Collected time": "Tempo raccolto",
    "Color": "Colore",
    "Color space": "Spazio colore",
    "Comma (1,000,000)": "Virgola (1.000.000)",
    "Comma(1,03)": "Virgola(1,03)",
    "Comment": "Commento",
    "Comment details": "Dettagli del commento",
    "Comments": "Commenti",
    "Community Edition": "Edizione pubblica",
    "Compressed": "Compresso",
    "Configure Seafile": "Configura Seafile",
    "Configure your Identity Provider": "Configura il tuo Provider di Identit\u00e0",
    "Confirm": "Conferma",
    "Confirm Password": "Conferma Password",
    "Confirm password": "Conferma la password",
    "Confluence export file": "File esportato Confluence",
    "Confluence file imported": "File Confluence importato",
    "Confluence imported": "Confluence importato",
    "Connect": "Connettere",
    "Contact Email": "Contatto Email",
    "Contact Email:": "Contatto Email:",
    "Contact Information": "Informazioni sui contatti",
    "Contact email": "Email di contatto",
    "Contact information is required.": "Le informazioni di contatto sono obbligatorie.",
    "Content Scan Records": "Record di scansione del contenuto",
    "Convert & Export": "Converti e esporta",
    "Convert Wiki": "Converti la Wiki",
    "Convert to Markdown": "Converti in Markdown",
    "Convert to docx": "Converti in docx",
    "Convert to new Wiki": "Converti in nuovo Wiki",
    "Convert to sdoc": "Converti in sdoc",
    "Convert with ONLYOFFICE": "Converti con ONLYOFFICE",
    "Converting": "Conversione in corso",
    "Converting, please wait...": "Conversione in corso, attendere prego...",
    "Converting...": "Conversione in corso...",
    "Copied": "Copiato",
    "Copied link to clipboard": "Link copiato negli appunti",
    "Copy": "Copia",
    "Copy failed": "Copia fallita",
    "Copy link": "Copia link",
    "Copy path": "Copia percorso",
    "Copy selected": "Copia selezionati",
    "Copy selected item(s) to:": "Copia gli elementi selezionati su:",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Copia il certificato dell'IdP e incollalo qui. Il formato del certificato \u00e8 il seguente:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Copia il dominio DNS TXT e aggiungilo ai record DNS del tuo dominio, poi clicca il pulsante per verificare l'osservienza del dominio. Devi verificare l'osservienza del dominio prima di accedere con Single Sign-On.",
    "Copy {num} items": "Copia {num} elementi",
    "Copy {placeholder} to": "Copia {placeholder} in",
    "Copyright Infringement": "Violazione del diritto d'autore",
    "Count": "Conta",
    "Cover": "Copertina",
    "Cover photo set": "Foto copertina impostata",
    "Create": "Crea",
    "Create At": "Creato il",
    "Create Group": "Creare un gruppo",
    "Create Library": "Crea libreria",
    "Create Report": "Rapporto Creato",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Crea un record DNS TXT per confermare l'osservienza del tuo dominio Email.",
    "Create a new tag": "Crea un nuovo tag",
    "Create time": "Orario di creazione",
    "Create top department": "Crea dipartimento superiore",
    "Created": "Creato",
    "Created At": "Creato il",
    "Created Files": "File creati",
    "Created draft": "Bozza creata",
    "Created file": "File creato",
    "Created folder": "Cartella creata",
    "Created group {group_name}": "Gruppo {group_name} creato",
    "Created library": "Liberia creata",
    "Created library {library_name} with {owner} as its owner": "Libreria {library_name} creata con {owner} come suo proprietario",
    "Created time": "Ora di creazione",
    "Created {n} files": "Creati {n} file",
    "Creator": "Creatore ",
    "Currency symbol is required": "Simbolo valuta obbligatorio",
    "Current Connected Devices": "Dispositivi Attualmente Connessi",
    "Current Library": "Libreria Corrente",
    "Current Path: ": "Percorso Attuale:",
    "Current Version": "Versione Corrente",
    "Current page": "Pagina corrente",
    "Current password": "Password corrente",
    "Current password cannot be blank": "La password attuale non pu\u00f2 essere vuota",
    "Current path: ": "Percorso corrente:",
    "Custom CSS": "CSS personalizzato",
    "Custom currency": "Valuta personalizzata",
    "Custom properties": "Propriet\u00e0 personalizzate",
    "Custom sharing permissions": "Autorizzazioni di condivisione personalizzate",
    "Custom symbol": "Simbolo personalizzato",
    "Custom time": "Tempo personalizzato",
    "Customer Portal": "Portale clienti",
    "Customize URL": "Personalizza URL",
    "DNS TXT Value": "Valore DNS TXT",
    "Dark mode": "Modalit\u00e0 scura",
    "Date": "Data",
    "Date Invalid.": "data non valida.",
    "Day": "Giorno",
    "Decimal separator": "Separatore decimale",
    "Decrypt document": "Decifra documento",
    "Default": "Predefinito",
    "Delete": "Elimina",
    "Delete Account": "Elimina Account",
    "Delete Department": "Dipartimento Rimosso",
    "Delete Expired Invitations": "Elimina inviti scaduti",
    "Delete File": "Rimuovi File",
    "Delete Folder": "Rimuovi Cartella",
    "Delete Group": "Elimina gruppo",
    "Delete Institution": "Elimina istituzione",
    "Delete Library": "Elimina libreria",
    "Delete Member": "Elimina membro",
    "Delete Notification": "Cancella Notifica",
    "Delete Organization": "Cancella l'organizzazione",
    "Delete Password": "Elimina password",
    "Delete T&C": "Cancella T&C",
    "Delete Team": "Elimina Team",
    "Delete User": "Elimina utente",
    "Delete User from Group": "Rimuovi utente dal gruppo",
    "Delete Users": "Cancella Utenti",
    "Delete WebDAV Password": "Elimina la password WebDAV",
    "Delete Wiki": "Rimuovi Wiki",
    "Delete department": "Cancella dipartimento",
    "Delete file": "Elimina file",
    "Delete files from this device the next time it comes online.": "Elimina i file da questo dispositivo la prossima volta che torni online.",
    "Delete folder": "Elimina cartella",
    "Delete group": "Cancella gruppo",
    "Delete location": "Elimina posizione",
    "Delete member": "Elimina membro",
    "Delete page": "Elimina pagina",
    "Delete property": "Elimina propriet\u00e0",
    "Delete selected": "Elimina selezionati",
    "Delete share link": "Elimina il collegamento di condivisione",
    "Delete share links": "Elimina i collegamenti di condivisione",
    "Delete tag": "Elimina tag",
    "Delete tags": "Elimina tag",
    "Delete upload links": "Elimina i collegamenti di caricamento",
    "Deleted": "Eliminato",
    "Deleted Libraries": "Librerie Eliminate",
    "Deleted Time": "Tempo di cancellazione",
    "Deleted by": "Cancellato da",
    "Deleted directories": "Cartelle eliminate",
    "Deleted draft": "Bozza cancellata",
    "Deleted file": "File rimosso",
    "Deleted files": "File eliminati",
    "Deleted folder": "Cartella rimossa",
    "Deleted group {group_name}": "Gruppo {group_name} eliminato",
    "Deleted library": "Libreria Rimossa",
    "Deleted library {library_name}": "Libreria {library_name} rimossa",
    "Deleted option": "Opzione eliminata",
    "Deleted time": "Tempo di cancellazione",
    "Deleted user %s": "Utente %s eliminato",
    "Deleted user {user}": "Utente {user} eliminato",
    "Deleted user {user} from group {group}": "Utente {user} rimosso dal gruppo {group}",
    "Department ID": "ID dipartimento",
    "Department moved successfully": "Trasferimento del gruppo avvenuto con successo",
    "Department not found": "Dipartimento non trovato",
    "Department renamed": "Dipartimento rinominato",
    "Departments": "Dipartimenti",
    "Descending by count": "Decrescente per conteggio",
    "Descending by creation time": "Ordina per data di creazione (in ordine discendente)",
    "Descending by files": "Ordinare per file (decrescente)",
    "Descending by name": "Ordina in ordine alfabetico inverso",
    "Descending by role": "Ordinare per ruolo (decrescente)",
    "Descending by size": "Ordina in ordine di dimensione inverso",
    "Descending by space used": "Ordina per spazio utilizzato in ordine discendente",
    "Descending by time": "Ordina in ordine di data inverso",
    "Descending by visit count": "Ordina per conteggio visiti (in ordine discendente)",
    "Description": "Descrizione",
    "Description generated": "Descrizione generata",
    "Description is required": "La Descrizione \u00e8 richiesta",
    "Desktop": "Desktop",
    "Detail": "Dettaglio",
    "Details": "Dettagli",
    "Detect faces": "Rileva volti",
    "Detecting faces by AI...": "Rilevamento volti tramite AI...",
    "Device": "Dispositivo",
    "Device Name": "Nome Dispositivo",
    "Device make": "Fornitore del dispositivo",
    "Device model": "Modello del dispositivo",
    "Devices": "Dispositivi",
    "Diagram": "Diagramma",
    "Dimensions": "Dimensioni",
    "Direct download link": "Collegamento diretto per il download",
    "Direct download link is copied to the clipboard.": "Il collegamento per il download diretto viene copiato negli appunti.",
    "Disable SSO user email / password login": "Disabilita il login utente tramite SSO se l'account SAML \u00e8 associato",
    "Disable Two-Factor Authentication": "Disabilita l'autenticazione a due fattori",
    "Disable sync with any folder": "Disabilita la sincronizzazione con qualsiasi cartella",
    "Disable user clean trash": "Disabilita la pulizia cestino utente",
    "Disconnect": "Disconnetti",
    "Discussion": "Discussione",
    "Display files": "Mostra file",
    "Do not automatically delete files": "Non eliminare automaticamente i file",
    "Do not keep sharing": "Non mantieni condivisione",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "Vuoi davvero disattivare le propriet\u00e0 estese? Le propriet\u00e0 esistenti verranno tutte eliminate.",
    "Do you really want to turn off face recognition? Existing results will all be deleted.": "Vuoi davvero disattivare il riconoscimento facciale? I risultati esistenti verranno tutti eliminati.",
    "Do you really want to turn off tags? Existing tags will all be deleted.": "Vuoi davvero disattivare i tag? I tag esistenti verranno tutti eliminati.",
    "Do you want to keep the library sharing relationships?": "Sei sicuro di voler mantenere le relazioni di condivisione della libreria?",
    "Document": "Documento",
    "Document conversion failed.": "Conversione documento fallita.",
    "Document keywords": "Parole chiave documento",
    "Dollar": "Dollaro",
    "Domain verified": "Dominio verificato",
    "Don't ignore": "Non ignorare",
    "Don't keep history": "Non conservare la cronologia",
    "Don't replace": "Non sostituire",
    "Don't send emails": "Email non inviate",
    "Don't show empty values": "Non mostrare valori vuoti",
    "Done": "Completato",
    "Dot(1.03)": "Punto(1.03)",
    "Down": "giu",
    "Download": "Scarica",
    "Download Rate Limit": "Limite Di Download",
    "Download an example file": "Scarica un file di esempio",
    "Download and upload": "Scarica e carica",
    "Drag and drop files or folders here.": "Trascina e rilascia i file o le cartelle qui.",
    "Duplicate": "Duplica",
    "Duplicate page": "Duplica pagina",
    "Edit": "Modifica",
    "Edit format settings": "Modifica impostazioni formato",
    "Edit labels": "Modifica etichette",
    "Edit metadata properties": "Modifica le propriet\u00e0 dei metadati",
    "Edit multiple select": "Modifica selezione multipla",
    "Edit on cloud and download": "Modifica nel Cloud e scarica",
    "Edit on cloud only": "Modifica solo sul cloud",
    "Edit permission": "Modifica permesso",
    "Edit single select": "Modifica selezione singola",
    "Edit succeeded": "Modifica eseguita",
    "Edit succeeded.": "Modifica riuscita.",
    "Edit tag": "Modifica tag",
    "Email": "Email",
    "Email Domain": "Dominio Email",
    "Email Notification": "Notifica per Email",
    "Email is invalid.": " L'e-mail non \u00e8 valida.",
    "Email notification updated": "Notifica per Email aggiornata",
    "Emails": "E-mail",
    "Emails, separated by ','": "Email, separate da ','",
    "Emojis": "Emoji",
    "Empty": "Vuoto",
    "Enable Two-Factor Authentication": "Abilita autenticazione a due fattori",
    "Enable branding CSS": "Abilita CSS di branding",
    "Enable departments feature": "Abilita la funzionalit\u00e0 dei dipartimenti",
    "Enable extended properties": "Abilita propriet\u00e0 estese",
    "Enable face recognition to identify people in your photos.": "Abilita il riconoscimento facciale per identificare le persone nelle tue foto.",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Abilitare l'amministratore di sistema per aggiungere termini e condizioni e tutti gli utenti dovranno accettare i termini.",
    "Enable tags to add tags to files and search files by tags.": "Abilita i tag per aggiungere tag ai file e cercare i file per tag.",
    "Enable terms and conditions": "Abilita i termini e le condizioni",
    "Enable two factor authentication": "Abilita l'autenticazione a due fattori",
    "Enable users to clean trash": "Consenti agli utenti di pulire il cestino della libreria",
    "Enable users to share libraries to any groups in the system.": "Consenti agli utenti di condividere le librerie con qualsiasi gruppo nel sistema.",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "Abilita condivisione in tutti i gruppi",
    "Encrypt": "Cifra",
    "Encrypted library": "Libreria crittografata",
    "End date": "Data di fine",
    "Enforce precision": "Applica precisione",
    "Enter characters to start searching": "Digita alcuni caratteri per avviare la ricerca",
    "Enter custom currency symbol": "Inserisci simbolo valuta personalizzato",
    "Enter date": "Inserisci data",
    "Error": "Errore",
    "Errors": "Errori",
    "Euro": "Euro",
    "European": "Europea",
    "Exact date": "Data esatta",
    "Exit Institution Admin": "Esci dall'amministrazione dell'istituto",
    "Exit Organization Admin": "Esci dall'amministrazione dell'organizzazione",
    "Exit System Admin": "Uscita da Amministrazione di Sistema",
    "Expand all": "Espandi tutto",
    "Expiration": "Scadenza",
    "Expiration date": "Data di scadenza",
    "Expiration days": "Giorni di scadenza",
    "Expiration time": "Tempo di scadenza",
    "Expired": "Scaduto",
    "Expired at": "Scaduro il",
    "Export": "Esportare",
    "Export Excel": "Esporta in Excel",
    "Export as Markdown": "Esporta come Markdown",
    "Export as docx": "Esporta come docx",
    "Export as sdoc": "Esporta come sdoc",
    "Export as zip": "Esporta come zip",
    "Export options": "Esporta opzioni",
    "Export tags": "Esporta tag",
    "Exporting": "Esportazione",
    "Exporting...": "Esportazione in corso...",
    "Exposure time": "Tempo esposizione",
    "Extended properties": "Propriet\u00e0 estese",
    "Extension Prompts": "Prompts estensioni",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Estensioni dei file di testo che possono essere visualizzati in anteprima online, ciascun suffisso \u00e8 separato da una virgola.",
    "Extract file detail": "Estrai dettagli del file",
    "Extract file details": "Estrai dettagli file",
    "Extract text": "Estrai testo",
    "Extracting file details by AI...": "Estrrazione dettagli file tramite AI...",
    "Extracting text, please wait...": "Estrazione testo, attendere prego...",
    "F number": "Numero f",
    "Face recognition": "Riconoscimento facciale",
    "Face recognition is done for library {libraryName}.": "L'identificazione facciale \u00e8 stata completata per la libreria {libraryName}.",
    "Faces detected": "Volti rilevati",
    "Failed": "Fallito",
    "Failed imported options": "Opzioni importate fallite",
    "Failed to add linked tags": "Impossibile aggiungere tag collegati.",
    "Failed to add people photos": "Aggiunta foto persone fallita",
    "Failed to add tags": "Impossibile aggiungere tag.",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "Impossibile aggiungere {email_placeholder}: {error_msg_placeholder}",
    "Failed to convert {name}.": "Impossibile convertire {name}.",
    "Failed to copy %(name)s": "Impossibile copiare %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Non \u00e8 stato possibile copiare %(name)s e %(amount)s altri elementi.",
    "Failed to copy %(name)s.": "Non \u00e8 stato possibile copiare %(name)s.",
    "Failed to copy file": "Copia file fallita",
    "Failed to copy files to another library.": "Impossibile copiare i file in un'altra libreria.",
    "Failed to copy {n} items": "Copia {n} elementi fallita",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Impossibile eliminare %(virus_file) dalla libreria %(library): %(error_msg)",
    "Failed to delete linked tags": "Impossibile eliminare tag collegati.",
    "Failed to delete property": "Eliminazione propriet\u00e0 fallita",
    "Failed to delete records": "Eliminazione record fallita",
    "Failed to delete tags": "Impossibile eliminare tag.",
    "Failed to delete {name}": "Impossibile eliminare {name}.",
    "Failed to delete {name} and {n} other items.": "Impossibile eliminare {name} e gli altri {n} elementi.",
    "Failed to delete {name}.": "Impossibile eliminare {name}.",
    "Failed to detect faces": "Rilevamento volti fallito",
    "Failed to download. The total size of the files exceeded the limit.": "Impossibile scaricare. La dimensione totale dei file ha superato il limite.",
    "Failed to duplicate file": "Duplicazione file fallita",
    "Failed to duplicate folder": "Duplicazione cartella fallita",
    "Failed to duplicate page": "Impossibile duplicare la pagina",
    "Failed to export tags": "Impossibile esportare tag.",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "Impossibile esportare. Controlla se la dimensione degli allegati della tabella supera il limite.",
    "Failed to extract file details": "Estrrazione dettagli file fallita",
    "Failed to extract text": "Impossibile estrarre il testo",
    "Failed to generate description": "Generazione descrizione fallita",
    "Failed to generate file tags": "{name_placeholder} Impossibile generare i tag del file",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Impossibile ignorare %(virus_file) dalla libreria %(library): %(error_msg)",
    "Failed to import Confluence": "Impossibile importare Confluence",
    "Failed to import Confluence file": "Impossibile importare il file Confluence",
    "Failed to import page": "Impossibile importare la pagina",
    "Failed to import tags": "Impossibile importare tag.",
    "Failed to insert property": "Inserimento propriet\u00e0 fallito",
    "Failed to merge tags": "Impossibile unire tag.",
    "Failed to modify filter": "Modifica filtro fallita",
    "Failed to modify group": "Modifica gruppo fallita",
    "Failed to modify hidden properties": "Modifica propriet\u00e0 nascoste fallita",
    "Failed to modify people name": "Modifica nome persona fallita",
    "Failed to modify property data": "Modifica dati propriet\u00e0 fallita",
    "Failed to modify property order": "Modifica ordine propriet\u00e0 fallita",
    "Failed to modify records": "Modifica record fallita",
    "Failed to modify settings": "Modifica impostazioni fallita",
    "Failed to modify sort": "Modifica ordinamento fallita",
    "Failed to modify tags": "Modifica tag fallita",
    "Failed to move %(name)s and %(amount)s other item(s).": "Non \u00e8 stato possibile spostare %(name)s e %(amount)s altri elementi.",
    "Failed to move %(name)s.": "Non \u00e8 stato possibile spostare %(name)s.",
    "Failed to move file": "Spostamento file fallito",
    "Failed to move files to another library.": "Impossibile spostare i file in un'altra libreria.",
    "Failed to move folder": "Spostamento cartella fallito",
    "Failed to move {name}.": "Non \u00e8 stato possibile spostare {name}.",
    "Failed to move {n} items": "Spostamento {n} elementi fallito",
    "Failed to remove people photos": "Rimozione foto persone fallita",
    "Failed to rename property": "Ridenominazione propriet\u00e0 fallita",
    "Failed to restore records": "Ripristino record fallito",
    "Failed to restore tags": "Impossibile ripristinare tag.",
    "Failed to restore {name}": "Impossibile ripristinare {name}.",
    "Failed to restore {name} and {n} other items": "Impossibile ripristinare {name} e gli altri {n} elementi.",
    "Failed to save": "Impossibile salvare",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Impossibile inviare a {email_placeholder}: {errorMsg_placeholder}",
    "Failed to set people cover photo": "Impostazione foto copertina persona fallita",
    "Failed to unshare {name}": "Impossibile scollegare {name}",
    "Failed to upload {file_name}.": "Impossibile caricare {file_name}.",
    "Failed. Please check the network.": "Errore. Si prega di verificare la configurazione di rete.",
    "Favicon": "Favicon",
    "Favorites": "Preferiti",
    "File": "File",
    "File Access": "Accesso ai file",
    "File Operations": "Operazioni sui file",
    "File Scan": "Scansione File",
    "File Update": "Aggiornamento File",
    "File Upload": "Caricare un file",
    "File Uploading...": "Caricamento file...",
    "File already exists.": "Il File esiste gi\u00e0.",
    "File collaborators": "Collaboratori file",
    "File count": "Numero di file",
    "File details": "Dettagli file",
    "File details extracted": "Dettagli file estratti",
    "File download is disabled: the share link traffic of owner is used up.": "File download disabilitato: la quota di traffico del collegamento per l'utente \u00e8 esaurita.",
    "File expire time": "Data scadenza file",
    "File extension white list": "Elenco estensioni file consentite",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "Elenco estensioni file consentite per il caricamento via web UI e API. Ad esempio, \"md;txt;docx\". L'empty significa nessun limite.",
    "File extensions can only be {placeholder}.": "Le estensioni dei file possono essere solo {placeholder}.",
    "File is locked by others.": "Il file \u00e8 bloccato da altri.",
    "File name": "Nome file",
    "File name and content": "Nome file e contenuto",
    "File name only": "Nome file solo",
    "File owner": "Proprietario file",
    "File rate": "Valutazione file",
    "File reviewer": "Revisore file",
    "File size is too large.": "Dimensione del File troppo grande.",
    "File size should be smaller than {max_size_placeholder}.": "La dimensione del file deve essere inferiore a {max_size_placeholder}.",
    "File status": "Stato file",
    "File suffix": "Estensione del file",
    "File too large": "File troppo grande",
    "File type": "Tipo di file",
    "File {file_link} has a new comment form user {author}.": "Il file {file_link} ha un nuovo commento dall'utente {author}.",
    "Files": "Documenti",
    "Files and folders": "File e cartelle",
    "Files by creator": "File per creatore",
    "Files by time": "File per tempo",
    "Files by type": "File per tipo",
    "Fill in": "Compila",
    "Filter": "Filtro",
    "Filters": "Filtri",
    "Find": "Cerca",
    "Find a tag": "Cerca una etichetta",
    "Find libraries": "Trova librerie",
    "Find modifiers": "Trova modificatori",
    "Find users": "Trova utenti",
    "Focal length": "Lunghezza focale",
    "Fold": "Collassa",
    "Fold the sidebar": "Nascondi la barra laterale",
    "Folder": "Cartella",
    "Folder Permission": "Permessi cartella",
    "Folder does not exist.": "La cartella non esiste.",
    "Folder permission is only effective after the library is shared to users or groups. It is used to fine tune sub-folder permissions.": "I permessi della cartella sono solo efficaci dopo che la libreria \u00e8 stata condivisa con utenti o gruppi. Sono utilizzati per regolare i permessi delle sottocartelle.",
    "Folders": "Cartelle",
    "Force Two-Factor Authentication": "Forza l'autenticazione a due fattori",
    "Force password change": "Forza l'utente a cambiare la password quando l'account viene aggiunto o ripristinato dall'amministratore",
    "Force user to change password when account is newly added or reset by admin": "Forza l'utente a cambiare la password quando l'account viene aggiunto o ripristinato dall'amministratore",
    "Force user to use SSO login if SSO account is bound": "Forza l'utente ad utilizzare il login tramite SSO se l'account SSO \u00e8 associato",
    "Force user to use a strong password when sign up or change password.": "Forza l'utente a utilizzare una password complessa al momento della registrazione o modifica della password.",
    "Force users to use password when generating share/upload link.": "Forza gli utenti a utilizzare una password quando generano il link di condivisione/upload.",
    "Format": "Formato",
    "Freeze Document": "Blocca documento",
    "Freeze page": "Congela pagina",
    "Freeze user account when failed login attempts exceed limit.": "Blocca l'account utente quando i tentativi di accesso falliti superano il limite.",
    "Freeze user on login failed": "Blocca l'account utente quando i tentativi di accesso falliti superano il limite.",
    "Frozen by {name}": "Congelato da {name}",
    "Full screen": "Schermo intero",
    "Gallery": "Galleria",
    "General": "Generale",
    "General information": "Informazioni generali",
    "Generate": "Generare",
    "Generate Link": "Genera collegamento",
    "Generate description": "Genera descrizione",
    "Generate file tags": "Genera tag del file",
    "Generate links in batch": "Genera collegamenti in batch",
    "Generate share link": "Link di condivisione generico",
    "Generating description by AI...": "Generazione descrizione tramite AI...",
    "Germany Russia etc": "Germania Russia ecc.",
    "Global Address Book": "Rubrica globale",
    "Global hidden properties": "Propriet\u00e0 nascoste globali",
    "Global hidden properties will not be displayed in all views.": "Le propriet\u00e0 nascoste globali non saranno visualizzate in tutte le viste.",
    "Go back": "Torna indietro",
    "Go to Library": "Vai alla Libreria",
    "Greater than or equal to {minDays_placeholder} days": "Maggiore o uguale a {minDays_placeholder} giorni",
    "Grid view": "Visualizzazione griglia",
    "Group": "Condivise ai miei Gruppi",
    "Group Invite": "Invito Gruppo",
    "Group Member": "Membro del gruppo",
    "Group Permission": "Permessi Gruppo",
    "Group Shares": "Condivisioni del Gruppo",
    "Group by": "Raggruppa per",
    "Group deleted": "Gruppo eliminato",
    "Group has been transferred": "Gruppo trasferito",
    "Group info": "Informazioni sul gruppo",
    "Group invitation link": "Link invito al gruppo",
    "Group members": "Membri del gruppo",
    "Grouped by 1 property": "Raggruppati per 1 propriet\u00e0",
    "Grouped by {name_placeholder} properties": "Raggruppati per {name_placeholder} propriet\u00e0",
    "Groups": "Gruppi",
    "Guest": "Ospite",
    "Handled": "Mantenuto",
    "Help": "Aiuto",
    "Help and resources": "Aiuto e risorse",
    "Hidden properties": "Propriet\u00e0 nascoste",
    "Hide": "Nacondi",
    "Hide advanced search": "Nascondi ricerca avanzata",
    "Hide all": "Nascondi tutto",
    "Hide properties": "Nascondi propriet\u00e0",
    "History": "Cronologia",
    "History Setting": "Preferenze Storico",
    "History Versions": "Versioni cronologia",
    "ID": "ID",
    "IP": "IP",
    "ISO": "ISO",
    "Identifying portraits...": "Riconoscimento ritratti in corso...",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "Se le notifiche non vengono lette entro un'ora, verranno inviate alla tua casella di posta.",
    "If the library is shared to another department, the sharing will be kept.": "Se la libreria \u00e8 condivisa con un altro dipartimento, la condivisione verr\u00e0 mantenuta.",
    "If the library is shared to another user, the sharing will be kept.": "Se la libreria \u00e8 condivisa con un altro utente, la condivisione verr\u00e0 mantenuta.",
    "If there are multiple items in the cell, a random one will be chosen and be compared with the filter value.": "Se nella cella ci sono pi\u00f9 elementi, verr\u00e0 scelto uno casuale e verr\u00e0 confrontato con il valore del filtro.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Se attivi, i client desktop non saranno in grado di sincronizzare una cartella al di fuori della cartella predefinita Seafile.",
    "If you don't have any device with you, you can access your account using backup codes.": "Se non hai alcun dispositivo con te, puoi accedere al tuo account usando i codici di backup.",
    "Ignore": "Ignora",
    "Ignored": "Ignorato",
    "Image saved": "Immagine salvata",
    "Import": "Importa",
    "Import Confluence": "Importa Confluence",
    "Import Confluence Wiki": "Importa Wiki Confluence",
    "Import Users": "Importa utenti",
    "Import members": "Importa membri",
    "Import members from a .xlsx file": "Importa membri da un file .xlsx",
    "Import options": "Importa opzioni",
    "Import page": "Importa pagina",
    "Import page from Markdown": "Importa pagina da Markdown",
    "Import page from docx": "Importa pagina da docx",
    "Import sdoc": "Importa sdoc",
    "Import tags": "Importa etichette",
    "Import users": "Importa utenti",
    "Import users from a .xlsx file": "Importa utente da un file .xlsx",
    "Importing page...": "Importando pagina...",
    "Importing sdoc, please wait...": "Importando sdoc, attendi...",
    "Importing tags...": "Importando etichette...",
    "Importing...": "Importando...",
    "In progress": "In corso",
    "In review": "In revisione",
    "Inactive": "Inattivo",
    "Info": "Info",
    "Institution Admin": "Amministratore dell'Istituzione",
    "Institutions": "Istruzioni",
    "Internal Link": "Collegamento interno",
    "Internal Server Error": "Errore interno del server",
    "Internal link has been copied to clipboard": "Il collegamento interno \u00e8 stato copiato negli appunti",
    "Invalid destination path": "Percorso di destinazione non valido",
    "Invalid filename.": "Nome file invalido.",
    "Invalid filter": "Filtro non valido",
    "Invalid month, should be yyyymm.": "Mese non valido, dovrebbe essere espresso nella forma aaaamm.",
    "Invalid regular expression": "Espressione regolare non valida",
    "Invisible": "Invisibile",
    "Invitation link has been copied to clipboard": "Link d'invito \u00e8 stato copiato negli appunti",
    "Invitations": "Inviti",
    "Invite Guest": "Invita ospite",
    "Invite Time": "Tempo di Invito",
    "Invite members": "Invita membri",
    "Invite users": "Invita utenti",
    "Invite users via WeChat": "Invita utenti tramite WeChat",
    "Invited at": "Invitato il",
    "Inviter": "Invitante",
    "Is expired": "\u00c8 scaduto",
    "It is already shared to user": "Gi\u00e0 condiviso con utente",
    "It is required.": "\u00c8 richiesto.",
    "It may take some time, please wait.": "Potrebbe volerci del tempo, ti preghiamo di attendere.",
    "Kanban": "Kanban",
    "Keep full history": "Conserva la cronologia",
    "Keep sharing": "Mantieni condivisione",
    "Keep sign in": "Conserva l'accesso",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP(importato)",
    "Label": "Etichetta",
    "Label Current State": "Etichetta Stato corrente",
    "Labels": "Etichette",
    "Language": "Lingua",
    "Language Setting": "Impostazioni Lingua",
    "Language for tags generated by AI": "Lingua per i tag generati da AI",
    "Last 30 days": "Ultimi 30 giorni",
    "Last 7 days": "Ultimi 7 giorni",
    "Last Access": "Ultimo Accesso",
    "Last Login": "Ultimo Accesso",
    "Last Update": "Ultimo aggiornamento",
    "Last modification": "Modifica precedente",
    "Last modified by": "Ultima modifica da",
    "Last modified time": "Ora dell'ultima modifica",
    "Last modifier": "Ultima modifica",
    "Leave": "Abbandona",
    "Leave Group": "Abbandona Gruppo",
    "Leave Share": "Lascia Condivisione",
    "Leave Share Wiki": "Abbandona Condivisione del Wiki",
    "Leave group": "Abbandona gruppo",
    "Leave this page? The system may not save your changes.": "Vuoi lasciare questa pagina? Il sistema potrebbe non salvare le tue modifiche.",
    "Less than or equal to {maxDays_placeholder} days": "Minore o uguale a {maxDays_placeholder} giorni",
    "Libraries": "Librerie",
    "Library": "Libreria",
    "Library Type": "Tipo di Libreria",
    "Library can not be shared to owner.": "La libreria non pu\u00f2 essere condivisa con il proprietario.",
    "Library does not exist": "La libreria non esiste",
    "Library history": "Storico libreria",
    "Library not found": "Libreria non trovata",
    "Library password minimum length": " Lunghezza minima della password della libreria crittografata",
    "Light mode": "Modalit\u00e0 chiara",
    "Limits": "Limiti",
    "Line wrapping": "Rappresentazione a capo",
    "Link": "Link",
    "Link has been copied to clipboard": "Il link \u00e8 stato copiato negli appunti",
    "Link image": "Link immagine",
    "Linked Devices": "Dispositivi collegati",
    "Links": "Link",
    "List view": "Visualizzazione elenco",
    "List your account in global address book, so that others can find you by typing your name.": "Elenca la rubrica globale del il tuo account, in modo che altri possano trovarti digitando il tuo nome.",
    "Load all": "Carica tutto",
    "Loading": "Caricamento in corso",
    "Loading metadata...": "Caricamento metadati...",
    "Loading...": "Sto Caricando...",
    "Location": "Posizione",
    "Lock": "Serratura",
    "Log out": "Termina Sessione",
    "Login": "Accesso",
    "Login ID": "ID Utente",
    "Login attempt limit": "Limite di tentativi di accesso",
    "Login background image": "Immagine di sfondo di login",
    "Logo": "Logo",
    "Logo updated": "Logo aggiornato",
    "Logs": "Logs",
    "Long text": "Testo lungo",
    "Manage group members": "Gestisci i membri del gruppo",
    "Manage members": "Gestisci membri",
    "Map": "Mappa",
    "Map is not ready": "Mappa non pronta",
    "Mark all as read": "Contrassegna tutto come letto",
    "Mark all read": "Segna come letti",
    "Mark as resolved": "Contrassegnato come risolto",
    "Marked \"{resolve_comment}\" as resolved in document {sdoc_link}": "Cambiato il \"{resolve_comment}\" in risolto nel documento {sdoc_link}",
    "Marked as resolved in document {sdoc_link}": "Cambiato in risolto nel documento {sdoc_link}",
    "Matching tags": "Tag corrispondenti",
    "Max": "Massimo",
    "Max number of members": "Numero massimo di membri",
    "Member": "Membro",
    "Members": "Membri",
    "Merge tags": "Unisci tag",
    "Merge tags to": "Unisci tag a",
    "Message": "Messaggio",
    "Message (optional):": "Messaggio (opzionale):",
    "Metrics": "Metriche",
    "Migrate": "Migra",
    "Migrate User": "Migrazione utente",
    "Migrate old version tags": "Migra i tag della versione precedente",
    "Mobile": "Mobile",
    "Modification Details": "Dettaglio Modifiche",
    "Modified": "Modificato",
    "Modified by": "Modificato da",
    "Modified by:": "Modificato da:",
    "Modified files": "File modificati",
    "Modified time": "Ora di modifica",
    "Modifier": "Modificatore",
    "Modify": "Modificare",
    "Modify includes modify file, move/rename file and folder": "Modifica include modificare file, spostare/rinominare file e cartelle",
    "Modify name": "Modifica nome",
    "Month": "Mese",
    "Month:": "Mese:",
    "Monthly User Traffic": "Traffico utenti mensile",
    "More": "Altro",
    "More operations": "Altro",
    "Move": "Sposta",
    "Move department": "Mossa dipartimento",
    "Move file": "Sposta file",
    "Move folder": "Sposta cartella",
    "Move selected item(s) to:": "Sposta gli oggetti selezionati su:",
    "Move to department": "Trasferisci gruppo a dipartimento",
    "Move {num} items": "Sposta {num} elementi",
    "Move {placeholder} to": "Sposta {placeholder} in",
    "Moved file": "File spostato",
    "Moved folder": "Cartella spostata",
    "Multiple select": "Selezione multipla",
    "My Activities": "Le mie attivit\u00e0",
    "My Libraries": "Le Mie Librerie",
    "My Wikis": "I miei Wiki",
    "Name": "Nome",
    "Name already exists": "Il nome esiste gi\u00e0",
    "Name cannot be double dots": "Il nome non pu\u00f2 contenere due punti",
    "Name cannot be empty": "Il nome non pu\u00f2 essere vuoto",
    "Name cannot contain backslash": " Il nome non pu\u00f2 contenere il carattere '\\'",
    "Name cannot contain backtick": "Il nome non pu\u00f2 contenere il carattere backtick",
    "Name cannot contain curly braces": "Il nome non pu\u00f2 contenere le parentesi graffe",
    "Name cannot contain dots": "Il nome non pu\u00f2 contenere punti",
    "Name cannot contain slash": " Il nome non pu\u00f2 contenere il carattere '/'",
    "Name is required": "Il nome \u00e8 obbligatorio",
    "Name is required.": "Il nome \u00e8 obbligatorio.",
    "Name or ID": "Nome o ID",
    "Name should be string": "Il nome dovrebbe essere una stringa",
    "Name should not include '/'.": "Il nome non dovrebbe contenere '/'.",
    "Name updated": "Nome aggiornato",
    "Name(optional)": "Nome(opzionale)",
    "Names don't match": "I nomi non corrispondono",
    "Network error": "Errore rete",
    "New": "Nuovo",
    "New Department": "Nuovo Dipartimento",
    "New Department Library": "Nuova libreria del dipartimento",
    "New Docxf File": "Nuovo file Docxf",
    "New Excalidraw File": "Nuovo file Excalidraw",
    "New Excel File": "Nuovo file Excel",
    "New File": "Nuovo File",
    "New Folder": "Nuova Cartella",
    "New Group": "Nuovo gruppo",
    "New Library": "Nuova libreria",
    "New Markdown File": "Nuovo file Markdown",
    "New Password": "Nuova Password",
    "New Password Again": "Nuova Password Controllo",
    "New PowerPoint File": "Nuovo file di PowerPoint",
    "New SeaDoc File": "Nuovo file SeaDoc",
    "New Sub-department": "Nuovo Sotto-dipartimento",
    "New Whiteboard File": "Nuovo file di\u767d\u677f",
    "New Word File": "Nuovo file Word",
    "New category": "Nuova categoria",
    "New child tag": "Nuovo tag figlio",
    "New directories": "Nuove cartelle",
    "New file name": "Nuovo nome file",
    "New files": "Nuovi file",
    "New folder": "Nuova cartella",
    "New folder name": "Nuovo nome cartella",
    "New page": "Nuova pagina",
    "New password": "Nuova password",
    "New password cannot be the same as old password": " La nuova password non pu\u00f2 essere uguale alla vecchia password",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": " La nuova password \u00e8 stata inviata alla tua email {mail}. Per favore controlla la tua casella di posta. Se non ricevi la password, controlla se il tuo indirizzo email \u00e8 configurato correttamente.",
    "New password is too short": "La nuova password \u00e8 troppo corta",
    "New passwords don't match": "Le nuove password non corrispondono",
    "New tag": "Nuovo tag",
    "New view": "Nuova vista",
    "Next": "Successivo",
    "Next (Right arrow key)": "Successivo (tasto freccia destra)",
    "Next modification": "Modifica successiva",
    "No Admin login logs": "Nessun log di accesso amministratore",
    "No Admin operation logs": "Nessun log di operazione amministrativa",
    "No Wikis": "Nessun Wiki",
    "No categories": "Nessuna categoria",
    "No changes": "Nessuna modifica",
    "No collaborators": "Nessun collaboratore",
    "No collaborators available": "Nessun collaboratore disponibile",
    "No comment yet.": "Ancora nessun commento.",
    "No connected devices": "Nessun dispositivo connesso",
    "No creator data available": "Nessun dato disponibile per il creatore",
    "No data available for statistics": "Nessun dato disponibile per le statistiche",
    "No deleted libraries": "Nessuna libreria eliminata",
    "No favorites": "Nessun preferito",
    "No file": "Nessun file",
    "No file access logs": "Nessun log di accesso ai file",
    "No file selected": "Nessun file selezionato",
    "No file update logs": "Nessun log di aggiornamento file",
    "No files": "Nessun file",
    "No files or folders have been shared with you": "Nessun file o cartella \u00e8 stato condiviso con te",
    "No files or folders have been shared with you from other servers.": "Nessun file o cartella \u00e8 stato condiviso con te da altri server.",
    "No filters": "Nessun filtro",
    "No folders shared": "Nessuna cartella condivisa",
    "No group invitation link yet. Group invitation link let registered users to join the group by clicking a link.": "Nessun link di inviti a un gruppo. I link permettono agli utenti registrati di unirsi a un gruppo cliccando su di essi",
    "No group shares": "Nessuna condivisione gruppo",
    "No groupings applied to this view.": "Nessun raggruppamento applicato a questa visualizzazione.",
    "No groups": "Nessun gruppo",
    "No guest invitations": "Nessun invito guest",
    "No invitations": "Nessun invito",
    "No items": "Nessun elemento",
    "No libraries": "Nessuna libreria",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "Nessuna libreria \u00e8 stata condivisa direttamente con te. Una libreria condivisa pu\u00f2 essere condivisa con permessi completi o limitati. Se hai bisogno di accedere a una libreria di propriet\u00e0 di un altro utente, chiedi all'utente di condividerla con te.",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.": "Nessuna libreria ha ancora been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.",
    "No libraries have been shared with you": "Nessuna libreria \u00e8 stata condivisa con te",
    "No libraries have been shared with you from other servers.": "Nessuna libreria \u00e8 stata condivisa con te da altri server.",
    "No libraries shared": "Nessuna libreria condivisa",
    "No libraries shared with this group": "Nessuna libreria condivisa con questo gruppo",
    "No linked devices": "Nessun dispositivo collegato",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Nessun dispositivo collegato. Non hai ancora effettuato l'accesso ai tuoi file con nessun client (desktop o mobile). Configura i client sui tuoi dispositivi per accedere ai tuoi dati pi\u00f9 comodamente.",
    "No login logs": "Nessun log di accesso",
    "No matching tags": "Nessun tag corrispondente",
    "No members": "Nessun membro",
    "No more activities": "Nessuna attivit\u00e0 pi\u00f9 recente",
    "No notifications": "Nessuna notifica",
    "No option": "Nessuna opzione",
    "No options": "Nessuna opzione",
    "No options available": "Nessuna opzione disponibile",
    "No permission logs": "Nessun log di autorizzazione",
    "No properties available to be hidden": "Nessuna propriet\u00e0 disponibile per essere nascosta",
    "No public libraries": "Nessuna libreria pubblica",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" item in the dropdown menu.": "Non sono state create ancora librerie pubbliche. Una libreria pubblica \u00e8 accessibile da tutti gli utenti. Puoi creare una libreria pubblica cliccando sull'elemento \"Aggiungi libreria\" nel menu a tendina.",
    "No recommended new tags": "Nessun tag consigliato",
    "No record": "Nessun record",
    "No result": "Nessun risultato",
    "No results": "Nessun risultato",
    "No results found": "Nessun risultato trovato",
    "No results matching": "Nessun risultato corrispondente",
    "No separator (1000000)": "Nessun separatore (1000000)",
    "No share links": "Nessun link di condivisione",
    "No shared Wikis": "Nessun Wiki condiviso",
    "No shared libraries": "Nessuna libreria condivisa",
    "No sorts": "Nessun ordinamento",
    "No sync errors": "Nessun errore di sincronizzazione",
    "No tag": "Nessun tag",
    "No tags": "Nessun tag",
    "No tags available": "Nessun tag disponibile",
    "No terms and conditions": "Nessun termine e condizione",
    "No text extracted": "Nessun testo estratto",
    "No time-based data available": "Nessun dato basato sul tempo disponibile",
    "No upload links": "Nessun link di caricamento",
    "No user shares": "Nessuna condivisione utente",
    "No users found": "Nessun utente trovato",
    "No version history": "Nessuna versione precedente",
    "Node": "Nodo",
    "None": "Niente",
    "Not allow user to clean library trash": "Non consentire all'utente di pulire il cestino della libreria",
    "Not allow user to create encrypted libraries": "Non consentire all'utente di creare librerie crittate",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Nota: le impostazioni tramite l'interfaccia web vengono salvate nella tabella del database (seahub-db/constance_config). Hanno una priorit\u00e0 pi\u00f9 alta rispetto alle impostazioni contenute dei file di configurazione",
    "Notification": "Notifica",
    "Notification Detail": "Dettagli di notifica",
    "Notifications": "Notifiche",
    "Notifications of collaboration": "Notifiche di collaborazione",
    "Notifications of file changes": "Notifiche delle modifiche ai file",
    "Number": "Numero",
    "Number format settings": "Impostazioni formato numerico",
    "Number of days ago": "Numero di giorni fa",
    "Number of days from now": "Numero di giorni da ora",
    "Number of days that keep user sign in.": "Numero di giorni in cui l'utente rimane connesso.",
    "Number of groups": "Numero di gruppi",
    "Number of links": "Numero di collegamenti",
    "Number of members": "Numero di membri",
    "Number of records exceeds the limit of 1000": "Il numero di record supera il limite di 1000",
    "OCR": "OCR",
    "OCR result": "Risultato OCR ",
    "Off": "Spento",
    "Office Suite": "Suite di Office",
    "Old Password": "Vecchia Password",
    "Old Wikis": "Vecchi Wiki",
    "On": "Acceso",
    "One month ago": "Un mese fa",
    "One month from now": "Un mese da ora",
    "One week ago": "Una settimana fa",
    "One week from now": "Una settimana da ora",
    "Online Preview": "Anteprima Online",
    "Online Read-Only": "Online in sola lettura",
    "Online Read-Only folder": "Cartella online in sola lettura",
    "Online Read-Only library": "Libreria online in sola lettura",
    "Online Read-Write": "Online Lettura-Scrittura",
    "Online Read-Write folder": "Cartella online di Lettura-Scrittura",
    "Online Read-Write library": "Libreria online di Lettura-Scrittura",
    "Online view is not applicable to this file format": "La visualizzazione online non \u00e8 applicabile a questo formato di file",
    "Only Show": "Solo Visualizzazione",
    "Only files": "Solo file",
    "Only folders": "Solo cartelle",
    "Only keep a period of history:": "Tieni solamente un periodo della cronologia:",
    "Only pictures": "Solo immagini",
    "Only videos": "Solo video",
    "Open file": "Apri file",
    "Open file in new tab": "Apri il file in una nuova scheda",
    "Open folder": "Apri cartella",
    "Open folder in new tab": "Apri la cartella in una nuova scheda",
    "Open in new tab": "Apri in nuova scheda",
    "Open parent folder": "Apri cartella principale",
    "Open the panel": "Apri la finestra",
    "Open via Client": "Apri tramite Client ",
    "Open via client": "Aprire tramite client",
    "Operation": "Operazione",
    "Operation succeeded.": "Operazione conclusa con successo.",
    "Operations": "Operazioni",
    "Operator": "Operatore",
    "Optional": "Opzionale",
    "Options imported": "Opzioni importate",
    "Or": "O",
    "Organization": "Organizzazione",
    "Organization Admin": "Amministratore dell'organizzazione",
    "Organizations": "Organizzazioni",
    "Original path": "Percorso originale",
    "Other": "Altro",
    "Other Libraries": "Altre Librerie",
    "Others": "Altri",
    "Out of quota.": "Quota superata.",
    "Outdated": "Obsoleto",
    "Outline": "Raggruppamento",
    "Owned Libraries": "Librerie di propriet\u00e0",
    "Owner": "Proprietario",
    "Owner can use admin panel in an organization, must be a new account.": "Il proprietario pu\u00f2 utilizzare il pannello di amministrazione in una organizzazione, deve essere un nuovo account.",
    "Packaging...": "Creazione del file zip in corso...",
    "Page fit": "Adatta alla pagina",
    "Page imported": "Pagina importata",
    "Page is frozen": "Pagina congelata",
    "Page name": "Nome pagina",
    "Page {name_placeholder} deleted.": "Pagina {name_placeholder} eliminata.",
    "Pages": "Pagine",
    "Parent folder": "Cartella madre",
    "Parent tags": "Tag genitori",
    "Password": "Password",
    "Password again": "Ridigita password",
    "Password cannot be blank": "Password non pu\u00f2 essere vuota",
    "Password is too short": "La password \u00e8 troppo corta",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "La password deve essere lunga almeno 8 caratteri e contenere caratteri diversi: lettere maiuscole, lettere minuscole, numeri e simboli speciali",
    "Password removed": "Password rimosso",
    "Password reset": "Password resettata",
    "Password set": "Password impostata",
    "Password strength": "Robustezza della password",
    "Password strength should be strong or very strong": "La forza della password dovrebbe essere forte o molto forte",
    "Password updated": "Password aggiornata",
    "Passwords do not match.": "Le password non corrispondono.",
    "Passwords don't match": "Le Password non corrispondono",
    "Path": "Percorso",
    "People": "Persone",
    "Per 4 hours": "Per 4 ore",
    "Per day": "Per giorno",
    "Per hour": "Per ora",
    "Per week": "Per settimana",
    "Percent": "Percentuale",
    "Permission": "Permesso",
    "Permission denied": "Permesso negato.",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Autorizzazione negata. Prova ad accedere nuovamente con {placeholder-left}. {placeholder-right}",
    "Permission name": "Nome permesso",
    "Person image": "Immagine della persona",
    "Picture": "Immagine",
    "Pictures and videos": "Immagini e video",
    "Platform": "Piattaforma",
    "Please check the network.": "Si prega di controllare la configurazione di rete.",
    "Please choose a .xlsx file.": "Si prega di scegliere un file .xlsx",
    "Please choose an image file.": "Scegli un file immagine.",
    "Please enter 1 or more character": "Prego inserire 1 o pi\u00f9 caratteri",
    "Please enter a new password": "Si prega di inserire una nuova password",
    "Please enter a new quota": "Inserisci una nuova quota",
    "Please enter a non-negative integer": "Prego inserire un intero non negativo",
    "Please enter a password.": "Inserisci una password.",
    "Please enter a positive integer": "Inserisci un numero intero positivo",
    "Please enter an integer bigger than 1 as number of links.": "Inserisci un numero intero maggiore di 1 come numero di collegamenti",
    "Please enter an integer not bigger than {max_number} as number of links.": "Inserisci un numero intero non maggiore di {max_number} come numero di collegamenti.",
    "Please enter days": "Prego inserire i giorni",
    "Please enter password": "Per favore, inserisci la password",
    "Please enter the address": "Compila l'indirizzo",
    "Please enter the new password again": "Si prega di inserire nuovamente la nuova password",
    "Please enter the old password": "Si prega di inserire la vecchia password",
    "Please enter the password again": "Si prega di inserire nuovamente la password",
    "Please input at least an email.": "Per favore inserisci almeno un'email.",
    "Please select": "Seleziona",
    "Please select a file": "Prego selezionare un file",
    "Please select a library or folder first.": "Per favore seleziona una libreria o una cartella prima.",
    "Please select a library to share.": "Seleziona una libreria da condividere.",
    "Please select an expiration time": "Seleziona una data di scadenza",
    "Please turn on extended properties setting first": "Per favore abilita le propriet\u00e0 estese prima di abilitare la riconoscimento facciale",
    "Please upload no more than {maxFiles} files at a time.": "Carica non pi\u00f9 di {maxFiles} file alla volta.",
    "Precision": "Precisione",
    "Preparing to upload...": "Preparazione al caricamento...",
    "Preset hide properties": "Propriet\u00e0 nascoste preimpostate",
    "Preview and download": "Anteprima e scarica",
    "Preview online": "Anteprima online",
    "Preview only": "Solo Anteprima",
    "Previous": "Precedente",
    "Previous (Left arrow key)": "Precedente (tasto freccia sinistra)",
    "Print": "Stampa",
    "Print document": "Stampa documento",
    "Professional Edition": "Versione Professionale",
    "Profile": "Profilo",
    "Profile Setting": "Settaggi del profilo",
    "Properties": "Propriet\u00e0",
    "Properties to display on the card": "Propriet\u00e0 da visualizzare sulla scheda",
    "Property name": "Nome della propriet\u00e0",
    "Publish": "Pubblica",
    "Publish Wiki": "Pubblica Wiki",
    "Published": "Pubblicato",
    "QR Code": "Codice QR",
    "Quota": "Quota",
    "Quota is invalid.": "Quota non valida.",
    "Rate": "Valutazione",
    "Read-Only": "Sola lettura",
    "Read-Only folder": "Cartella in sola lettura",
    "Read-Only library": "Libreria in Lettura-Scrittura",
    "Read-Write": "Lettura-Scrittura",
    "Read-Write folder": "Cartella in Lettura-Scrittura",
    "Read-Write library": "Libreria in Lettura-Scrittura",
    "Really want to delete this group?": "Vuoi davvero eliminare questo gruppo?",
    "Really want to delete your account?": "Vuoi veramente eliminare il tuo account?",
    "Really want to leave this group?": "Vuoi davvero lasciare questo gruppo?",
    "Recently Used": "Recenti Utilizzi",
    "Recently used tags": "Tag recenti",
    "Recognizing portraits. Please refresh the page later.": "Riconoscimento ritratti in corso. Aggiorna la pagina pi\u00f9 tardi.",
    "Recommended new tags": "Tag consigliati",
    "Refresh": "Aggiornare",
    "Refresh the view": "Aggiorna",
    "Remaining": "Rimanente",
    "Remove": "Rimuovi",
    "Remove Member": "Rimuovi membro",
    "Remove from this group": "Rimuovi da questo gruppo",
    "Removed all items from trash": "Rimosso tutti gli elementi dal cestino",
    "Removed items older than {n} days from trash": "Rimosso gli elementi pi\u00f9 vecchi di {n} giorni dal cestino",
    "Rename": "Rinomina",
    "Rename Department": "Rinominare Dipartimento",
    "Rename File": "File Rinominato",
    "Rename Folder": "Cartella Rinominata",
    "Rename Group": "Rinomina Gruppo",
    "Rename Library": "Rinomina Libreria",
    "Rename Wiki": "Rinomina Wiki",
    "Rename file": "Rinomina file",
    "Rename folder": "Rinomina cartella",
    "Rename group to": "Rinomina gruppo in ",
    "Rename property": "Rinomina propriet\u00e0",
    "Renamed file": "File rinominato",
    "Renamed folder": "Cartella rinominata",
    "Renamed library": "Libreria Rinominata",
    "Renamed or Moved files": "File rinominati o spostati",
    "Renaming {name} failed": "Ridenominazione {name} fallita",
    "Replace": "Sostituire",
    "Replace file {filename}?": "Sostituisci il file {filename}?",
    "Replacing it will overwrite its content.": "Sotituirlo sovrascriver\u00e0 il suo contenuto.",
    "Repo Transfer": "Trasferimento Repo",
    "Report Abuse": "Segnala abuso",
    "Reporter": "Segnalatore",
    "Reports": "Resoconti",
    "Required at least three letters.": "Richiesto almeno tre lettere.",
    "Reset": "Reimposta",
    "Reset Password": "Cambia Password",
    "Reset WebDAV Password": "Reimposta la password WebDAV",
    "Reset library password": "Reimposta la password della libreria",
    "ResetPwd": "Ripristina Password",
    "Resetting user's password, please wait for a moment.": "Resettando la password dell'utente, attendi un momento.",
    "Resolved comments": "Commenti risolti",
    "Restore": "Ripristina",
    "Restore Library": "Ripristina Libreria",
    "Restored 1 item": "Ripristinato 1 elemento",
    "Restored file": "File recuperato",
    "Restored folder": "Cartella recuperata",
    "Restored library": "Liberaria recuperata",
    "Restored {name}": "Il {name} \u00e8 stato ripristinato.",
    "Restored {name} and {n} other items": "I {name} e gli altri {n} elementi sono stati ripristinati.",
    "Resubmit": "Reinvia",
    "Result": "Risultato",
    "Retry": "Riprova",
    "Retry All": "Riprova tutti",
    "Revoke": "Revoca",
    "Revoke Access": "Accesso Revocato",
    "Revoke Admin": "Revoca l'amministratore",
    "Role": "Ruolo",
    "Rotate": "Rotazione",
    "SAML config": "Configurazione SAML",
    "SAML config updated": "Configurazione SAML aggiornata",
    "SSO": "SSO abilitato",
    "Satellite": "Mappa satellitare",
    "Save": "Salvare",
    "Save Selected Items": "Salva gli elementi selezionati",
    "Save as ...": "Salva con nome ...",
    "Save to description field": "Salva in campo descrizione",
    "Save to:": "Salva in:",
    "Saving...": "Salvataggio...",
    "Scan the QR code to view the shared content directly": "Scansiona il codice QR per visualizzare direttamente il contenuto condiviso",
    "SeaTable integration": "Integrazione di SeaTable",
    "Seafile": "Seafile",
    "Search": "Ricerca",
    "Search Groups": "Cerca Gruppi",
    "Search Libraries": "Ricerca Librerie",
    "Search Organizations": "Ricerca Organizzazioni",
    "Search Users": "Cerca Utenti",
    "Search collaborator": "Cerca collaboratore",
    "Search collaborators": "Cerca collaboratori",
    "Search department": "Cerca dipartimento",
    "Search departments": "Cerca dipartimenti",
    "Search failed": "Ricerca fallita",
    "Search failed. Please try again.": "Ricerca fallita. Riprova.",
    "Search files": "Ricerca files",
    "Search files in this library": "Ricerca documenti in questa libreria",
    "Search group members": "Cerca membri del gruppo",
    "Search groups": "Cerca gruppi",
    "Search groups by name": "Cerca gruppi per nome",
    "Search in trash": "Ricerca nel cestino",
    "Search in trash...": "Ricerca in cestino...",
    "Search libraries by name or ID": "Cerca librerie per nome o ID",
    "Search libraries by owner": "Ricerca librerie per proprietario",
    "Search option": "Opzioni di ricerca",
    "Search organizations": "Ricerca organizzazioni",
    "Search properties": "Cerca propriet\u00e0",
    "Search property": "Cerca propriet\u00e0",
    "Search results": "Risultati ricerca",
    "Search results visited recently": "Risultati di ricerca visitati di recente",
    "Search service unavailable": "Servizio di ricerca non disponibile",
    "Search tag": "Cerca tag",
    "Search user": "Cerca utente",
    "Search users": "Ricerca utenti",
    "Search users...": "Cerca utenti...",
    "Searching...": "Ricerca in corso...",
    "Select": "Seleziona",
    "Select File": "Seleziona il file",
    "Select a Confluence HTML export file (.html.zip)": "Seleziona un file esportato Confluence HTML (.html.zip)",
    "Select a Confluence HTML exported file (.html.zip)": "Seleziona un file esportato Confluence HTML (.html.zip)",
    "Select a Confluence exported file": "Seleziona un file esportato Confluence",
    "Select a department": "Seleziona un dipartimento",
    "Select a server": "Seleziona il server",
    "Select a user": "Seleziona un utente",
    "Select a user as admin": "Seleziona un utente come amministratore",
    "Select all": "Seleziona tutto",
    "Select all items": "Seleziona tutti gli elementi",
    "Select an office suite": "Seleziona un suite di office",
    "Select an option": "Seleziona un'opzione",
    "Select collaborators": "Seleziona collaboratori",
    "Select group members": "Seleziona membri del gruppo",
    "Select image": "Seleziona immagine",
    "Select items": "Seleziona elementi",
    "Select libraries to share": "Selezione le librerie da condividere",
    "Select option(s)": "Seleziona opzione(s)",
    "Select shared users": "Seleziona utenti condivisi",
    "Select tag": "Seleziona tag",
    "Select target department": "Trasferisci gruppo a dipartimento",
    "Select this item": "Seleziona questo elemento",
    "Select up to 50 files": "Seleziona fino a 50 file",
    "Select users": "Seleziona utenti",
    "Selected": "Selezionato",
    "Send": "Invia",
    "Send activation Email after user registration.": "Invia l'email di attivazione dopo la registrazione dell'utente.",
    "Send activation email": "Invia email di attivazione",
    "Send to:": "Spedisci a:",
    "Sending new password...": "Invio nuova password...",
    "Sending...": "Invio...",
    "Separate multiple suffixes by \",\"(like sdoc, pdf)": "Separa le estensioni multiple con \",\" (come sdoc, pdf)  ",
    "Server": "Server",
    "Server Version: ": "Versione Server:",
    "Set": "Imposta",
    "Set Admin": "Imposta amministratore",
    "Set Contact Email": "Imposta Email Contatto",
    "Set Download Rate Limit": "Imposta il limite di velocit\u00e0 di download",
    "Set Login ID": "Imposta ID Login",
    "Set Name": "Imposta il Nome",
    "Set Password": "Imposta Password",
    "Set Quota": "Imposta Quota",
    "Set Upload Rate Limit": "Imposta il limite di velocit\u00e0 di caricamento",
    "Set WebDAV Password": "Imposta la password WebDAV",
    "Set access scope": "Imposta l'ambito di accesso",
    "Set as cover photo": "Imposta come foto copertina",
    "Set child tags": "Imposta tag figli",
    "Set max number of members": "Imposta il numero massimo di membri",
    "Set organization inactive": "Imposta l'organizzazione inattiva",
    "Set password": "Imposta la password",
    "Set permission": "Imposta permessi",
    "Set permission of {placeholder}": "Imposta l'autorizzazione per {placeholder}",
    "Set quota": "Imposta la quota",
    "Set to current": "Imposta a corrente",
    "Set user contact email": "Imposta email di riferimento per l'utente",
    "Set user default quota": "Imposta la quota predefinita dell'utente",
    "Set user inactive": "Imposta utente inattivo",
    "Set user name": "Imposta il nome utente\"",
    "Set user quota": "Imposta la quota dell'utente",
    "Setting library history is disabled by Admin.": "L'impostazione della cronologia delle librerie \u00e8 disabilitata dall'amministratore.",
    "Setting updated": "Impostazione aggiornata",
    "Settings": "Impostazioni",
    "Share": "Condividi",
    "Share Admin": "Amministrazione Condivisioni",
    "Share From": "Condividi Da",
    "Share Link": "Condividi Collegamento",
    "Share Link Traffic": "Condivisione Link del Traffico",
    "Share Links": "Link condivisi",
    "Share To": "Condiviso con",
    "Share To:": "Condividi con:",
    "Share existing libraries": "Condividi le librerie esistenti",
    "Share link download": "Condividi il link per scaricare",
    "Share link is copied to the clipboard.": "Il link di condivisione viene copiato negli appunti.",
    "Share link upload": "Condividi il link  di caricamento",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "Non \u00e8 possibile generare link di condivisione perch\u00e9 in alcune cartella(e) della libreria \u00e8 impostato come \"Invisibile\", \"Lettura-scrittura online\" o \"Sola lettura online\".",
    "Share to group": "Condividi con il gruppo",
    "Share to other server": "Condividi su un altro server",
    "Share to user": "Condividi con l'utente",
    "Share/upload link force password": "Forza gli utenti a utilizzare una password quando generano il link di condivisione/upload.",
    "Share/upload link password minimum length": " Lunghezza minima della password del link di condivisione/upload",
    "Share/upload link password strength level": "Livello di forza della password del link di condivisione/upload",
    "Shared By": "Condiviso da",
    "Shared Libraries": "Librerie condivise",
    "Shared Links": "Collegamenti condivisi",
    "Shared by:": "Condiviso da:",
    "Shared by: ": "Condiviso da:",
    "Shared from other servers": "Condivisi da altri server",
    "Shared with all": "Condivisi con tutti",
    "Shared with me": "Condivisi con me",
    "Sharing Time": "Ora di condivisione",
    "Show": "Visualizza",
    "Show Codes": "Mostra codici",
    "Show advanced search": "Mostra ricerca avanzata",
    "Show all": "Mostra tutto",
    "Show changes": "Mostra modifiche",
    "Show daily history": "Mostra l'istoria giornaliera",
    "Show property names": "Mostra nomi propriet\u00e0",
    "Side Nav Menu": "Menu laterale di navigazione",
    "Single Sign On (SSO)": "SSO (Single Sign On)",
    "Single select": "Selezione singola",
    "Site name": "Nome del sito",
    "Site name used in email sending": "Nome del sito utilizzato nell'invio di e-mail",
    "Site title": "Titolo del sito",
    "Site title shown in a browser tab": "Titolo del sito mostrato nella scheda del browser",
    "Size": "Dimensione",
    "Sort": "Ordinamento",
    "Sort ascending": "Ordina crescente",
    "Sort descending": "Ordina decrescente",
    "Space (1 000 000)": "Spazio (1 000 000)",
    "Space Used": "Spazio Utilizzato",
    "Space Used / Quota": "Spazio utilizzato / Quota",
    "Space used": "Spazio utilizzato",
    "Specific people with email address": "Persone specifiche con indirizzo email",
    "Specific users in the team": "Utenti specifici nel team",
    "Star": "Marca",
    "Start date": "Data di inizio",
    "Statistic": "Statistiche",
    "Statistics": "Statistiche",
    "Status": "Stato",
    "Status: enabled": "Stato: abilitato",
    "Storage": "Storage",
    "Storage Backend": "Backend di archiviazione",
    "Storage Used": "Archivio utilizzato",
    "Strong password": "Password complessa",
    "Style": "Stile",
    "Submit": "Invia",
    "Success": "Successo",
    "Successfully added %s.": "%s aggiunto con successo.",
    "Successfully added label(s) for library {placeholder}": "Etichett(a/e) libreria {placeholder} aggiunta/e con successo",
    "Successfully added the file.": "File aggiunto con successo",
    "Successfully added {email_placeholder}": "Utente {email_placeholder} aggiunto al gruppo",
    "Successfully change the group": "Gruppo modificato con successo",
    "Successfully changed library password.": "Password della biblioteca modificata con successo.",
    "Successfully changed the office suite.": "Successivamente cambiato il suite di office.",
    "Successfully cleaned all errors.": "Tutti gli errori sono stati puliti con successo",
    "Successfully cleaned invalid share links.": "Cestini condivisi puliti con successo",
    "Successfully cleaned invalid upload links.": "Cestini caricamenti non validi puliti con successo",
    "Successfully cleared trash.": "Cestino svuotato con successo",
    "Successfully converted the file.": "Il file \u00e8 stato convertito con successo.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s copiato con successo e %(amount)s altri articoli.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s copiato con successo e 1 altro elemento.",
    "Successfully copied %(name)s.": "%(name)sCopiato con successo.",
    "Successfully copied files to another library.": "I file sono stati copiati con successo in un'altra libreria.",
    "Successfully copied {name} and {n} other items": "I {name} e gli altri {n} elementi sono stati copiati.",
    "Successfully deleted 1 item": "1 elemento rimosso con successo",
    "Successfully deleted 1 item.": "1 oggetto Eliminato con successo.",
    "Successfully deleted 1 share link": "Eliminato 1 link di condivisione con successo",
    "Successfully deleted 1 upload link": "1 elemento rimosso con successo",
    "Successfully deleted 1 user.": "Utente cancellato con successo.",
    "Successfully deleted {name}": "Eliminato con successo {name}",
    "Successfully deleted {name} and {n} other items": "Eliminati con successo {name} e altri {n} elementi",
    "Successfully deleted {name} and {n} other items.": "I {name} e gli altri {n} elementi sono stati eliminati.",
    "Successfully deleted {name}.": "{name} eliminato correttamente.",
    "Successfully deleted {number_placeholder} share links": "Link di condivisione {number_placeholder} eliminati correttamente",
    "Successfully deleted {number_placeholder} upload links": "Rimosso con successo {number_placeholder} link di caricamento",
    "Successfully deleted {user_number_placeholder} users.": "Utenti cancellati con successo.",
    "Successfully edited labels.": "Etichette modificate con successo.",
    "Successfully imported tags.": "Tag importati con successo.",
    "Successfully imported {user_placeholder}": "Importato con successo {user_placeholder}",
    "Successfully invited %(email) and %(num) other people.": "Invitato con successo %(email) e %(num) altre persone.",
    "Successfully invited %(email).": "Invitato con successo %(email).",
    "Successfully modified permission.": "Permessi modificati con successo",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s spostato con successo e %(amount)s altri articoli.",
    "Successfully moved %(name)s and 1 other item.": "%(name)s spostato con successo e 1 altro elemento.",
    "Successfully moved %(name)s.": "%(name)s spostato con successo. ",
    "Successfully moved files to another library.": "I file sono stati spostati con successo in un'altra libreria.",
    "Successfully moved {name} and {n} other items": "I {name} e gli altri {n} elementi sono stati spostati.",
    "Successfully moved {name}.": "Il {name} \u00e8 stato spostato.",
    "Successfully removed {placeholder}.": "Utente {placeholder} rimosso dal gruppo.",
    "Successfully renamed the library.": "Libreria rinominata con successo.",
    "Successfully restored the library {library_name}.": "Ripristino della libreria {library_name} riuscito.",
    "Successfully restored the library.": "Libreria ripristinata con successo.",
    "Successfully restored.": "Recuperato con successo.",
    "Successfully revoke the admin permission of %s": "Permessi di amministrazione revocati a %s correttamente",
    "Successfully revoked access of user {placeholder}.": "Accesso revocato all'utente {placeholder}.",
    "Successfully revoked the admin permission of {placeholder}.": "Permesso amministratore di {placeholder} revocato con successo.",
    "Successfully saved": "Salvato con successo",
    "Successfully sent to {placeholder}": "Inviato con successo a {placeholder}",
    "Successfully set %s as admin.": "%s \u00e8 stato correttamente impostato come amministratore correttamente.",
    "Successfully set it.": "Impostalo con successo.",
    "Successfully set library history.": "Impostare correttamente la cronologia della libreria.",
    "Successfully set quota.": "Quota impostata con successo.",
    "Successfully starred {library_name_placeholder}.": "{library_name_placeholder} selezionato con successo.",
    "Successfully starred {name_placeholder}.": "Successivamente comparso {name_placeholder}.",
    "Successfully transferred the group.": "Gruppo trasferito con successo.",
    "Successfully transferred the library.": "Libreria trasferita con successo.",
    "Successfully unlinked %(name)s.": "Scollegamento riuscito%(name)s.",
    "Successfully unlinked the device.": "Dispositivo disconnesso con successo",
    "Successfully unshared library {placeholder}": "Condivisione della libreria {placeholder} annullata con successo",
    "Successfully unshared {name}": "Condivisione {name} rimossa con successo",
    "Successfully unstarred {library_name_placeholder}.": "{library_name_placeholder} deselezionato con successo.",
    "Successfully unstarred {name_placeholder}.": "Successivamente scomparso {name_placeholder}.",
    "Successfully unwatched the library.": "Libreria non osservata con successo.",
    "Successfully watched the library.": "Libreria osservata con successo.",
    "Suggestion": "Suggerimento",
    "Switch sort mode": "Cambia la modalit\u00e0 di ordinamento",
    "Switch to plain text editor": "Passa a editor di testo semplice",
    "Switch to rich text editor": "Passa a editor di testo ricco",
    "Switch view mode": "Cambia modalit\u00e0 di visualizzazione",
    "Symbol position": "Posizione simbolo",
    "Sync": "Sincronizza",
    "Sync Download": "Sincronizzare il Download",
    "Sync Traffic": "Sincronizzazione Traffico",
    "Sync Upload": "Sincronizzare il Caricamento",
    "System": "Sistema",
    "System Admin": "Amministratore del Sistema",
    "System Info": "Informazioni di Sistema",
    "System settings updated": "Impostazioni del sistema aggiornate",
    "Table": "Tabella",
    "Tag": "Tag",
    "Tag not found": "Etichetta non trovata",
    "Tagged Files": "File contrasseganti",
    "Tags": "Tag",
    "Tags migrated successfully": "Tag migrati con successo",
    "Team deleted": "Team cancellato",
    "Team name": "Nome del team",
    "Template": "Modello",
    "Terms": "Termini",
    "Terms and Conditions": "Termini e Condizioni",
    "Text": "Testo",
    "Text file extensions": "Estensioni dei file di testo che possono essere visualizzati in anteprima online, ciascun suffisso \u00e8 separato da una virgola.",
    "Text is required.": "Il testo \u00e8 obbligatorio.",
    "Text wraps": "Testo a capo",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "Il contenuto del documento ha superato il limite di 100000 caratteri, e solo i primi 100000 caratteri sono stati salvati",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "Il contenuto del documento ha superato il limite di 100000 caratteri, e il contenuto non pu\u00f2 essere salvato",
    "The current quota for {group_name} is {quota}": "Quota corrente per {group_name} \u00e8 {quota}",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "La parte personalizzata dell'URL deve essere compresa tra 5 e 30 caratteri e pu\u00f2 contenere solo lettere (a-z), numeri e trattini.",
    "The file is too large. Allowed maximum size is 1MB.": " Il file \u00e8 troppo grande. La dimensione massima consentita \u00e8 1 MB.",
    "The image could not be previewed.": "Anteprima immagine non disponibile",
    "The import process may take several minutes depending on the size of your Confluence export.": "Il processo di importazione pu\u00f2 richiedere alcuni minuti a seconda della dimensione del tuo esportato Confluence.",
    "The imported options already exists": "Le opzioni importate esistono gi\u00e0",
    "The imported options are invalid": "Le opzioni importate sono invali",
    "The least number of characters a share/upload link password should include.": "Il numero minimo di caratteri di una password che un link di condivisione/upload dovrebbe contenere",
    "The least number of characters an encrypted library password should include.": "Il numero minimo di caratteri di una password che una libreria crittografata dovrebbe contenere",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "Il livello (1-4) di forza di una password di un link di condivisione/upload. Ad esempio, '3' significa che la password deve avere almeno 3 dei seguenti: num, lettera maiuscola, lettera minuscola e simboli",
    "The link is copied to the clipboard.": "Il link viene copiato negli appunti.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "L'elenco dei file aggiunti, eliminati e modificati verr\u00e0 inviato alla tua casella di posta.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "Il numero massimo di tentativi di accesso non riusciti prima di mostrare CAPTCHA.",
    "The name \"{name}\" is already taken. Please choose a different name.": "Il nome \"{name}\" risulta gi\u00e0 utilizzato. Prego scegliere un nome differenze.",
    "The next month": "Il prossimo mese",
    "The next numbers of days": "I prossimi numeri di giorni",
    "The next week": "La prossima settimana",
    "The next year": "Il prossimo anno",
    "The owner of this library has run out of space.": "Il proprietario di questa libreria non ha pi\u00f9 spazio a disposizione.",
    "The password is too short.": "La password \u00e8 troppo corta.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": " La password \u00e8 troppo debole. Dovrebbe includere almeno {passwordStrengthLevel} dei seguenti caratteri: numero, lettere maiuscole, lettere minuscole e altri simboli speciali.",
    "The password will be kept in the server for only 1 hour.": "La password \u00e8 conservata nel server per solo 1 ora.",
    "The past month": "Il mese scorso",
    "The past numbers of days": "Il numero di giorni passati",
    "The past week": "La settimana scorsa",
    "The past year": "L'anno scorso",
    "The path has been copied to the clipboard": "Il percorso \u00e8 stato copiato negli appunti",
    "The row is locked and cannot be modified": "La riga \u00e8 bloccata e non pu\u00f2 essere modificata",
    "The uploaded image has not been saved yet. Please close this page later.": "L'immagine caricata non \u00e8 stata ancora salvata. Chiudi questa pagina pi\u00f9 tardi.",
    "There is another option with this name": "C'\u00e8 gi\u00e0 un'altra opzione con questo nome",
    "There is another property with this name": "Esiste gi\u00e0 una propriet\u00e0 con questo nome",
    "There is no information to display.": "Nessun informazione da mostrare.",
    "This file has (apparently) not been accessed yet": "Questo file (apparentemente) non \u00e8 stato ancora visitato",
    "This file has been updated.": "Questo file \u00e8 stato aggiornato.",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": " Questa cartella \u00e8 stata condivisa con {user_amount} user(s) e {group_amount} group(s).",
    "This folder has no content at this time.": "Questa cartella adesso non ha contenuti.",
    "This is a special group representing a department.": "Questo \u00e8 un gruppo speciale che rappresenta un dipartimento.",
    "This is required": "Questo \u00e8 necessario",
    "This library contains tags of old version. Do you like to migrate the tags to new version?": "Questa libreria contiene tag della versione precedente. Vuoi migrare i tag alla versione nuova?",
    "This library has been set to read-only by admin and cannot be updated.": "Questa libreria \u00e8 stata impostata su sola lettura da amministratore e non pu\u00f2 essere aggiornata.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": " Questa libreria \u00e8 stata condivisa con {user_amount} utemte(i) e {group_amount} group(s).",
    "This library is password protected": "Questa libreria \u00e8 protetta da password",
    "This list is collapsed": "Questa lista \u00e8 compressa",
    "This month": "Questo mese",
    "This operation will not be reverted. Please think twice!": "Questa operazione non sar\u00e0 reversibile. Per cortesia pensaci due volte!",
    "This property can not be deleted": "Questa propriet\u00e0 non pu\u00f2 essere eliminata",
    "This property does not support sorting": "Questa propriet\u00e0 non supporta l'ordinamento",
    "This property is not editable": "Questa propriet\u00e0 non \u00e8 modificabile",
    "This user has not created or joined any groups": "Questo utente non ha creato o aggiunto alcun gruppo",
    "This week": "Questa settimana",
    "This year": "Questo anno",
    "Thousands separator": "Separatore migliaia",
    "Thumbnail": "Miniatura",
    "Time": "Orario",
    "Tip: -2 means no limit.": "Suggerimento: -2 significa nessun limite.",
    "Tip: 0 means default limit": "Suggerimento: 0 significa limite predefinito",
    "Tip: 0 means default limit, the unit is MB": "Suggerimento: 0 significa limite predefinito, l'unit\u00e0 \u00e8 MB",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Suggerimento: verr\u00e0 generata un'istantanea dopo la modifica, che registra lo stato della libreria dopo la modifica.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Suggerimento: le librerie eliminate {placeholder} giorni fa verranno rimosse automaticamente.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": " Consiglio: le librerie eliminate {trashReposExpireDays} giorni fa verranno pulite automaticamente.",
    "Tip: you can search by keyword in name or ID.": " Consiglio: puoi cercare per parola chiave in nome o ID.",
    "Tip: you can search by keyword in name.": "Suggerimento: puoi cercare per parola chiave nel nome.",
    "Tips: There are tags of old version. Please migrate tags to new version.": "Suggerimento: Ci sono etichette di versione precedente. Per favore migra le etichette alla versione nuova.",
    "Tips: These are tags of old version. The feature is deprecated and can no longer be used.": "Suggerimento: Queste sono etichette di versione precedente. La funzionalit\u00e0 \u00e8 deprecata e non pu\u00f2 essere utilizzata pi\u00f9.",
    "Title property": "Propriet\u00e0 titolo",
    "To confirm, type \"{placeholder}\" in the box below": "Per confermare, inserisci \"{placeholder}\" nel campo sottostante",
    "Today": "Oggi",
    "Toggle children": "Alterna figli",
    "Toggle repo selector": "Alterna selettore libreria",
    "Toggle selector menu": "Apri/Chiudi menu selezionatore",
    "Toggle user selector": "Alterna selettore utente",
    "Token": "Simbolo",
    "Token:": "Token:",
    "Tomorrow": "Domani",
    "Too many requests": "Troppe richieste",
    "Total Devices": "Dispositivi Totali",
    "Total Storage": "Archiviazione totale",
    "Total Traffic": "Traffico Totale",
    "Total Users": "Utenti totali",
    "Total users": "Numero totale di utenti",
    "Total {comments_count} comment": "Tutti i commenti",
    "Total {comments_count} comments": "Tutti i commenti",
    "Traffic": "Traffico",
    "Traffic exceeded": " Traffico superato",
    "Traffic this month": " Traffico mensile",
    "Transfer": "Trasferisci",
    "Transfer From": "Trasferimento Da",
    "Transfer Group": "Trasferisci Gruppo",
    "Transfer Group {placeholder} to": "Trasferisci gruppo {placeholder} a",
    "Transfer Library": "Trasferisci Libreria",
    "Transfer Library {library_name}": "Trasferimento Libreria {library_name}",
    "Transfer To": "Trasferimento A",
    "Transfer group to": "Trasferisci al gruppo",
    "Transfer to department": "Trasferimento al dipartimento",
    "Transfer to user": "Trasferimento all'utente",
    "Transferred group {group_name} from {user_from} to {user_to}": "Gruppo {group_name} trasferito da {user_from} a {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "Libreria {library_name} trasferita da {user_from} a {user_to}",
    "Trash": "Cestino",
    "Turn off": "Spegnere",
    "Turn off extended properties": "Disattiva le propriet\u00e0 estese",
    "Turn off face recognition": "Disattiva il riconoscimento facciale",
    "Turn off tags": "Disattiva i tag",
    "Turn on extensible properties and views to experience a new way of managing files": "Abilita le propriet\u00e0 estensioni e le viste per esperienza nuova gestione dei file",
    "Two-Factor Authentication": "Autenticazione a due fattori",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "L'autenticazione a due fattori non \u00e8 abilitata per il tuo account. Abilita l'autenticazione a due fattori per una maggiore sicurezza degli account.",
    "Type": "Tipo",
    "Type characters to start search": "Digita alcini caratteri per avviare la ricerca",
    "URL is copied to the clipboard": "URL copiato negli appunti",
    "URL is required": "URL obbligatorio",
    "US": "US",
    "Uncategorized": "Senza categoria",
    "Undo": "Annulla",
    "Unfold": "Collassa",
    "Unfold the sidebar": "Apri la barra laterale",
    "Unfreeze Document": "Sblocca documento",
    "Unhandled": "Non gestito",
    "Unknown": "Sconosciuto",
    "Unknown people": "Persone sconosciute",
    "Unlink": "Scollega",
    "Unlink device": "Scollega dispositivo",
    "Unlock": "Sbloccato",
    "Unpublish": "Annulla pubblicazione",
    "Unpublish Wiki": "Annulla pubblicazione Wiki",
    "Unresolved comments": "Commenti non risolti",
    "Unselect": "Deseleziona",
    "Unselect all": "Deseleziona tutto",
    "Unselect all items": "Deseleziona tutti gli elementi",
    "Unselect items": "Deseleziona elementi",
    "Unselect this item": "Deseleziona questo elemento",
    "Unshare": "Elimina condivisione",
    "Unshare Library": "Annulla condivisione libreria",
    "Unstar": "Smarca",
    "Untitled": "Senza titolo",
    "Unwatch File Changes": "Non consultare le modifiche ai file",
    "Up": "su",
    "Update": "Aggiorna",
    "Update Terms and Conditions": "Aggiorna termini e condizioni",
    "Update password": "Aggiorna la password",
    "Update succeeded.": "Aggiornamento eseguito.",
    "Update time": "Ora di aggiornamento",
    "Updated draft": "Bozza aggiornata",
    "Updated file": "File aggiornato",
    "Upgrade to Pro Edition": "Esegui l'avanzamento alla versione professionale",
    "Upload": "Carica",
    "Upload Files": "Carica File",
    "Upload Folder": "Carica cartella",
    "Upload Link": "Link di Upload",
    "Upload Links": "Link di Upload",
    "Upload failed": "Caricamento non riuscito",
    "Upload file": "Carica file",
    "Upload files to": "Carica file in",
    "Upload license": "Carica licenza",
    "Upload link is copied to the clipboard.": "Il link di caricamento viene copiato negli appunti.",
    "Uploaded": "Caricato",
    "Uploading...": "Caricamento...",
    "Use custom CSS": "Utilizza CSS personalizzato",
    "Use information from your Identity Provider to configure Seafile": "Usa le informazioni dal tuo Provider di Identit\u00e0 per configurare Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Utilizza la funzione di importazione/export per trasferire le opzioni rapidamente. (L'export \u00e8 in formato JSON.) Copiando le celle da una colonna di testo, un file Excel o un file TXT, puoi anche aggiungere opzioni rapidamente.",
    "Use these values to configure your Identity Provider": "Usa questi valori per configurare il tuo Provider di Identit\u00e0",
    "Used:": "Utilizzato:",
    "User": "Utente",
    "User Email": "Email utente",
    "User ID": "ID Utente",
    "User Permission": "Permessi Utente",
    "User Shares": "Condivisioni degli utenti",
    "User Storage": "Archiviazione degli utenti",
    "User can not see this folder.": "L'utente non pu\u00f2 vedere questa cartella.",
    "User can only view files online via browser. Files can't be downloaded.": "L'utente pu\u00f2 solo visualizzare i file online tramite browser. I file non possono essere scaricati.",
    "User can read, download and sync files.": "L'utente pu\u00f2 leggere, scaricare e sincronizzare i file.",
    "User can read, write, upload, download and sync files.": "L'utente pu\u00f2 leggere, scrivere, caricare, scaricare e sincronizzare i file.",
    "User can view and edit file online via browser. Files can't be downloaded.": "L'utente pu\u00f2 visualizzare e modificare i file online tramite browser. I file non possono essere scaricati.",
    "User default quota": "Quota predefinita utente",
    "User default quota updated": "Quota predefinita utente aggiornata",
    "User deleted": "Utente {placeholder} eliminato.",
    "User info updated": "Informazioni utente aggiornate",
    "User is already in this group": "L'utente \u00e8 gi\u00e0 parte del gruppo",
    "User migrate from {user_from} to {user_to}": "Utente {user} migrato da {user_from} a {user_to}",
    "User not found": "Utente non trovato",
    "User number limit": "Limite di utenti",
    "User {user_link} has added you to {group_link}": "L'utente {user_link} ti ha aggiunto a {group_link}",
    "Username:": "Nome utente:",
    "Users": "Utenti",
    "Value": "Valore",
    "Verified": "Verificato",
    "Verify": "Verifica",
    "Verify Domain": "Verifica Dominio",
    "Version": "Versione",
    "Version Number": "Numero della versione",
    "Version Number is required.": "Il numero di versione \u00e8 obbligatorio.",
    "Version Number must be a number.": "Il numero di versione deve essere un numero.",
    "Video": "Video",
    "View": "Vedi",
    "View Link": "Visualizza Collegamento",
    "View Related Snapshot": "Vedi snapshot correlato",
    "View Snapshot": "Visualizza Istantanea",
    "View all notifications": "Visualizza tutte le notifiche",
    "View original image": "Vedi l'immagine originale",
    "View profile and more": "Consulta il profilo e le altre impostazioni",
    "View published page": "Visualizza pagina pubblicata",
    "Views": "Viste",
    "Virus": "Virus",
    "Virus File": "File infetto",
    "Virus Scan": "Scansione Virus",
    "Visit count": "Numero di visitatori",
    "Visit old version page": "Visita la vecchia versione della pagina",
    "Visited": "Visitato",
    "Visits": "Visite",
    "Waiting...": "In attesa...",
    "Watch File Changes": "Consulta le modifiche ai file",
    "Web API Auth Token": "Token di autenticazione API via Web",
    "Web Download": "Download via Web",
    "Web Traffic": "Traffico Web",
    "Web Upload": "Caricamento via Web",
    "WebDAV Access": "Accesso WebDAV",
    "WebDAV password:": "Password WebDAV:",
    "WebDAV username:": "None utente WebDAV:",
    "Welcome to {site_name_placeholder}": "Benvenuto su {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "Se le notifiche di collaborazione come la condivisione della libreria o l'adesione al gruppo devono essere inviate alla tua casella di posta.",
    "Wiki custom URL deleted": "URL personalizzato rimosso",
    "Wiki owner": "Proprietario del Wiki",
    "Wiki published": "Wiki pubblicato",
    "Wikis": "Wiki",
    "Workspace": "Spazio di lavoro",
    "Wrong password": "Password sbagliata",
    "Year": "Anno",
    "Yesterday": "Ieri",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Puoi anche aggiungere come guest, egli non potr\u00e0 creare librerie o gruppi.",
    "You can click the \"Add Wiki\" button below to add a new Wiki.": "Puoi cliccare sul pulsante \"Aggiungi Wiki\" sotto per aggiungere un nuovo Wiki.",
    "You can create files quickly": "Puoi creare file rapidamente",
    "You can create libraries by clicking the \"New Library\" item in the dropdown menu.": "Puoi creare librerie cliccando sull'item \"Nuova Libreria\" nel menu a tendina.",
    "You can enter multiple emails. An invitation link will be sent to each of them.": " Puoi inserire pi\u00f9 email. A ciascuno di loro verr\u00e0 inviato un link di invito.",
    "You can use this field at login.": "Puoi usare questo campo al login.",
    "You do not have permission": "Non hai i permessi necessari",
    "You don't have any favorite items yet": "Nessun elemento preferito",
    "You don't have any share links": "Non hai collegamenti di condivisione",
    "You don't have any upload links": "Non hai nessun link per il caricamento",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "Non hai ancora acceduto ai tuoi file con nessun client (desktop o mobile). Configura i client sui tuoi dispositivi per accedere ai tuoi dati pi\u00f9 comodamente.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "Non hai ancora aggiunto nessuna libreria, cartella o file ai preferiti. Un preferito ti d\u00e0 accesso rapido agli oggetti che usi pi\u00f9 frequentemente. Puoi aggiungere una libreria, cartella o file ai preferiti cliccando sulla stella a sinistra del suo nome.",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" item in the dropdown menu.": "Non hai ancora creato nessuna libreria. Una libreria \u00e8 un contenitore per organizzare i tuoi file e le tue cartelle. Una libreria pu\u00f2 essere condivisa con altri utenti e sincronizzata sui tuoi dispositivi connessi. Puoi creare una libreria cliccando sul pulsante \"Nuova Libreria\" nell'elenco a discesa.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "Non hai ancora creato alcun link di condivisione. Un link di condivisione pu\u00f2 essere utilizzato per condividere file e cartelle con chiunque. Puoi creare un link di condivisione per un file o cartella cliccando sull'icona di condivisione a destra del suo nome.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "Non hai ancora creato alcun link di upload. Un link di upload consente a chiunque di caricare file in una cartella o libreria. Puoi creare un link di upload per una cartella o libreria cliccando sull'icona di condivisione a destra del suo nome.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "Non hai eliminato alcuna libreria negli ultimi {placeholder} giorni. Una libreria eliminata verr\u00e0 pulita automaticamente dopo questo periodo.",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" item in the dropdown menu.": "Non hai ancora invitato nessun guest. Un guest pu\u00f2 accedere alle librerie condivise tramite l'interfaccia web, consentendo modi pi\u00f9 efficienti per collaborare rispetto ai link. Puoi invitare un guest cliccando sull'item \"Invita Guest\" nel menu a tendina.",
    "You have not shared any folders": "Non hai condiviso alcuna cartella",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "Non hai ancora condiviso nessuna cartella con altri utenti. Puoi condividere una cartella con altri utenti cliccando sull'icona di condivisione a destra del nome di una cartella.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "Nessuna libreria condivisa con altri utenti. Puoi condividere una libreria con altri utenti cliccando sull'icona di condivisione a destra del nome della libreria in \"Mie Librerie\".",
    "You have only one backup code remaining.": "Ti rimane un solo codice di backup.",
    "You have {num} backup codes remaining.": "Ti restano {num} codici di backup.",
    "Your name": "Il tuo nome",
    "Your notifications will be sent to this email.": "Le tue notifiche verranno inviate a questa email.",
    "Yuan": "Yuan",
    "ZIP": "ZIP",
    "Zoom in": "Ingrandire",
    "Zoom out": "Rimpicciolire",
    "all": "tutto/i",
    "all members": "tutti i membri",
    "contains": "contiene",
    "copy": "copia",
    "days": "giorni",
    "deleted": "cancellato",
    "deleted option": "Opzione eliminata",
    "details": "dettagli",
    "does not contain": "non contiene",
    "email is required": "\u00e8 richiesta l'email",
    "freezed": "congelato",
    "has all of...": "ha tutti di...",
    "has any of...": "ha qualcuno di...",
    "has none of...": "non ha nessuno di...",
    "icon": "icona",
    "in all libraries": "in tutte le librerie",
    "in this folder": "in questa cartella",
    "in this library": "in questa libreria",
    "include the current user": "includere l'utente corrente",
    "is": "\u00e8",
    "is after...": "\u00e8 dopo...",
    "is any of...": "\u00e8 uno qualsiasi di...",
    "is before...": "\u00e8 prima...",
    "is current user's ID": "\u00e8 l'ID dell'utente corrente",
    "is empty": "\u00e8 vuoto",
    "is exactly...": "\u00e8 esattamente...",
    "is none of...": "non \u00e8 nessuno di...",
    "is not": "non \u00e8",
    "is not empty": "non \u00e8 vuoto",
    "is on or after...": " \u00e8 adesso o dopo...",
    "is on or before...": "\u00e8 adesso o prima...",
    "is within...": "\u00e8 dentro...",
    "items": "elementi",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "Licenziato a {placeholder_license_to}, scadenza {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "Licenziato a {placeholder_license_to}, scadenza del servizio di upgrade in {placeholder_license_expiration}",
    "locked": "bloccato",
    "locked by {name}": "Bloccato da {name}",
    "members": "membri",
    "mm": "mm",
    "name": "nome",
    "not set": "non impostato",
    "only show {placeholder}": "Solo mostra {placeholder}",
    "progress": "avanzamento",
    "s": "s",
    "selected": "selezionato",
    "show more": "mostra di pi\u00f9",
    "size": "dimensione",
    "sorts": "ordinamenti",
    "starred": "preferiti",
    "state": "stato",
    "successfully added user %s.": "Utente %s aggiunto correttamente.",
    "successfully sent email to %s.": "Email inviata a %s correttamente.",
    "tags": "tag",
    "unstarred": "non preferiti",
    "xxx cells copied": "xxx celle copiate",
    "xxx cells cut": "xxx celle tagliate",
    "xxx cells selected": "xxx celle selezionate",
    "xxx record": "1 record",
    "xxx records": "xxx record",
    "xxx records selected": "xxx record selezionati",
    "xxx rows are copied.": "xxx righe tagliate.",
    "you can also press \u2192": "you can also press \u2192",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} file(s) caricamento non riuscito",
    "{file} and {n} other files": "{file} e altri {n} file",
    "{library_name} Office Suite": "Suite di Office {library_name}",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} giorni",
    "{name_placeholder} cells copied": "{name_placeholder} celle copiate",
    "{name_placeholder} cells cut": "{name_placeholder} celle tagliate",
    "{name_placeholder} cells selected": "{name_placeholder} celle selezionate",
    "{name_placeholder} hidden properties": "Propriet\u00e0 nascoste {name_placeholder}",
    "{name_placeholder} preset hidden properties": "{name_placeholder} Propriet\u00e0 nascoste preimpostate",
    "{name_placeholder} record": "{name_placeholder} record",
    "{name_placeholder} records": "{name_placeholder} record",
    "{name_placeholder} records selected": "{name_placeholder} record selezionati",
    "{name_placeholder} rows are copied.": "{name_placeholder} righe copiate.",
    "{name} rows use this option.": "Le {name} righe usano questa opzione.",
    "{number_placeholder} / Page": "{number_placeholder} / Pagina",
    "{placeholder} API Token": "Token API {placeholder}",
    "{placeholder} Access Log": "{placeholder} Access Log",
    "{placeholder} Folder Permission": "{placeholder} Permesso cartella",
    "{placeholder} History Setting": "{placeholder} Impostazione dello storico",
    "{placeholder} Modification History": "Cronologia modifiche {placeholder}",
    "{placeholder} Share Admin": "{placeholder} Condividi amministratore",
    "{placeholder} Snapshot": "Snapshot {placeholder}",
    "{placeholder} Trash": "{placeholder} Cestino",
    "{placeholder} Wiki Trash": "Cestino Wiki {placeholder}",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} ha annullato la condivisione della cartella {repo_name}.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} ha annullato la condivisione della libreria {repo_name}.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} ha cambiato i permessi della cartella {repo_link} in {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} ha cambiato l'autorizzazione della libreria {repo_link} in {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} ha condiviso una cartella denominata {repo_link} con il gruppo {group_link}.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} ha condiviso con te una cartella denominata {repo_link}.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} ha condiviso una libreria denominata {repo_link} nel gruppo {group_link}.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} ha condiviso con te una libreria denominata {repo_link}.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "{site_name_placeholder}  organizza i file in librerie. Ogni libreria pu\u00f2 essere sincronizzata e condivisa separatamente. Tuttavia, poich\u00e9 ora sei un utente ospite, non puoi creare librerie.",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder}  organizza i file in librerie. Ogni libreria pu\u00f2 essere sincronizzata e condivisa separatamente. Abbiamo creato per te una libreria personale. Puoi creare pi\u00f9 librerie in un secondo momento.",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} Files",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "L'organizzazione e tutte le sue librerie e collegamenti verranno cancellate.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} ha creato il file {fileName} e {fileCount} altro/i file(s) nella libreria {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "{user} ha creato il file {fileName} nella libreria {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha creato la cartella {folderName} e {folderCount} altra/e cartella(e) nella libreria {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "{user} ha creato la cartella {folderName} nella libreria {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} a rimosso il file {fileName} e {fileCount} altro/i file(s) nella libreria {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "{user} ha eliminato il file {fileName} nella libreria {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha rimosso la cartella {folderName} e {folderCount} altra/e cartella(e) nella libreria {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "{user} ha rimosso la cartella {folderName} nella libreria {libraryName}.",
    "{user} has transferred a library named {repo_link} to you.": "{user} ti ha trasferito una libreria chiamata{repo_link}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} ha spostato il file {fileName} e {fileCount} altro/i file(s) nella libreria {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "{user} ha spostato il file {fileName} nella libreria {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} ha spostato la cartella {folderName} e {folderCount} altra/e cartella(e) nella libreria {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "{user} ha spostato la cartella {folderName} nella libreria {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "{user} ha rinominato il file {oldFileName} {fileName} nella libreria {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "{user} ha rinominato la cartella {oldFolderName} {folderName} nella libreria {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "{user} ha ripristinato il file  {fileName} nella libreria {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "{user} ha ripristinato la cartella {folderName} nella libreria {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "{user} ha aggiornato il file {fileName} nella libreria {libraryName}.",
    "{xxx} items have been selected": "Selezionati {xxx} elementi"
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "l d F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%d/%m/%y %H:%M:%S",
      "%d/%m/%y %H:%M:%S.%f",
      "%d/%m/%y %H:%M",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%d-%m-%Y %H:%M:%S",
      "%d-%m-%Y %H:%M:%S.%f",
      "%d-%m-%Y %H:%M",
      "%d-%m-%y %H:%M:%S",
      "%d-%m-%y %H:%M:%S.%f",
      "%d-%m-%y %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "d F Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%Y/%m/%d",
      "%d-%m-%Y",
      "%Y-%m-%d",
      "%d-%m-%y",
      "%d/%m/%y"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": 1,
    "MONTH_DAY_FORMAT": "j F",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i",
    "SHORT_DATE_FORMAT": "d/m/Y",
    "THOUSAND_SEPARATOR": ".",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

