import { CellType, PRIVATE_COLUMN_KEY } from './column';

const SORT_TYPE = {
  UP: 'up',
  DOWN: 'down',
};

const SORT_COLUMN_OPTIONS = [
  CellType.FILE_NAME,
  CellType.CTIME,
  CellType.MTIME,
  CellType.TEXT,
  CellType.DATE,
  CellType.SINGLE_SELECT,
  CellType.MULTIPLE_SELECT,
  CellType.COLLABORATOR,
  CellType.CHECKBOX,
  CellType.NUMBER,
  CellType.RATE,
];

const SHOW_DISABLED_SORT_COLUMNS = [
  CellType.LONG_TEXT,
  CellType.GEOLOCATION,
  CellType.CREATOR,
  CellType.LAST_MODIFIER,
];

const GALLERY_SORT_COLUMN_OPTIONS = [
  CellType.CTIME,
  CellType.MTIME,
  CellType.RATE,
  CellType.NUMBER,
  CellType.FILE_NAME,
];

const GALLERY_FIRST_SORT_COLUMN_OPTIONS = [
  CellType.CTIME,
  CellType.MTIME,
];

const GALLERY_SORT_PRIVATE_COLUMN_KEYS = [
  PRIVATE_COLUMN_KEY.CAPTURE_TIME,
  PRIVATE_COLUMN_KEY.CTIME,
  PRIVATE_COLUMN_KEY.MTIME,
  PRIVATE_COLUMN_KEY.FILE_NAME,
];

const GALLERY_FIRST_SORT_PRIVATE_COLUMN_KEYS = [
  PRIVATE_COLUMN_KEY.CAPTURE_TIME,
  PRIVATE_COLUMN_KEY.CTIME,
  PRIVATE_COLUMN_KEY.MTIME,
];

const TEXT_SORTER_COLUMN_TYPES = [CellType.TEXT];
const NUMBER_SORTER_COLUMN_TYPES = [CellType.NUMBER, CellType.RATE];

export {
  SORT_TYPE,
  SORT_COLUMN_OPTIONS,
  SHOW_DISABLED_SORT_COLUMNS,
  GALLERY_SORT_COLUMN_OPTIONS,
  GALLERY_FIRST_SORT_COLUMN_OPTIONS,
  GALLERY_SORT_PRIVATE_COLUMN_KEYS,
  GALLERY_FIRST_SORT_PRIVATE_COLUMN_KEYS,
  TEXT_SORTER_COLUMN_TYPES,
  NUMBER_SORTER_COLUMN_TYPES,
};
