
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = 0;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(\u5982\u679c\u70ba\u7a7a\uff0c\u64c1\u6709\u8005\u5c07\u70ba\u7ba1\u7406\u54e1)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "\u5bc6\u78bc\u81f3\u5c11 {passwordMinLength} \u500b\u5b57\u7b26\uff0c\u4e26\u5305\u542b {passwordStrengthLevel} \u7a2e\u4ee5\u4e0b\u7684\u5b57\u7b26\uff1a\u6578\u5b57\u3001\u5927\u5beb\u5b57\u6bcd\u3001\u5c0f\u5beb\u5b57\u6bcd\u548c\u5176\u4ed6\u7b26\u865f\u3002",
    "(at least {placeholder} characters)": "\uff08\u81f3\u5c11 {placeholder} \u500b\u5b57\u5143\uff09",
    "(current notification)": "\uff08\u7576\u524d\u901a\u77e5\uff09",
    "(current version)": "(\u7576\u524d\u7248\u672c)",
    "(deleted)": "\uff08\u5df2\u522a\u9664\uff09",
    "1 Hidden property": "1 \u500b\u96b1\u85cf\u5c6c\u6027",
    "1 Year": "1 \u5e74",
    "1 cell copied": "\u8907\u88fd 1 \u500b\u55ae\u5143\u683c\u3002",
    "1 cell cut": "\u526a\u4e0b 1 \u500b\u55ae\u5143\u683c",
    "1 filter": "1 \u500b\u7be9\u9078",
    "1 hidden property": "1 \u500b\u96b1\u85cf\u5c6c\u6027",
    "1 month ago": "1\u500b\u6708\u4e4b\u524d",
    "1 preset hidden property": "1 \u500b\u9810\u8a2d\u96b1\u85cf\u5c6c\u6027",
    "1 record selected": "\u9078\u64c7 1 \u689d\u8a18\u9304",
    "1 row is copied.": "\u8907\u88fd 1 \u884c\u3002",
    "1 sort": "1 \u500b\u6392\u5e8f",
    "1 week ago": "1\u5468\u4e4b\u524d",
    "3 days ago": "3\u5929\u524d",
    "30 Days": "30 \u5929",
    "7 Days": "7 \u5929",
    "A file is being uploaded. Are you sure you want to leave this page?": "\u78ba\u8a8d\u96e2\u958b\u6b64\u9801\u9762\u55ce\uff1f",
    "A file named {upload_file_link} is uploaded to {uploaded_link}.": "\u540d\u70ba{upload_file_link}\u7684\u6a94\u6848\u5df2\u4e0a\u8f09\u5230{uploaded_link}\u3002",
    "A file named {upload_file_link} is uploaded.": "\u5df2\u4e0a\u8f09\u540d\u70ba{upload_file_link}\u7684\u6a94\u6848\u3002",
    "A file with the same name already exists in this folder.": "\u8a72\u8cc7\u6599\u593e\u4e0b\u6709\u540c\u540d\u6a94\u6848\u3002",
    "A folder named {upload_folder_link} is uploaded to {uploaded_link}.": "\u540d\u70ba {upload_folder_link} \u7684\u8cc7\u6599\u593e\u5df2\u4e0a\u8f09\u5230 {uploaded_link}\u3002",
    "A folder named {upload_folder_link} is uploaded.": "\u5df2\u4e0a\u8f09\u540d\u70ba {upload_folder_link} \u7684\u8cc7\u6599\u593e\u3002",
    "AI": "AI",
    "AI credit used this month": "\u672c\u6708 AI \u4fe1\u7528\u4f7f\u7528\u91cf",
    "AI credit used:": "\u5df2\u7528 AI \u8a8d\u77e5\u7a7a\u9593\uff1a",
    "API Token": "API \u91d1\u9470",
    "API token is copied to the clipboard.": "API \u4ee4\u724c\u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f\u3002",
    "About": "\u95dc\u65bc",
    "About Us": "\u95dc\u65bc\u6211\u5011",
    "Abuse Content": "\u6feb\u7528\u5167\u5bb9",
    "Abuse Reports": "\u6feb\u7528\u5831\u544a",
    "Abuse Type": "\u6feb\u7528\u985e\u578b",
    "Abuse report added": "\u6feb\u7528\u5831\u544a\u5df2\u63d0\u4ea4",
    "Accept": "\u63a5\u53d7",
    "Accepted": "\u5df2\u7d93\u63a5\u53d7",
    "Accepted at": "\u63a5\u53d7\u6642\u9593",
    "Accepter": "\u63a5\u53d7\u8005",
    "Access Log": "\u700f\u89bd\u65e5\u8a8c",
    "Access scope": "\u8a2a\u554f\u7bc4\u570d",
    "Accurate to minute": "\u7cbe\u78ba\u5230\u5206\u9418",
    "Action": "\u64cd\u4f5c",
    "Actions": "\u64cd\u4f5c",
    "Activate after registration": "\u8a3b\u518a\u5f8c\u5373\u555f\u7528\u7528\u6236\u5e33\u6236",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "\u8a3b\u518a\u5f8c\u5373\u555f\u7528\u7528\u6236\u5e33\u6236\u3002\u5982\u679c\u95dc\u9589\u6b64\u529f\u80fd\uff0c\u7528\u6236\u9700\u8981\u7531\u7cfb\u7d71\u7ba1\u7406\u54e1\u6216\u901a\u904e\u6fc0\u6d3b\u90f5\u4ef6\u555f\u7528\u3002",
    "Activated": "\u5df2\u958b\u901a",
    "Activated Users": "\u958b\u901a\u7528\u6236",
    "Active": "\u5553\u52d5",
    "Active Users": "\u6d3b\u8e8d\u7528\u6236\u6578",
    "Active users": "\u6d3b\u8e8d\u7528\u6236",
    "Activities": "\u6a94\u6848\u6d3b\u52d5",
    "Actual size": "\u5be6\u969b\u5927\u5c0f",
    "Add": "\u65b0\u589e",
    "Add Admin": "\u65b0\u589e\u7ba1\u7406\u54e1",
    "Add Folder": "\u65b0\u589e\u76ee\u9304",
    "Add Institution": "\u65b0\u589e\u6a5f\u69cb",
    "Add Library": "\u65b0\u589e\u8cc7\u6599\u5eab",
    "Add Member": "\u6dfb\u52a0\u6210\u54e1",
    "Add Organization": "\u65b0\u589e\u7d44\u7e54",
    "Add Terms and Conditions": "\u589e\u52a0\u8edf\u4ef6\u4f7f\u7528\u689d\u6b3e",
    "Add User": "\u65b0\u589e\u4f7f\u7528\u8005",
    "Add User to Group": "\u5c07\u4f7f\u7528\u8005\u65b0\u589e\u81f3\u7fa4\u7d44",
    "Add Wiki": "\u6dfb\u52a0\u7dad\u57fa",
    "Add admin": "\u65b0\u589e\u7ba1\u7406\u54e1",
    "Add auto expiration": "\u589e\u52a0\u81ea\u52d5\u904e\u671f",
    "Add column": "\u6dfb\u52a0\u5217",
    "Add cover": "\u65b0\u589e\u5c01\u9762",
    "Add custom permission": "\u6dfb\u52a0\u81ea\u5b9a\u7fa9\u6b0a\u9650",
    "Add department at": "\u5728\u4f3a\u670d\u5668\u6dfb\u52a0\u90e8\u9580",
    "Add filter": "\u6dfb\u52a0\u7be9\u9078",
    "Add group": "\u6dfb\u52a0\u5206\u7d44",
    "Add group member": "\u65b0\u589e\u7fa4\u7d44\u6210\u54e1",
    "Add icon": "\u65b0\u589e\u7d75\u6587\u5b57",
    "Add institution": "\u65b0\u589e\u6a5f\u69cb",
    "Add member": "\u65b0\u589e\u6210\u54e1",
    "Add members": "\u65b0\u589e\u6210\u54e1",
    "Add new notification": "\u65b0\u589e\u65b0\u901a\u77e5",
    "Add option": "\u6dfb\u52a0\u9078\u9805",
    "Add option: %s": "\u6dfb\u52a0\u9078\u9805\uff1a %s",
    "Add page": "\u65b0\u589e\u9801\u9762",
    "Add page above": "\u65b0\u589e\u4e0a\u5c64\u9801\u9762",
    "Add page below": "\u65b0\u589e\u4e0b\u5c64\u9801\u9762",
    "Add page inside": "\u65b0\u589e\u5b50\u9801\u9762",
    "Add password protection": "\u589e\u52a0\u5bc6\u78bc\u4fdd\u8b77",
    "Add permission": "\u65b0\u589e\u6b0a\u9650",
    "Add sort": "\u6dfb\u52a0\u6392\u5e8f",
    "Add sub-department": "\u65b0\u589e\u5b50\u90e8\u9580",
    "Add tag": "\u6dfb\u52a0\u6a19\u7c64",
    "Add to groups": "\u6dfb\u52a0\u5230\u7fa4\u7d44",
    "Add user": "\u65b0\u589e\u7528\u6236",
    "Add view": "\u65b0\u589e\u6aa2\u8996",
    "Added": "\u5df2\u65b0\u589e",
    "Added a new comment in document {sdoc_link}:": "\u7528\u6236 {user} \u5df2\u5728\u6587\u4ef6 {sdoc_link} \u4e2d\u6dfb\u52a0\u65b0\u7559\u8a00\uff1a{comment}",
    "Added a new reply in document {sdoc_link}:": "\u7528\u6236 {user} \u5df2\u5728\u6587\u4ef6 {sdoc_link} \u4e2d\u6dfb\u52a0\u65b0\u56de\u8986\uff1a{reply}",
    "Added user {user}": "\u5df2\u65b0\u589e\u4f7f\u7528\u8005 {user}",
    "Added user {user} to group {group}": "\u5c07\u4f7f\u7528\u8005 {user} \u65b0\u589e\u81f3\u7fa4\u7d44 {group}",
    "Address": "\u5730\u5740",
    "Admin": "\u7ba1\u7406",
    "Admin Login Logs": "\u7ba1\u7406\u767b\u5165\u65e5\u8a8c",
    "Admin Logs": "\u7ba1\u7406\u54e1\u65e5\u8a8c",
    "Admin Operation Logs": "\u7ba1\u7406\u64cd\u4f5c\u65e5\u8a8c",
    "Admin access": "\u7ba1\u7406\u54e1\u5b58\u53d6",
    "Admin updated": "\u5df2\u5c07 {placeholder} \u8a2d\u70ba\u7ba1\u7406\u54e1\u3002",
    "Admins": "\u7ba1\u7406\u54e1",
    "Advanced": "\u9032\u968e",
    "After": "\u5f8c",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "\u555f\u7528\u64f4\u5c55\u5c6c\u6027\u5f8c\uff0c\u60a8\u53ef\u4ee5\u70ba\u6587\u4ef6\u6dfb\u52a0\u4e0d\u540c\u7684\u5c6c\u6027\uff0c\u5982\u5354\u4f5c\u8005\u3001\u6587\u4ef6\u904e\u671f\u6642\u9593\u3001\u6587\u4ef6\u63cf\u8ff0\u3002\u60a8\u9084\u53ef\u4ee5\u57fa\u65bc\u64f4\u5c55\u5c6c\u6027\u5275\u5efa\u4e0d\u540c\u7684\u8996\u5716\u3002",
    "After exceeding the traffic limit, the file download speed will be restricted.": "\u8d85\u904e\u6d41\u91cf\u9650\u5236\u5f8c\uff0c\u6587\u4ef6\u4e0b\u8f09\u901f\u5ea6\u5c07\u53d7\u9650\u5236\u3002",
    "All": "\u5168\u90e8",
    "All Activities": "\u6240\u6709\u6d3b\u52d5",
    "All Groups": "\u6240\u6709\u7fa4\u7d44",
    "All Notifications": "\u6240\u6709\u901a\u77e5",
    "All Public Links": "\u5168\u90e8\u516c\u5171\u9023\u7d50",
    "All comments": "\u6240\u6709\u8a55\u8ad6",
    "All files uploaded": "\u6240\u6709\u6587\u4ef6\u4e0a\u50b3\u5b8c\u6210\u3002",
    "All tags": "\u6240\u6709\u6a19\u7c64",
    "Allow new registrations": "\u5141\u8a31\u7528\u6236\u8a3b\u518a",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "\u5141\u8a31\u7528\u6236\u8a3b\u518a\u3002\u5982\u679c\u95dc\u9589\u6b64\u529f\u80fd\uff0c\u5c07\u7981\u6b62\u4efb\u4f55\u4eba\u9032\u884c\u8a3b\u518a\u3002",
    "Allow users to change library history settings": "\u7528\u6236\u53ef\u4ee5\u67e5\u770b\u548c\u7ba1\u7406\u81ea\u5df1\u7684\u8cc7\u6599\u5eab\u6b77\u53f2\u8a18\u9304\u3002",
    "Allow users to clean library trash": "\u7528\u6236\u53ef\u4ee5\u6e05\u7406\u81ea\u5df1\u7684\u5783\u573e\u6876\u3002",
    "Allow users to create encrypted libraries": "\u7528\u6236\u53ef\u4ee5\u5275\u5efa\u52a0\u5bc6\u7684\u8cc7\u6599\u5eab\u3002",
    "An integer that is greater than 0 or equal to -2.": "\u5927\u65bc 0 \u6216\u7b49\u65bc -2 \u7684\u6574\u6578\u3002",
    "An integer that is greater than or equal to 0.": "\u5927\u65bc\u7b49\u65bc 0 \u7684\u6574\u6578\u3002",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "\u5167\u90e8\u93c8\u63a5\u63cf\u8ff0",
    "And": "\u4e14",
    "Anonymous User": "\u533f\u540d\u7528\u6236",
    "Another property has this property type": "\u53e6\u4e00\u500b\u5c6c\u6027\u5177\u6709\u6b64\u5c6c\u6027\u985e\u578b",
    "Another user is editing this file!": "\u53e6\u4e00\u7528\u6236\u6b63\u5728\u7de8\u8f2f\u6b64\u6587\u4ef6\uff01",
    "Anyone with the link": "\u4efb\u4f55\u6709\u93c8\u63a5\u7684\u4eba",
    "App Name": "\u61c9\u7528\u7a0b\u5f0f\u540d\u7a31",
    "Are you sure to change group {placeholder} to department ?": "\u78ba\u8a8d\u5c07\u7fa4\u7d44 {placeholder} \u66f4\u6539\u70ba\u90e8\u9580\u55ce\uff1f",
    "Are you sure to delete": "\u78ba\u8a8d\u522a\u9664\u90e8\u9580\u55ce\uff1f",
    "Are you sure to delete ": "\u662f\u5426\u78ba\u8a8d\u522a\u9664\uff1f",
    "Are you sure to delete this comment?": "\u78ba\u5b9a\u8981\u522a\u9664\u6b64\u8a55\u8ad6\u55ce\uff1f",
    "Are you sure to delete this reply?": "\u78ba\u5b9a\u8981\u522a\u9664\u6b64\u56de\u8986\u55ce\uff1f",
    "Are you sure to revoke access of user {placeholder} ?": "\u78ba\u8a8d\u64a4\u92b7\u7528\u6236 {placeholder} \u7684\u8a2a\u554f\u6b0a\u9650\u55ce\uff1f",
    "Are you sure you want to clean invalid share links?": "\u78ba\u8a8d\u6e05\u9664\u7121\u6548\u7684\u5206\u4eab\u9023\u7d50\u55ce\uff1f",
    "Are you sure you want to clean invalid upload links?": "\u78ba\u8a8d\u6e05\u9664\u7121\u6548\u7684\u4e0a\u50b3\u9023\u7d50\u55ce\uff1f",
    "Are you sure you want to clear trash?": "\u78ba\u5b9a\u8981\u6e05\u7a7a\u56de\u6536\u7ad9\u55ce\uff1f",
    "Are you sure you want to delete": "\u78ba\u5b9a\u8981\u522a\u9664\u55ce\uff1f",
    "Are you sure you want to delete WebDAV password?": "\u78ba\u8a8d\u522a\u9664 WebDAV \u5bc6\u78bc\u55ce\uff1f",
    "Are you sure you want to delete Wiki": "\u78ba\u8a8d\u522a\u9664 Wiki \u55ce\uff1f",
    "Are you sure you want to delete the notification ?": "\u78ba\u8a8d\u8981\u522a\u9664\u901a\u77e5\u55ce\uff1f",
    "Are you sure you want to delete the selected share link(s) ?": "\u78ba\u8a8d\u8981\u522a\u9664\u9078\u4e2d\u7684\u5171\u4eab\u7db2\u5740\u55ce\uff1f",
    "Are you sure you want to delete the selected upload link(s) ?": "\u78ba\u8a8d\u8981\u522a\u9664\u9078\u4e2d\u7684\u4e0a\u50b3\u9023\u7d50\u55ce\uff1f",
    "Are you sure you want to delete the selected user(s) ?": "\u78ba\u5b9a\u8981\u522a\u9664\u9078\u4e2d\u7684\u7528\u6236\u55ce\uff1f",
    "Are you sure you want to delete the share link?": "\u78ba\u8a8d\u522a\u9664\u5206\u4eab\u9023\u7d50\u55ce\uff1f",
    "Are you sure you want to delete this option?": "\u78ba\u8a8d\u522a\u9664\u6b64\u9078\u9805\u55ce\uff1f",
    "Are you sure you want to delete this page?": "\u78ba\u5b9a\u8981\u522a\u9664\u8a72\u9801\u9762\uff1f",
    "Are you sure you want to delete {placeholder} ?": "\u78ba\u8a8d\u522a\u9664 {placeholder} \u55ce\uff1f",
    "Are you sure you want to delete {placeholder} completely?": "\u78ba\u5b9a\u8981\u6c38\u4e45\u522a\u9664 {placeholder} \u55ce\uff1f",
    "Are you sure you want to disconnect?": "\u78ba\u8a8d\u65b7\u958b\u9023\u63a5\u55ce\uff1f",
    "Are you sure you want to leave share Wiki": "\u78ba\u8a8d\u53d6\u6d88\u5206\u4eab Wiki \u55ce\uff1f",
    "Are you sure you want to remove {placeholder} ?": "\u78ba\u8a8d\u8981\u5c07 {placeholder} \u79fb\u9664\u55ce\uff1f",
    "Are you sure you want to reset the password of {placeholder} ?": "\u78ba\u8a8d\u8981\u91cd\u7f6e {placeholder} \u7684\u5bc6\u78bc\u55ce\uff1f",
    "Are you sure you want to restore this library?": "\u78ba\u5b9a\u8981\u9084\u539f\u8a72\u8cc7\u6599\u5eab\uff1f",
    "Are you sure you want to restore {placeholder}?": "\u78ba\u5b9a\u8981\u6062\u5fa9 {placeholder} \u55ce\uff1f",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "\u78ba\u8a8d\u8981\u64a4\u92b7 {placeholder} \u7684\u7ba1\u7406\u54e1\u6b0a\u9650\u55ce\uff1f",
    "Are you sure you want to set {placeholder} as Admin?": "\u78ba\u8a8d\u8981\u5c07 {placeholder} \u8a2d\u70ba\u7ba1\u7406\u54e1\u55ce\uff1f",
    "Are you sure you want to set {user_placeholder} inactive?": "\u60a8\u78ba\u5b9a\u8981\u5c07 {user_placeholder} \u8a2d\u70ba\u4e0d\u6d3b\u52d5\u55ce\uff1f",
    "Are you sure you want to unlink this device?": "\u78ba\u5b9a\u8981\u65b7\u958b\u6b64\u8a2d\u5099\u7684\u9023\u63a5\u55ce\uff1f",
    "Are you sure you want to unpublish Wiki": "\u78ba\u8a8d\u53d6\u6d88\u767c\u5e03 Wiki \u55ce\uff1f",
    "Are you sure you want to unshare {placeholder} ?": "\u78ba\u8a8d\u8981\u53d6\u6d88\u5171\u4eab {placeholder} \u55ce\uff1f",
    "Ascending by count": "\u6309\u6578\u91cf\u5347\u5e8f",
    "Ascending by creation time": "\u6309\u5275\u5efa\u6642\u9593\u5347\u5e8f\u6392\u5e8f",
    "Ascending by name": "\u6309\u540d\u7a31\u5347\u51aa\u6392\u5e8f",
    "Ascending by role": "\u6309\u89d2\u8272\u5347\u5e8f\u6392\u5e8f",
    "Ascending by size": "\u6309\u5927\u5c0f\u5347\u51aa\u6392\u5e8f",
    "Ascending by space used": "\u6309\u7a7a\u9593\u4f7f\u7528\u91cf\u5347\u5e8f\u6392\u5e8f",
    "Ascending by time": "\u6309\u6642\u9593\u5347\u51aa\u6392\u5e8f",
    "Ascending by visit count": "\u6309\u8a2a\u554f\u6b21\u6578\u5347\u5e8f\u6392\u5e8f",
    "At server": "\u5728\u4f3a\u670d\u5668",
    "Audio": "\u97f3\u983b",
    "Auth Token created": "\u5df2\u6210\u529f\u5efa\u7acb\u8a8d\u8b49\u4ee4\u724c\u3002",
    "Auth Token deleted": "\u5df2\u6210\u529f\u522a\u9664\u8a8d\u8b49\u4ee4\u724c\u3002",
    "Authenticated emails": "\u5df2\u9a57\u8b49\u96fb\u5b50\u90f5\u4ef6",
    "Authenticated users": "\u5df2\u9a57\u8b49\u7528\u6236",
    "Auto deletion": "\u81ea\u52d5\u522a\u9664",
    "Automatically delete files that are not modified within certain days:": "\u81ea\u52d5\u522a\u9664\u672a\u4fee\u6539\u8d85\u904e\u4e00\u5b9a\u5929\u6578\u7684\u6587\u4ef6:",
    "Avatar": "\u982d\u50cf",
    "Avatar updated": "\u982d\u50cf\u5df2\u66f4\u65b0",
    "Avatar:": "\u982d\u50cf\uff1a",
    "Back": "\u8fd4\u56de",
    "Basic": "\u57fa\u672c\u7be9\u9078",
    "Before": "\u524d",
    "Bell Icon": "\u9b27\u9418\u5716\u793a",
    "Besides Write permission, user can also share the library.": "\u9664\u4e86\u5beb\u5165\u6b0a\u9650\uff0c\u7528\u6236\u9084\u53ef\u4ee5\u5206\u4eab\u5eab\u3002",
    "Billing": "\u8ba1\u8d39",
    "Branding": "\u54c1\u724c",
    "Broken (please contact your administrator to fix this library)": "\u640d\u58de (\u8acb\u806f\u7e6b\u60a8\u7684\u7ba1\u7406\u54e1\u4f86\u4fee\u5fa9\u8a72\u8cc7\u6599\u5eab)",
    "Broken ({repo_id_placeholder})": "\u5df2\u640d\u58de ({repo_id_placeholder})",
    "By child tags count ascending": "\u6309\u5b50\u6a19\u7c64\u6578\u91cf\u5347\u51aa\u6392\u5e8f",
    "By child tags count descending": "\u6309\u5b50\u6a19\u7c64\u6578\u91cf\u964d\u51aa\u6392\u5e8f",
    "By day": "\u6309\u5929\u5206\u7d44",
    "By file count ascending": "\u6309\u6587\u4ef6\u6578\u91cf\u5347\u51aa\u6392\u5e8f",
    "By file count descending": "\u6309\u6587\u4ef6\u6578\u91cf\u964d\u51aa\u6392\u5e8f",
    "By month": "\u6309\u6708\u5206\u7d44",
    "By name ascending": "\u6309\u540d\u7a31\u5347\u5e8f",
    "By name descending": "\u6309\u540d\u7a31\u964d\u5e8f",
    "By quarter": "\u6309\u5b63\u5ea6\u5206\u7d44",
    "By size ascending": "\u6309\u5927\u5c0f\u5347\u5e8f",
    "By size descending": "\u6309\u5927\u5c0f\u964d\u5e8f",
    "By tag name ascending": "\u6309\u6a19\u7c64\u540d\u7a31\u5347\u51aa\u6392\u5e8f",
    "By tag name descending": "\u6309\u6a19\u7c64\u540d\u7a31\u964d\u51aa\u6392\u5e8f",
    "By time ascending": "\u6309\u6642\u9593\u5347\u5e8f",
    "By time descending": "\u6309\u6642\u9593\u964d\u5e8f",
    "By week": "\u6309\u5468\u5206\u7d44",
    "By year": "\u6309\u5e74\u5206\u7d44",
    "Can not copy folder %(src)s to its subfolder %(des)s": "\u4e0d\u80fd\u5c07\u8cc7\u6599\u593e %(src)s \u8907\u88fd\u5230\u5176\u5b50\u8cc7\u6599\u593e %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "\u4e0d\u80fd\u5c07\u8cc7\u6599\u593e %(src)s \u79fb\u52d5\u5230\u5176\u5b50\u8cc7\u6599\u593e %(des)s",
    "Can only copy files that are in the same folder": "\u53ea\u80fd\u8907\u88fd\u540c\u4e00\u6587\u4ef6\u593e\u4e2d\u7684\u6587\u4ef6",
    "Can only download files that are in the same folder": "\u53ea\u80fd\u4e0b\u8f09\u540c\u4e00\u6587\u4ef6\u593e\u4e2d\u7684\u6587\u4ef6",
    "Can only move files that are in the same folder": "\u53ea\u80fd\u79fb\u52d5\u540c\u4e00\u6587\u4ef6\u593e\u4e2d\u7684\u6587\u4ef6",
    "Cancel": "\u53d6\u6d88",
    "Cancel All": "\u5168\u90e8\u53d6\u6d88",
    "Cannot move parent page to child page": "\u4e0d\u80fd\u5c07\u7236\u9801\u9762\u79fb\u52d5\u5230\u5b50\u9801\u9762\u3002",
    "Capture information": "\u62cd\u651d\u8cc7\u8a0a",
    "Capture time": "\u62cd\u651d\u6642\u9593",
    "Card": "\u5361\u7247",
    "Certificate": "\u8b49\u66f8",
    "Change": "\u4fee\u6539",
    "Change Password": "\u4fee\u6539\u5bc6\u78bc",
    "Change Password of Library {placeholder}": "\u66f4\u6539\u8cc7\u6599\u5eab {placeholder} \u5bc6\u78bc",
    "Change cover": "\u66f4\u6539\u5c01\u9762",
    "Change group to department": "\u5c07\u7fa4\u7d44\u66f4\u6539\u70ba\u90e8\u9580",
    "Change to department": "\u8b8a\u66f4\u70ba\u90e8\u9580",
    "Change view type": "\u66f4\u6539\u8996\u5716\u985e\u578b",
    "Changes": "\u8b8a\u66f4",
    "Checkbox": "\u8907\u9078\u6846",
    "Child tags count": "\u5b50\u6a19\u7c64\u6578\u91cf",
    "Choose date": "\u9078\u64c7\u65e5\u671f",
    "Clean": "\u6e05\u7a7a",
    "Clean invalid share links": "\u6e05\u9664\u7121\u6548\u7684\u5206\u4eab\u9023\u7d50",
    "Clean invalid upload links": "\u6e05\u9664\u7121\u6548\u7684\u4e0a\u50b3\u9023\u7d50",
    "Clean succeeded.": "\u6e05\u7a7a\u6210\u529f\u3002",
    "Cleaned trash": "\u5df2\u6e05\u9664\u56de\u6536\u7ad9",
    "Clear": "\u6e05\u7a7a",
    "Clear Trash": "\u6e05\u7a7a\u56de\u6536\u7ad9",
    "Clear files in trash and history\uff1a": "\u6e05\u7a7a\u56de\u6536\u7ad9\u548c\u6b77\u53f2\u4fe1\u606f\u4e2d\u7684\u6a94\u6848",
    "Clear search": "\u6e05\u7a7a\u641c\u7d22",
    "Clear selected": "\u6e05\u9664\u9078\u64c7",
    "Clients": "\u5ba2\u6237\u7aef",
    "Close": "\u95dc\u9589",
    "Close (Esc)": "\u95dc\u9589 (Esc)",
    "Close the panel": "\u95dc\u9589\u9762\u677f",
    "Code": "\u884c\u5167\u4ee3\u78bc",
    "Collaborator": "\u5354\u4f5c\u8005",
    "Collaborators": "\u5354\u4f5c\u8005",
    "Collapse all": "\u647a\u758a\u6240\u6709",
    "Collected time": "\u6536\u96c6\u6642\u9593",
    "Color": "\u984f\u8272",
    "Color space": "\u8272\u5f69\u7a7a\u9593",
    "Comma (1,000,000)": "\u9017\u865f (1,000,000)",
    "Comma(1,03)": "\u9017\u865f(1,03)",
    "Comment": "\u8a55\u8ad6",
    "Comment details": "\u8a55\u8ad6\u8a73\u60c5",
    "Comments": "\u8a55\u8ad6",
    "Community Edition": "\u793e\u5340\u7248",
    "Compressed": "\u58d3\u7e2e\u6587\u4ef6",
    "Configure Seafile": "\u914d\u7f6e Seafile",
    "Configure your Identity Provider": "\u914d\u7f6e\u60a8\u7684\u8eab\u4efd\u63d0\u4f9b\u8005",
    "Confirm": "\u78ba\u8a8d",
    "Confirm Password": "\u78ba\u8a8d\u5bc6\u78bc",
    "Confirm password": "\u78ba\u8a8d\u5bc6\u78bc",
    "Confluence export file": "Confluence \u5c0e\u51fa\u6587\u4ef6",
    "Confluence file imported": "\u5df2\u5c0e\u5165 Confluence \u6587\u4ef6",
    "Confluence imported": "\u5df2\u532f\u5165 Confluence \u9801\u9762\u3002",
    "Connect": "\u9023\u63a5",
    "Contact Email": "\u806f\u7e6b\u96fb\u90f5",
    "Contact Email:": "\u806f\u7d61\u96fb\u90f5:",
    "Contact Information": "\u806f\u7d61\u8cc7\u8a0a",
    "Contact email": "\u806f\u7d61\u96fb\u5b50\u90f5\u4ef6",
    "Contact information is required.": "\u9700\u8981\u806f\u7d61\u8cc7\u8a0a",
    "Content Scan Records": "\u5167\u5bb9\u6383\u63cf\u8a18\u9304",
    "Convert & Export": "\u8f49\u63db\u8207\u532f\u51fa",
    "Convert Wiki": "\u5c07 Wiki \u8f49\u63db\u70ba\u6587\u4ef6",
    "Convert to Markdown": "\u8f49\u63db\u70ba Markdown",
    "Convert to docx": "\u8f49\u63db\u70ba docx",
    "Convert to new Wiki": "\u5c07 Wiki \u8f49\u63db\u70ba\u65b0 Wiki",
    "Convert to sdoc": "\u8f49\u63db\u70ba sdoc",
    "Convert with ONLYOFFICE": "\u4f7f\u7528 ONLYOFFICE \u8f49\u63db",
    "Converting": "\u6b63\u5728\u8f49\u63db",
    "Converting, please wait...": "\u8f49\u63db\u4e2d\uff0c\u8acb\u7a0d\u7b49...",
    "Converting...": "\u6b63\u5728\u8f49\u63db...",
    "Copied": "\u5df2\u8907\u88fd",
    "Copied link to clipboard": "\u5df2\u8907\u88fd\u9023\u7d50\u5230\u526a\u8cbc\u677f\u3002",
    "Copy": "\u8907\u88fd",
    "Copy failed": "\u8907\u88fd\u5931\u6557\u3002",
    "Copy link": "\u8907\u88fd\u9023\u7d50",
    "Copy path": "\u8907\u88fd\u8def\u5f91",
    "Copy selected": "\u8907\u88fd\u9078\u64c7",
    "Copy selected item(s) to:": "\u5c07\u5df2\u9078\u689d\u76ee\u8907\u88fd\u5230\uff1a",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "\u8acb\u8907\u88fd IdP \u7684\u8b49\u66f8\u4e26\u5c07\u5176\u7c98\u8cbc\u5230\u9019\u88e1\u3002\u8b49\u66f8\u683c\u5f0f\u5982\u4e0b\uff1a",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "\u8907\u88fd\u57df\u540d DNS TXT \u4e26\u5c07\u5176\u6dfb\u52a0\u5230\u60a8\u57df\u540d\u7684 DNS \u8a18\u9304\u4e2d\uff0c\u7136\u5f8c\u55ae\u64ca\u9a57\u8b49\u57df\u540d\u6240\u6709\u8005\u8eab\u4efd\u7684\u6309\u9215\u3002\u60a8\u5fc5\u9808\u5728\u55ae\u9ede\u767b\u9304\u4e4b\u524d\u9a57\u8b49\u57df\u540d\u7684\u6240\u6709\u8005\u8eab\u4efd\u3002",
    "Copy {num} items": "\u8907\u88fd {num} \u500b\u9805\u76ee",
    "Copy {placeholder} to": "\u5c07 {placeholder} \u8907\u88fd\u5230",
    "Copyright Infringement": "\u4fb5\u6b0a\u5167\u5bb9",
    "Count": "\u6578\u91cf",
    "Cover": "\u5c01\u9762",
    "Cover photo set": "\u5c01\u9762\u7167\u7247\u5df2\u8a2d\u7f6e",
    "Create": "\u5efa\u7acb",
    "Create At": "\u5efa\u7acb\u6642\u9593",
    "Create Group": "\u5efa\u7acb\u7fa4\u7d44",
    "Create Library": "\u5275\u5efa\u8cc7\u6599\u5eab",
    "Create Report": "\u5275\u5efa\u5831\u544a",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "\u5275\u5efa\u4e00\u500b DNS TXT \u8a18\u9304\u4ee5\u78ba\u8a8d\u60a8\u7684\u90f5\u4ef6\u57df\u540d\u7684\u6240\u6709\u8005\u8eab\u4efd\u3002",
    "Create a new tag": "\u6dfb\u52a0\u9078\u9805",
    "Create time": "\u5efa\u7acb\u6642\u9593",
    "Create top department": "\u5275\u5efa\u9802\u90e8\u90e8\u9580",
    "Created": "\u5efa\u7acb\u65bc",
    "Created At": "\u5efa\u7acb\u6642\u9593",
    "Created Files": "\u5df2\u5efa\u7acb\u6587\u4ef6",
    "Created draft": "\u5df2\u5efa\u7acb\u8349\u7a3f",
    "Created file": "\u5df2\u5efa\u7acb\u7684\u6a94\u6848",
    "Created folder": "\u5df2\u5efa\u7acb\u7684\u8cc7\u6599\u593e",
    "Created group {group_name}": "\u5efa\u7acb\u7fa4\u7d44 {group_name}",
    "Created library": "\u5efa\u7acb\u4e86\u8cc7\u6599\u5eab",
    "Created library {library_name} with {owner} as its owner": "\u5275\u5efa\u8cc7\u6599\u5eab {library_name} \u7531{owner}\u70ba\u64c1\u6709\u8005",
    "Created time": "\u5efa\u7acb\u6642\u9593",
    "Created {n} files": "\u5df2\u5efa\u7acb {n} \u500b\u6a94\u6848",
    "Creator": "\u5efa\u7acb\u8005",
    "Currency symbol is required": "\u8ca8\u5e63\u7b26\u865f\u662f\u5fc5\u586b\u9805",
    "Current Connected Devices": "\u7576\u524d\u9023\u63a5\u7684\u8a2d\u5099",
    "Current Library": "\u7576\u524d\u8cc7\u6599\u5eab",
    "Current Path: ": "\u7576\u524d\u8def\u5f91\uff1a",
    "Current Version": "\u7576\u524d\u7248\u672c",
    "Current page": "\u7576\u524d\u9801\u9762",
    "Current password": "\u7576\u524d\u5bc6\u78bc",
    "Current password cannot be blank": "\u7576\u524d\u5bc6\u78bc\u4e0d\u80fd\u70ba\u7a7a",
    "Current path: ": "\u7576\u524d\u8def\u5f91\uff1a",
    "Custom CSS": "\u81ea\u5b9a\u7fa9 CSS",
    "Custom currency": "\u81ea\u5b9a\u7fa9\u8ca8\u5e63",
    "Custom properties": "\u81ea\u5b9a\u7fa9\u5c6c\u6027",
    "Custom sharing permissions": "\u81ea\u5b9a\u7fa9\u5171\u4eab\u6b0a\u9650",
    "Custom symbol": "\u81ea\u5b9a\u7fa9\u7b26\u865f",
    "Custom time": "\u81ea\u5b9a\u7fa9\u6642\u9593",
    "Customer Portal": "\u5ba2\u6236\u7aef\u5165\u53e3",
    "Customize URL": "\u81ea\u5b9a\u7fa9 URL",
    "DNS TXT Value": "DNS TXT \u503c",
    "Dark mode": "\u6df1\u8272\u6a21\u5f0f",
    "Date": "\u65e5\u671f",
    "Date Invalid.": "\u65e5\u671f\u7121\u6548\u3002",
    "Day": "\u65e5\u671f",
    "Decimal separator": "\u5c0f\u6578\u9ede\u5206\u9694\u7b26",
    "Decrypt document": "\u89e3\u5bc6\u6587\u4ef6",
    "Default": "\u9810\u8a2d",
    "Delete": "\u5220\u9664",
    "Delete Account": "\u522a\u9664\u5e33\u865f",
    "Delete Department": "\u522a\u9664\u90e8\u9580",
    "Delete Expired Invitations": "\u522a\u9664\u904e\u671f\u9080\u8acb",
    "Delete File": "\u522a\u9664\u6587\u4ef6",
    "Delete Folder": "\u522a\u9664\u6587\u4ef6\u593e",
    "Delete Group": "\u5220\u9664\u7fa4\u7ec4",
    "Delete Institution": "\u522a\u9664\u6a5f\u69cb",
    "Delete Library": "\u522a\u9664\u8cc7\u6599\u5eab",
    "Delete Member": "\u5220\u9664\u6210\u54e1",
    "Delete Notification": "\u522a\u9664\u901a\u77e5",
    "Delete Organization": "\u522a\u9664\u5718\u9ad4",
    "Delete Password": "\u522a\u9664\u5bc6\u78bc",
    "Delete T&C": "\u522a\u9664\u689d\u6b3e",
    "Delete Team": "\u522a\u9664\u5718\u968a",
    "Delete User": "\u522a\u9664\u4f7f\u7528\u8005",
    "Delete User from Group": "\u5c07\u4f7f\u7528\u8005\u5f9e\u7fa4\u7d44\u4e2d\u79fb\u9664",
    "Delete Users": "\u522a\u9664\u7528\u6236",
    "Delete WebDAV Password": "\u522a\u9664 WebDAV \u5bc6\u78bc",
    "Delete Wiki": "\u78ba\u8a8d\u522a\u9664 Wiki \u55ce\uff1f",
    "Delete department": "\u522a\u9664\u90e8\u9580",
    "Delete file": "\u522a\u9664\u6587\u4ef6",
    "Delete files from this device the next time it comes online.": "\u5728\u6b64\u8a2d\u5099\u4e0b\u6b21\u4e0a\u7dda\u6642\u522a\u9664\u6b64\u8a2d\u5099\u4e0a\u7684\u6587\u4ef6\u3002",
    "Delete folder": "\u522a\u9664\u6587\u4ef6\u593e",
    "Delete group": "\u522a\u9664\u7fa4\u7d44",
    "Delete location": "\u522a\u9664\u4f4d\u7f6e",
    "Delete member": "\u522a\u9664\u6210\u54e1",
    "Delete page": "\u522a\u9664\u9801\u9762",
    "Delete property": "\u522a\u9664\u5c6c\u6027",
    "Delete selected": "\u522a\u9664\u9078\u64c7",
    "Delete share link": "\u522a\u9664\u5206\u4eab\u9023\u7d50",
    "Delete share links": "\u78ba\u8a8d\u8981\u522a\u9664\u9078\u4e2d\u7684\u5171\u4eab\u7db2\u5740\u55ce\uff1f",
    "Delete tag": "\u522a\u9664\u6a19\u7c64",
    "Delete tags": "\u522a\u9664\u6a19\u7c64",
    "Delete upload links": "\u78ba\u8a8d\u8981\u522a\u9664\u9078\u4e2d\u7684\u4e0a\u50b3\u9023\u7d50\u55ce\uff1f",
    "Deleted": "\u5df2\u522a\u9664",
    "Deleted Libraries": "\u5df2\u522a\u9664\u7684\u8cc7\u6599\u5eab",
    "Deleted Time": "\u522a\u9664\u6642\u9593",
    "Deleted by": "\u522a\u9664\u8005",
    "Deleted directories": "\u522a\u9664\u7684\u76ee\u9304",
    "Deleted draft": "\u5df2\u522a\u9664\u8349\u7a3f",
    "Deleted file": "\u5df2\u522a\u9664\u7684\u6a94\u6848",
    "Deleted files": "\u522a\u9664\u7684\u6587\u4ef6",
    "Deleted folder": "\u5df2\u522a\u9664\u7684\u8cc7\u6599\u593e",
    "Deleted group {group_name}": "\u5df2\u522a\u9664\u7fa4\u7d44 {group_name}",
    "Deleted library": "\u5df2\u522a\u9664\u7684\u8cc7\u6599\u5eab",
    "Deleted library {library_name}": "\u522a\u9664\u8cc7\u6599\u5eab {library_name}",
    "Deleted option": "\u5df2\u522a\u9664\u9078\u9805",
    "Deleted time": "\u522a\u9664\u6642\u9593",
    "Deleted user %s": "\u5df2\u522a\u9664\u7528\u6236 %s",
    "Deleted user {user}": "\u522a\u9664\u4f7f\u7528\u8005 {user}",
    "Deleted user {user} from group {group}": "\u5c07\u4f7f\u7528\u8005 {user} \u5f9e\u7fa4\u7d44 {group} \u4e2d\u79fb\u9664",
    "Department ID": "\u90e8\u9580 ID",
    "Department moved successfully": "\u7d44\u7e54\u5df2\u6210\u529f\u79fb\u52d5\u3002",
    "Department not found": "\u90e8\u9580\u672a\u627e\u5230",
    "Department renamed": "\u90e8\u9580\u5df2\u91cd\u547d\u540d",
    "Departments": "\u90e8\u9580",
    "Descending by count": "\u6309\u6578\u91cf\u964d\u5e8f",
    "Descending by creation time": "\u6309\u5275\u5efa\u6642\u9593\u964d\u5e8f\u6392\u5e8f",
    "Descending by files": "\u6309\u6587\u4ef6\u964d\u5e8f\u6392\u5e8f",
    "Descending by name": "\u6309\u540d\u7a31\u964d\u51aa\u6392\u5e8f",
    "Descending by role": "\u6309\u89d2\u8272\u964d\u5e8f\u6392\u5e8f",
    "Descending by size": "\u6309\u5927\u5c0f\u964d\u51aa\u6392\u5e8f",
    "Descending by space used": "\u6309\u7a7a\u9593\u4f7f\u7528\u91cf\u964d\u5e8f\u6392\u5e8f",
    "Descending by time": "\u6309\u6642\u9593\u964d\u51aa\u6392\u5e8f",
    "Descending by visit count": "\u6309\u8a2a\u554f\u6b21\u6578\u964d\u5e8f\u6392\u5e8f",
    "Description": "\u63cf\u8ff0",
    "Description generated": "\u63cf\u8ff0\u5df2\u751f\u6210",
    "Description is required": "\u63cf\u8ff0\u70ba\u5fc5\u586b\u9805",
    "Desktop": "\u684c\u9762\u5ba2\u6236\u7aef",
    "Detail": "\u4fee\u6539\u5167\u5bb9",
    "Details": "\u8a73\u60c5",
    "Detect faces": "\u6aa2\u6e2c\u81c9\u90e8",
    "Detecting faces by AI...": "\u6b63\u5728\u7531 AI \u6aa2\u6e2c\u81c9\u90e8...",
    "Device": "\u8a2d\u5099",
    "Device Name": "\u8a2d\u5099\u540d\u7a31",
    "Device make": "\u88dd\u7f6e\u88fd\u9020\u5546",
    "Device model": "\u88dd\u7f6e\u6a21\u578b",
    "Devices": "\u8a2d\u5099",
    "Diagram": "\u5716\u8868",
    "Dimensions": "\u5c3a\u5bf8",
    "Direct download link": "\u76f4\u63a5\u4e0b\u8f09\u9023\u7d50",
    "Direct download link is copied to the clipboard.": "\u76f4\u63a5\u4e0b\u8f09\u9023\u7d50\u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f\u3002",
    "Disable SSO user email / password login": "\u7981\u7528 SSO \u7528\u6236\u90f5\u7bb1 / \u5bc6\u78bc\u767b\u9304",
    "Disable Two-Factor Authentication": "\u505c\u7528\u5169\u6b65\u9a57\u8b49",
    "Disable sync with any folder": "\u7528\u6236\u53ef\u4ee5\u9078\u64c7\u4e0d\u540c\u6b65\u4efb\u4f55\u8cc7\u6599\u593e\u3002",
    "Disable user clean trash": "\u7981\u7528\u7528\u6236\u6e05\u9664\u56de\u6536\u7ad9",
    "Disconnect": "\u65b7\u958b\u9023\u63a5",
    "Discussion": "\u8a0e\u8ad6",
    "Display files": "\u986f\u793a\u6587\u4ef6",
    "Do not automatically delete files": "\u4e0d\u81ea\u52d5\u522a\u9664\u6587\u4ef6",
    "Do not keep sharing": "\u4e0d\u4fdd\u7559\u5171\u4eab\u95dc\u4fc2",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "\u662f\u5426\u78ba\u8a8d\u95dc\u9589\u64f4\u5c55\u5c6c\u6027\uff1f\u73fe\u6709\u5c6c\u6027\u5c07\u5168\u90e8\u88ab\u522a\u9664\u3002",
    "Do you really want to turn off face recognition? Existing results will all be deleted.": "\u662f\u5426\u78ba\u8a8d\u95dc\u9589\u81c9\u90e8\u8b58\u5225\uff1f\u73fe\u6709\u7d50\u679c\u5c07\u5168\u90e8\u88ab\u522a\u9664\u3002",
    "Do you really want to turn off tags? Existing tags will all be deleted.": "\u662f\u5426\u78ba\u8a8d\u95dc\u9589\u6a19\u7c64\uff1f\u73fe\u6709\u6a19\u7c64\u5c07\u5168\u90e8\u88ab\u522a\u9664\u3002",
    "Do you want to keep the library sharing relationships?": "\u662f\u5426\u4fdd\u7559\u5eab\u5171\u4eab\u95dc\u4fc2\uff1f",
    "Document": "\u6587\u4ef6",
    "Document conversion failed.": "\u6587\u4ef6\u8f49\u63db\u5931\u6557\u3002",
    "Document keywords": "\u6587\u4ef6\u95dc\u9375\u8a5e",
    "Dollar": "\u7f8e\u5143",
    "Domain verified": "\u57df\u540d\u5df2\u9a57\u8b49",
    "Don't ignore": "\u4e0d\u5ffd\u7565",
    "Don't keep history": "\u4e0d\u4fdd\u7559\u6b77\u53f2",
    "Don't replace": "\u4e0d\u53d6\u4ee3",
    "Don't send emails": "\u4e0d\u8981\u767c\u9001\u90f5\u4ef6",
    "Don't show empty values": "\u4e0d\u986f\u793a\u7a7a\u503c",
    "Done": "\u5df2\u5b8c\u6210",
    "Dot(1.03)": "\u9ede(1.03)",
    "Down": "\u4e0b",
    "Download": "\u4e0b\u8f09",
    "Download Rate Limit": "\u4e0b\u8f09\u901f\u7387\u9650\u5236",
    "Download an example file": "\u4e0b\u8f09\u793a\u4f8b\u6587\u4ef6",
    "Download and upload": "\u4e0b\u8f09\u4e26\u4e0a\u50b3",
    "Drag and drop files or folders here.": "\u5c07\u6587\u4ef6\u6216\u8cc7\u6599\u593e\u62d6\u653e\u5230\u9019\u88e1\u4e0a\u50b3\u3002",
    "Duplicate": "\u8907\u88fd",
    "Duplicate page": "\u8907\u88fd\u9801\u9762",
    "Edit": "\u7de8\u8f2f",
    "Edit format settings": "\u7de8\u8f2f\u683c\u5f0f\u8a2d\u5b9a",
    "Edit labels": "\u7de8\u8f2f\u6a19\u7c64",
    "Edit metadata properties": "\u7de8\u8f2f\u5143\u6578\u64da\u5c6c\u6027",
    "Edit multiple select": "\u7de8\u8f2f\u591a\u9078",
    "Edit on cloud and download": "\u5728\u96f2\u7aef\u7de8\u8f2f\u4e26\u4e0b\u8f09",
    "Edit on cloud only": "\u50c5\u5728\u96f2\u7aef\u7de8\u8f2f",
    "Edit permission": "\u7de8\u8f2f\u6b0a\u9650",
    "Edit single select": "\u7de8\u8f2f\u55ae\u9078",
    "Edit succeeded": "\u6b0a\u9650\u4fee\u6539\u6210\u529f",
    "Edit succeeded.": "\u7de8\u8f2f\u6210\u529f\u3002",
    "Edit tag": "\u7de8\u8f2f\u6a19\u7c64",
    "Edit tags": "\u7de8\u8f2f\u6a19\u7c64",
    "Email": "\u96fb\u5b50\u90f5\u4ef6",
    "Email Domain": "\u90f5\u4ef6\u57df\u540d",
    "Email Notification": "\u90f5\u4ef6\u901a\u77e5",
    "Email is invalid.": "\u7121\u6548\u7684\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\u3002",
    "Email notification updated": "\u90f5\u4ef6\u901a\u77e5\u5df2\u66f4\u65b0",
    "Emails": "\u96fb\u5b50\u90f5\u4ef6\u5730\u5740",
    "Emails, separated by ','": "\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\uff0c\u4ee5\u9017\u865f\u5206\u9694",
    "Emojis": "\u7d75\u6587\u5b57",
    "Empty": "\u66ab\u7121",
    "Enable Two-Factor Authentication": "\u555f\u7528\u5169\u6b65\u9a57\u8b49",
    "Enable branding CSS": "\u555f\u7528\u54c1\u724c CSS",
    "Enable departments feature": "\u555f\u7528\u90e8\u9580\u529f\u80fd",
    "Enable extended properties": "\u555f\u7528\u64f4\u5c55\u5c6c\u6027",
    "Enable face recognition to identify people in your photos.": "\u555f\u7528\u81c9\u90e8\u8b58\u5225\u4ee5\u8b58\u5225\u7167\u7247\u4e2d\u7684\u4eba",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "\u7cfb\u7d71\u7ba1\u7406\u54e1\u53ef\u4ee5\u6dfb\u52a0\u689d\u6b3e\uff0c\u7528\u6236\u4e0a\u50b3\u6587\u4ef6\u6642\u5fc5\u9808\u63a5\u53d7\u689d\u6b3e\u3002",
    "Enable tags to add tags to files and search files by tags.": "\u555f\u7528\u6a19\u7c64\u4ee5\u70ba\u6587\u4ef6\u6dfb\u52a0\u6a19\u7c64\u4e26\u901a\u904e\u6a19\u7c64\u641c\u7d22\u6587\u4ef6\u3002",
    "Enable terms and conditions": "\u7528\u6236\u9700\u8981\u63a5\u53d7\u689d\u6b3e\u624d\u80fd\u4e0a\u50b3\u6587\u4ef6\u3002",
    "Enable two factor authentication": "\u958b\u555f\u5169\u6b65\u9a57\u8b49",
    "Enable users to clean trash": "\u7528\u6236\u53ef\u4ee5\u6e05\u7406\u81ea\u5df1\u7684\u5783\u573e\u6876\u3002",
    "Enable users to share libraries to any groups in the system.": "\u5141\u8a31\u7528\u6236\u5206\u4eab\u5eab\u5230\u7cfb\u7d71\u4e2d\u7684\u4efb\u4f55\u7fa4\u7d44\u3002",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "\u555f\u7528\u7528\u6236\u5206\u4eab\u5230\u6240\u6709\u7fa4\u7d44\u3002",
    "Encrypt": "\u52a0\u5bc6",
    "Encrypted library": "\u52a0\u5bc6\u8cc7\u6599\u5eab",
    "End date": "\u7d50\u675f\u65e5\u671f",
    "Enforce precision": "\u5f37\u5236\u7cbe\u5ea6",
    "Enter characters to start searching": "\u8f38\u5165\u5b57\u7b26\u958b\u59cb\u641c\u7d22",
    "Enter custom currency symbol": "\u8f38\u5165\u81ea\u5b9a\u7fa9\u8ca8\u5e63\u7b26\u865f",
    "Enter date": "\u8acb\u8f38\u5165\u65e5\u671f",
    "Error": "\u932f\u8aa4",
    "Errors": "\u932f\u8aa4",
    "Euro": "\u6b50\u5143",
    "European": "\u6b50\u6d32\u683c\u5f0f",
    "Exact date": "\u7cbe\u78ba\u65e5\u671f",
    "Exit Institution Admin": "\u9000\u51fa\u673a\u6784\u7ba1\u7406",
    "Exit Organization Admin": "\u9000\u51fa\u7d44\u7e54\u7ba1\u7406",
    "Exit System Admin": "\u9000\u51fa\u7cfb\u7d71\u7ba1\u7406",
    "Expand all": "\u5c55\u958b\u6240\u6709",
    "Expiration": "\u904e\u671f\u6642\u9593",
    "Expiration date": "\u904e\u671f\u65e5\u671f",
    "Expiration days": "\u5230\u671f\u5929\u6578",
    "Expiration time": "\u5230\u671f\u6642\u9593",
    "Expired": "\u5df2\u904e\u671f",
    "Expired at": "\u5230\u671f\u65e5",
    "Export": "\u5c0e\u51fa",
    "Export Excel": "\u5c0e\u51fa\u5230 Excel",
    "Export as Markdown": "\u5c07\u9801\u9762\u532f\u51fa\u70ba Markdown \u6587\u4ef6\u3002",
    "Export as docx": "\u532f\u51fa\u70ba docx",
    "Export as sdoc": "\u5c07\u9801\u9762\u532f\u51fa\u70ba sdoc \u6587\u4ef6\u3002",
    "Export as zip": "\u532f\u51fa\u70ba zip",
    "Export options": "\u5c0e\u51fa\u9078\u9805",
    "Export tags": "\u532f\u51fa\u6a19\u7c64",
    "Exporting": "\u6b63\u5728\u532f\u51fa",
    "Exporting...": "\u6b63\u5728\u532f\u51fa...",
    "Exposure time": "\u66dd\u5149\u6642\u9593",
    "Extended properties": "\u64f4\u5c55\u5c6c\u6027",
    "Extension Prompts": "\u64f4\u5145\u529f\u80fd\u63d0\u793a",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "\u53ef\u4ee5\u76f4\u63a5\u9810\u89bd\u7684\u6587\u672c\u6587\u4ef6\u526f\u6a94\u540d\u3002",
    "Extract file detail": "\u63d0\u53d6\u6587\u4ef6\u8a73\u60c5",
    "Extract file details": "\u63d0\u53d6\u6587\u4ef6\u8a73\u60c5",
    "Extract text": "\u63d0\u53d6\u6587\u672c",
    "Extracting file details by AI...": "\u6b63\u5728\u7531 AI \u63d0\u53d6\u6587\u4ef6\u8a73\u60c5...",
    "Extracting text, please wait...": "\u6b63\u5728\u63d0\u53d6\u6587\u672c\uff0c\u8acb\u7a0d\u7b49...",
    "F number": "\u5149\u5708\u503c",
    "Face recognition": "\u81c9\u90e8\u8b58\u5225",
    "Face recognition is done for library {libraryName}.": "\u5716\u66f8\u9928\u5df2\u5b8c\u6210\u4eba\u81c9\u8b58\u5225 {libraryName}.",
    "Faces detected": "\u81c9\u90e8\u5df2\u6aa2\u6e2c\u5230",
    "Failed": "\u5931\u6557",
    "Failed imported options": "\u5c0e\u5165\u9078\u9805\u5931\u6557",
    "Failed to add linked tags": "\u5408\u4f75\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to add people photos": "\u6dfb\u52a0\u4eba\u54e1\u7167\u7247\u5931\u6557",
    "Failed to add tags": "\u65b0\u589e\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "\u65b0\u589e {email_placeholder} \u5931\u6557\uff1a{error_msg_placeholder}",
    "Failed to convert {name}.": "\u5c07 {name} \u8f49\u63db\u5931\u6557\u3002",
    "Failed to copy %(name)s": "\u8907\u88fd %(name)s \u5931\u6557",
    "Failed to copy %(name)s and %(amount)s other item(s).": "\u8907\u88fd %(name)s \u548c\u5176\u4ed6 %(amount)s \u9805\u689d\u76ee\u5931\u6557\u3002",
    "Failed to copy %(name)s.": "\u8907\u88fd %(name)s \u5931\u6557\u3002",
    "Failed to copy file": "\u8907\u88fd\u6587\u4ef6\u5931\u6557",
    "Failed to copy files to another library.": "\u8907\u88fd\u6587\u4ef6\u5230\u53e6\u4e00\u500b\u5eab\u5931\u6557\u3002",
    "Failed to copy {n} items": "\u8907\u88fd {n} \u500b\u9805\u76ee\u5931\u6557",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "\u7121\u6cd5\u5f9e %(library) \u4e2d\u522a\u9664 %(virus_file)\uff1a%(error_msg)",
    "Failed to delete linked tags": "\u5408\u4f75\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to delete property": "\u522a\u9664\u5c6c\u6027\u5931\u6557",
    "Failed to delete records": "\u522a\u9664\u8a18\u9304\u5931\u6557",
    "Failed to delete tags": "\u522a\u9664\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to delete {name}": "\u522a\u9664 {name} \u5931\u6557\u3002",
    "Failed to delete {name} and {n} other items.": "\u522a\u9664 {name} \u548c {n} \u5176\u4ed6\u9805\u76ee\u5931\u6557\u3002",
    "Failed to delete {name}.": "\u522a\u9664 {name} \u5931\u6557\u3002",
    "Failed to detect faces": "\u6aa2\u6e2c\u81c9\u90e8\u5931\u6557",
    "Failed to download. The total size of the files exceeded the limit.": "\u4e0b\u8f09\u5931\u6557\u3002\u6a94\u6848\u7e3d\u5927\u5c0f\u8d85\u904e\u9650\u5236\u3002",
    "Failed to duplicate file": "\u8907\u88fd\u6587\u4ef6\u5931\u6557",
    "Failed to duplicate folder": "\u8907\u88fd\u6587\u4ef6\u593e\u5931\u6557",
    "Failed to duplicate page": "\u8907\u88fd\u9801\u9762\u5931\u6557\u3002",
    "Failed to export tags": "\u532f\u51fa\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "\u5c0e\u51fa\u5931\u6557\u3002\u8acb\u6aa2\u67e5\u8868\u683c\u9644\u4ef6\u5927\u5c0f\u662f\u5426\u8d85\u904e\u9650\u5236\u3002",
    "Failed to extract file details": "\u63d0\u53d6\u6587\u4ef6\u8a73\u60c5\u5931\u6557",
    "Failed to extract text": "\u63d0\u53d6\u6587\u672c\u5931\u6557",
    "Failed to generate description": "\u751f\u6210\u63cf\u8ff0\u5931\u6557",
    "Failed to generate file tags": "\u751f\u6210\u6587\u4ef6\u6a19\u7c64\u5931\u6557",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "\u7121\u6cd5\u5ffd\u7565 %(library) \u4e2d\u7684 %(virus_file)\uff1a%(error_msg)",
    "Failed to import Confluence": "\u532f\u5165 Confluence \u5931\u6557\u3002",
    "Failed to import Confluence file": "\u5c0e\u5165 Confluence \u6587\u4ef6\u5931\u6557",
    "Failed to import page": "\u532f\u5165\u9801\u9762 {name_placeholder} \u5931\u6557\u3002",
    "Failed to import tags": "\u532f\u5165\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to insert property": "\u63d2\u5165\u5c6c\u6027\u5931\u6557",
    "Failed to merge tags": "\u5408\u4f75\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to modify filter": "\u4fee\u6539\u7be9\u9078\u5668\u5931\u6557",
    "Failed to modify group": "\u4fee\u6539\u7fa4\u7d44\u5931\u6557",
    "Failed to modify hidden properties": "\u4fee\u6539\u96b1\u85cf\u5c6c\u6027\u5931\u6557",
    "Failed to modify people name": "\u4fee\u6539\u4eba\u54e1\u59d3\u540d\u5931\u6557",
    "Failed to modify property data": "\u4fee\u6539\u5c6c\u6027\u6578\u64da\u5931\u6557",
    "Failed to modify property order": "\u4fee\u6539\u5c6c\u6027\u9806\u5e8f\u5931\u6557",
    "Failed to modify records": "\u4fee\u6539\u8a18\u9304\u5931\u6557",
    "Failed to modify settings": "\u4fee\u6539\u8a2d\u7f6e\u5931\u6557",
    "Failed to modify sort": "\u4fee\u6539\u6392\u5e8f\u5931\u6557",
    "Failed to modify tags": "\u4fee\u6539\u6a19\u7c64\u5931\u6557",
    "Failed to move %(name)s and %(amount)s other item(s).": "\u79fb\u52d5 %(name)s \u548c\u5176\u4ed6 %(amount)s \u9805\u689d\u76ee\u5931\u6557\u3002",
    "Failed to move %(name)s.": "\u79fb\u52d5 %(name)s \u5931\u6557\u3002",
    "Failed to move file": "\u79fb\u52d5\u6587\u4ef6\u5931\u6557",
    "Failed to move files to another library.": "\u79fb\u52d5\u6587\u4ef6\u5230\u53e6\u4e00\u500b\u5eab\u5931\u6557\u3002",
    "Failed to move folder": "\u79fb\u52d5\u6587\u4ef6\u593e\u5931\u6557",
    "Failed to move {name}.": "\u79fb\u52d5 {name} \u5931\u6557\u3002",
    "Failed to move {n} items": "\u79fb\u52d5 {n} \u500b\u9805\u76ee\u5931\u6557",
    "Failed to remove people photos": "\u79fb\u9664\u4eba\u54e1\u7167\u7247\u5931\u6557",
    "Failed to rename property": "\u91cd\u547d\u540d\u5c6c\u6027\u5931\u6557",
    "Failed to restore records": "\u6062\u5fa9\u8a18\u9304\u5931\u6557",
    "Failed to restore tags": "\u6062\u5fa9\u6a19\u7c64\u6642\u767c\u751f\u932f\u8aa4",
    "Failed to restore {name}": "\u6062\u5fa9 {name} \u5931\u6557\u3002",
    "Failed to restore {name} and {n} other items": "\u6062\u5fa9 {name} \u548c {n} \u5176\u4ed6\u9805\u76ee\u5931\u6557\u3002",
    "Failed to save": "\u4fdd\u5b58\u5931\u6557",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "\u672a\u80fd\u767c\u9001\u7d66 {email_placeholder}\uff1a{errorMsg_placeholder}",
    "Failed to set people cover photo": "\u8a2d\u7f6e\u4eba\u54e1\u5c01\u9762\u7167\u7247\u5931\u6557",
    "Failed to unshare {name}": "\u53d6\u6d88\u5206\u4eab {name} \u5931\u6557",
    "Failed to upload {file_name}.": "\u4e0a\u50b3\u6587\u4ef6 {file_name} \u5931\u6557\u3002",
    "Failed. Please check the network.": "\u64cd\u4f5c\u5931\u6557\u3002\u8acb\u6aa2\u67e5\u7db2\u7d61\u662f\u5426\u5df2\u9023\u63a5\u3002",
    "Favicon": "\u7db2\u7ad9 favicon",
    "Favorites": "\u6536\u85cf\u593e",
    "File": "\u6a94\u6848",
    "File Access": "\u6a94\u6848\u5b58\u53d6",
    "File Operations": "\u6587\u4ef6\u64cd\u4f5c",
    "File Scan": "\u6383\u63cf\u6587\u4ef6",
    "File Update": "\u6a94\u6848\u66f4\u65b0",
    "File Upload": "\u4e0a\u50b3\u6a94\u6848",
    "File Uploading...": "\u6587\u4ef6\u4e0a\u50b3\u4e2d...",
    "File already exists.": "\u6587\u4ef6\u5df2\u5b58\u5728\u3002",
    "File collaborators": "\u6587\u4ef6\u5354\u4f5c\u8005",
    "File count": "\u6587\u4ef6\u6578\u91cf",
    "File details": "\u6587\u4ef6\u8a73\u60c5",
    "File details extracted": "\u6587\u4ef6\u8a73\u60c5\u5df2\u63d0\u53d6",
    "File download is disabled: the share link traffic of owner is used up.": "\u6a94\u6848\u4e0b\u8f09\u5df2\u7981\u7528\uff1a\u5916\u93c8\u64c1\u6709\u8005\u7684\u6d41\u91cf\u5df2\u7528\u5b8c\u3002",
    "File expire time": "\u6587\u4ef6\u904e\u671f\u6642\u9593",
    "File extension white list": "\u66f4\u65b0\u4e86\u4e0a\u50b3\u6a94\u6848\u7684\u6587\u4ef6\u64f4\u5c55\u540d\u767d\u540d\u55ae",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "\u4e0a\u50b3\u6a94\u6848\u7684\u6587\u4ef6\u64f4\u5c55\u540d\u767d\u540d\u55ae\uff0c\u4f8b\u5982 \"md;txt;docx\"\u3002\u7a7a\u503c\u8868\u793a\u7121\u9650\u5236\u3002",
    "File extensions can only be {placeholder}.": "\u6587\u4ef6\u526f\u6a94\u540d\u53ea\u80fd\u662f {placeholder}\u3002",
    "File is locked by others.": "\u6b64\u6587\u4ef6\u5df2\u88ab\u5176\u4ed6\u7528\u6236\u9396\u5b9a\u3002",
    "File name": "\u6587\u4ef6\u540d",
    "File name and content": "\u6587\u4ef6\u540d\u548c\u5167\u5bb9",
    "File name only": "\u6587\u4ef6\u540d\u7a31",
    "File owner": "\u6587\u4ef6\u6240\u6709\u8005",
    "File rate": "\u6587\u4ef6\u8a55\u5206",
    "File reviewer": "\u6587\u4ef6\u5be9\u6838\u4eba",
    "File size is too large.": "\u6587\u4ef6\u5927\u5c0f\u8d85\u904e\u4e0a\u9650\u3002",
    "File size should be smaller than {max_size_placeholder}.": "\u4e0a\u50b3\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u904e {max_size_placeholder}\u3002",
    "File status": "\u6587\u4ef6\u72c0\u614b",
    "File suffix": "\u6a94\u6848\u526f\u6a94\u540d",
    "File too large": "\u6587\u4ef6\u592a\u5927\u3002",
    "File type": "\u6587\u4ef6\u985e\u578b",
    "File {file_link} has a new comment form user {author}.": "\u6587\u4ef6 {file_link} \u6709\u65b0\u7684\u8a55\u8ad6\u8868\u55ae\u7528\u6236 {author}\u3002",
    "Files": "\u6a94\u6848",
    "Files and folders": "\u641c\u7d22\u6587\u4ef6\u548c\u6587\u4ef6\u593e",
    "Files by creator": "\u6309\u5275\u4f5c\u8005\u5206\u985e",
    "Files by time": "\u6309\u6642\u9593\u5206\u985e",
    "Files by type": "\u6309\u6587\u4ef6\u985e\u578b\u5206\u985e",
    "Fill in": "\u8acb\u586b\u5beb",
    "Filter": "\u7be9\u9078",
    "Filters": "\u7be9\u9078",
    "Find": "\u5c0b\u627e",
    "Find a tag": "\u5c0b\u627e\u6a19\u7c64",
    "Find libraries": "\u5c0b\u627e\u8cc7\u6599\u5eab",
    "Find modifiers": "\u5c0b\u627e\u4fee\u6539\u8005",
    "Find users": "\u5c0b\u627e\u7528\u6236",
    "Focal length": "\u7126\u8ddd",
    "Fold": "\u647a\u758a",
    "Fold the sidebar": "\u647a\u758a\u5074\u908a\u6b04",
    "Folder": "\u8cc7\u6599\u593e",
    "Folder Permission": "\u76ee\u9304\u6b0a\u9650",
    "Folder does not exist.": "\u8cc7\u6599\u593e\u4e0d\u5b58\u5728\u3002",
    "Folder permission is only effective after the library is shared to users or groups. It is used to fine tune sub-folder permissions.": "\u76ee\u9304\u6b0a\u9650\u50c5\u5728\u5c07\u8cc7\u6599\u5eab\u5206\u4eab\u7d66\u7528\u6236\u6216\u7fa4\u7d44\u5f8c\u624d\u6709\u6548\u3002\u7528\u65bc\u7cbe\u7d30\u8abf\u6574\u5b50\u76ee\u9304\u6b0a\u9650\u3002",
    "Folders": "\u8cc7\u6599\u593e",
    "Force Two-Factor Authentication": "\u5f37\u5236\u555f\u7528\u96d9\u56e0\u7d20\u9a57\u8b49",
    "Force password change": "\u5f37\u5236\u7528\u6236\u5728\u8a3b\u518a\u6216\u4fee\u6539\u5bc6\u78bc\u6642\u4f7f\u7528\u5f37\u529b\u5bc6\u78bc\u3002",
    "Force user to change password when account is newly added or reset by admin": "\u5f37\u5236\u65b0\u7528\u6236\u6216\u88ab\u7ba1\u7406\u54e1\u91cd\u7f6e\u4e86\u5bc6\u78bc\u7684\u7528\u6236\uff0c\u5728\u4e0b\u6b21\u767b\u5165\u6642\u4fee\u6539\u5bc6\u78bc",
    "Force user to use SSO login if SSO account is bound": "\u5982\u679c\u7d81\u5b9a\u4e86 SSO \u5e33\u6236\uff0c\u5247\u5f37\u5236\u7528\u6236\u4f7f\u7528 SSO \u767b\u9304",
    "Force user to use a strong password when sign up or change password.": "\u5f37\u5236\u5728\u65b0\u7528\u6236\u8a3b\u518a\u6642\u6216\u7528\u6236\u4fee\u6539\u5bc6\u78bc\u6642\u4f7f\u7528\u5f37\u529b\u5bc6\u78bc\u3002",
    "Force users to use password when generating share/upload link.": "\u7528\u6236\u751f\u6210\u5206\u4eab/\u4e0a\u50b3\u9023\u7d50\u6642\uff0c\u662f\u5426\u5f37\u5236\u8981\u6c42\u5bc6\u78bc\u3002",
    "Format": "\u683c\u5f0f",
    "Freeze Document": "\u51cd\u7d50\u6587\u4ef6",
    "Freeze page": "\u51cd\u7d50\u9801\u9762",
    "Freeze user account when failed login attempts exceed limit.": "\u7576\u7528\u6236\u767b\u5165\u5931\u6557\u8d85\u904e\u9650\u5236\u6642\uff0c\u51cd\u7d50\u7528\u6236\u5e33\u6236\u3002",
    "Freeze user on login failed": "\u7576\u7528\u6236\u767b\u5165\u5931\u6557\u8d85\u904e\u9650\u5236\u6642\uff0c\u51cd\u7d50\u7528\u6236\u5e33\u6236\u3002",
    "Frozen by {name}": "\u5df2\u51cd\u7d50\u65bc {name}",
    "Full screen": "\u5168\u5c4f",
    "Gallery": "\u76f8\u7c3f",
    "General": "\u4e00\u822c",
    "General information": "\u4e00\u822c\u8cc7\u8a0a",
    "Generate": "\u751f\u6210\u9023\u7d50",
    "Generate Link": "\u751f\u6210\u5206\u4eab\u9023\u7d50",
    "Generate description": "\u751f\u6210\u63cf\u8ff0",
    "Generate file tags": "\u751f\u6210\u6587\u4ef6\u6a19\u7c64",
    "Generate links in batch": "\u6279\u91cf\u751f\u6210\u5206\u4eab\u9023\u7d50",
    "Generate share link": "\u751f\u6210\u5206\u4eab\u9023\u7d50",
    "Generating description by AI...": "\u6b63\u5728\u7531 AI \u751f\u6210\u63cf\u8ff0...",
    "Germany Russia etc": "\u5fb7\u570b\u3001\u4fc4\u7f85\u65af\u7b49",
    "Global Address Book": "\u5168\u57df\u5730\u5740\u7c3f",
    "Global hidden properties": "\u5168\u57df\u96b1\u85cf\u5c6c\u6027",
    "Global hidden properties will not be displayed in all views.": "\u5168\u57df\u96b1\u85cf\u5c6c\u6027\u5c07\u4e0d\u6703\u5728\u6240\u6709\u8996\u5716\u4e2d\u986f\u793a\u3002",
    "Go back": "\u8fd4\u56de",
    "Go to Library": "\u524d\u5f80\u8cc7\u6599\u5eab",
    "Greater than or equal to {minDays_placeholder} days": "\u5927\u65bc\u7b49\u65bc {minDays_placeholder} \u5929",
    "Grid view": "\u7db2\u683c\u6aa2\u8996",
    "Group": "\u7fa4\u7d44",
    "Group Invite": "\u7fa4\u7d44\u9080\u8acb",
    "Group Member": "\u7fa4\u7d44\u6210\u54e1",
    "Group Permission": "\u7fa4\u7d44\u6b0a\u9650",
    "Group Shares": "\u7fa4\u7d44\u5171\u4eab",
    "Group by": "\u5206\u7d44",
    "Group deleted": "\u7fa4\u7d44\u5df2\u88ab\u522a\u9664",
    "Group has been transferred": "\u7fa4\u7d44\u5df2\u8f49\u8b93",
    "Group info": "\u7fa4\u7d44\u8cc7\u8a0a",
    "Group invitation link": "\u7fa4\u7d44\u9080\u8acb\u9023\u7d50",
    "Group members": "\u7fa4\u7d44\u6210\u54e1",
    "Grouped by 1 property": "\u6309 1 \u500b\u5c6c\u6027\u5206\u7d44",
    "Grouped by {name_placeholder} properties": "\u6309 {name_placeholder} \u5c6c\u6027\u5206\u7d44",
    "Groups": "\u7fa4\u7d44",
    "Guest": "\u8a2a\u5ba2",
    "Handled": "\u5df2\u8655\u7406",
    "Help": "\u4f7f\u7528\u5e6b\u52a9",
    "Help and resources": "\u5e6b\u52a9\u548c\u8cc7\u6e90",
    "Hidden properties": "\u96b1\u85cf\u5c6c\u6027",
    "Hide": "\u96b1\u85cf",
    "Hide advanced search": "\u96b1\u85cf\u9032\u968e\u641c\u7d22",
    "Hide all": "\u96b1\u85cf\u6240\u6709",
    "Hide properties": "\u96b1\u85cf\u5c6c\u6027",
    "History": "\u6b77\u53f2",
    "History Setting": "\u6b77\u53f2\u8a2d\u5b9a",
    "History Versions": "\u6b77\u53f2\u7248\u672c",
    "ID": "ID",
    "IP": "IP",
    "ISO": "ISO \u683c\u5f0f",
    "Identifying portraits...": "\u6b63\u5728\u8b58\u5225\u4eba\u50cf...",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "\u5982\u679c\u672a\u5728\u5c0f\u6642\u5167\u8b80\u53d6\u901a\u77e5\uff0c\u5247\u6703\u767c\u9001\u5230\u60a8\u7684\u90f5\u7bb1\u3002",
    "If the library is shared to another department, the sharing will be kept.": "\u5982\u679c\u5eab\u88ab\u5171\u4eab\u5230\u53e6\u4e00\u500b\u90e8\u9580\uff0c\u5171\u4eab\u95dc\u4fc2\u5c07\u88ab\u4fdd\u7559\u3002",
    "If the library is shared to another user, the sharing will be kept.": "\u5982\u679c\u5eab\u88ab\u5171\u4eab\u5230\u53e6\u4e00\u500b\u7528\u6236\uff0c\u5171\u4eab\u95dc\u4fc2\u5c07\u88ab\u4fdd\u7559\u3002",
    "If there are multiple items in the cell, a random one will be chosen and be compared with the filter value.": "\u5982\u679c\u55ae\u5143\u683c\u4e2d\u6709\u591a\u500b\u9805\u76ee\uff0c\u5c07\u96a8\u6a5f\u9078\u64c7\u4e00\u500b\u9805\u76ee\u9032\u884c\u6bd4\u8f03\u3002",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "\u5982\u679c\u555f\u7528\u6b64\u529f\u80fd\uff0c\u684c\u9762\u5ba2\u6236\u7aef\u5c07\u4e0d\u80fd\u540c\u6b65Seafile\u76ee\u9304\u5916\u7684\u8cc7\u6599\u593e\u3002",
    "If you don't have any device with you, you can access your account using backup codes.": "\u5982\u679c\u4f60\u8eab\u908a\u6c92\u6709\u8a2d\u5099\uff0c\u53ef\u4ee5\u900f\u904e\u5099\u7528\u9a57\u8b49\u78bc\u4f86\u767b\u5165\u5e33\u6236\u3002",
    "Ignore": "\u5ffd\u7565",
    "Ignored": "\u5df2\u5ffd\u7565",
    "Image saved": "\u5df2\u4fdd\u5b58\u5716\u7247",
    "Import": "\u5c0e\u5165",
    "Import Confluence": "\u532f\u5165 Confluence \u9801\u9762\u3002",
    "Import Confluence Wiki": "\u5c0e\u5165 Confluence Wiki",
    "Import Users": "\u532f\u5165\u7528\u6236",
    "Import members": "\u532f\u5165\u6210\u54e1",
    "Import members from a .xlsx file": "\u5f9e .xlsx \u6587\u4ef6\u5c0e\u5165\u6210\u54e1",
    "Import options": "\u5c0e\u5165\u9078\u9805",
    "Import page": "\u5c0e\u5165\u9801\u9762",
    "Import page from Markdown": "\u5f9e Markdown \u532f\u5165\u9801\u9762",
    "Import page from docx": "\u5f9e docx \u532f\u5165\u9801\u9762",
    "Import sdoc": "\u5c0e\u5165sdoc",
    "Import tags": "\u5c0e\u5165\u6a19\u7c64",
    "Import users": "\u5c0e\u5165\u7528\u6236",
    "Import users from a .xlsx file": "\u5f9e .xlsx \u6587\u4ef6\u5c0e\u5165\u7528\u6236",
    "Importing page...": "\u6b63\u5728\u5c0e\u5165\u9801\u9762...",
    "Importing sdoc, please wait...": "\u6b63\u5728\u5c0e\u5165sdoc\uff0c\u8acb\u7a0d\u7b49...",
    "Importing tags...": "\u6b63\u5728\u5c0e\u5165\u6a19\u7c64...",
    "Importing...": "\u6b63\u5728\u5c0e\u5165...",
    "In progress": "\u9032\u884c\u4e2d",
    "In review": "\u5be9\u6838\u4e2d",
    "Inactive": "\u4e0d\u5553\u52d5",
    "Info": "\u8cc7\u8a0a",
    "Institution Admin": "\u673a\u6784\u7ba1\u7406",
    "Institutions": "\u6a5f\u69cb",
    "Internal Link": "\u5167\u90e8\u93c8\u63a5",
    "Internal Server Error": "\u4f3a\u670d\u5668\u5167\u90e8\u932f\u8aa4",
    "Internal link has been copied to clipboard": "\u8907\u88fd\u5167\u90e8\u93c8\u63a5",
    "Invalid destination path": "\u76ee\u6a19\u8def\u5f91\u7121\u6548",
    "Invalid filename.": "\u7121\u6548\u7684\u6587\u4ef6\u540d\u7a31\u3002",
    "Invalid filter": "\u7121\u6548\u7be9\u9078",
    "Invalid month, should be yyyymm.": "\u7121\u6548\u7684\u6708\u4efd\uff0c\u61c9\u70ba yyyymm\u3002",
    "Invalid regular expression": "\u7121\u6548\u7684\u6b63\u5247\u8868\u9054\u5f0f",
    "Invisible": "\u4e0d\u53ef\u898b",
    "Invitation link has been copied to clipboard": "\u9080\u8acb\u9023\u7d50\u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f\u3002",
    "Invitations": "\u9080\u8acb",
    "Invite Guest": "\u9080\u8acb\u8a2a\u5ba2",
    "Invite Time": "\u9080\u8acb\u6642\u9593",
    "Invite members": "\u9080\u8acb\u6210\u54e1",
    "Invite users": "\u9080\u8acb\u7528\u6236",
    "Invite users via WeChat": "\u901a\u904e\u5fae\u4fe1\u9080\u8acb\u7528\u6236",
    "Invited at": "\u9080\u8acb\u6642\u9593",
    "Inviter": "\u9080\u8acb\u4eba",
    "Is expired": "\u5df2\u904e\u671f",
    "It is already shared to user": "\u7528\u6236\u5df2\u88ab\u5206\u4eab",
    "It is required.": "\u5fc5\u586b\u9805\u3002",
    "It may take some time, please wait.": "\u53ef\u80fd\u9700\u8981\u4e00\u4e9b\u6642\u9593\uff0c\u8acb\u7a0d\u7b49\u3002",
    "Kanban": "\u770b\u677f",
    "Keep full history": "\u4fdd\u7559\u6240\u6709\u6b77\u53f2",
    "Keep sharing": "\u4fdd\u7559\u5171\u4eab\u95dc\u4fc2",
    "Keep sign in": "\u4fdd\u6301\u767b\u5165",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP (\u5df2\u5c0e\u5165)",
    "Label": "\u6a19\u7c64",
    "Label Current State": "\u6a19\u8a18\u7576\u524d\u72c0\u614b",
    "Labels": "\u6a19\u7c64",
    "Language": "\u8a9e\u8a00",
    "Language Setting": "\u8a9e\u8a00\u8a2d\u5b9a",
    "Language for tags generated by AI": "AI \u751f\u6210\u7684\u6a19\u7c64\u8a9e\u8a00",
    "Last 30 days": "\u6700\u8fd1 30 \u5929",
    "Last 7 days": "\u6700\u8fd1 7 \u5929",
    "Last Access": "\u6700\u5f8c\u700f\u89bd\u6642\u9593",
    "Last Login": "\u4e0a\u6b21\u767b\u5165",
    "Last Update": "\u66f4\u65b0\u6642\u9593",
    "Last modification": "\u6700\u5f8c\u4fee\u6539",
    "Last modified by": "\u6700\u5f8c\u4fee\u6539\u8005",
    "Last modified time": "\u6700\u5f8c\u4fee\u6539\u6642\u9593",
    "Last modifier": "\u6700\u5f8c\u4fee\u6539\u8005",
    "Leave": "\u9000\u51fa",
    "Leave Group": "\u9000\u51fa\u7fa4\u7d44",
    "Leave Share": "\u9000\u51fa\u5171\u4eab",
    "Leave Share Wiki": "\u78ba\u8a8d\u53d6\u6d88\u5206\u4eab Wiki \u55ce\uff1f",
    "Leave group": "\u9000\u51fa\u7fa4\u7d44",
    "Leave this page? The system may not save your changes.": "\u662f\u5426\u96e2\u958b\u6b64\u9801\u9762\uff1f\u7cfb\u7d71\u53ef\u80fd\u4e0d\u6703\u4fdd\u5b58\u60a8\u7684\u66f4\u6539\u3002",
    "Less than or equal to {maxDays_placeholder} days": "\u5c0f\u65bc\u7b49\u65bc {maxDays_placeholder} \u5929",
    "Libraries": "\u8cc7\u6599\u5eab",
    "Library": "\u8cc7\u6599\u5eab",
    "Library Type": "\u8cc7\u6599\u5eab\u985e\u578b",
    "Library can not be shared to owner.": "\u4e0d\u80fd\u5c07\u8cc7\u6599\u5eab\u5171\u4eab\u7d66\u6240\u6709\u8005\u3002",
    "Library does not exist": "\u8cc7\u6599\u5eab\u4e0d\u5b58\u5728",
    "Library history": "\u7528\u6236\u53ef\u4ee5\u67e5\u770b\u548c\u7ba1\u7406\u81ea\u5df1\u7684\u8cc7\u6599\u5eab\u6b77\u53f2\u8a18\u9304\u3002",
    "Library not found": "\u672a\u627e\u5230\u8cc7\u6599\u5eab",
    "Library password minimum length": "\u52a0\u5bc6\u8cc7\u6599\u5eab\u7684\u6700\u5c0f\u5bc6\u78bc\u9577\u5ea6\u3002",
    "Light mode": "\u6dfa\u8272\u6a21\u5f0f",
    "Limits": "\u7528\u6236\u6578\u9650\u5236",
    "Line wrapping": "\u884c wrap",
    "Link": "\u93c8\u7d50",
    "Link has been copied to clipboard": "\u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f",
    "Link image": "\u9023\u7d50\u5716\u7247",
    "Linked Devices": "\u5df2\u9023\u63a5\u7684\u8a2d\u5099",
    "Links": "\u9023\u7d50",
    "List view": "\u6e05\u55ae\u6aa2\u8996",
    "List your account in global address book, so that others can find you by typing your name.": "\u5c07\u60a8\u7684\u5e33\u6236\u5217\u5728\u5168\u57df\u5730\u5740\u7c3f\u4e2d\uff0c\u4ee5\u4fbf\u5176\u4ed6\u7528\u6236\u53ef\u4ee5\u900f\u904e\u8f38\u5165\u60a8\u7684\u59d3\u540d\u4f86\u627e\u5230\u60a8\u3002",
    "Load all": "\u8f09\u5165\u6240\u6709\u8a18\u9304",
    "Loading": "\u8f09\u5165\u4e2d...",
    "Loading metadata...": "\u6b63\u5728\u8f09\u5165\u5143\u6578\u64da...",
    "Loading...": "\u8f09\u5165\u4e2d...",
    "Location": "\u4f4d\u7f6e",
    "Lock": "\u9396\u5b9a",
    "Log out": "\u9000\u51fa",
    "Login": "\u767b\u5165\u65e5\u8a8c",
    "Login ID": "\u767b\u5165ID",
    "Login attempt limit": "\u767b\u5165\u5617\u8a66\u6b21\u6578\u9650\u5236",
    "Login background image": "\u767b\u5165\u80cc\u666f\u5716\u7247",
    "Logo": "\u7db2\u7ad9 logo",
    "Logo updated": "\u66f4\u65b0\u4e86 logo",
    "Logs": "\u65e5\u8a8c",
    "Long text": "\u9577\u6587\u672c",
    "Manage group members": "\u7ba1\u7406\u7fa4\u7d44\u6210\u54e1",
    "Manage members": "\u7ba1\u7406\u6210\u54e1",
    "Map": "\u5730\u5716",
    "Map is not ready": "\u5730\u5716\u672a\u6e96\u5099\u5c31\u7dd2",
    "Mark all as read": "\u6a19\u8a18\u6240\u6709\u70ba\u5df2\u8b80",
    "Mark all read": "\u5168\u90e8\u8a2d\u70ba\u5df2\u8b80",
    "Mark as resolved": "\u6a19\u8a18\u70ba\u5df2\u89e3\u6c7a",
    "Mark notification as read": "\u5c07\u901a\u77e5\u6a19\u8a18\u70ba\u5df2\u8b80",
    "Marked \"{resolve_comment}\" as resolved in document {sdoc_link}": "\u7528\u6236 {user} \u5df2\u5728\u6587\u4ef6 {sdoc_link} \u4e2d\u5c07\u7559\u8a00 \"{resolve_comment}\" \u6a19\u8a18\u70ba\u5df2\u89e3\u6c7a\u3002",
    "Marked as resolved in document {sdoc_link}": "\u7528\u6236 {user} \u5df2\u5728\u6587\u4ef6 {sdoc_link} \u4e2d\u5c07\u6240\u6709\u7559\u8a00\u6a19\u8a18\u70ba\u5df2\u89e3\u6c7a\u3002",
    "Matching tags": "\u5339\u914d\u6a19\u7c64",
    "Max": "\u6700\u5927",
    "Max number of members": "\u6700\u5927\u6210\u54e1\u6578\u91cf",
    "Member": "\u6210\u54e1",
    "Members": "\u6210\u54e1",
    "Merge tags": "\u5408\u4f75\u6a19\u7c64",
    "Merge tags to": "\u5408\u4f75\u6a19\u7c64\u5230",
    "Message": "\u8a0a\u606f",
    "Message (optional):": "\u9644\u52a0\u6d88\u606f(\u53ef\u9078)\uff1a",
    "Metrics": "\u6307\u6a19",
    "Migrate": "\u8fc1\u79fb",
    "Migrate User": "\u8f49\u79fb\u4f7f\u7528\u8005",
    "Migrate old version tags": "\u8fc1\u79fb\u820a\u7248\u672c\u6a19\u7c64",
    "Mobile": "\u79fb\u52d5\u5ba2\u6236\u7aef",
    "Modification Details": "\u4fee\u6539\u8a73\u60c5",
    "Modified": "\u4fee\u6539\u4e86",
    "Modified by": "\u4fee\u6539\u8005",
    "Modified by:": "\u4fee\u6539\u8005\uff1a",
    "Modified files": "\u5df2\u4fee\u6539\u6587\u4ef6",
    "Modified time": "\u4fee\u6539\u6642\u9593",
    "Modifier": "\u4fee\u6539\u8005",
    "Modify": "\u4fee\u6539",
    "Modify includes modify file, move/rename file and folder": "\u4fee\u6539\u5305\u62ec\u4fee\u6539\u6587\u4ef6\u3001\u79fb\u52d5/\u91cd\u547d\u540d\u6587\u4ef6\u548c\u6587\u4ef6\u593e",
    "Modify name": "\u4fee\u6539\u540d\u7a31",
    "Month": "\u6708\u4efd",
    "Month:": "\u6708\u4efd\uff1a",
    "Monthly User Traffic": "\u6bcf\u6708\u7528\u6236\u6d41\u91cf",
    "More": "\u66f4\u591a",
    "More operations": "\u66f4\u591a\u64cd\u4f5c",
    "Move": "\u79fb\u52d5",
    "Move department": "\u79fb\u52d5\u90e8\u9580",
    "Move file": "\u79fb\u52d5\u6587\u4ef6",
    "Move folder": "\u79fb\u52d5\u6587\u4ef6\u593e",
    "Move selected item(s) to:": "\u5c07\u5df2\u9078\u689d\u76ee\u79fb\u52d5\u5230\uff1a",
    "Move to department": "\u5c07\u7fa4\u7d44\u79fb\u52d5\u5230\u90e8\u9580",
    "Move {num} items": "\u79fb\u52d5 {num} \u500b\u9805\u76ee",
    "Move {placeholder} to": "\u5c07 {placeholder} \u79fb\u52d5\u5230",
    "Moved file": "\u5df2\u79fb\u52d5\u7684\u6a94\u6848",
    "Moved folder": "\u79fb\u52d5\u4e86\u8cc7\u6599\u593e",
    "Multiple select": "\u591a\u9078\u6846",
    "My Activities": "\u6211\u7684\u6d3b\u52d5",
    "My Libraries": "\u6211\u7684\u8cc7\u6599\u5eab",
    "My Wikis": "\u6211\u7684 Wiki",
    "Name": "\u540d\u7a31",
    "Name already exists": "\u540d\u7a31\u5df2\u5b58\u5728",
    "Name cannot be double dots": "\u540d\u7a31\u4e0d\u80fd\u5305\u542b\u9023\u7e8c\u7684\u9ede\u865f\u3002",
    "Name cannot be empty": "\u540d\u7a31\u4e0d\u80fd\u70ba\u7a7a\u3002",
    "Name cannot contain backslash": "\u540d\u7a31\u4e0d\u80fd\u5305\u542b\u53cd\u659c\u6760",
    "Name cannot contain backtick": "\u540d\u7a31\u4e0d\u80fd\u5305\u542b\u53cd\u5f15\u865f",
    "Name cannot contain curly braces": "\u540d\u7a31\u4e0d\u80fd\u5305\u542b\u5927\u62ec\u865f",
    "Name cannot contain dots": "\u540d\u7a31\u4e0d\u80fd\u5305\u542b\u53e5\u9ede",
    "Name cannot contain slash": "\u540d\u7a31\u4e0d\u80fd\u5305\u542b\u659c\u6760",
    "Name is required": "\u540d\u7a31\u70ba\u5fc5\u586b\u9805",
    "Name is required.": "\u5fc5\u9808\u586b\u5beb\u540d\u5b57\u3002",
    "Name or ID": "\u540d\u7a31\u6216 ID",
    "Name should be string": "\u540d\u7a31\u61c9\u70ba\u5b57\u7b26\u4e32",
    "Name should not include '/'.": "\u540d\u5b57\u4e0d\u80fd\u5305\u542b \u2018/\u2019\u3002",
    "Name updated": "\u90e8\u9580\u540d\u7a31\u5df2\u66f4\u65b0",
    "Name(optional)": "\u540d\u5b57(\u53ef\u9078)",
    "Names don't match": "\u540d\u7a31\u4e0d\u5339\u914d",
    "Network error": "\u7db2\u7d61\u932f\u8aa4\u3002",
    "New": "\u65b0\u5efa",
    "New Department": "\u65b0\u589e\u90e8\u9580",
    "New Department Library": "\u65b0\u7684\u90e8\u9580\u6587\u4ef6\u5eab",
    "New Docxf File": "\u65b0\u5efaDocxf\u6587\u4ef6",
    "New Excalidraw File": "\u65b0\u5efaExcalidraw\u6587\u4ef6",
    "New Excel File": "\u65b0\u5efaExcel\u6587\u4ef6",
    "New File": "\u65b0\u5efa\u6587\u4ef6",
    "New Folder": "\u65b0\u5efa\u8cc7\u6599\u593e",
    "New Group": "\u65b0\u5efa\u7fa4\u7d44",
    "New Library": "\u65b0\u5efa\u8cc7\u6599\u5eab",
    "New Markdown File": "\u65b0\u5efaMarkdown\u6587\u4ef6",
    "New Password": "\u65b0\u5bc6\u78bc",
    "New Password Again": "\u518d\u6b21\u8f38\u5165\u65b0\u5bc6\u78bc",
    "New PowerPoint File": "\u65b0\u5efaPowerPoint\u6587\u4ef6",
    "New SeaDoc File": "\u65b0\u5efaSeaDoc\u6587\u4ef6",
    "New Sub-department": "\u65b0\u589e\u5b50\u90e8\u9580",
    "New Whiteboard File": "\u65b0\u5efaWhiteboard\u6587\u4ef6",
    "New Word File": "\u65b0\u5efaWord\u6587\u4ef6",
    "New category": "\u65b0\u5206\u985e",
    "New child tag": "\u65b0\u589e\u5b50\u6a19\u7c64",
    "New directories": "\u65b0\u76ee\u9304",
    "New file name": "\u65b0\u7684\u6587\u4ef6\u540d\u7a31",
    "New files": "\u65b0\u6587\u4ef6",
    "New folder": "\u65b0\u8cc7\u6599\u593e",
    "New folder name": "\u65b0\u7684\u76ee\u9304\u540d\u7a31",
    "New page": "\u65b0\u9801\u9762",
    "New password": "\u65b0\u5bc6\u78bc",
    "New password cannot be the same as old password": "\u65b0\u5bc6\u78bc\u4e0d\u80fd\u8207\u820a\u5bc6\u78bc\u76f8\u540c",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "\u65b0\u5bc6\u78bc\u5df2\u5bc4\u9001\u81f3\u60a8\u7684\u90f5\u7bb1 {mail}\u3002\u8acb\u6aa2\u67e5\u60a8\u7684\u90f5\u7bb1\u3002\u5982\u679c\u60a8\u6c92\u6709\u6536\u5230\u5bc6\u78bc\uff0c\u8acb\u6aa2\u67e5\u60a8\u7684\u90f5\u7bb1\u5730\u5740\u662f\u5426\u6b63\u78ba\u914d\u7f6e\u3002",
    "New password is too short": "\u65b0\u5bc6\u78bc\u592a\u77ed",
    "New passwords don't match": "\u5169\u6b21\u8f38\u5165\u7684\u65b0\u5bc6\u78bc\u4e0d\u4e00\u81f4",
    "New tag": "\u65b0\u589e\u6a19\u7c64",
    "New view": "\u65b0\u8996\u5716",
    "Next": "\u4e0b\u4e00\u9801",
    "Next (Right arrow key)": "\u4e0b\u4e00\u5f35 (\u53f3\u65b9\u5411\u9375)",
    "Next modification": "\u4e0b\u4e00\u6b21\u4fee\u6539",
    "No Admin login logs": "\u6c92\u6709\u7ba1\u7406\u54e1\u767b\u5165\u8a18\u9304",
    "No Admin operation logs": "\u6c92\u6709\u7ba1\u7406\u54e1\u64cd\u4f5c\u8a18\u9304",
    "No Wikis": "\u6c92\u6709 Wiki \u9801\u9762\u3002",
    "No categories": "\u6c92\u6709\u5206\u985e",
    "No changes": "\u7121\u8b8a\u66f4",
    "No collaborators": "\u6c92\u6709\u5354\u4f5c\u8005",
    "No collaborators available": "\u6c92\u6709\u53ef\u7528\u7684\u5354\u4f5c\u8005",
    "No comment yet.": "\u9084\u6c92\u6709\u8a55\u8ad6",
    "No connected devices": "\u6c92\u6709\u9023\u4e0a\u7684\u5ba2\u6236\u7aef",
    "No creator data available": "\u6c92\u6709\u53ef\u7528\u7684\u5275\u4f5c\u8005\u6578\u64da",
    "No data available for statistics": "\u6c92\u6709\u53ef\u7528\u7684\u7d71\u8a08\u6578\u64da",
    "No deleted libraries": "\u672a\u522a\u9664\u4efb\u4f55\u8cc7\u6599\u5eab",
    "No favorites": "\u6c92\u6709\u6536\u85cf",
    "No file": "\u6c92\u6709\u6587\u4ef6",
    "No file access logs": "\u6c92\u6709\u6587\u4ef6\u5b58\u53d6\u8a18\u9304",
    "No file selected": "\u672a\u9078\u64c7\u6587\u4ef6",
    "No file update logs": "\u6c92\u6709\u6587\u4ef6\u66f4\u65b0\u8a18\u9304",
    "No files": "\u6c92\u6709\u6587\u4ef6",
    "No files or folders have been shared with you": "\u60a8\u672a\u5171\u4eab\u4efb\u4f55\u6587\u4ef6\u6216\u8cc7\u6599\u593e\u3002",
    "No files or folders have been shared with you from other servers.": "\u60a8\u672a\u5f9e\u5176\u4ed6\u4f3a\u670d\u5668\u5171\u4eab\u4efb\u4f55\u6587\u4ef6\u6216\u8cc7\u6599\u593e\u3002",
    "No filters": "\u6c92\u6709\u7be9\u9078",
    "No folders shared": "\u6c92\u6709\u5206\u4eab\u7684\u8cc7\u6599\u593e",
    "No group invitation link yet. Group invitation link let registered users to join the group by clicking a link.": "\u76ee\u524d\u9084\u6c92\u6709\u7fa4\u7d44\u9080\u8acb\u9023\u7d50\u3002\u7fa4\u7d44\u9080\u8acb\u9023\u7d50\u8b93\u5df2\u8a3b\u518a\u7528\u6236\u901a\u904e\u9ede\u64ca\u9023\u7d50\u52a0\u5165\u7fa4\u7d44\u3002",
    "No group shares": "\u60a8\u76ee\u524d\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u7fa4\u7d44\u3002\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u7fa4\u7d44\u540d\u7a31\u53f3\u908a\u7684\u5206\u4eab\u5716\u793a\u4f86\u5206\u4eab\u7fa4\u7d44\u3002",
    "No groupings applied to this view.": "\u6b64\u8996\u5716\u672a\u61c9\u7528\u4efb\u4f55\u5206\u7d44\u3002",
    "No groups": "\u6c92\u6709\u7fa4\u7d44",
    "No guest invitations": "\u76ee\u524d\u6c92\u6709\u9080\u8acb\u4efb\u4f55\u5ba2\u6236\u7aef",
    "No invitations": "\u6c92\u6709\u9080\u8acb",
    "No items": "\u6c92\u6709\u9805\u76ee",
    "No libraries": "\u6c92\u6709\u8cc7\u6599\u5eab",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "\u60a8\u76ee\u524d\u6c92\u6709\u76f4\u63a5\u5206\u4eab\u4efb\u4f55\u5eab\u7d66\u60a8\u3002\u5206\u4eab\u7684\u5eab\u53ef\u4ee5\u6709\u5b8c\u6574\u6216\u9650\u5236\u7684\u6b0a\u9650\u3002\u5982\u679c\u60a8\u9700\u8981\u8a2a\u554f\u53e6\u4e00\u7528\u6236\u64c1\u6709\u7684\u5eab\uff0c\u8acb\u5411\u8a72\u7528\u6236\u8acb\u6c42\u5206\u4eab\u5eab\u3002",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.": "\u6b64\u7fa4\u7d44\u672a\u5206\u4eab\u4efb\u4f55\u8cc7\u6599\u5eab\u3002\u60a8\u53ef\u4ee5\u5728 \"\u6211\u7684\u8cc7\u6599\u5eab\" \u4e2d\u5206\u4eab\u8cc7\u6599\u5eab\u7d66\u6b64\u7fa4\u7d44\u3002\u60a8\u4e5f\u53ef\u4ee5\u9ede\u64ca\u4e0b\u62c9\u83dc\u55ae\u4e2d\u7684 \"\u65b0\u8cc7\u6599\u5eab\" \u9805\u76ee\u4f86\u5efa\u7acb\u65b0\u7684\u8cc7\u6599\u5eab\u3002",
    "No libraries have been shared with you": "\u60a8\u76ee\u524d\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u5eab\u7d66\u5176\u4ed6\u7528\u6236\u3002",
    "No libraries have been shared with you from other servers.": "\u60a8\u76ee\u524d\u6c92\u6709\u5f9e\u5176\u4ed6\u4f3a\u670d\u5668\u5206\u4eab\u4efb\u4f55\u5eab\u7d66\u5176\u4ed6\u7528\u6236\u3002",
    "No libraries shared": "\u6c92\u6709\u5206\u4eab\u7684\u5eab",
    "No libraries shared with this group": "\u6b64\u7fa4\u7d44\u672a\u5206\u4eab\u4efb\u4f55\u8cc7\u6599\u5eab",
    "No linked devices": "\u672a\u9023\u63a5\u4efb\u4f55\u8a2d\u5099",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "\u60a8\u9084\u6c92\u6709\u4f7f\u7528\u4efb\u4f55\u5ba2\u6236\u7aef\uff08\u684c\u9762\u6216\u624b\u6a5f\uff09\u8a2a\u554f\u60a8\u7684\u6587\u4ef6\u3002\u5728\u60a8\u7684\u8a2d\u5099\u4e0a\u914d\u7f6e\u5ba2\u6236\u7aef\u4ee5\u66f4\u65b9\u4fbf\u5730\u8a2a\u554f\u60a8\u7684\u6578\u64da\u3002",
    "No login logs": "\u6c92\u6709\u767b\u5165\u8a18\u9304",
    "No matching tags": "\u672a\u5339\u914d\u5230\u6a19\u7c64",
    "No members": "\u66ab\u7121\u6210\u54e1",
    "No more activities": "\u6c92\u6709\u66f4\u591a\u6d3b\u52d5",
    "No notifications": "\u6c92\u6709\u901a\u77e5",
    "No option": "\u6c92\u6709\u9078\u9805",
    "No options": "\u6c92\u6709\u9078\u9805",
    "No options available": "\u6c92\u6709\u53ef\u7528\u9078\u9805",
    "No permission logs": "\u6c92\u6709\u6b0a\u9650\u8a18\u9304",
    "No properties available to be hidden": "\u6c92\u6709\u53ef\u7528\u7684\u5c6c\u6027\u53ef\u96b1\u85cf",
    "No public libraries": "\u60a8\u76ee\u524d\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u516c\u958b\u7684\u5eab\u7d66\u5176\u4ed6\u7528\u6236\u3002",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" item in the dropdown menu.": "\u60a8\u76ee\u524d\u6c92\u6709\u5efa\u7acb\u4efb\u4f55\u516c\u5171\u5eab\u3002\u516c\u5171\u5eab\u5c0d\u6240\u6709\u7528\u6236\u90fd\u662f\u53ef\u8a2a\u554f\u7684\u3002\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u4e0b\u62c9\u83dc\u55ae\u4e2d\u7684\u300c\u65b0\u589e\u5eab\u300d\u9805\u76ee\u4f86\u5efa\u7acb\u516c\u5171\u5eab\u3002",
    "No recommended new tags": "\u672a\u5efa\u8b70\u65b0\u6a19\u7c64",
    "No record": "\u6c92\u6709\u8a18\u9304",
    "No result": "\u6c92\u6709\u7d50\u679c",
    "No results": "\u6c92\u6709\u7d50\u679c",
    "No results found": "\u672a\u627e\u5230\u7d50\u679c",
    "No results matching": "\u672a\u627e\u5230\u7b26\u5408\u7684\u7d50\u679c\u3002",
    "No separator (1000000)": "\u7121\u5206\u9694\u7b26 (1000000)",
    "No share links": "\u6c92\u6709\u5171\u4eab\u7db2\u5740",
    "No shared Wikis": "\u6c92\u6709\u5206\u4eab\u7684 Wiki",
    "No shared libraries": "\u60a8\u76ee\u524d\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u5eab\u7d66\u5176\u4ed6\u7528\u6236\u3002",
    "No sorts": "\u6c92\u6709\u6392\u5e8f",
    "No sync errors": "\u6c92\u6709\u540c\u6b65\u932f\u8aa4",
    "No tag": "\u6c92\u6709\u6a19\u7c64",
    "No tags": "\u6c92\u6709\u6a19\u7c64",
    "No tags available": "\u6c92\u6709\u53ef\u7528\u7684\u6a19\u7c64",
    "No terms and conditions": "\u6c92\u6709\u689d\u6b3e\u8207\u689d\u4ef6",
    "No text extracted": "\u672a\u63d0\u53d6\u5230\u6587\u672c",
    "No time-based data available": "\u6c92\u6709\u53ef\u7528\u7684\u6642\u9593\u57fa\u6578\u6578\u64da",
    "No upload links": "\u6c92\u6709\u4e0a\u50b3\u9023\u7d50",
    "No user shares": "\u60a8\u76ee\u524d\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u7528\u6236\u3002\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u7528\u6236\u540d\u7a31\u53f3\u908a\u7684\u5206\u4eab\u5716\u793a\u4f86\u5206\u4eab\u7528\u6236\u3002",
    "No users found": "\u672a\u627e\u5230\u7528\u6236",
    "No version history": "\u6c92\u6709\u7248\u672c\u6b77\u53f2\u8a18\u9304",
    "Node": "\u7bc0\u9ede",
    "None": "\u7121",
    "Not allow user to clean library trash": "\u4e0d\u5141\u8a31\u7528\u6236\u6e05\u9664\u56de\u6536\u7ad9",
    "Not allow user to create encrypted libraries": "\u4e0d\u5141\u8a31\u7528\u6236\u5275\u5efa\u52a0\u5bc6\u5eab",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "\u6ce8\u610f\uff1a\u900f\u904eWeb\u754c\u9762\u8a2d\u5b9a\u7684\u9078\u9805\u6703\u5132\u5b58\u5728\u6578\u64da\u5eab(seahub-db / constance_config)\u4e2d\u3002\u4ed6\u5011\u6bd4\u914d\u7f6e\u6a94\u6848\u4e2d\u7684\u8a2d\u5b9a\u6709\u66f4\u9ad8\u7684\u512a\u5148\u7d1a\u3002",
    "Notification": "\u901a\u77e5",
    "Notification Detail": "\u901a\u77e5\u5167\u5bb9",
    "Notifications": "\u901a\u77e5",
    "Notifications of collaboration": "\u5354\u4f5c\u901a\u77e5",
    "Notifications of file changes": "\u6587\u4ef6\u66f4\u6539\u901a\u77e5",
    "Number": "\u6578\u5b57",
    "Number format settings": "\u6578\u5b57\u683c\u5f0f\u8a2d\u7f6e",
    "Number of days ago": "\u904e\u53bb\u7684\u5929\u6578",
    "Number of days from now": "\u672a\u4f86\u7684\u5929\u6578",
    "Number of days that keep user sign in.": "\u4fdd\u6301\u767b\u5165\u7684\u65e5\u6578\u3002",
    "Number of groups": "\u7fa4\u7d44\u6578\u91cf",
    "Number of links": "\u5206\u4eab\u9023\u7d50\u6578\u91cf",
    "Number of members": "\u6210\u54e1\u6578\u91cf",
    "Number of records exceeds the limit of 1000": "\u8a18\u9304\u6578\u8d85\u904e 1000 \u500b\u7684\u9650\u5236",
    "OCR": "OCR",
    "OCR result": "OCR \u7d50\u679c",
    "Off": "\u95dc\u9589",
    "Office Suite": "\u529e\u516c\u5957\u4ef6",
    "Old Password": "\u820a\u5bc6\u78bc",
    "Old Wikis": "\u820a\u7248 Wiki",
    "On": "\u958b\u555f",
    "One month ago": "\u4e00\u500b\u6708\u524d",
    "One month from now": "\u4e00\u500b\u6708\u5f8c",
    "One week ago": "\u4e00\u9031\u524d",
    "One week from now": "\u4e00\u9031\u5f8c",
    "Online Preview": "\u76f4\u63a5\u9810\u89bd\u6587\u672c\u6587\u4ef6\u3002",
    "Online Read-Only": "\u7dda\u4e0a\u552f\u8b80",
    "Online Read-Only folder": "\u7dda\u4e0a\u552f\u8b80\u8cc7\u6599\u593e",
    "Online Read-Only library": "\u7dda\u4e0a\u552f\u8b80\u8cc7\u6599\u5eab",
    "Online Read-Write": "\u7dda\u4e0a\u53ef\u8b80\u53ef\u5beb",
    "Online Read-Write folder": "\u7dda\u4e0a\u53ef\u8b80\u53ef\u5beb\u8cc7\u6599\u593e",
    "Online Read-Write library": "\u53ef\u8b80\u53ef\u5beb\u8cc7\u6599\u5eab",
    "Online view is not applicable to this file format": "\u6b64\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u63f4\u7dda\u4e0a\u67e5\u770b",
    "Only Show": "\u50c5\u986f\u793a",
    "Only files": "\u50c5\u641c\u7d22\u6587\u4ef6",
    "Only folders": "\u50c5\u641c\u7d22\u6587\u4ef6\u593e",
    "Only keep a period of history:": "\u50c5\u4fdd\u7559\u4e00\u6bb5\u6642\u9593\u7684\u6b77\u53f2:",
    "Only pictures": "\u50c5\u641c\u7d22\u5716\u7247",
    "Only videos": "\u50c5\u641c\u7d22\u8996\u983b",
    "Open file": "\u6253\u958b\u6a94\u6848",
    "Open file in new tab": "\u5728\u65b0\u6a19\u7c64\u9801\u4e2d\u6253\u958b\u6587\u4ef6",
    "Open folder": "\u6253\u958b\u8cc7\u6599\u593e",
    "Open folder in new tab": "\u5728\u65b0\u6a19\u7c64\u9801\u4e2d\u6253\u958b\u6587\u4ef6\u593e",
    "Open in new tab": "\u5728\u65b0\u6a19\u7c64\u9801\u958b\u555f",
    "Open parent folder": "\u958b\u555f\u7236\u76ee\u9304",
    "Open the panel": "\u6253\u958b\u9762\u677f",
    "Open via Client": "\u5ba2\u6236\u7aef\u6253\u958b",
    "Open via client": "\u900f\u904e\u5ba2\u6236\u7aef\u6253\u958b",
    "Operation": "\u64cd\u4f5c",
    "Operation succeeded.": "\u64cd\u4f5c\u6210\u529f",
    "Operations": "\u64cd\u4f5c",
    "Operator": "\u64cd\u4f5c\u54e1",
    "Optional": "\u9078\u9805",
    "Options imported": "\u5df2\u5c0e\u5165\u9078\u9805",
    "Or": "\u6216",
    "Organization": "\u5718\u9ad4",
    "Organization Admin": "\u7d44\u7e54\u7ba1\u7406",
    "Organizations": "\u7d44\u7e54",
    "Original path": "\u539f\u59cb\u8def\u5f91",
    "Other": "\u5176\u4ed6",
    "Other Libraries": "\u5176\u4ed6\u8cc7\u6599\u5eab",
    "Others": "\u5176\u4ed6",
    "Out of quota.": "\u8d85\u904e\u7a7a\u9593\u4e0a\u9650\u3002",
    "Outdated": "\u5df2\u904e\u671f",
    "Outline": "\u5927\u7eb2",
    "Owned Libraries": "\u6240\u6709\u5eab",
    "Owner": "\u64c1\u6709\u8005",
    "Owner can use admin panel in an organization, must be a new account.": "\u64c1\u6709\u8005\u80fd\u4f7f\u7528\u6a5f\u69cb\u7684\u7ba1\u7406\u54e1\u9762\u677f, \u5fc5\u9808\u662f\u4e00\u500b\u65b0\u7684\u5e33\u865f.",
    "Packaging...": "\u6b63\u5728\u5c01\u5305",
    "Page fit": "\u9801\u9762\u9069\u5408",
    "Page imported": "\u5df2\u532f\u5165\u9801\u9762 {name_placeholder}\u3002",
    "Page is frozen": "\u9801\u9762\u5df2\u51cd\u7d50\uff0c\u7121\u6cd5\u7de8\u8f2f\u3002",
    "Page name": "\u9801\u9762\u540d\u7a31",
    "Page {name_placeholder} deleted.": "\u5df2\u522a\u9664\u9801\u9762 {name_placeholder}\u3002",
    "Pages": "\u9801\u9762",
    "Parent folder": "\u7236\u6587\u4ef6\u593e",
    "Parent tags": "\u7236\u6a19\u7c64",
    "Password": "\u5bc6\u78bc",
    "Password again": "\u8acb\u518d\u6b21\u8f38\u5165\u5bc6\u78bc",
    "Password cannot be blank": "\u5bc6\u78bc\u4e0d\u80fd\u70ba\u7a7a",
    "Password is too short": "\u5bc6\u78bc\u592a\u77ed",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "\u5bc6\u78bc\u5fc5\u9808\u81f3\u5c11 8 \u500b\u5b57\u5143\u9577\uff0c\u4e26\u5305\u542b\u4e0d\u540c\u7684\u5b57\u5143\uff1a\u5927\u5beb\u5b57\u6bcd\u3001\u5c0f\u5beb\u5b57\u6bcd\u3001\u6578\u5b57\u548c\u7279\u6b8a\u7b26\u865f",
    "Password removed": "\u5bc6\u78bc\u5df2\u79fb\u9664",
    "Password reset": "\u5bc6\u78bc\u5df2\u91cd\u7f6e",
    "Password set": "\u5bc6\u78bc\u5df2\u8a2d\u7f6e",
    "Password strength": "\u5bc6\u78bc\u5f37\u5ea6",
    "Password strength should be strong or very strong": "\u5bc6\u78bc\u5f37\u5ea6\u61c9\u70ba\u5f37\u6216\u975e\u5e38\u5f37",
    "Password updated": "\u5bc6\u78bc\u5df2\u66f4\u65b0",
    "Passwords do not match.": "\u5bc6\u78bc\u4e0d\u5339\u914d\u3002",
    "Passwords don't match": "\u5169\u6b21\u8f38\u5165\u7684\u5bc6\u78bc\u4e0d\u4e00\u81f4",
    "Path": "\u8def\u5f91",
    "People": "\u4eba",
    "Per 4 hours": "\u6bcf\u56db\u5c0f\u6642",
    "Per day": "\u6bcf\u5929",
    "Per hour": "\u6bcf\u5c0f\u6642",
    "Per week": "\u6bcf\u9031",
    "Percent": "\u767e\u5206\u6bd4",
    "Permission": "\u8b80\u5beb\u6b0a\u9650",
    "Permission denied": "\u6c92\u6709\u6b0a\u9650",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "\u6b0a\u9650\u88ab\u62d2\u7d55\u3002\u8acb\u5617\u8a66\u91cd\u65b0\u767b\u5165\u3002",
    "Permission name": "\u6b0a\u9650\u540d\u7a31",
    "Person image": "\u4eba\u7269\u5716\u50cf",
    "Picture": "\u5716\u7247",
    "Pictures and videos": "\u641c\u7d22\u5716\u7247\u548c\u8996\u983b",
    "Platform": "\u5e73\u53f0",
    "Please check the network.": "\u8acb\u6aa2\u67e5\u7db2\u7d61\u662f\u5426\u5df2\u9023\u63a5\u3002",
    "Please choose a .xlsx file.": "\u8acb\u9078\u64c7\u4e00\u500b .xlsx \u6587\u4ef6\u3002",
    "Please choose an image file.": "\u8acb\u9078\u64c7\u4e00\u500b\u5716\u50cf\u6587\u4ef6\u3002",
    "Please enter 1 or more character": "\u8acb\u8f38\u5165 1 \u500b\u6216\u66f4\u591a\u5b57\u7b26",
    "Please enter a new password": "\u8acb\u8f38\u5165\u65b0\u5bc6\u78bc\u3002",
    "Please enter a new quota": "\u8acb\u8f38\u5165\u65b0\u7684\u5bb9\u91cf",
    "Please enter a non-negative integer": "\u8acb\u8f38\u5165\u4e00\u500b\u975e\u8ca0\u6574\u6578",
    "Please enter a password.": "\u8acb\u8f38\u5165\u5bc6\u78bc\u3002",
    "Please enter a positive integer": "\u8acb\u8f38\u5165\u6b63\u6574\u6578",
    "Please enter an integer bigger than 1 as number of links.": "\u8acb\u8f38\u5165\u5927\u65bc 1 \u7684\u6574\u6578\u4f5c\u70ba\u5206\u4eab\u9023\u7d50\u6578\u91cf\u3002",
    "Please enter an integer not bigger than {max_number} as number of links.": "\u8acb\u8f38\u5165\u4e0d\u8d85\u904e {max_number} \u7684\u6574\u6578\u4f5c\u70ba\u5206\u4eab\u9023\u7d50\u6578\u91cf\u3002",
    "Please enter days": "\u8acb\u8f38\u5165\u5929\u6578",
    "Please enter password": "\u8acb\u8f38\u5165\u5bc6\u78bc",
    "Please enter the address": "\u8acb\u586b\u5beb\u5730\u5740",
    "Please enter the new password again": "\u8acb\u518d\u6b21\u8f38\u5165\u65b0\u5bc6\u78bc",
    "Please enter the old password": "\u8acb\u8f38\u5165\u820a\u5bc6\u78bc\u3002",
    "Please enter the password again": "\u8acb\u518d\u6b21\u8f38\u5165\u5bc6\u78bc",
    "Please input at least an email.": "\u8acb\u8f38\u5165\u81f3\u5c11\u4e00\u500b\u90f5\u7bb1\u3002",
    "Please select": "\u8acb\u9078\u64c7",
    "Please select a file": "\u8acb\u9078\u64c7\u4e00\u500b\u6587\u4ef6",
    "Please select a library or folder first.": "\u8acb\u5148\u9078\u64c7\u4e00\u500b\u8cc7\u6599\u5eab\u6216\u8cc7\u6599\u593e\u3002",
    "Please select a library to share.": "\u8acb\u9078\u64c7\u8981\u5171\u4eab\u7684\u8cc7\u6599\u5eab\u3002",
    "Please select an expiration time": "\u8acb\u9078\u64c7\u904e\u671f\u6642\u9593",
    "Please turn on extended properties setting first": "\u8acb\u5148\u555f\u7528\u64f4\u5c55\u5c6c\u6027\u8a2d\u7f6e",
    "Please upload no more than {maxFiles} files at a time.": "\u4e00\u6b21\u6700\u591a\u4e0a\u50b3 {maxFiles} \u500b\u6587\u4ef6\u3002",
    "Precision": "\u7cbe\u5ea6",
    "Preparing to upload...": "\u6e96\u5099\u4e0a\u50b3\u4e2d...",
    "Preset hide properties": "\u9810\u8a2d\u96b1\u85cf\u5c6c\u6027",
    "Preview and download": "\u9810\u89bd\u4e26\u4e0b\u8f09",
    "Preview online": "\u9810\u89bd\u7dda\u4e0a",
    "Preview only": "\u50c5\u9810\u89bd",
    "Previous": "\u524d\u4e00\u9801",
    "Previous (Left arrow key)": "\u4e0a\u4e00\u5f35 (\u5de6\u65b9\u5411\u9375)",
    "Print": "\u6253\u5370",
    "Print document": "\u5217\u5370\u6587\u4ef6",
    "Professional Edition": "\u4f01\u696d\u7248",
    "Profile": "\u8a2d\u5b9a",
    "Profile Setting": "\u500b\u4eba\u8cc7\u8a0a\u8a2d\u5b9a",
    "Properties": "\u5c6c\u6027",
    "Properties to display on the card": "\u986f\u793a\u5728\u5361\u7247\u4e0a\u7684\u5c6c\u6027",
    "Property name": "\u5c6c\u6027\u540d\u7a31",
    "Publish": "\u767c\u5e03",
    "Publish Wiki": "\u767c\u5e03 Wiki",
    "Published": "\u5df2\u767c\u5e03",
    "QR Code": "QR \u78bc",
    "Quota": "\u5bb9\u91cf",
    "Quota is invalid.": "\u5bb9\u91cf\u7121\u6548\u3002",
    "Rate": "\u8a55\u5206",
    "Read-Only": "\u552f\u8b80",
    "Read-Only folder": "\u552f\u8b80\u8cc7\u6599\u593e",
    "Read-Only library": "\u552f\u8b80\u8cc7\u6599\u5eab",
    "Read-Write": "\u53ef\u8b80\u5beb",
    "Read-Write folder": "\u53ef\u8b80\u53ef\u5beb\u8cc7\u6599\u593e",
    "Read-Write library": "\u53ef\u8b80\u5beb\u8cc7\u6599\u5eab",
    "Really want to delete this group?": "\u78ba\u8a8d\u522a\u9664\u672c\u7fa4\u7d44\u55ce\uff1f",
    "Really want to delete your account?": "\u78ba\u5b9a\u8981\u522a\u9664\u8a72\u5e33\u865f\u55ce\uff1f",
    "Really want to leave this group?": "\u78ba\u8a8d\u9000\u51fa\u6b64\u7fa4\u7d44\u55ce\uff1f",
    "Recently Used": "\u6700\u8fd1\u4f7f\u7528",
    "Recently used tags": "\u6700\u8fd1\u4f7f\u7528\u7684\u6a19\u7c64",
    "Recognizing portraits. Please refresh the page later.": "\u6b63\u5728\u8b58\u5225\u4eba\u50cf\u3002\u8acb\u7a0d\u5f8c\u5237\u65b0\u9801\u9762\u3002",
    "Recommended new tags": "\u5efa\u8b70\u65b0\u6a19\u7c64",
    "Refresh": "\u91cd\u65b0\u6574\u7406",
    "Refresh the view": "\u5237\u65b0\u6aa2\u8996",
    "Remaining": "\u5269\u9918\u6642\u9593",
    "Remove": "\u522a\u9664",
    "Remove Member": "\u79fb\u9664\u6210\u54e1",
    "Remove from this group": "\u5f9e\u6b64\u7fa4\u7d44\u79fb\u9664",
    "Removed all items from trash": "\u5df2\u5f9e\u56de\u6536\u7ad9\u4e2d\u79fb\u9664\u6240\u6709\u9805\u76ee",
    "Removed items older than {n} days from trash": "\u5df2\u5f9e\u56de\u6536\u7ad9\u4e2d\u79fb\u9664\u8d85\u904e {n} \u5929\u7684\u9805\u76ee",
    "Rename": "\u91cd\u547d\u540d",
    "Rename Department": "\u91cd\u547d\u540d\u90e8\u9580",
    "Rename File": "\u91cd\u65b0\u547d\u540d\u6587\u4ef6",
    "Rename Folder": "\u91cd\u65b0\u547d\u540d\u76ee\u9304",
    "Rename Group": "\u91cd\u65b0\u547d\u540d\u7fa4\u7d44",
    "Rename Library": "\u91cd\u65b0\u547d\u540d\u5b58\u5132\u5eab",
    "Rename Wiki": "\u91cd\u65b0\u547d\u540d Wiki",
    "Rename Wiki to": "\u5c07Wiki\u91cd\u547d\u540d\u70ba",
    "Rename file": "\u91cd\u547d\u540d\u6587\u4ef6",
    "Rename file to": "\u5c07\u6a94\u6848\u91cd\u547d\u540d\u70ba",
    "Rename folder": "\u91cd\u547d\u540d\u6587\u4ef6\u593e",
    "Rename folder to": "\u5c07\u8cc7\u6599\u593e\u91cd\u547d\u540d\u70ba",
    "Rename group to": "\u5c07\u7fa4\u7d44\u91cd\u547d\u540d\u70ba",
    "Rename property": "\u91cd\u547d\u540d\u5c6c\u6027",
    "Renamed file": "\u5df2\u91cd\u547d\u540d\u7684\u6a94\u6848",
    "Renamed folder": "\u91cd\u547d\u540d\u6216\u79fb\u52d5\u4e86\u8cc7\u6599\u593e",
    "Renamed library": "\u5df2\u91cd\u547d\u540d\u7684\u8cc7\u6599\u5eab",
    "Renamed or Moved files": "\u91cd\u547d\u540d\u6216\u79fb\u52d5\u7684\u6587\u4ef6",
    "Renaming {name} failed": "\u91cd\u547d\u540d {name} \u5931\u6557",
    "Replace": "\u53d6\u4ee3",
    "Replace file {filename}?": "\u8986\u84cb\u6587\u4ef6 {filename} \uff1f",
    "Replacing it will overwrite its content.": "\u66ff\u63db\u5b83\u6703\u8986\u84cb\u5df2\u6709\u5167\u5bb9\u3002",
    "Repo Transfer": "\u5009\u5eab\u50b3\u8f38",
    "Report Abuse": "\u8209\u5831\u6feb\u7528",
    "Reporter": "\u56de\u5831\u4eba",
    "Reports": "\u5831\u544a",
    "Required at least three letters.": "\u81f3\u5c11\u9700\u8981\u4e09\u500b\u5b57\u6bcd\u3002",
    "Reset": "\u91cd\u7f6e",
    "Reset Password": "\u91cd\u7f6e\u5bc6\u78bc",
    "Reset WebDAV Password": "\u91cd\u7f6e WebDAV \u5bc6\u78bc",
    "Reset library password": "\u91cd\u7f6e\u8cc7\u6599\u5eab\u5bc6\u78bc",
    "ResetPwd": "\u91cd\u7f6e\u5bc6\u78bc",
    "Resetting user's password, please wait for a moment.": "\u91cd\u7f6e\u7528\u6236\u5bc6\u78bc\uff0c\u8acb\u7a0d\u7b49\u7247\u523b\u3002",
    "Resolved comments": "\u5df2\u89e3\u6c7a\u7684\u8a55\u8ad6",
    "Restore": "\u9084\u539f",
    "Restore Library": "\u9084\u539f\u8cc7\u6599\u5eab",
    "Restored 1 item": "\u5df2\u6062\u5fa9 1 \u500b\u9805\u76ee",
    "Restored file": "\u5df2\u6062\u5fa9\u7684\u6a94\u6848",
    "Restored folder": "\u5df2\u6062\u5fa9\u7684\u8cc7\u6599\u593e",
    "Restored library": "\u5df2\u6062\u5fa9\u7684\u8cc7\u6599\u5eab",
    "Restored {name}": "\u6210\u529f\u6062\u5fa9 {name}\u3002",
    "Restored {name} and {n} other items": "\u6210\u529f\u6062\u5fa9 {name} \u548c {n} \u5176\u4ed6\u9805\u76ee\u3002",
    "Resubmit": "\u91cd\u65b0\u63d0\u4ea4",
    "Result": "\u641c\u5c0b\u7d50\u679c",
    "Retry": "\u91cd\u8a66",
    "Retry All": "\u91cd\u8a66\u5168\u90e8",
    "Revoke": "\u64a4\u92b7",
    "Revoke Access": "\u64a4\u92b7\u8a2a\u554f\u6b0a\u9650",
    "Revoke Admin": "\u53d6\u6d88\u7ba1\u7406\u54e1",
    "Role": "\u7528\u6236\u89d2\u8272",
    "Rotate": "\u65cb\u8f49",
    "SAML config": "SAML \u914d\u7f6e",
    "SAML config updated": "SAML \u914d\u7f6e\u5df2\u66f4\u65b0",
    "SSO": "SSO \u6574\u5408",
    "Satellite": "\u885b\u661f\u5730\u5716",
    "Save": "\u4fdd\u5b58",
    "Save Selected Items": "\u5132\u5b58\u9078\u53d6\u9805\u76ee",
    "Save as ...": "\u53e6\u5b58\u70ba ...",
    "Save to description field": "\u5c07\u6587\u672c\u4fdd\u5b58\u5230\u63cf\u8ff0\u5b57\u6bb5",
    "Save to:": "\u4fdd\u5b58\u5230\uff1a",
    "Saving...": "\u4fdd\u5b58\u4e2d...",
    "Scan the QR code to view the shared content directly": "\u6383\u63cf QR \u78bc\u76f4\u63a5\u67e5\u770b\u5206\u4eab\u5167\u5bb9",
    "SeaTable integration": "SeaTable \u6574\u5408",
    "Seafile": "\u6d77\u6587\u4e92\u77e5",
    "Search": "\u641c\u7d22",
    "Search Groups": "\u641c\u5c0b\u7fa4\u7d44",
    "Search Libraries": "\u641c\u7d22\u5eab",
    "Search Organizations": "\u641c\u7d22\u5718\u9ad4",
    "Search Users": "\u641c\u7d22\u7528\u6236",
    "Search collaborator": "\u641c\u7d22\u53c3\u8207\u8005",
    "Search collaborators": "\u641c\u7d22\u5354\u4f5c\u8005",
    "Search department": "\u641c\u7d22\u90e8\u9580",
    "Search departments": "\u641c\u7d22\u90e8\u9580",
    "Search failed": "\u641c\u7d22\u5931\u6557",
    "Search failed. Please try again.": "\u641c\u7d22\u5931\u6557\u3002\u8acb\u91cd\u65b0\u5617\u8a66\u3002",
    "Search files": "\u641c\u5c0b\u6587\u4ef6",
    "Search files in this library": "\u5728\u7576\u524d\u8cc7\u6599\u5eab\u641c\u5c0b\u6a94\u6848",
    "Search group members": "\u641c\u5c0b\u7fa4\u7d44\u6210\u54e1",
    "Search groups": "\u67e5\u627e\u7fa4\u7d44",
    "Search groups by name": "\u6309\u540d\u7a31\u641c\u5c0b\u7fa4\u7d44",
    "Search in trash": "\u5728\u56de\u6536\u7ad9\u641c\u7d22",
    "Search in trash...": "\u5728\u56de\u6536\u7ad9\u641c\u7d22...",
    "Search libraries by name or ID": "\u6309\u540d\u7a31\u6216 ID \u641c\u7d22\u5eab",
    "Search libraries by owner": "\u6309\u6240\u6709\u8005\u641c\u7d22\u5eab",
    "Search option": "\u641c\u7d22\u9078\u9805",
    "Search organizations": "\u641c\u7d22\u5718\u9ad4",
    "Search properties": "\u641c\u7d22\u5c6c\u6027",
    "Search property": "\u641c\u7d22\u5c6c\u6027",
    "Search results": "\u641c\u7d22\u7d50\u679c",
    "Search results visited recently": "\u6700\u8fd1\u8a2a\u554f\u7684\u641c\u5c0b\u7d50\u679c",
    "Search service unavailable": "\u641c\u5c0b\u670d\u52d9\u76ee\u524d\u4e0d\u53ef\u7528",
    "Search tag": "\u641c\u7d22\u6a19\u7c64",
    "Search user": "\u641c\u7d22\u7528\u6236",
    "Search users": "\u641c\u7d22\u7528\u6236",
    "Search users...": "\u641c\u5c0b\u7528\u6236...",
    "Searching...": "\u641c\u5c0b\u4e2d...",
    "Select": "\u9078\u64c7",
    "Select File": "\u9078\u64c7\u6587\u4ef6",
    "Select a Confluence HTML export file (.html.zip)": "\u9078\u64c7 Confluence HTML \u5c0e\u51fa\u6587\u4ef6 (.html.zip)",
    "Select a Confluence HTML exported file (.html.zip)": "\u9078\u64c7 Confluence HTML \u5c0e\u51fa\u6587\u4ef6 (.html.zip)",
    "Select a Confluence exported file": "\u9078\u64c7 Confluence \u5c0e\u51fa\u6587\u4ef6",
    "Select a department": "\u9078\u64c7\u90e8\u9580",
    "Select a server": "\u9078\u64c7\u4f3a\u670d\u5668",
    "Select a user": "\u9078\u64c7\u7528\u6236",
    "Select a user as admin": "\u9078\u64c7\u4e00\u500b\u7528\u6236\u4f5c\u70ba\u7ba1\u7406\u54e1",
    "Select all": "\u53d6\u6d88\u9078\u64c7\u6240\u6709",
    "Select all items": "\u9078\u64c7\u6240\u6709\u9805\u76ee",
    "Select an office suite": "\u9078\u64c7 Office \u5957\u4ef6",
    "Select an option": "\u9078\u64c7\u4e00\u500b\u9078\u9805",
    "Select collaborators": "\u9078\u64c7\u53c3\u8207\u8005",
    "Select group members": "\u9078\u64c7\u7fa4\u7d44\u6210\u54e1",
    "Select image": "\u9078\u64c7\u5716\u7247",
    "Select items": "\u9078\u64c7\u9805\u76ee",
    "Select libraries to share": "\u9078\u64c7\u8981\u5171\u4eab\u7684\u8cc7\u6599\u5eab",
    "Select members from department": "\u5f9e\u90e8\u9580\u4e2d\u9078\u64c7\u6210\u54e1",
    "Select option(s)": "\u9078\u64c7\u9078\u9805\uff08s\uff09",
    "Select shared users": "\u9078\u64c7\u5206\u4eab\u7528\u6236",
    "Select tag": "\u9078\u64c7\u6a19\u7c64",
    "Select target department": "\u9078\u64c7\u76ee\u6a19\u90e8\u9580",
    "Select this item": "\u9078\u64c7\u6b64\u9805\u76ee",
    "Select up to 50 files": "\u6700\u591a\u53ef\u9078\u64c7 50 \u500b\u6587\u4ef6",
    "Select users": "\u9078\u64c7\u7528\u6236",
    "Selected": "\u5df2\u9078\u64c7",
    "Send": "\u767c\u9001",
    "Send activation Email after user registration.": "\u7528\u6236\u8a3b\u518a\u5f8c\u767c\u9001\u958b\u901a\u90f5\u4ef6\u3002",
    "Send activation email": "\u7528\u6236\u8a3b\u518a\u5f8c\u767c\u9001\u6fc0\u6d3b\u90f5\u4ef6\u3002",
    "Send to:": "\u767c\u9001\u5230\uff1a",
    "Sending new password...": "\u6b63\u5728\u767c\u9001\u65b0\u5bc6\u78bc...",
    "Sending...": "\u767c\u9001\u4e2d...",
    "Separate multiple suffixes by \",\"(like sdoc, pdf)": "\u591a\u500b\u526f\u6a94\u540d\u8acb\u7528 \",\" \u5206\u9694 (\u4f8b\u5982 sdoc, pdf)",
    "Server": "\u4f3a\u670d\u5668",
    "Server Version: ": "\u4f3a\u670d\u5668\u7248\u672c\uff1a",
    "Set": "\u8a2d\u5b9a",
    "Set Admin": "\u8a2d\u70ba\u7ba1\u7406\u54e1",
    "Set Contact Email": "\u8a2d\u5b9a\u806f\u7d61\u96fb\u5b50\u90f5\u4ef6",
    "Set Download Rate Limit": "\u8a2d\u7f6e\u4e0b\u8f09\u901f\u7387\u9650\u5236",
    "Set Login ID": "\u8a2d\u5b9a\u767b\u5165 ID",
    "Set Name": "\u8a2d\u7f6e\u540d\u7a31",
    "Set Password": "\u8a2d\u5b9a\u5bc6\u78bc",
    "Set Quota": "\u8a2d\u5b9a\u5bb9\u91cf",
    "Set Upload Rate Limit": "\u8a2d\u7f6e\u4e0a\u50b3\u901f\u7387\u9650\u5236",
    "Set WebDAV Password": "\u8a2d\u5b9a WebDAV \u5bc6\u78bc",
    "Set access scope": "\u8a2d\u7f6e\u8a2a\u554f\u7bc4\u570d",
    "Set as cover photo": "\u8a2d\u7f6e\u70ba\u5c01\u9762\u7167\u7247",
    "Set child tags": "\u8a2d\u5b9a\u5b50\u6a19\u7c64",
    "Set max number of members": "\u8a2d\u7f6e\u6700\u5927\u6210\u54e1\u6578\u91cf",
    "Set organization inactive": "\u505c\u7528\u5718\u9ad4",
    "Set password": "\u8a2d\u7f6e\u5bc6\u78bc",
    "Set permission": "\u8a2d\u7f6e\u6b0a\u9650",
    "Set permission of {placeholder}": "\u8a2d\u5b9a {placeholder} \u76ee\u9304\u6b0a\u9650",
    "Set quota": "\u8a2d\u5b9a\u5bb9\u91cf",
    "Set to current": "\u8a2d\u70ba\u7576\u524d\u901a\u77e5",
    "Set user contact email": "\u8a2d\u5b9a\u7528\u6236\u806f\u7d61\u90f5\u7bb1",
    "Set user default quota": "\u8a2d\u5b9a\u7528\u6236\u9810\u8a2d\u914d\u989d",
    "Set user inactive": "\u8a2d\u7f6e\u7528\u6236\u4e0d\u6d3b\u52d5",
    "Set user name": "\u8a2d\u5b9a\u7528\u6236\u540d\u5b57",
    "Set user quota": "\u8a2d\u5b9a\u7528\u6236\u914d\u989d",
    "Setting library history is disabled by Admin.": "\u7ba1\u7406\u54e1\u5df2\u7981\u7528\u8a2d\u7f6e\u8cc7\u6599\u5eab\u6b77\u53f2\u3002",
    "Setting updated": "\u66f4\u65b0\u4e86\u8a2d\u5b9a",
    "Settings": "\u8a2d\u5b9a",
    "Share": "\u5171\u4eab",
    "Share Admin": "\u5171\u4eab\u7ba1\u7406",
    "Share From": "\u5171\u4eab\u4f86\u6e90",
    "Share Link": "\u5171\u4eab\u93c8\u63a5",
    "Share Link Traffic": "\u5206\u4eab\u9023\u7d50\u6d41\u91cf",
    "Share Links": "\u5171\u4eab\u7db2\u5740",
    "Share To": "\u5171\u4eab\u7d66",
    "Share To:": "\u5206\u4eab\u7d66\uff1a",
    "Share existing libraries": "\u5171\u4eab\u5df2\u6709\u8cc7\u6599\u5eab",
    "Share link download": "\u5206\u4eab\u9023\u7d50\u4e0b\u8f09",
    "Share link is copied to the clipboard.": "\u5206\u4eab\u9023\u7d50\u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f\u3002",
    "Share link upload": "\u5206\u4eab\u9023\u7d50\u4e0a\u50b3",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "\u5206\u4eab\u9023\u7d50\u4e0d\u80fd\u88ab\u751f\u6210\uff0c\u56e0\u70ba\u60a8\u5728\u67d0\u4e9b\u6587\u4ef6\u593e\u4e2d\u8a2d\u7f6e\u4e86\u300c\u4e0d\u53ef\u898b\u300d\u3001\u300c\u7dda\u4e0a\u53ef\u8b80\u53ef\u5beb\u300d\u6216\u300c\u7dda\u4e0a\u53ef\u8b80\u300d\u6b0a\u9650\u3002",
    "Share to group": "\u5171\u4eab\u5230\u7fa4\u7d44",
    "Share to other server": "\u5171\u4eab\u5230\u5176\u4ed6\u4f3a\u670d\u5668",
    "Share to user": "\u5171\u4eab\u5230\u7528\u6236",
    "Share/upload link force password": "\u7528\u6236\u751f\u6210\u5206\u4eab/\u4e0a\u50b3\u9023\u7d50\u6642\uff0c\u662f\u5426\u5f37\u5236\u8981\u6c42\u5bc6\u78bc\u3002",
    "Share/upload link password minimum length": "\u5206\u4eab/\u4e0a\u50b3\u9023\u7d50\u7684\u6700\u5c0f\u5bc6\u78bc\u9577\u5ea6\u3002",
    "Share/upload link password strength level": "\u5206\u4eab/\u4e0a\u50b3\u9023\u7d50\u7684\u5bc6\u78bc\u5f37\u5ea6\u7b49\u7d1a\u3002",
    "Shared By": "\u5171\u4eab\u4f86\u6e90",
    "Shared Libraries": "\u5171\u4eab\u5eab  ",
    "Shared Links": "\u5171\u4eab\u7db2\u5740",
    "Shared by:": "\u5206\u4eab\u8005\uff1a",
    "Shared by: ": "\u5171\u4eab\u4f86\u6e90\uff1a",
    "Shared from other servers": "\u5f9e\u5176\u4ed6\u4f3a\u670d\u5668\u5171\u4eab",
    "Shared with all": "\u8207\u6240\u6709\u4eba\u5171\u4eab",
    "Shared with me": "\u8207\u6211\u5171\u4eab",
    "Sharing Time": "\u5171\u4eab\u6642\u9593",
    "Show": "\u986f\u793a",
    "Show Codes": "\u986f\u793a\u9a57\u8b49\u78bc",
    "Show advanced search": "\u986f\u793a\u9032\u968e\u641c\u7d22",
    "Show all": "\u986f\u793a\u6240\u6709",
    "Show changes": "\u986f\u793a\u8b8a\u66f4",
    "Show daily history": "\u986f\u793a\u6bcf\u65e5\u6b77\u53f2\u8a18\u9304",
    "Show property names": "\u986f\u793a\u5c6c\u6027\u540d\u7a31",
    "Side Nav Menu": "\u5074\u908a\u5c0e\u822a\u9078\u55ae",
    "Single Sign On (SSO)": "\u55ae\u4e00\u767b\u5165\uff08SSO\uff09",
    "Single select": "\u55ae\u9078\u6846",
    "Site name": "\u7db2\u7ad9\u540d\u7a31",
    "Site name used in email sending": "\u7528\u65bc\u90f5\u4ef6\u767c\u9001\u7684\u7db2\u7ad9\u540d\u7a31",
    "Site title": "\u7db2\u7ad9\u540d\u7a31",
    "Site title shown in a browser tab": "\u700f\u89bd\u5668\u6a19\u7c64\u9801\u4e2d\u7684\u7db2\u7ad9\u540d\u7a31",
    "Size": "\u5927\u5c0f",
    "Sort": "\u6392\u5e8f",
    "Sort ascending": "\u6309\u5347\u5e8f\u6392\u5e8f",
    "Sort descending": "\u6309\u964d\u5e8f\u6392\u5e8f",
    "Space (1 000 000)": "\u7a7a\u683c (1 000 000)",
    "Space Used": "\u5df2\u7528\u7a7a\u9593",
    "Space Used / Quota": "\u5df2\u7528\u7a7a\u9593/\u5bb9\u91cf",
    "Space used": "\u5df2\u7528\u7a7a\u9593",
    "Specific people with email address": "\u7279\u5b9a\u90f5\u7bb1\u7528\u6236",
    "Specific users in the team": "\u7279\u5b9a\u5718\u968a\u6210\u54e1",
    "Star": "\u65b0\u589e\u661f\u6a19",
    "Start date": "\u958b\u59cb\u65e5\u671f",
    "Statistic": "\u7d71\u8a08",
    "Statistics": "\u7d71\u8a08",
    "Status": "\u72c0\u614b",
    "Status: enabled": "\u5df2\u555f\u7528",
    "Storage": "\u5b58\u5132",
    "Storage Backend": "\u5132\u5b58\u5f8c\u7aef",
    "Storage Used": "\u5df2\u7528\u7a7a\u95f4",
    "Strong password": "\u5f37\u529b\u5bc6\u78bc",
    "Style": "\u6a23\u5f0f",
    "Submit": "\u63d0\u4ea4",
    "Success": "\u6210\u529f",
    "Successfully added %s.": "\u6210\u529f\u65b0\u589e %s\u3002",
    "Successfully added label(s) for library {placeholder}": "\u6210\u529f\u70ba\u8cc7\u6599\u5eab {placeholder} \u6dfb\u52a0\u6a19\u7c64\u3002",
    "Successfully added the file.": "\u6210\u529f\u6dfb\u52a0\u6587\u4ef6\u3002",
    "Successfully added {email_placeholder}": "\u6210\u529f\u65b0\u589e {email_placeholder}",
    "Successfully change the group": "\u6210\u529f\u8b8a\u66f4\u7fa4\u7d44",
    "Successfully changed library password.": "\u8cc7\u6599\u5eab\u5bc6\u78bc\u91cd\u7f6e\u6210\u529f\u3002",
    "Successfully changed the office suite.": "\u6210\u529f\u66f4\u6539 Office \u5957\u4ef6\u3002",
    "Successfully cleaned all errors.": "\u6210\u529f\u6e05\u9664\u6240\u6709\u932f\u8aa4\u3002",
    "Successfully cleaned invalid share links.": "\u6210\u529f\u6e05\u9664\u7121\u6548\u7684\u5206\u4eab\u9023\u7d50\u3002",
    "Successfully cleaned invalid upload links.": "\u6210\u529f\u6e05\u9664\u7121\u6548\u7684\u4e0a\u50b3\u9023\u7d50\u3002",
    "Successfully cleared trash.": "\u6210\u529f\u6e05\u7a7a\u56de\u6536\u7ad9\u3002",
    "Successfully converted the file.": "\u6210\u529f\u5c07\u6587\u4ef6\u8f49\u63db\u3002",
    "Successfully copied %(name)s and %(amount)s other items.": "\u6210\u529f\u8907\u88fd %(name)s \u548c\u5176\u4ed6 %(amount)s \u9805\u689d\u76ee\u3002",
    "Successfully copied %(name)s and 1 other item.": "\u6210\u529f\u8907\u88fd %(name)s \u548c\u53e61\u9805\u689d\u76ee\u3002",
    "Successfully copied %(name)s.": "\u6210\u529f\u8907\u88fd %(name)s\u3002",
    "Successfully copied files to another library.": "\u6210\u529f\u5c07\u6587\u4ef6\u8907\u88fd\u5230\u53e6\u4e00\u500b\u5eab\u3002",
    "Successfully copied {name} and {n} other items": "\u6210\u529f\u5c07 {name} \u548c {n} \u5176\u4ed6\u9805\u76ee\u8907\u88fd\u3002",
    "Successfully deleted 1 item": "\u6210\u529f\u522a\u9664 1 \u500b\u689d\u76ee",
    "Successfully deleted 1 item.": "\u6210\u529f\u522a\u9664 1 \u500b\u9805\u76ee\u3002",
    "Successfully deleted 1 share link": "\u6210\u529f\u522a\u9664 1 \u500b\u5206\u4eab\u9023\u7d50",
    "Successfully deleted 1 upload link": "\u6210\u529f\u522a\u9664 1 \u500b\u4e0a\u50b3\u9023\u7d50",
    "Successfully deleted 1 user.": "\u6210\u529f\u522a\u9664 1 \u500b\u7528\u6236\u3002",
    "Successfully deleted {name}": "\u6210\u529f\u522a\u9664 {name}",
    "Successfully deleted {name} and {n} other items": "\u6210\u529f\u522a\u9664 {name} \u53ca\u5176\u4ed6 {n} \u500b\u9805\u76ee",
    "Successfully deleted {name} and {n} other items.": "\u6210\u529f\u522a\u9664 {name} \u548c {n} \u5176\u4ed6\u9805\u76ee\u3002",
    "Successfully deleted {name}.": "\u6210\u529f\u522a\u9664 {name}\u3002",
    "Successfully deleted {number_placeholder} share links": "\u6210\u529f\u522a\u9664 {number_placeholder} \u500b\u5206\u4eab\u9023\u7d50",
    "Successfully deleted {number_placeholder} upload links": "\u6210\u529f\u522a\u9664 {number_placeholder} \u500b\u4e0a\u50b3\u9023\u7d50",
    "Successfully deleted {user_number_placeholder} users.": "\u6210\u529f\u522a\u9664 {user_number_placeholder} \u500b\u7528\u6236\u3002",
    "Successfully edited labels.": "\u6210\u529f\u7de8\u8f2f\u6a19\u7c64\u3002",
    "Successfully imported tags.": "\u5df2\u6210\u529f\u532f\u5165\u6a19\u7c64\u3002",
    "Successfully imported {user_placeholder}": "\u6210\u529f\u532f\u5165 {user_placeholder}",
    "Successfully invited %(email) and %(num) other people.": "\u6210\u529f\u9080\u8acb %(email) \u548c %(num) \u5176\u4ed6\u7528\u6236\u3002",
    "Successfully invited %(email).": "\u6210\u529f\u9080\u8acb %(email)",
    "Successfully modified permission.": "\u6210\u529f\u4fee\u6539\u6b0a\u9650",
    "Successfully moved %(name)s and %(amount)s other items.": "\u6210\u529f\u79fb\u52d5 %(name)s \u548c\u5176\u4ed6 %(amount)s \u9805\u689d\u76ee\u3002",
    "Successfully moved %(name)s and 1 other item.": "\u6210\u529f\u79fb\u52d5 %(name)s \u548c\u53e61\u9805\u689d\u76ee\u3002",
    "Successfully moved %(name)s.": "\u6210\u529f\u79fb\u52d5 %(name)s\u3002",
    "Successfully moved files to another library.": "\u6210\u529f\u5c07\u6587\u4ef6\u79fb\u52d5\u5230\u53e6\u4e00\u500b\u5eab\u3002",
    "Successfully moved {name} and {n} other items": "\u6210\u529f\u5c07 {name} \u548c {n} \u5176\u4ed6\u9805\u76ee\u79fb\u52d5\u3002",
    "Successfully moved {name}.": "\u6210\u529f\u5c07 {name} \u79fb\u52d5\u3002",
    "Successfully removed {placeholder}.": "\u6210\u529f\u79fb\u9664 {placeholder}\u3002",
    "Successfully renamed the library.": "\u8cc7\u6599\u5eab\u5df2\u91cd\u547d\u540d\u3002",
    "Successfully restored the library {library_name}.": "\u6210\u529f\u6062\u5fa9\u8cc7\u6599\u5eab {library_name}\u3002",
    "Successfully restored the library.": "\u6210\u529f\u6062\u5fa9\u4e86\u8a72\u8cc7\u6599\u5eab\u3002",
    "Successfully restored.": "\u6210\u529f\u6062\u5fa9\u3002",
    "Successfully revoke the admin permission of %s": "\u6210\u529f\u53d6\u6d88 %s \u7684\u7ba1\u7406\u6b0a\u9650",
    "Successfully revoked access of user {placeholder}.": "\u6210\u529f\u64a4\u92b7\u7528\u6236 {placeholder} \u7684\u8a2a\u554f\u6b0a\u9650\u3002",
    "Successfully revoked the admin permission of {placeholder}.": "\u5df2\u64a4\u92b7 {placeholder} \u7684\u7ba1\u7406\u54e1\u6b0a\u9650\u3002",
    "Successfully saved": "\u6210\u529f\u4fdd\u5b58",
    "Successfully sent to {placeholder}": "\u6210\u529f\u767c\u9001\u7d66 {placeholder}",
    "Successfully set %s as admin.": "\u6210\u529f\u8a2d\u5b9a %s \u70ba\u7ba1\u7406\u54e1\u3002",
    "Successfully set it.": "\u6210\u529f\u8a2d\u7f6e\u3002",
    "Successfully set library history.": "\u6210\u529f\u8a2d\u7f6e\u8cc7\u6599\u5eab\u6b77\u53f2\u3002",
    "Successfully set quota.": "\u6210\u529f\u8a2d\u7f6e\u7528\u6236\u7a7a\u9593\u9650\u5236\u3002",
    "Successfully starred {library_name_placeholder}.": "\u5df2\u6210\u529f\u661f\u6a19 {library_name_placeholder}\u3002",
    "Successfully starred {name_placeholder}.": "\u5df2\u6210\u529f\u661f\u6a19 {name_placeholder}\u3002",
    "Successfully transferred the group.": "\u7fa4\u7d44\u8f49\u8b93\u6210\u529f\u3002",
    "Successfully transferred the library.": "\u8cc7\u6599\u5eab\u8f49\u8b93\u6210\u529f\u3002",
    "Successfully unlinked %(name)s.": "\u5df2\u6210\u529f\u53d6\u6d88\u9023\u63a5 %(name)s\u3002",
    "Successfully unlinked the device.": "\u6210\u529f\u53d6\u6d88\u9023\u63a5\u8a2d\u5099\u3002",
    "Successfully unshared library {placeholder}": "\u6210\u529f\u53d6\u6d88\u5171\u4eab\u8cc7\u6599\u5eab {placeholder}",
    "Successfully unshared {name}": "\u6210\u529f\u53d6\u6d88\u5171\u4eab {name}",
    "Successfully unstarred {library_name_placeholder}.": "\u5df2\u6210\u529f\u53d6\u6d88\u661f\u6a19 {library_name_placeholder}\u3002",
    "Successfully unstarred {name_placeholder}.": "\u5df2\u6210\u529f\u53d6\u6d88\u661f\u6a19 {name_placeholder}\u3002",
    "Successfully unwatched the library.": "\u5df2\u505c\u6b62\u76e3\u63a7\u6b64\u8cc7\u6599\u5eab\u7684\u6a94\u6848\u8b8a\u66f4\u3002",
    "Successfully watched the library.": "\u5df2\u958b\u59cb\u76e3\u63a7\u6b64\u8cc7\u6599\u5eab\u7684\u6a94\u6848\u8b8a\u66f4\u3002",
    "Suggestion": "\u5efa\u8b70",
    "Switch sort mode": "\u5207\u63db\u6392\u5e8f\u6a21\u5f0f",
    "Switch to plain text editor": "\u5207\u63db\u5230\u7d14\u6587\u672c\u7de8\u8f2f\u5668",
    "Switch to rich text editor": "\u5207\u63db\u5230\u5bcc\u6587\u672c\u7de8\u8f2f\u5668",
    "Switch view mode": "\u5207\u63db\u6aa2\u8996\u6a21\u5f0f",
    "Symbol position": "\u7b26\u865f\u4f4d\u7f6e",
    "Sync": "\u540c\u6b65",
    "Sync Download": "\u540c\u6b65\u4e0b\u8f09",
    "Sync Traffic": "\u540c\u6b65\u6d41\u91cf",
    "Sync Upload": "\u540c\u6b65\u4e0a\u50b3",
    "System": "\u7cfb\u7d71\u8cc7\u6599\u5eab",
    "System Admin": "\u7cfb\u7d71\u7ba1\u7406",
    "System Info": "\u7cfb\u7d71\u4fe1\u606f",
    "System settings updated": "\u7cfb\u7d71\u8a2d\u5b9a\u5df2\u66f4\u65b0",
    "Table": "\u8868\u683c",
    "Tag": "\u6a19\u7c64",
    "Tag not found": "\u7121\u53ef\u7528\u9078\u9805",
    "Tagged Files": "\u6a19\u8a18\u6587\u4ef6",
    "Tags": "\u6a19\u7c64",
    "Tags migrated successfully": "\u6a19\u7c64\u8fc1\u79fb\u6210\u529f",
    "Team deleted": "\u5718\u9ad4\u5df2\u522a\u9664",
    "Team name": "\u5718\u968a\u540d\u7a31",
    "Template": "\u6a21\u7d44",
    "Terms": "\u689d\u6b3e",
    "Terms and Conditions": "\u8edf\u4ef6\u4f7f\u7528\u689d\u6b3e",
    "Text": "\u6587\u5b57",
    "Text file extensions": "\u53ef\u4ee5\u76f4\u63a5\u9810\u89bd\u7684\u6587\u672c\u6587\u4ef6\u526f\u6a94\u540d\u3002",
    "Text is required.": "\u6587\u5b57\u70ba\u5fc5\u586b\u9805\u3002",
    "Text wraps": "\u6587\u672c\u5305\u88f9",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "\u6587\u4ef6\u5167\u5bb9\u8d85\u904e 100000 \u500b\u5b57\u7b26\u9650\u5236\uff0c\u50c5\u4fdd\u5b58\u524d 100000 \u500b\u5b57\u7b26",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "\u6587\u4ef6\u5167\u5bb9\u8d85\u904e 100000 \u500b\u5b57\u7b26\u9650\u5236\uff0c\u7121\u6cd5\u4fdd\u5b58",
    "The current quota for {group_name} is {quota}": "\u7fa4\u7d44 {group_name} \u7684\u7576\u524d\u5bb9\u91cf\u70ba {quota}",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "URL \u81ea\u5b9a\u7fa9\u90e8\u5206\u5fc5\u9808\u4ecb\u65bc 5 \u5230 30 \u500b\u5b57\u7b26\u4e4b\u9593\uff0c\u4e14\u53ea\u80fd\u5305\u542b\u5b57\u6bcd (a-z)\u3001\u6578\u5b57\u548c\u77ed\u5283\u7dda\u3002",
    "The file is too large. Allowed maximum size is 1MB.": "\u6587\u4ef6\u592a\u5927\uff0c\u5141\u8a31\u7684\u6700\u5927\u5927\u5c0f\u70ba 1MB\u3002",
    "The image could not be previewed.": "\u7121\u6cd5\u9810\u89bd\u6b64\u5716\u50cf\u3002",
    "The import process may take several minutes depending on the size of your Confluence export.": "\u5c0e\u5165\u904e\u7a0b\u53ef\u80fd\u9700\u8981\u5e7e\u5206\u9418\uff0c\u53d6\u6c7a\u65bc\u60a8\u7684 Confluence \u5c0e\u51fa\u6587\u4ef6\u5927\u5c0f\u3002",
    "The imported options already exists": "\u5c0e\u5165\u7684\u9078\u9805\u5df2\u5b58\u5728",
    "The imported options are invalid": "\u5c0e\u5165\u7684\u9078\u9805\u7121\u6548",
    "The least number of characters a share/upload link password should include.": "\u5206\u4eab/\u4e0a\u50b3\u9023\u7d50\u7684\u6700\u5c0f\u5bc6\u78bc\u9577\u5ea6\u3002",
    "The least number of characters an encrypted library password should include.": "\u52a0\u5bc6\u8cc7\u6599\u5eab\u7684\u6700\u5c0f\u5bc6\u78bc\u9577\u5ea6\u3002",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "\u5171\u4eaf/\u4e0a\u50b3\u9023\u7d50\u5bc6\u78bc\u5f3a\u5ea6\u7684\u7d1a\u5225\uff081-4\uff09\u3002\u4f8b\u5982\uff0c\u201c3\u201d\u8868\u793a\u5bc6\u78bc\u5fc5\u9808\u81f3\u5c11\u5305\u542b\u4ee5\u4e0b3\u500b\u5b57\u5143\uff1anum\u3001\u5927\u5beb\u5b57\u6bcd\u3001\u5c0f\u5beb\u5b57\u6bcd\u548c\u5176\u4ed6\u7b26\u865f",
    "The link is copied to the clipboard.": "\u93c8\u63a5\u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f\u3002",
    "The list of added, deleted and modified files will be sent to your mailbox.": "\u5df2\u6dfb\u52a0\u3001\u522a\u9664\u6216\u4fee\u6539\u7684\u6587\u4ef6\u5217\u8868\u5c07\u6703\u767c\u9001\u5230\u60a8\u7684\u90f5\u7bb1\u3002",
    "The maximum number of failed login attempts before showing CAPTCHA.": "\u7528\u6236\u767b\u5165\u5931\u6557\u5e7e\u6b21\u5f8c\u986f\u793a\u9a57\u8b49\u78bc\u3002",
    "The name \"{name}\" is already taken. Please choose a different name.": "\u540d\u7a31 \"{name}\" \u5df2\u88ab\u4f7f\u7528\u3002\u8acb\u9078\u64c7\u4e0d\u540c\u7684\u540d\u7a31\u3002",
    "The next month": "\u672a\u4f86\u7684\u4e00\u500b\u6708",
    "The next numbers of days": "\u672a\u4f86\u7684\u5929\u6578",
    "The next week": "\u672a\u4f86\u7684\u4e00\u9031",
    "The next year": "\u672a\u4f86\u7684\u4e00\u5e74",
    "The owner of this library has run out of space.": "\u8a72\u8cc7\u6599\u5eab\u64c1\u6709\u8005\u7684\u7a7a\u9593\u5df2\u7528\u5b8c\u3002",
    "The password is too short.": "\u5bc6\u78bc\u592a\u77ed\u3002",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "\u5bc6\u78bc\u592a\u5f31\u3002\u5b83\u61c9\u8a72\u5305\u542b\u81f3\u5c11 {passwordStrengthLevel} \u7a2e\u4ee5\u4e0b\u7684\u5b57\u7b26\uff1a\u6578\u5b57\u3001\u5927\u5beb\u5b57\u6bcd\u3001\u5c0f\u5beb\u5b57\u6bcd\u548c\u5176\u4ed6\u7b26\u865f\u3002",
    "The password will be kept in the server for only 1 hour.": "\u5bc6\u78bc\u5c07\u5728\u4f3a\u670d\u5668\u4e0a\u5132\u5b58\u4e00\u5c0f\u6642\u3002",
    "The past month": "\u904e\u53bb\u7684\u4e00\u500b\u6708",
    "The past numbers of days": "\u904e\u53bb\u7684\u5929\u6578",
    "The past week": "\u904e\u53bb\u7684\u4e00\u9031",
    "The past year": "\u904e\u53bb\u7684\u4e00\u5e74",
    "The path has been copied to the clipboard": "\u5df2\u5c07\u8def\u5f91\u8907\u88fd\u5230\u526a\u8cbc\u677f",
    "The row is locked and cannot be modified": "\u8a72\u884c\u5df2\u88ab\u9396\u5b9a\uff0c\u4e0d\u80fd\u88ab\u4fee\u6539",
    "The uploaded image has not been saved yet. Please close this page later.": "\u4e0a\u50b3\u7684\u5716\u7247\u5c1a\u672a\u4fdd\u5b58\u3002\u8acb\u7a0d\u5f8c\u95dc\u9589\u6b64\u9801\u9762\u3002",
    "There is another option with this name": "\u6709\u53e6\u4e00\u500b\u9078\u9805\u5177\u6709\u76f8\u540c\u7684\u540d\u7a31",
    "There is another property with this name": "\u5df2\u7d93\u6709\u4e00\u500b\u540c\u540d\u5c6c\u6027",
    "There is no information to display.": "\u6c92\u6709\u53ef\u7528\u7684\u4fe1\u606f\u53ef\u986f\u793a\u3002",
    "This file has (apparently) not been accessed yet": "\u9019\u500b\u6a94\u6848\u76ee\u524d\u4e26\u6c92\u6709\u88ab\u700f\u89bd",
    "This file has been updated.": "\u6b64\u6587\u4ef6\u5df2\u66f4\u65b0",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "\u6b64\u6587\u4ef6\u593e\u5df2\u88ab\u5206\u4eab\u7d66 {user_amount} \u500b\u7528\u6236\u548c {group_amount} \u500b\u7fa4\u7d44\u3002",
    "This folder has no content at this time.": "\u6b64\u8cc7\u6599\u593e\u76ee\u524d\u6c92\u6709\u5167\u5bb9\u3002",
    "This is a special group representing a department.": "\u9019\u662f\u4e00\u500b\u7279\u6b8a\u7fa4\u7d44\uff0c\u4ee3\u8868\u4e00\u500b\u90e8\u9580\u3002",
    "This is required": "\u5fc5\u586b",
    "This library contains tags of old version. Do you like to migrate the tags to new version?": "\u662f\u5426\u559c\u6b61\u5c07\u820a\u7248\u672c\u6a19\u7c64\u8fc1\u79fb\u5230\u65b0\u7248\u672c\uff1f",
    "This library has been set to read-only by admin and cannot be updated.": "\u6b64\u5eab\u5df2\u7531\u7ba1\u7406\u54e1\u8a2d\u7f6e\u70ba\u552f\u8b80\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "\u6b64\u8cc7\u6599\u5eab\u5df2\u88ab\u5206\u4eab\u7d66 {user_amount} \u500b\u7528\u6236\u548c {group_amount} \u500b\u7fa4\u7d44\u3002",
    "This library is password protected": "\u8a72\u8cc7\u6599\u5eab\u5df2\u52a0\u5bc6",
    "This list is collapsed": "\u6b64\u5217\u8868\u5df2\u647a\u758a",
    "This month": "\u9019\u4e00\u500b\u6708",
    "This operation will not be reverted. Please think twice!": "\u8a72\u64cd\u4f5c\u5c07\u4e0d\u53ef\u5fa9\u539f\u3002\u8acb\u4e09\u601d\uff01",
    "This property can not be deleted": "\u6b64\u5c6c\u6027\u4e0d\u80fd\u88ab\u522a\u9664",
    "This property does not support sorting": "\u6b64\u5c6c\u6027\u4e0d\u652f\u6301\u6392\u5e8f",
    "This property is not editable": "\u6b64\u5c6c\u6027\u4e0d\u53ef\u7de8\u8f2f",
    "This user has not created or joined any groups": "\u6b64\u7528\u6236\u6c92\u6709\u5efa\u7acb\u6216\u52a0\u5165\u7fa4\u7d44",
    "This week": "\u9019\u4e00\u9031",
    "This year": "\u9019\u4e00\u5e74",
    "Thousands separator": "\u5343\u4f4d\u5206\u9694\u7b26",
    "Thumbnail": "\u7e2e\u7565\u5716",
    "Time": "\u6642\u9593",
    "Tip: -2 means no limit.": "\u63d0\u793a\uff1a-2 \u8868\u793a\u7121\u9650\u5236\u3002",
    "Tip: 0 means default limit": "\u63d0\u793a: \u8a2d\u5b9a\u70ba0\u8868\u793a\u91cd\u7f6e\u70ba\u9810\u8a2d\u4e0a\u9650",
    "Tip: 0 means default limit, the unit is MB": "\u63d0\u793a\uff1a0 \u8868\u793a\u9ed8\u8a8d\u9650\u5236\uff0c\u55ae\u4f4d\u70ba MB",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "\u63d0\u793a\uff1a\u5728\u6bcf\u6b21\u4fee\u6539\u5f8c\u6703\u751f\u6210\u4e00\u500b\u93e1\u50cf\uff0c\u8a18\u9304\u4fee\u6539\u4e4b\u524d\u7684\u76ee\u9304\u72c0\u614b\u3002",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "\u63d0\u793a\uff1a{placeholder} \u5929\u524d\u522a\u9664\u7684\u8cc7\u6599\u5eab\u5c07\u6703\u81ea\u52d5\u6e05\u9664\u3002",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "\u63d0\u793a\uff1a{trashReposExpireDays} \u5929\u524d\u522a\u9664\u7684\u8cc7\u6599\u5eab\u5c07\u6703\u81ea\u52d5\u6e05\u9664\u3002",
    "Tip: you can search by keyword in name or ID.": "\u63d0\u793a\uff1a\u60a8\u53ef\u4ee5\u5728\u540d\u7a31\u6216 ID \u4e2d\u641c\u7d22\u95dc\u9375\u5b57\u3002",
    "Tip: you can search by keyword in name.": "\u63d0\u793a\uff1a\u53ef\u4ee5\u7528\u540d\u7a31\u95dc\u9375\u8a5e\u4f86\u641c\u5c0b\u3002",
    "Tips: There are tags of old version. Please migrate tags to new version.": "\u63d0\u793a\uff1a\u6709\u820a\u7248\u672c\u7684\u6a19\u7c64\u3002\u8acb\u5c07\u6a19\u7c64\u8fc1\u79fb\u5230\u65b0\u7248\u672c\u3002",
    "Tips: These are tags of old version. The feature is deprecated and can no longer be used.": "\u63d0\u793a\uff1a\u9019\u4e9b\u662f\u820a\u7248\u672c\u7684\u6a19\u7c64\u3002\u6b64\u529f\u80fd\u5df2\u88ab\u68c4\u7528\uff0c\u4e0d\u518d\u53ef\u7528\u3002",
    "Title property": "\u6a19\u984c\u5c6c\u6027",
    "To confirm, type \"{placeholder}\" in the box below": "\u70ba\u4e86\u78ba\u8a8d\u522a\u9664\uff0c\u8acb\u5728\u4e0b\u65b9\u8f38\u5165\u6846\u4e2d\u8f38\u5165 \"{placeholder}\"",
    "Today": "\u4eca\u5929",
    "Toggle children": "\u5207\u63db\u5b50\u9805\u76ee",
    "Toggle repo selector": "\u5207\u63db\u8cc7\u6599\u5eab\u9078\u64c7\u5668",
    "Toggle selector menu": "\u5207\u63db\u9078\u64c7\u5668\u83dc\u55ae",
    "Toggle user selector": "\u5207\u63db\u7528\u6236\u9078\u64c7\u5668",
    "Token": "\u4ee4\u724c",
    "Token:": "\u4ee4\u724c:",
    "Tomorrow": "\u660e\u5929",
    "Too many requests": "\u8acb\u6c42\u904e\u591a",
    "Total Devices": "\u6240\u6709\u7684\u8a2d\u5099",
    "Total Storage": "\u7e3d\u5b58\u5132",
    "Total Traffic": "\u7e3d\u6d41\u91cf",
    "Total Users": "\u7e3d\u7528\u6236",
    "Total users": "\u7528\u6236\u7e3d\u6578",
    "Total {comments_count} comment": "\u5171 {comments_count} \u689d\u8a55\u8ad6",
    "Total {comments_count} comments": "\u5171 {comments_count} \u689d\u8a55\u8ad6",
    "Traffic": "\u6d41\u91cf",
    "Traffic exceeded": "\u6d41\u91cf\u8d85\u904e",
    "Traffic this month": "\u672c\u6708\u6d41\u91cf",
    "Transfer": "\u8f49\u8b93",
    "Transfer From": "\u50b3\u8f38\u81ea",
    "Transfer Group": "\u8f49\u8b93\u7fa4\u7d44",
    "Transfer Group {placeholder} to": "\u5c07\u7fa4\u7d44 {placeholder} \u8f49\u79fb\u5230",
    "Transfer Library": "\u8f49\u8b93\u8cc7\u6599\u5eab",
    "Transfer Library {library_name}": "\u8f49\u79fb\u5eab {library_name}",
    "Transfer To": "\u50b3\u8f38\u81f3",
    "Transfer group to": "\u8f49\u8b93\u7fa4\u7d44\u5230",
    "Transfer to department": "\u8f49\u79fb\u5230\u90e8\u9580",
    "Transfer to user": "\u8f49\u79fb\u5230\u7528\u6236",
    "Transferred group {group_name} from {user_from} to {user_to}": "\u8f49\u8b93\u7fa4\u7d44 {group_name} \u7531 {user_from} \u5230 {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "\u8f49\u8b93\u8cc7\u6599\u5eab {library_name} \u7531 {user_from} \u5230 {user_to}",
    "Trash": "\u8cc7\u6e90\u56de\u6536\u7b52",
    "Turn off": "\u95dc\u9589",
    "Turn off extended properties": "\u95dc\u9589\u64f4\u5c55\u5c6c\u6027",
    "Turn off face recognition": "\u95dc\u9589\u81c9\u90e8\u8b58\u5225",
    "Turn off tags": "\u95dc\u9589\u6a19\u7c64",
    "Turn on extensible properties and views to experience a new way of managing files": "\u958b\u555f\u53ef\u64f4\u5145\u7684\u5c6c\u6027\u548c\u6aa2\u8996\uff0c\u4ee5\u9ad4\u9a57\u65b0\u7684\u6a94\u6848\u7ba1\u7406\u65b9\u5f0f\u3002",
    "Two-Factor Authentication": "\u5169\u6b65\u9a57\u8b49",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "\u4f60\u7684\u5e33\u6236\u4e26\u672a\u958b\u59cb\u5169\u6b65\u9a57\u8b49\uff0c\u8acb\u958b\u555f\u5169\u6b65\u9a57\u8b49\u589e\u52a0\u5e33\u6236\u5b89\u5168\u6027\u3002",
    "Type": "\u985e\u578b",
    "Type characters to start search": "\u8f38\u5165\u5b57\u7b26\u4ee5\u958b\u59cb\u641c\u5c0b",
    "URL is copied to the clipboard": "URL \u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f",
    "URL is required": "URL \u662f\u5fc5\u586b\u9805",
    "US": "\u7f8e\u570b\u683c\u5f0f",
    "Uncategorized": "\u672a\u5206\u985e",
    "Undo": "\u64a4\u92b7",
    "Unfold": "\u5c55\u958b",
    "Unfold the sidebar": "\u5c55\u958b\u5074\u908a\u6b04",
    "Unfreeze Document": "\u89e3\u51bb\u6587\u4ef6",
    "Unhandled": "\u672a\u8655\u7406",
    "Unknown": "\u672a\u77e5",
    "Unknown people": "\u672a\u77e5\u4eba\u7269",
    "Unlink": "\u65b7\u958b\u9023\u63a5",
    "Unlink device": "\u65b7\u958b\u9023\u63a5\u8a2d\u5099",
    "Unlock": "\u89e3\u9396",
    "Unpublish": "\u53d6\u6d88\u767c\u5e03",
    "Unpublish Wiki": "\u53d6\u6d88\u767c\u5e03 Wiki",
    "Unresolved comments": "\u672a\u89e3\u6c7a\u7684\u8a55\u8ad6",
    "Unselect": "\u53d6\u6d88\u9078\u64c7",
    "Unselect all": "\u53d6\u6d88\u9078\u64c7\u6240\u6709",
    "Unselect all items": "\u53d6\u6d88\u9078\u64c7\u6240\u6709\u9805\u76ee",
    "Unselect items": "\u53d6\u6d88\u9078\u64c7\u9805\u76ee",
    "Unselect this item": "\u53d6\u6d88\u9078\u64c7\u6b64\u9805\u76ee",
    "Unshare": "\u53d6\u6d88\u5171\u4eab",
    "Unshare Library": "\u53d6\u6d88\u5171\u4eab\u8cc7\u6599\u5eab",
    "Unstar": "\u53d6\u6d88\u661f\u6a19",
    "Untitled": "\u672a\u547d\u540d",
    "Unwatch File Changes": "\u53d6\u6d88\u76e3\u63a7\u6b64\u8cc7\u6599\u5eab\u7684\u6a94\u6848\u8b8a\u66f4",
    "Up": "\u4e0a",
    "Update": "\u66f4\u65b0",
    "Update Terms and Conditions": "\u66f4\u65b0\u8edf\u4ef6\u4f7f\u7528\u689d\u6b3e",
    "Update password": "\u66f4\u65b0\u5bc6\u78bc",
    "Update succeeded.": "\u66f4\u65b0\u6210\u529f\u3002",
    "Update time": "\u66f4\u65b0\u6642\u9593",
    "Updated draft": "\u5df2\u66f4\u65b0\u8349\u7a3f",
    "Updated file": "\u5df2\u66f4\u65b0\u7684\u6a94\u6848",
    "Upgrade to Pro Edition": "\u5347\u7d1a\u5230\u5c08\u696d\u7248",
    "Upload": "\u4e0a\u50b3",
    "Upload Files": "\u4e0a\u50b3\u6a94\u6848",
    "Upload Folder": "\u4e0a\u50b3\u76ee\u9304",
    "Upload Link": "\u4e0a\u50b3\u9023\u7d50",
    "Upload Links": "\u4e0a\u50b3\u9023\u7d50",
    "Upload failed": "\u4e0a\u50b3\u5931\u6557\u3002",
    "Upload file": "\u4e0a\u50b3\u6587\u4ef6",
    "Upload files to": "\u4e0a\u50b3\u6587\u4ef6\u5230",
    "Upload license": "\u4e0a\u50b3\u6388\u6b0a",
    "Upload link is copied to the clipboard.": "\u4e0a\u50b3\u9023\u7d50\u5df2\u8907\u88fd\u5230\u526a\u8cbc\u677f\u3002",
    "Uploaded": "\u4e0a\u50b3\u5b8c\u6210\u3002",
    "Uploading...": "\u4e0a\u50b3\u4e2d...",
    "Use custom CSS": "\u4f7f\u7528\u81ea\u5b9a\u7fa9 CSS",
    "Use information from your Identity Provider to configure Seafile": "\u4f7f\u7528\u60a8\u7684\u8eab\u4efd\u63d0\u4f9b\u8005\u4fe1\u606f\u914d\u7f6e Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "\u4f7f\u7528\u5c0e\u5165/\u5c0e\u51fa\u529f\u80fd\u5feb\u901f\u50b3\u8f38\u9078\u9805\u3002\uff08\u5c0e\u51fa\u683c\u5f0f\u70ba JSON \u683c\u5f0f\u3002\uff09\u901a\u904e\u7c98\u8cbc\u55ae\u5143\u683c\uff0c\u5f9e\u6587\u672c\u5217\u3001Excel \u6216 TXT \u6587\u4ef6\u4e2d\u8907\u88fd\uff0c\u60a8\u9084\u53ef\u4ee5\u5feb\u901f\u6dfb\u52a0\u9078\u9805\u3002",
    "Use these values to configure your Identity Provider": "\u4f7f\u7528\u9019\u4e9b\u503c\u914d\u7f6e\u60a8\u7684\u8eab\u4efd\u63d0\u4f9b\u8005",
    "Used:": "\u5df2\u7528\u7a7a\u9593\uff1a",
    "User": "\u7528\u6236",
    "User Email": "\u7528\u6236\u90f5\u7bb1",
    "User ID": "\u7528\u6236 ID",
    "User Permission": "\u7528\u6236\u6b0a\u9650",
    "User Shares": "\u7528\u6236\u5171\u4eab",
    "User Storage": "\u7528\u6236\u5b58\u5132",
    "User can not see this folder.": "\u7528\u6236\u4e0d\u80fd\u67e5\u770b\u6b64\u8cc7\u6599\u593e\u3002",
    "User can only view files online via browser. Files can't be downloaded.": "\u7528\u6236\u53ea\u80fd\u901a\u904e\u700f\u89bd\u5668\u5728\u7dda\u67e5\u770b\u6587\u4ef6\u3002\u6587\u4ef6\u4e0d\u80fd\u4e0b\u8f09\u3002",
    "User can read, download and sync files.": "\u7528\u6236\u53ef\u4ee5\u8b80\u53d6\u3001\u4e0b\u8f09\u548c\u540c\u6b65\u6587\u4ef6\u3002",
    "User can read, write, upload, download and sync files.": "\u7528\u6236\u53ef\u4ee5\u8b80\u53d6\u3001\u5beb\u5165\u3001\u4e0a\u50b3\u3001\u4e0b\u8f09\u548c\u540c\u6b65\u6587\u4ef6\u3002",
    "User can view and edit file online via browser. Files can't be downloaded.": "\u7528\u6236\u53ef\u4ee5\u901a\u904e\u700f\u89bd\u5668\u5728\u7dda\u67e5\u770b\u548c\u7de8\u8f2f\u6587\u4ef6\u3002\u6587\u4ef6\u4e0d\u80fd\u4e0b\u8f09\u3002",
    "User default quota": "\u7528\u6236\u9ed8\u8a8d\u914d\u989d",
    "User default quota updated": "\u66f4\u65b0\u4e86\u7528\u6236\u9ed8\u8a8d\u914d\u989d",
    "User deleted": "\u7528\u6236\u5df2\u88ab\u522a\u9664\u3002",
    "User info updated": "\u5df2\u66f4\u65b0\u7528\u6236\u8cc7\u8a0a\u3002",
    "User is already in this group": "\u7528\u6236\u5df2\u5728\u672c\u7fa4\u7d44\u4e2d",
    "User migrate from {user_from} to {user_to}": "\u4f7f\u7528\u8005 {user} \u5df2\u5f9e {user_from} \u8f49\u79fb\u81f3 {user_to}",
    "User not found": "\u7528\u6236\u4e0d\u5b58\u5728",
    "User number limit": "\u7528\u6236\u6578\u91cf\u9650\u5236",
    "User {user_link} has added you to {group_link}": "\u7528\u6236 {user_link} \u5df2\u5c07\u60a8\u6dfb\u52a0\u5230\u7fa4\u7d44 {group_link}",
    "Username:": "\u7528\u6236\u540d\u7a31:",
    "Users": "\u7528\u6236",
    "Value": "\u503c",
    "Verified": "\u5df2\u9a57\u8b49",
    "Verify": "\u9a57\u8b49",
    "Verify Domain": "\u9a57\u8b49\u57df\u540d",
    "Version": "\u7248\u672c",
    "Version Number": "\u7248\u672c\u865f",
    "Version Number is required.": "\u7248\u672c\u865f\u70ba\u5fc5\u586b\u9805\u3002",
    "Version Number must be a number.": "\u7248\u672c\u865f\u5fc5\u9808\u662f\u6578\u5b57\u3002",
    "Video": "\u8996\u983b",
    "View": "\u67e5\u770b",
    "View Link": "\u67e5\u770b\u9023\u7d50",
    "View Related Snapshot": "\u67e5\u770b\u76f8\u95dc\u5feb\u7167",
    "View Snapshot": "\u67e5\u770b\u93e1\u50cf",
    "View all notifications": "\u67e5\u770b\u6240\u6709\u901a\u77e5",
    "View notification": "\u67e5\u770b\u901a\u77e5",
    "View original image": "\u67e5\u770b\u539f\u59cb\u5716\u50cf",
    "View profile and more": "\u67e5\u770b\u500b\u4eba\u8cc7\u6599",
    "View published page": "\u67e5\u770b\u5df2\u767c\u5e03\u9801\u9762",
    "Views": "\u6aa2\u8996",
    "Virus": "\u75c5\u6bd2",
    "Virus File": "\u75c5\u6bd2\u6a94\u6848",
    "Virus Scan": "\u6383\u63cf\u75c5\u6bd2",
    "Visit count": "\u9020\u8a2a\u6b21\u6578",
    "Visit old version page": "\u8a2a\u554f\u820a\u7248\u672c\u9801\u9762",
    "Visit the wiki": "\u8a2a\u554fwiki",
    "Visited": "\u5df2\u8a2a\u554f",
    "Visits": "\u700f\u89bd\u6b21\u6578",
    "Waiting...": "\u7b49\u5f85\u4e2d...",
    "Watch File Changes": "\u958b\u59cb\u76e3\u63a7\u6b64\u8cc7\u6599\u5eab\u7684\u6a94\u6848\u8b8a\u66f4\u3002",
    "Web API Auth Token": "Web API \u8a8d\u8b49\u4ee4\u724c",
    "Web Download": "\u7db2\u7d61\u4e0b\u8f09",
    "Web Traffic": "\u7db2\u7d61\u6d41\u91cf",
    "Web Upload": "\u7db2\u7d61\u4e0a\u50b3",
    "WebDAV Access": "WebDAV \u5b58\u53d6",
    "WebDAV password:": "WebDAV \u5bc6\u78bc:",
    "WebDAV username:": "WebDAV \u7528\u6236\u540d\u7a31:",
    "Welcome to {site_name_placeholder}": "\u6b61\u8fce\u4f86\u5230 {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "\u662f\u5426\u61c9\u8a72\u5c07\u5354\u4f5c\u901a\u77e5\uff08\u4f8b\u5982\u5171\u4eab\u5eab\u6216\u52a0\u5165\u7fa4\u7d44\uff09\u767c\u9001\u5230\u60a8\u7684\u90f5\u7bb1\u3002",
    "Wiki custom URL deleted": "\u5df2\u522a\u9664\u81ea\u5b9a\u7fa9\u7684 Wiki URL",
    "Wiki owner": "\u7dad\u57fa\u64c1\u6709\u8005",
    "Wiki published": "Wiki \u5df2\u767c\u5e03",
    "Wikis": "\u7dad\u57fa\u767e\u79d1",
    "Workspace": "\u500b\u4eba\u5de5\u4f5c\u81fa",
    "Wrong password": "\u5bc6\u78bc\u932f\u8aa4",
    "Year": "\u5e74\u4efd",
    "Yesterday": "\u6628\u5929",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "\u53ef\u4ee5\u65b0\u589e\u4e00\u500b\u201c\u8a2a\u5ba2\u201d\u7528\u6236\uff0c\u201c\u8a2a\u5ba2\u201d\u7528\u6236\u7121\u6cd5\u5efa\u7acb\u8cc7\u6599\u5eab\u548c\u7fa4\u7d44\u3002",
    "You can click the \"Add Wiki\" button below to add a new Wiki.": "\u60a8\u53ef\u4ee5\u9ede\u64ca\u4e0b\u65b9\u7684 \"\u65b0\u589e Wiki\" \u6309\u9215\u4f86\u65b0\u589e\u65b0\u7684 Wiki \u9801\u9762\u3002",
    "You can create files quickly": "\u60a8\u53ef\u4ee5\u5feb\u901f\u5efa\u7acb\u6587\u4ef6\u3002",
    "You can create libraries by clicking the \"New Library\" item in the dropdown menu.": "\u60a8\u53ef\u4ee5\u5728\u4e0b\u62c9\u83dc\u55ae\u4e2d\u9ede\u64ca \"\u65b0\u8cc7\u6599\u5eab\" \u9805\u76ee\u4f86\u5efa\u7acb\u65b0\u7684\u8cc7\u6599\u5eab\u3002",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "\u60a8\u53ef\u4ee5\u8f38\u5165\u591a\u500b\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\u3002\u6bcf\u500b\u5730\u5740\u5c07\u6536\u5230\u4e00\u5c01\u9080\u8acb\u93c8\u63a5\u3002",
    "You can use this field at login.": "\u60a8\u53ef\u4ee5\u7528\u8a72\u5b57\u6bb5\u767b\u5165\u3002",
    "You do not have permission": "\u60a8\u6c92\u6709\u6b0a\u9650",
    "You don't have any favorite items yet": "\u60a8\u76ee\u524d\u6c92\u6709\u6536\u85cf\u4efb\u4f55\u9805\u76ee",
    "You don't have any share links": "\u60a8\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u5206\u4eab\u9023\u7d50",
    "You don't have any upload links": "\u60a8\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u4e0a\u50b3\u9023\u7d50",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "\u60a8\u5c1a\u672a\u4f7f\u7528\u4efb\u4f55\u5ba2\u6236\u7aef\uff08\u684c\u9762\u6216\u79fb\u52d5\u8a2d\u5099\uff09\u8a2a\u554f\u60a8\u7684\u6587\u4ef6\u3002\u8acb\u5728\u60a8\u7684\u8a2d\u5099\u4e0a\u914d\u7f6e\u5ba2\u6236\u7aef\u4ee5\u66f4\u65b9\u4fbf\u5730\u8a2a\u554f\u60a8\u7684\u6578\u64da\u3002",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "\u60a8\u76ee\u524d\u6c92\u6709\u5c07\u4efb\u4f55\u5eab\u3001\u8cc7\u6599\u593e\u6216\u6587\u4ef6\u6dfb\u52a0\u5230\u60a8\u7684\u6536\u85cf\u4e2d\u3002\u6536\u85cf\u53ef\u4ee5\u8b93\u60a8\u5feb\u901f\u8a2a\u554f\u60a8\u6700\u5e38\u4f7f\u7528\u7684\u5c0d\u8c61\u3002\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u5176\u540d\u7a31\u5de6\u908a\u7684\u661f\u661f\u5716\u793a\u4f86\u5c07\u5eab\u3001\u8cc7\u6599\u593e\u6216\u6587\u4ef6\u6dfb\u52a0\u5230\u60a8\u7684\u6536\u85cf\u4e2d\u3002",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" item in the dropdown menu.": "\u60a8\u5c1a\u672a\u5275\u5efa\u4efb\u4f55\u8cc7\u6599\u5eab\u3002\u8cc7\u6599\u5eab\u662f\u7d44\u7e54\u60a8\u6587\u4ef6\u548c\u8cc7\u6599\u593e\u7684\u5bb9\u5668\u3002\u60a8\u9084\u53ef\u4ee5\u8207\u5176\u4ed6\u7528\u6236\u5171\u4eab\u548c\u540c\u6b65\u5230\u60a8\u9023\u63a5\u7684\u8a2d\u5099\u3002\u60a8\u53ef\u4ee5\u901a\u904e\u5728\u83dc\u55ae\u6b04\u4e2d\u55ae\u64ca \"New Library\" \u6309\u9215\u4f86\u5275\u5efa\u8cc7\u6599\u5eab\u3002",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "\u60a8\u76ee\u524d\u6c92\u6709\u5efa\u7acb\u4efb\u4f55\u5206\u4eab\u9023\u7d50\u3002\u5206\u4eab\u9023\u7d50\u53ef\u4ee5\u8b93\u5176\u4ed6\u7528\u6236\u5206\u4eab\u6587\u4ef6\u6216\u8cc7\u6599\u593e\u3002\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u5176\u540d\u7a31\u53f3\u908a\u7684\u5206\u4eab\u5716\u793a\u4f86\u5efa\u7acb\u5206\u4eab\u9023\u7d50\u3002",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "\u60a8\u76ee\u524d\u6c92\u6709\u5efa\u7acb\u4efb\u4f55\u4e0a\u50b3\u9023\u7d50\u3002\u4e0a\u50b3\u9023\u7d50\u5141\u8a31\u5176\u4ed6\u7528\u6236\u4e0a\u50b3\u6587\u4ef6\u5230\u8cc7\u6599\u593e\u6216\u5eab\u3002\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u5176\u540d\u7a31\u53f3\u908a\u7684\u5206\u4eab\u5716\u793a\u4f86\u5efa\u7acb\u4e0a\u50b3\u9023\u7d50\u3002",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "\u60a8\u5728\u6700\u8fd1 {placeholder} \u5929\u5167\u672a\u522a\u9664\u4efb\u4f55\u8cc7\u6599\u5eab\u3002\u522a\u9664\u7684\u8cc7\u6599\u5eab\u5c07\u5728\u9019\u500b\u5468\u671f\u5f8c\u81ea\u52d5\u6e05\u9664\u3002",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" item in the dropdown menu.": "\u76ee\u524d\u6c92\u6709\u9080\u8acb\u4efb\u4f55\u5ba2\u6236\u7aef\u3002\u5ba2\u6236\u7aef\u53ef\u4ee5\u901a\u904e\u7db2\u7d61\u754c\u9762\u8a2a\u554f\u5171\u4eab\u5eab\uff0c\u5141\u8a31\u66f4\u9ad8\u6548\u7684\u5354\u4f5c\u65b9\u5f0f\uff0c\u800c\u4e0d\u662f\u901a\u904e\u93c8\u63a5\u3002\u60a8\u53ef\u4ee5\u901a\u904e\u9ede\u64ca\u4e0b\u62c9\u83dc\u55ae\u4e2d\u7684 \"\u9080\u8acb\u5ba2\u6236\u7aef\" \u9805\u76ee\u4f86\u9080\u8acb\u5ba2\u6236\u7aef\u3002",
    "You have not shared any folders": "\u60a8\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u8cc7\u6599\u593e",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "\u60a8\u76ee\u524d\u6c92\u6709\u8207\u5176\u4ed6\u7528\u6236\u5206\u4eab\u4efb\u4f55\u8cc7\u6599\u593e\u3002\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u8cc7\u6599\u593e\u540d\u7a31\u53f3\u908a\u7684\u5206\u4eab\u5716\u793a\u4f86\u5206\u4eab\u8cc7\u6599\u593e\u3002",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "\u60a8\u76ee\u524d\u6c92\u6709\u5206\u4eab\u4efb\u4f55\u5eab\u7d66\u5176\u4ed6\u7528\u6236\u3002\u60a8\u53ef\u4ee5\u901a\u904e\u9ede\u64ca \"My Libraries\" \u4e2d\u7684\u5206\u4eab\u5716\u793a\u4f86\u5206\u4eab\u4e00\u500b\u5eab\u7d66\u5176\u4ed6\u7528\u6236\u3002",
    "You have only one backup code remaining.": "\u60a8\u9084\u6709\u4e00\u500b\u5099\u7528\u9a57\u8b49\u78bc\u3002",
    "You have {num} backup codes remaining.": "\u60a8\u9084\u6709 {num} \u500b\u5099\u7528\u9a57\u8b49\u78bc\u3002",
    "Your name": "\u60a8\u7684\u540d\u7a31",
    "Your notifications will be sent to this email.": "\u60a8\u7684\u901a\u77e5\u5c07\u767c\u9001\u5230\u8a72\u90f5\u7bb1\u3002",
    "Yuan": "\u5143",
    "ZIP": "ZIP",
    "Zoom in": "\u653e\u5927 (Ctrl + \u9f20\u6a19\u6efe\u8f2a)",
    "Zoom out": "\u7e2e\u5c0f (Ctrl - \u9f20\u6a19\u6efe\u8f2a)",
    "all": "\u5168\u90e8",
    "all members": "\u6240\u6709\u6210\u54e1",
    "contains": "\u5305\u542b",
    "copy": "\u8907\u88fd",
    "days": "\u5929",
    "deleted": "\u5df2\u522a\u9664",
    "deleted option": "\u5df2\u522a\u9664\u9078\u9805",
    "details": "\u8a73\u60c5",
    "does not contain": "\u4e0d\u5305\u542b",
    "email is required": "\u96fb\u5b50\u90f5\u4ef6\u70ba\u5fc5\u586b\u9805",
    "freezed": "\u5df2\u51cd\u7d50",
    "has all of...": "\u5305\u542b\u6240\u6709...",
    "has any of...": "\u5305\u542b\u4efb\u4f55...",
    "has none of...": "\u4e0d\u5305\u542b\u4efb\u4f55...",
    "icon": "\u5716\u793a",
    "in all libraries": "\u5728\u6240\u6709\u5eab\u4e2d\u641c\u5c0b",
    "in this folder": "\u5728\u672c\u8cc7\u6599\u593e\u4e2d\u641c\u5c0b",
    "in this library": "\u5728\u672c\u5eab\u4e2d\u641c\u5c0b",
    "include the current user": "\u5305\u542b\u6211",
    "is": "\u662f",
    "is after...": "\u5728...\u4e4b\u5f8c",
    "is any of...": "\u5305\u542b\u4efb\u4f55...",
    "is before...": "\u5728...\u4e4b\u524d",
    "is current user's ID": "\u7576\u524d\u7528\u6236 ID",
    "is empty": "\u70ba\u7a7a",
    "is exactly...": "\u7cbe\u78ba\u7b49\u65bc...",
    "is none of...": "\u4e0d\u5305\u542b\u4efb\u4f55...",
    "is not": "\u4e0d\u662f",
    "is not empty": "\u4e0d\u70ba\u7a7a",
    "is on or after...": "\u5728...\u4e4b\u5f8c\u6216\u5728...\u4e0a",
    "is on or before...": "\u5728...\u4e4b\u524d\u6216\u5728...\u4e0a",
    "is within...": "\u5728...\u5167",
    "items": "\u9805\u76ee",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "\u5df2\u6388\u6b0a\u81f3 {placeholder_license_to}\uff0c\u5c07\u5728 {placeholder_license_expiration} \u5230\u671f",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "\u5df2\u6388\u6b0a\u81f3 {placeholder_license_to}\uff0c\u5347\u7d1a\u670d\u52d9\u5c07\u5728 {placeholder_license_expiration} \u5230\u671f",
    "locked": "\u5df2\u9396\u5b9a",
    "locked by {name}": "\u5df2\u9396\u5b9a\u65bc {name}",
    "members": "\u6210\u54e1",
    "mm": "\u6beb\u7c73",
    "name": "\u540d\u7a31",
    "not set": "\u672a\u8a2d\u5b9a\u5bc6\u78bc",
    "only show {placeholder}": "\u50c5\u986f\u793a {placeholder}",
    "progress": "\u9032\u5ea6",
    "s": "\u79d2",
    "selected": "\u5df2\u9078\u64c7",
    "show more": "\u986f\u793a\u66f4\u591a",
    "size": "\u5927\u5c0f",
    "sorts": "\u6392\u5e8f",
    "starred": "\u5df2\u52a0\u661f\u6a19",
    "state": "\u72c0\u614b",
    "successfully added user %s.": "\u6210\u529f\u65b0\u589e\u7528\u6236 %s\u3002",
    "successfully sent email to %s.": "\u6210\u529f\u767c\u9001\u90f5\u4ef6\u81f3 %s\u3002",
    "tags": "\u6a19\u7c64",
    "unstarred": "\u672a\u52a0\u661f\u6a19",
    "xxx cells copied": "\u8907\u88fd {xxx} \u500b\u55ae\u5143\u683c\u3002",
    "xxx cells cut": "\u526a\u4e0b {xxx} \u500b\u55ae\u5143\u683c",
    "xxx cells selected": "\u9078\u64c7 {xxx} \u500b\u55ae\u5143\u683c",
    "xxx record": "\u9078\u64c7 1 \u689d\u8a18\u9304",
    "xxx records": "\u9078\u64c7 {xxx} \u689d\u8a18\u9304",
    "xxx records selected": "\u9078\u64c7 {xxx} \u689d\u8a18\u9304",
    "xxx rows are copied.": "\u8907\u88fd {xxx} \u884c\u3002",
    "you can also press \u2192": "\u4f60\u4e5f\u53ef\u4ee5\u6309 \u2192",
    "{failed_files_num} file(s) failed to upload": "\u4e0a\u50b3\u5931\u6557 {failed_files_num} \u500b\u6587\u4ef6\u3002",
    "{file} and {n} other files": "\u5305\u542b {n} \u500b\u5176\u4ed6\u6a94\u6848",
    "{library_name} Office Suite": "{library_name} Office \u5957\u4ef6",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} \u5929",
    "{name_placeholder} cells copied": "\u5df2\u8907\u88fd {name_placeholder} \u55ae\u5143\u683c\u3002",
    "{name_placeholder} cells cut": "\u526a\u4e0b\u55ae\u5143\u683c",
    "{name_placeholder} cells selected": "\u5df2\u9078\u64c7 {name_placeholder} \u55ae\u5143\u683c\u3002",
    "{name_placeholder} hidden properties": "\u96b1\u85cf {name_placeholder} \u5c6c\u6027",
    "{name_placeholder} preset hidden properties": "\u9810\u8a2d\u96b1\u85cf {name_placeholder} \u5c6c\u6027",
    "{name_placeholder} record": "\u5df2\u9078\u64c7 {name_placeholder} \u8a18\u9304\u3002",
    "{name_placeholder} records": "\u5df2\u9078\u64c7 {name_placeholder} \u8a18\u9304\u3002",
    "{name_placeholder} records selected": "\u5df2\u9078\u64c7 {name_placeholder} \u8a18\u9304\u3002",
    "{name_placeholder} rows are copied.": "\u5df2\u8907\u88fd {name_placeholder} \u884c\u3002",
    "{name} rows use this option.": "{name} \u884c\u4f7f\u7528\u6b64\u9078\u9805\u3002",
    "{number_placeholder} / Page": "\u9801\u9762 {number_placeholder} / \u5171 {total_placeholder} \u9801",
    "{placeholder} API Token": "API \u4ee4\u724c",
    "{placeholder} Access Log": "\u6587\u4ef6\u8a2a\u554f\u65e5\u8a8c",
    "{placeholder} Folder Permission": "{placeholder} \u76ee\u9304\u6b0a\u9650",
    "{placeholder} History Setting": "{placeholder} \u6b77\u53f2\u8a2d\u7f6e",
    "{placeholder} Modification History": "\u4fee\u6539\u6b77\u53f2\u8a18\u9304",
    "{placeholder} Share Admin": "\u5171\u4eab\u7ba1\u7406\u54e1",
    "{placeholder} Snapshot": "{placeholder} \u5feb\u7167",
    "{placeholder} Trash": "\u641c\u7d22\u5931\u6557",
    "{placeholder} Wiki Trash": "{placeholder} Wiki \u56de\u6536\u7ad9",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "\u7528\u6236 {share_from} \u5df2\u53d6\u6d88\u5206\u4eab\u6587\u4ef6\u593e {repo_name}\u3002",
    "{share_from} has cancelled the sharing of library {repo_name}.": "\u7528\u6236 {share_from} \u5df2\u53d6\u6d88\u5206\u4eab\u5eab {repo_name}\u3002",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "\u7528\u6236 {share_from} \u5df2\u5c07\u6587\u4ef6\u593e {repo_link} \u7684\u6b0a\u9650\u66f4\u6539\u70ba {permission}\u3002",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "\u7528\u6236 {share_from} \u5df2\u5c07\u5eab {repo_link} \u7684\u6b0a\u9650\u66f4\u6539\u70ba {permission}\u3002",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "\u7528\u6236 {share_from} \u5df2\u5206\u4eab\u6587\u4ef6\u593e {repo_link} \u5230\u7fa4\u7d44 {group_link}\u3002",
    "{share_from} has shared a folder named {repo_link} to you.": "\u7528\u6236 {share_from} \u5206\u4eab\u4e86\u4e00\u500b\u540d\u70ba {repo_link} \u7684\u6587\u4ef6\u593e\u5230\u60a8\u3002",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "\u7528\u6236 {share_from} \u5df2\u5206\u4eab\u5eab {repo_link} \u5230\u7fa4\u7d44 {group_link}\u3002",
    "{share_from} has shared a library named {repo_link} to you.": "\u7528\u6236 {share_from} \u5206\u4eab\u4e86\u4e00\u500b\u540d\u70ba {repo_link} \u7684\u5eab\u5230\u60a8\u3002",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": "\u7531\u65bc\u60a8\u73fe\u5728\u662f\u8bbf\u5ba2\u7528\u6236\uff0c\u56e0\u6b64\u60a8\u7121\u6cd5\u5275\u5efa\u5eab\u3002",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "\u6b61\u8fce\u4f86\u5230 {site_name_placeholder}\u3002{site_name_placeholder} \u5c07\u6587\u4ef6\u7d44\u7e54\u6210\u5eab\u3002\u6bcf\u500b\u5eab\u53ef\u4ee5\u7368\u7acb\u540c\u6b65\u548c\u5206\u4eab\u3002\u6211\u5011\u70ba\u60a8\u5275\u5efa\u4e86\u4e00\u500b\u500b\u4eba\u5eab\u3002\u60a8\u53ef\u4ee5\u5f8c\u7e8c\u5275\u5efa\u66f4\u591a\u5eab\u3002",
    "{uploaded_files_num}/{all_files_num} Files": "\u5df2\u4e0a\u50b3 {uploaded_files_num}/{all_files_num} \u500b\u6587\u4ef6\u3002",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "\u6b64\u5718\u9ad4\u5305\u542b {userCount} \u500b\u7528\u6236\u548c {repoCount} \u500b\u5eab\uff0c\u5c07\u540c\u6642\u88ab\u522a\u9664\u3002",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u5275\u5efa\u6587\u4ef6 {fileName} \u4ee5\u53ca {fileCount} \u500b\u5176\u4ed6\u6587\u4ef6\u3002",
    "{user} created file {fileName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u5275\u5efa\u6587\u4ef6 {fileName}\u3002",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u5275\u5efa\u6587\u4ef6\u593e {folderName} \u4ee5\u53ca {folderCount} \u500b\u5176\u4ed6\u6587\u4ef6\u593e\u3002",
    "{user} created folder {folderName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u5275\u5efa\u6587\u4ef6\u593e {folderName}\u3002",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u522a\u9664\u6587\u4ef6 {fileName} \u4ee5\u53ca {fileCount} \u500b\u5176\u4ed6\u6587\u4ef6\u3002",
    "{user} deleted file {fileName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u522a\u9664\u6587\u4ef6 {fileName}\u3002",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u522a\u9664\u6587\u4ef6\u593e {folderName} \u4ee5\u53ca {folderCount} \u500b\u5176\u4ed6\u6587\u4ef6\u593e\u3002",
    "{user} deleted folder {folderName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u522a\u9664\u6587\u4ef6\u593e {folderName}\u3002",
    "{user} has transferred a library named {repo_link} to you.": "\u7528\u6236 {user} \u5df2\u5c07\u5eab {repo_link} \u8f49\u79fb\u5230\u60a8\u3002",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u79fb\u52d5\u6587\u4ef6 {fileName} \u4ee5\u53ca {fileCount} \u500b\u5176\u4ed6\u6587\u4ef6\u3002",
    "{user} moved file {fileName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u79fb\u52d5\u6587\u4ef6 {fileName}\u3002",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u79fb\u52d5\u6587\u4ef6\u593e {folderName} \u4ee5\u53ca {folderCount} \u500b\u5176\u4ed6\u6587\u4ef6\u593e\u3002",
    "{user} moved folder {folderName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u79fb\u52d5\u6587\u4ef6\u593e {folderName}\u3002",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u5c07\u6587\u4ef6 {oldFileName} \u91cd\u547d\u540d\u70ba {fileName}\u3002",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u5c07\u6587\u4ef6\u593e {oldFolderName} \u91cd\u547d\u540d\u70ba {folderName}\u3002",
    "{user} restored file {fileName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u6062\u5fa9\u6587\u4ef6 {fileName}\u3002",
    "{user} restored folder {folderName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u6062\u5fa9\u6587\u4ef6\u593e {folderName}\u3002",
    "{user} updated file {fileName} in library {libraryName}.": "\u7528\u6236 {user} \u5df2\u5728\u5eab {libraryName} \u4e2d\u66f4\u65b0\u6587\u4ef6 {fileName}\u3002",
    "{xxx} items have been selected": "\u5df2\u9078\u64c7 {xxx} \u500b\u9805\u76ee"
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "N j, Y, P",
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%m/%d/%Y %H:%M:%S",
      "%m/%d/%Y %H:%M:%S.%f",
      "%m/%d/%Y %H:%M",
      "%m/%d/%y %H:%M:%S",
      "%m/%d/%y %H:%M:%S.%f",
      "%m/%d/%y %H:%M"
    ],
    "DATE_FORMAT": "N j, Y",
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d",
      "%m/%d/%Y",
      "%m/%d/%y",
      "%b %d %Y",
      "%b %d, %Y",
      "%d %b %Y",
      "%d %b, %Y",
      "%B %d %Y",
      "%B %d, %Y",
      "%d %B %Y",
      "%d %B, %Y"
    ],
    "DECIMAL_SEPARATOR": ".",
    "FIRST_DAY_OF_WEEK": 0,
    "MONTH_DAY_FORMAT": "F j",
    "NUMBER_GROUPING": 0,
    "SHORT_DATETIME_FORMAT": "m/d/Y P",
    "SHORT_DATE_FORMAT": "m/d/Y",
    "THOUSAND_SEPARATOR": ",",
    "TIME_FORMAT": "P",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

