/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.GUI;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.QuestName;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020!H\u0007J\b\u0010#\u001a\u00020!H\u0007J\b\u0010$\u001a\u00020!H\u0007J\b\u0010%\u001a\u00020\u0007H\u0007J\b\u0010&\u001a\u00020\u0007H\u0007J\b\u0010'\u001a\u00020(H\u0007J\b\u0010)\u001a\u00020\u0003H\u0007J\u0006\u0010*\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006+"}, d2={"Lcom/unciv/logic/civilization/managers/AssignedQuest;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "questName", "", "assigner", "assignee", "assignedOnTurn", "", "data1", "data2", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getQuestName", "()Ljava/lang/String;", "getAssigner", "getAssignee", "getAssignedOnTurn", "()I", "getData1", "getData2", "gameInfo", "Lcom/unciv/logic/GameInfo;", "questObject", "Lcom/unciv/models/ruleset/Quest;", "questNameInstance", "Lcom/unciv/models/ruleset/QuestName;", "getQuestNameInstance", "()Lcom/unciv/models/ruleset/QuestName;", "setTransients", "", "quest", "setTransients$core", "isIndividual", "", "isGlobal", "doesExpire", "isExpired", "getDuration", "getRemainingTurns", "getInfluence", "", "getDescription", "onClickAction", "core"})
public final class AssignedQuest
implements IsPartOfGameInfoSerialization {
    @NotNull
    private final String questName;
    @NotNull
    private final String assigner;
    @NotNull
    private final String assignee;
    private final int assignedOnTurn;
    @NotNull
    private final String data1;
    @NotNull
    private final String data2;
    private transient GameInfo gameInfo;
    private transient Quest questObject;

    public AssignedQuest(@NotNull String questName, @NotNull String assigner, @NotNull String assignee, int assignedOnTurn, @NotNull String data1, @NotNull String data2) {
        Intrinsics.checkNotNullParameter(questName, "questName");
        Intrinsics.checkNotNullParameter(assigner, "assigner");
        Intrinsics.checkNotNullParameter(assignee, "assignee");
        Intrinsics.checkNotNullParameter(data1, "data1");
        Intrinsics.checkNotNullParameter(data2, "data2");
        this.questName = questName;
        this.assigner = assigner;
        this.assignee = assignee;
        this.assignedOnTurn = assignedOnTurn;
        this.data1 = data1;
        this.data2 = data2;
    }

    public /* synthetic */ AssignedQuest(String string, String string2, String string3, int n, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "";
        }
        if ((n2 & 0x20) != 0) {
            string5 = "";
        }
        this(string, string2, string3, n, string4, string5);
    }

    @NotNull
    public final String getQuestName() {
        return this.questName;
    }

    @NotNull
    public final String getAssigner() {
        return this.assigner;
    }

    @NotNull
    public final String getAssignee() {
        return this.assignee;
    }

    public final int getAssignedOnTurn() {
        return this.assignedOnTurn;
    }

    @NotNull
    public final String getData1() {
        return this.data1;
    }

    @NotNull
    public final String getData2() {
        return this.data2;
    }

    @NotNull
    public final QuestName getQuestNameInstance() {
        Quest quest = this.questObject;
        if (quest == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest = null;
        }
        return quest.getQuestNameInstance();
    }

    public final void setTransients$core(@NotNull GameInfo gameInfo, @Nullable Quest quest) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.gameInfo = gameInfo;
        Quest quest2 = quest;
        if (quest2 == null) {
            Quest quest3 = gameInfo.getRuleset().getQuests().get(this.questName);
            Intrinsics.checkNotNull(quest3);
            quest2 = quest3;
        }
        this.questObject = quest2;
    }

    public static /* synthetic */ void setTransients$core$default(AssignedQuest assignedQuest, GameInfo gameInfo, Quest quest, int n, Object object) {
        if ((n & 2) != 0) {
            quest = null;
        }
        assignedQuest.setTransients$core(gameInfo, quest);
    }

    @Readonly
    public final boolean isIndividual() {
        return !this.isGlobal();
    }

    @Readonly
    public final boolean isGlobal() {
        Quest quest = this.questObject;
        if (quest == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest = null;
        }
        return quest.isGlobal();
    }

    @Readonly
    public final boolean doesExpire() {
        Quest quest = this.questObject;
        if (quest == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest = null;
        }
        return quest.getDuration() > 0;
    }

    @Readonly
    public final boolean isExpired() {
        return this.doesExpire() && this.getRemainingTurns() == 0;
    }

    @Readonly
    public final int getDuration() {
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
            gameInfo = null;
        }
        float f = gameInfo.getSpeed().getModifier();
        Quest quest = this.questObject;
        if (quest == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest = null;
        }
        return (int)(f * (float)quest.getDuration());
    }

    @Readonly
    public final int getRemainingTurns() {
        int n = this.assignedOnTurn + this.getDuration();
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
            gameInfo = null;
        }
        return RangesKt.coerceAtLeast(n - gameInfo.getTurns(), 0);
    }

    @Readonly
    public final float getInfluence() {
        Quest quest = this.questObject;
        if (quest == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest = null;
        }
        return quest.getInfluence();
    }

    @Readonly
    @NotNull
    public final String getDescription() {
        Quest quest = this.questObject;
        if (quest == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest = null;
        }
        String[] stringArray = new String[]{this.data1};
        return TranslationsKt.fillPlaceholders(quest.getDescription(), stringArray);
    }

    public final void onClickAction() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getQuestNameInstance().ordinal()]) {
            case 1: {
                GUI.INSTANCE.resetToWorldScreen();
                WorldMapHolder.setCenterPosition$default(GUI.INSTANCE.getMap(), new Vector2(Float.parseFloat(this.data1), Float.parseFloat(this.data2)), false, false, null, 10, null);
                break;
            }
            case 2: {
                GUI.INSTANCE.resetToWorldScreen();
                WorldMapHolder worldMapHolder = GUI.INSTANCE.getMap();
                GameInfo gameInfo = this.gameInfo;
                if (gameInfo == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
                    gameInfo = null;
                }
                City city = Civilization.getCapital$default(gameInfo.getCivilization(this.assigner), false, 1, null);
                Intrinsics.checkNotNull(city);
                WorldMapHolder.setCenterPosition$default(worldMapHolder, city.getLocation(), false, false, null, 10, null);
                break;
            }
        }
    }

    public AssignedQuest() {
        this(null, null, null, 0, null, null, 63, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QuestName.values().length];
            try {
                nArray[QuestName.ClearBarbarianCamp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.Route.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

