/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0000H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001cH\u0003J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/unciv/logic/civilization/managers/RuinsManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "lastChosenRewards", "", "", "<init>", "(Ljava/util/List;)V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "validRewards", "", "Lcom/unciv/models/ruleset/RuinReward;", "getValidRewards", "()Ljava/util/Collection;", "setValidRewards", "(Ljava/util/Collection;)V", "clone", "setTransients", "", "rememberReward", "reward", "getShuffledPossibleRewards", "", "triggeringUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isPossibleReward", "", "ruinReward", "unit", "selectNextRuinsReward", "core"})
@SourceDebugExtension(value={"SMAP\nRuinsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuinsManager.kt\ncom/unciv/logic/civilization/managers/RuinsManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,77:1\n1255#2,2:78\n*S KotlinDebug\n*F\n+ 1 RuinsManager.kt\ncom/unciv/logic/civilization/managers/RuinsManager\n*L\n57#1:78,2\n*E\n"})
public final class RuinsManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    private List<String> lastChosenRewards;
    public transient Civilization civInfo;
    public transient Collection<RuinReward> validRewards;

    public RuinsManager(@NotNull List<String> lastChosenRewards) {
        Intrinsics.checkNotNullParameter(lastChosenRewards, "lastChosenRewards");
        this.lastChosenRewards = lastChosenRewards;
    }

    public /* synthetic */ RuinsManager(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String[] stringArray = new String[]{"", ""};
            list2 = CollectionsKt.mutableListOf(stringArray);
        }
        this(list2);
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final Collection<RuinReward> getValidRewards() {
        Collection<RuinReward> collection = this.validRewards;
        if (collection != null) {
            return collection;
        }
        Intrinsics.throwUninitializedPropertyAccessException("validRewards");
        return null;
    }

    public final void setValidRewards(@NotNull Collection<RuinReward> collection) {
        Intrinsics.checkNotNullParameter(collection, "<set-?>");
        this.validRewards = collection;
    }

    @Readonly
    @NotNull
    public final RuinsManager clone() {
        return new RuinsManager(new ArrayList(this.lastChosenRewards));
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setCivInfo(civInfo);
        Collection<RuinReward> collection = civInfo.getGameInfo().getRuleset().getRuinRewards().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        this.setValidRewards(collection);
    }

    private final void rememberReward(String reward) {
        this.lastChosenRewards.set(0, this.lastChosenRewards.get(1));
        this.lastChosenRewards.set(1, reward);
    }

    @Readonly
    private final Iterable<RuinReward> getShuffledPossibleRewards(MapUnit triggeringUnit) {
        List candidates = SequencesKt.toMutableList(SequencesKt.flatMap(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getValidRewards()), arg_0 -> RuinsManager.getShuffledPossibleRewards$lambda$0(this, triggeringUnit, arg_0)), RuinsManager::getShuffledPossibleRewards$lambda$1));
        CollectionsKt.shuffle(candidates, RandomKt.Random(triggeringUnit.getTile().getPosition().hashCode()));
        return candidates;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final boolean isPossibleReward(RuinReward ruinReward, MapUnit unit) {
        boolean bl;
        block4: {
            void $this$any$iv;
            if (this.lastChosenRewards.contains(ruinReward.getName())) {
                return false;
            }
            if (ruinReward.isUnavailableBySettings(this.getCivInfo().getGameInfo())) {
                return false;
            }
            GameContext gameContext = new GameContext(this.getCivInfo(), null, unit, unit.getTile(), null, null, null, null, null, null, false, 2034, null);
            if (ruinReward.hasUnique(UniqueType.Unavailable, gameContext)) {
                return false;
            }
            Sequence<Unique> sequence = ruinReward.getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!(!it.conditionalsApply(gameContext))) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return !bl;
    }

    public final void selectNextRuinsReward(@NotNull MapUnit triggeringUnit) {
        Intrinsics.checkNotNullParameter(triggeringUnit, "triggeringUnit");
        for (RuinReward possibleReward : this.getShuffledPossibleRewards(triggeringUnit)) {
            boolean atLeastOneUniqueHadEffect = false;
            for (Unique unique : possibleReward.getUniqueObjects()) {
                boolean uniqueTriggered = unique.conditionalsApply(triggeringUnit.getCache().getState()) && UniqueTriggerActivation.INSTANCE.triggerUnique(unique, triggeringUnit, possibleReward.getNotification(), "from the ruins");
                atLeastOneUniqueHadEffect = atLeastOneUniqueHadEffect || uniqueTriggered;
            }
            if (!atLeastOneUniqueHadEffect) continue;
            this.rememberReward(possibleReward.getName());
            break;
        }
    }

    private static final boolean getShuffledPossibleRewards$lambda$0(RuinsManager this$0, MapUnit $triggeringUnit, RuinReward it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.isPossibleReward(it, $triggeringUnit);
    }

    private static final Sequence getShuffledPossibleRewards$lambda$1(RuinReward reward) {
        Intrinsics.checkNotNullParameter(reward, "reward");
        return SequencesKt.take(SequencesKt.generateSequence(() -> RuinsManager.getShuffledPossibleRewards$lambda$1$0(reward)), reward.getWeight());
    }

    private static final RuinReward getShuffledPossibleRewards$lambda$1$0(RuinReward $reward) {
        return $reward;
    }

    public RuinsManager() {
        this(null, 1, null);
    }
}

