/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.IconTextButtonKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.pickerscreens.CityRenamePopup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityScreenCityPickerTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "update", "", "core"})
@SourceDebugExtension(value={"SMAP\nCityScreenCityPickerTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityScreenCityPickerTable.kt\ncom/unciv/ui/screens/cityscreen/CityScreenCityPickerTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class CityScreenCityPickerTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;

    public CityScreenCityPickerTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
    }

    public final void update() {
        Cell<Actor> cell;
        Object $this$update_u24lambda_u242;
        Object starImage;
        Object object;
        Cell<Actor> cell2;
        City city = this.cityScreen.getCity$core();
        Civilization civInfo = city.getCiv();
        this.setBackground(BaseScreen.Companion.getSkinStrings().getUiBackground("CityScreen/CityPickerTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), civInfo.getNation().getOuterColor()));
        this.clear();
        if (this.cityScreen.getViewableCities().size() > 1) {
            Table prevCityButton = new Table();
            Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/BackArrow", null, 2, null);
            image.setColor(civInfo.getNation().getInnerColor());
            prevCityButton.add((Actor)image).size(25.0f).pad(10.0f);
            prevCityButton.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(prevCityButton, () -> CityScreenCityPickerTable.update$lambda$0(this));
            cell2 = this.add((Actor)prevCityButton).pad(10.0f);
        } else {
            cell2 = this.add();
        }
        Table cityNameTable = new Table();
        if (city.isBeingRazed()) {
            Image fireImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Fire", null, 2, null);
            cityNameTable.add((Actor)fireImage).size(20.0f).padRight(5.0f);
        }
        if (city.isPuppet()) {
            object = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Puppet", null, 2, null);
            Image $this$update_u24lambda_u241 = object;
            boolean bl = false;
            $this$update_u24lambda_u241.setColor(Color.LIGHT_GRAY);
            starImage = object;
            cityNameTable.add((Actor)starImage).size(20.0f).padRight(5.0f);
        }
        if (city.isInResistance()) {
            Image resistanceImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, "StatIcons/Resistance", null, 2, null);
            cityNameTable.add((Actor)resistanceImage).size(20.0f).padRight(5.0f);
        }
        if (city.isCapital()) {
            $this$update_u24lambda_u242 = object = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Star", null, 2, null);
            boolean bl2 = false;
            ((Actor)$this$update_u24lambda_u242).setColor(Color.LIGHT_GRAY);
            starImage = object;
            cityNameTable.add((Actor)starImage).size(20.0f).padRight(5.0f);
        }
        object = city.getName();
        $this$update_u24lambda_u242 = civInfo.getNation().getInnerColor();
        Label currentCityLabel = Scene2dExtensionsKt.toLabel$default((String)object, (Color)$this$update_u24lambda_u242, 30, 0, true, 4, null);
        if (this.cityScreen.getCanChangeState()) {
            ActivationExtensionsKt.onClick(currentCityLabel, () -> CityScreenCityPickerTable.update$lambda$3(this, city));
        }
        currentCityLabel.setEllipsis(true);
        Cell<Actor> cell3 = cityNameTable.add((Actor)currentCityLabel).minWidth(0.0f);
        Intrinsics.checkNotNullExpressionValue(cell3, "minWidth(...)");
        IconTextButtonKt.padTopDescent(cell3);
        City $this$update_u24lambda_u244 = city;
        boolean bl = false;
        $this$update_u24lambda_u242 = " (" + $this$update_u24lambda_u244.getPopulation().getPopulation() + ')';
        Color bl2 = civInfo.getNation().getInnerColor();
        Label currentCityPop = Scene2dExtensionsKt.toLabel$default((String)$this$update_u24lambda_u242, bl2, 30, 0, true, 4, null);
        Cell<Actor> cell4 = cityNameTable.add((Actor)currentCityPop);
        Intrinsics.checkNotNullExpressionValue(cell4, "add(...)");
        IconTextButtonKt.padTopDescent(cell4);
        MapUnit garrison = city.getGarrison();
        if (garrison != null) {
            cityNameTable.add((Actor)new UnitIconGroup(garrison, 30.0f)).padLeft(5.0f);
        }
        float width = this.cityScreen.isCrampedPortrait() ? this.getStage().getWidth() / (float)3 : this.getStage().getWidth() / (float)4;
        this.add((Actor)cityNameTable).width(width);
        if (this.cityScreen.getViewableCities().size() > 1) {
            Table nextCityButton = new Table();
            Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/BackArrow", null, 2, null);
            image.setSize(25.0f, 25.0f);
            image.setOrigin(1);
            image.setRotation(180.0f);
            image.setColor(civInfo.getNation().getInnerColor());
            nextCityButton.add((Actor)image).size(25.0f).pad(10.0f);
            nextCityButton.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(nextCityButton, () -> CityScreenCityPickerTable.update$lambda$5(this));
            cell = this.add((Actor)nextCityButton).pad(10.0f);
        } else {
            cell = this.add();
        }
        this.pack();
    }

    private static final Unit update$lambda$0(CityScreenCityPickerTable this$0) {
        this$0.cityScreen.page(-1);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3(CityScreenCityPickerTable this$0, City $city) {
        new CityRenamePopup(this$0.cityScreen, $city, () -> CityScreenCityPickerTable.update$lambda$3$0(this$0, $city));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3$0(CityScreenCityPickerTable this$0, City $city) {
        this$0.cityScreen.getGame().replaceCurrentScreen(new CityScreen($city, null, null, null, 14, null));
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$5(CityScreenCityPickerTable this$0) {
        this$0.cityScreen.page(1);
        return Unit.INSTANCE;
    }
}

