/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.map.MapParameters;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.newgamescreen.MapFileSelectTable;
import com.unciv.ui.screens.newgamescreen.MapParametersTable;
import com.unciv.ui.screens.newgamescreen.NewGameScreen;
import com.unciv.ui.screens.newgamescreen.ScenarioSelectTable;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/newgamescreen/MapOptionsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "newGameScreen", "Lcom/unciv/ui/screens/newgamescreen/NewGameScreen;", "<init>", "(Lcom/unciv/ui/screens/newgamescreen/NewGameScreen;)V", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "mapTypeSpecificTable", "generatedMapOptionsTable", "Lcom/unciv/ui/screens/newgamescreen/MapParametersTable;", "getGeneratedMapOptionsTable$core", "()Lcom/unciv/ui/screens/newgamescreen/MapParametersTable;", "randomMapOptionsTable", "savedMapOptionsTable", "Lcom/unciv/ui/screens/newgamescreen/MapFileSelectTable;", "scenarioOptionsTable", "Lcom/unciv/ui/screens/newgamescreen/ScenarioSelectTable;", "mapTypeSelectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "getMapTypeSelectBox$core", "()Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "getSelectedScenario", "Lcom/unciv/ui/screens/newgamescreen/ScenarioSelectTable$ScenarioData;", "getSelectedScenario$core", "cancelBackgroundJobs", "", "cancelBackgroundJobs$core", "core"})
public final class MapOptionsTable
extends Table {
    @NotNull
    private final NewGameScreen newGameScreen;
    @NotNull
    private final MapParameters mapParameters;
    @NotNull
    private Table mapTypeSpecificTable;
    @NotNull
    private final MapParametersTable generatedMapOptionsTable;
    @NotNull
    private final MapParametersTable randomMapOptionsTable;
    @NotNull
    private final MapFileSelectTable savedMapOptionsTable;
    @NotNull
    private final ScenarioSelectTable scenarioOptionsTable;
    @NotNull
    private final TranslatedSelectBox mapTypeSelectBox;

    public MapOptionsTable(@NotNull NewGameScreen newGameScreen) {
        Intrinsics.checkNotNullParameter(newGameScreen, "newGameScreen");
        this.newGameScreen = newGameScreen;
        this.mapParameters = this.newGameScreen.getGameSetupInfo().getMapParameters();
        this.mapTypeSpecificTable = new Table();
        this.generatedMapOptionsTable = new MapParametersTable(this.newGameScreen, this.mapParameters, "Generated", false, null, 24, null);
        this.randomMapOptionsTable = new MapParametersTable(this.newGameScreen, this.mapParameters, "Random Generated", false, null, 24, null);
        this.savedMapOptionsTable = new MapFileSelectTable(this.newGameScreen, this.mapParameters);
        this.scenarioOptionsTable = new ScenarioSelectTable(this.newGameScreen);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/MapOptionsTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        String[] stringArray = new String[]{"Generated", "Random Generated"};
        ArrayList<String> mapTypes = CollectionsKt.arrayListOf(stringArray);
        if (this.savedMapOptionsTable.isNotEmpty()) {
            mapTypes.add("Custom");
        }
        if (SequencesKt.any(this.newGameScreen.getGame().getFiles().getScenarioFiles())) {
            mapTypes.add("Scenario");
        }
        this.mapTypeSelectBox = new TranslatedSelectBox((Collection<String>)mapTypes, "Generated");
        MapOptionsTable._init_$updateOnMapTypeChange(this);
        ActivationExtensionsKt.onChange(this.mapTypeSelectBox, arg_0 -> MapOptionsTable._init_$lambda$0(this, arg_0));
        Table mapTypeSelectWrapper = new Table();
        mapTypeSelectWrapper.add((Actor)Scene2dExtensionsKt.toLabel("{Map Type}:")).left().expandX();
        mapTypeSelectWrapper.add((Actor)this.mapTypeSelectBox).right();
        this.add((Actor)mapTypeSelectWrapper).pad(10.0f).fillX().row();
        this.add((Actor)this.mapTypeSpecificTable).row();
    }

    @NotNull
    public final MapParametersTable getGeneratedMapOptionsTable$core() {
        return this.generatedMapOptionsTable;
    }

    @NotNull
    public final TranslatedSelectBox getMapTypeSelectBox$core() {
        return this.mapTypeSelectBox;
    }

    @Nullable
    public final ScenarioSelectTable.ScenarioData getSelectedScenario$core() {
        if (!Intrinsics.areEqual(((TranslatedSelectBox.TranslatedString)this.mapTypeSelectBox.getSelected()).getValue(), "Scenario")) {
            return null;
        }
        return this.scenarioOptionsTable.getSelectedScenario();
    }

    public final void cancelBackgroundJobs$core() {
        this.savedMapOptionsTable.cancelBackgroundJobs$core();
    }

    private static final void _init_$updateOnMapTypeChange(MapOptionsTable this$0) {
        this$0.mapTypeSpecificTable.clear();
        switch (((TranslatedSelectBox.TranslatedString)this$0.mapTypeSelectBox.getSelected()).getValue()) {
            case "Custom": {
                this$0.mapParameters.setType("Custom");
                this$0.mapTypeSpecificTable.add((Actor)this$0.savedMapOptionsTable);
                this$0.savedMapOptionsTable.activateCustomMaps();
                this$0.newGameScreen.unlockTables();
                break;
            }
            case "Generated": {
                this$0.mapParameters.setName("");
                this$0.mapParameters.setType(((TranslatedSelectBox.TranslatedString)this$0.generatedMapOptionsTable.getMapTypeSelectBox().getSelected()).getValue());
                this$0.mapTypeSpecificTable.add((Actor)this$0.generatedMapOptionsTable);
                this$0.newGameScreen.unlockTables();
                break;
            }
            case "Random Generated": {
                this$0.mapParameters.setName("");
                this$0.mapTypeSpecificTable.add((Actor)this$0.randomMapOptionsTable);
                this$0.newGameScreen.unlockTables();
                break;
            }
            case "Scenario": {
                this$0.mapParameters.setName("");
                this$0.mapTypeSpecificTable.add((Actor)this$0.scenarioOptionsTable);
                this$0.scenarioOptionsTable.selectScenario();
                this$0.newGameScreen.lockTables();
            }
        }
        this$0.newGameScreen.getGameSetupInfo().getGameParameters().setGodMode(false);
        this$0.newGameScreen.updateTables();
    }

    private static final Unit _init_$lambda$0(MapOptionsTable this$0, ChangeListener.ChangeEvent it) {
        MapOptionsTable._init_$updateOnMapTypeChange(this$0);
        return Unit.INSTANCE;
    }
}

