/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.VictoryData;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.newgamescreen.NewGameScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCharts;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivRankings;
import com.unciv.ui.screens.victoryscreen.VictoryScreenDemographics;
import com.unciv.ui.screens.victoryscreen.VictoryScreenGlobalVictory;
import com.unciv.ui.screens.victoryscreen.VictoryScreenIllustrations;
import com.unciv.ui.screens.victoryscreen.VictoryScreenOurVictory;
import com.unciv.ui.screens.victoryscreen.VictoryScreenReplay;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002 !B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J!\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "pageNumber", "", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;I)V", "music", "Lcom/unciv/ui/audio/MusicController;", "getMusic", "()Lcom/unciv/ui/audio/MusicController;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "tabs", "Lcom/unciv/ui/components/widgets/TabbedPager;", "displayWinner", "", "victoryData", "Lcom/unciv/logic/VictoryData;", "displayWonOrLost", "descriptions", "", "", "([Ljava/lang/String;)V", "show", "dispose", "recreate", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "CivWithStat", "VictoryTabs", "core"})
public final class VictoryScreen
extends PickerScreen
implements RecreateOnResize {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final Civilization playerCiv;
    @NotNull
    private final TabbedPager tabs;

    public VictoryScreen(@NotNull WorldScreen worldScreen, int pageNumber) {
        Object tab2;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(false, 1, null);
        this.worldScreen = worldScreen;
        this.gameInfo = this.worldScreen.getGameInfo();
        this.playerCiv = this.worldScreen.getViewingCiv();
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.tabs = new TabbedPager(0.0f, 0.0f, 0.0f, 0.0f, 0, null, null, null, 0.0f, color, this, 0, 2559, null);
        this.worldScreen.getAutoPlay().stopAutoPlay();
        this.getSplitPane().setFirstWidget(this.tabs);
        float iconSize = 24.0f;
        for (Object tab2 : VictoryTabs.getEntries()) {
            boolean tabHidden = tab2.isHidden(this.playerCiv);
            if (tabHidden) {
                if (!tab2.getAllowAsSecret()) continue;
                Input input2 = Gdx.input;
                Intrinsics.checkNotNullExpressionValue(input2, "input");
                if (!Scene2dExtensionsKt.areSecretKeysPressed(input2)) continue;
            }
            Image icon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "VictoryScreenIcons/" + tab2.name(), null, 2, null);
            TabbedPager tabbedPager = this.tabs;
            String string = tab2.getCaption();
            if (string == null) {
                string = tab2.name();
            }
            String string2 = string;
            Table table2 = tab2.getContent(this);
            KeyCharAndCode keyCharAndCode = new KeyCharAndCode(tab2.getKey());
            boolean bl = tabHidden && tab2.getAllowAsSecret();
            TabbedPager.addPage$default(tabbedPager, string2, table2, icon, iconSize, 0, bl, false, keyCharAndCode, 10, false, 592, null);
        }
        TabbedPager.selectPage$default(this.tabs, pageNumber, false, 2, null);
        if (this.gameInfo.getVictoryData() != null) {
            VictoryData victoryData = this.gameInfo.getVictoryData();
            Intrinsics.checkNotNull(victoryData);
            this.displayWinner(victoryData);
        } else if (this.playerCiv.isDefeated()) {
            String[] stringArray = new String[]{new Victory().getDefeatString()};
            this.displayWonOrLost(stringArray);
            MusicController musicController = this.getMusic();
            String string = this.playerCiv.getCivName();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
            musicController.chooseTrack(string, "Defeat", enumSet);
        } else {
            this.getRightSideButton().setVisible(false);
            this.setDefaultCloseAction();
        }
        this.tabs.pack();
        VictoryTabs $this$_init__u24lambda_u240 = tab2 = new VerticalGroup();
        boolean bl = false;
        ((VerticalGroup)((Object)$this$_init__u24lambda_u240)).space(5.0f);
        ((VerticalGroup)((Object)$this$_init__u24lambda_u240)).align(16);
        ((Group)((Object)$this$_init__u24lambda_u240)).addActor(Scene2dExtensionsKt.toLabel("{Game Speed}: {" + this.gameInfo.getGameParameters().getSpeed() + '}'));
        if (this.gameInfo.getGameParameters().getVictoryTypes().contains("Time")) {
            ((Group)((Object)$this$_init__u24lambda_u240)).addActor(Scene2dExtensionsKt.toLabel("{Max Turns}: " + TranslationsKt.tr(this.gameInfo.getGameParameters().getMaxTurns())));
        }
        ((WidgetGroup)((Object)$this$_init__u24lambda_u240)).pack();
        VictoryTabs topRightPanel = tab2;
        Label difficultyLabel = Scene2dExtensionsKt.toLabel("{Difficulty}: {" + this.gameInfo.getDifficulty() + '}');
        float neededSpace = RangesKt.coerceAtLeast(((Actor)((Object)topRightPanel)).getWidth(), difficultyLabel.getWidth()) * (float)2 + this.tabs.getHeaderPrefWidth();
        if (neededSpace > this.getStage().getWidth()) {
            this.tabs.decorateHeader(difficultyLabel, true, false);
            this.tabs.decorateHeader((Actor)((Object)topRightPanel), false, false);
            this.tabs.getHeaderScroll().setFadeScrollBars(false);
        } else {
            float panelY = this.getStage().getHeight() - this.tabs.getRowHeight(0) * 0.5f;
            this.getStage().addActor((Actor)((Object)topRightPanel));
            ((Actor)((Object)topRightPanel)).setPosition(this.getStage().getWidth() - 10.0f, panelY, 16);
            this.getStage().addActor(difficultyLabel);
            difficultyLabel.setPosition(10.0f, panelY, 8);
        }
    }

    public /* synthetic */ VictoryScreen(WorldScreen worldScreen, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(worldScreen, n);
    }

    private final MusicController getMusic() {
        return UncivGame.Companion.getCurrent().getMusicController();
    }

    private final void displayWinner(VictoryData victoryData) {
        Victory victory;
        String winningCiv = victoryData.component1();
        String victoryType = victoryData.component2();
        Victory victory2 = this.gameInfo.getRuleset().getVictories().get(victoryType);
        if (victory2 == null) {
            victory2 = victory = new Victory();
        }
        if (Intrinsics.areEqual(winningCiv, this.playerCiv.getCivName())) {
            String[] stringArray = new String[]{"You have won a [" + victoryType + "] Victory!", victory.getVictoryString()};
            this.displayWonOrLost(stringArray);
            MusicController musicController = this.getMusic();
            String string = victory.getName();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.PrefixMustMatch, (Enum)MusicTrackChooserFlags.SuffixMustMatch);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
            if (!musicController.chooseTrack(string, "Victory", enumSet)) {
                MusicController musicController2 = this.getMusic();
                String string2 = this.playerCiv.getCivName();
                stringArray = new String[]{"Victory", "Theme"};
                List<String> list2 = CollectionsKt.listOf(stringArray);
                EnumSet<Enum> enumSet2 = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
                Intrinsics.checkNotNullExpressionValue(enumSet2, "of(...)");
                musicController2.chooseTrack(string2, list2, enumSet2);
            }
        } else {
            String[] stringArray = new String[]{'[' + winningCiv + "] has won a [" + victoryType + "] Victory!", victory.getDefeatString()};
            this.displayWonOrLost(stringArray);
            MusicController musicController = this.getMusic();
            String string = victory.getName();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.PrefixMustMatch, (Enum)MusicTrackChooserFlags.SuffixMustMatch);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
            if (!musicController.chooseTrack(string, "Defeat", enumSet)) {
                MusicController musicController3 = this.getMusic();
                String string3 = this.playerCiv.getCivName();
                EnumSet<Enum> enumSet3 = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
                Intrinsics.checkNotNullExpressionValue(enumSet3, "of(...)");
                musicController3.chooseTrack(string3, "Defeat", enumSet3);
            }
        }
        this.worldScreen.getAutoPlay().stopAutoPlay();
    }

    private final void displayWonOrLost(String ... descriptions) {
        this.getDescriptionLabel().setText(ArraysKt.joinToString$default(descriptions, (CharSequence)"\n", null, null, 0, null, VictoryScreen::displayWonOrLost$lambda$0, 30, null));
        this.getRightSideButton().setText(TranslationsKt.tr$default("Start new game", false, false, 3, null));
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        ActivationExtensionsKt.onClick(this.getRightSideButton(), () -> VictoryScreen.displayWonOrLost$lambda$1(this));
        this.getCloseButton().setText(TranslationsKt.tr$default("One more turn...!", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getCloseButton(), () -> VictoryScreen.displayWonOrLost$lambda$2(this));
    }

    @Override
    public void show() {
        super.show();
        this.tabs.askForPassword(2747985);
    }

    @Override
    public void dispose() {
        TabbedPager.selectPage$default(this.tabs, -1, false, 2, null);
        super.dispose();
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return new VictoryScreen(this.worldScreen, this.tabs.getActivePage());
    }

    private static final CharSequence displayWonOrLost$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    private static final Unit displayWonOrLost$lambda$1(VictoryScreen this$0) {
        GameSetupInfo newGameSetupInfo = new GameSetupInfo(this$0.gameInfo);
        newGameSetupInfo.getMapParameters().reseed();
        this$0.getGame().pushScreen(new NewGameScreen(newGameSetupInfo));
        return Unit.INSTANCE;
    }

    private static final Unit displayWonOrLost$lambda$2(VictoryScreen this$0) {
        this$0.gameInfo.setOneMoreTurnMode(true);
        this$0.getGame().popScreen();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$CivWithStat;", "", "civ", "Lcom/unciv/logic/civilization/Civilization;", "value", "", "<init>", "(Lcom/unciv/logic/civilization/Civilization;I)V", "category", "Lcom/unciv/ui/screens/victoryscreen/RankingType;", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/victoryscreen/RankingType;)V", "getCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getValue", "()I", "core"})
    public static final class CivWithStat {
        @NotNull
        private final Civilization civ;
        private final int value;

        public CivWithStat(@NotNull Civilization civ, int value) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            this.civ = civ;
            this.value = value;
        }

        @NotNull
        public final Civilization getCiv() {
            return this.civ;
        }

        public final int getValue() {
            return this.value;
        }

        public CivWithStat(@NotNull Civilization civ, @NotNull RankingType category) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            Intrinsics.checkNotNullParameter((Object)category, "category");
            this(civ, civ.getStatForRanking(category));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u001e"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "", "key", "", "caption", "", "allowAsSecret", "", "<init>", "(Ljava/lang/String;ICLjava/lang/String;Z)V", "getKey", "()C", "getCaption", "()Ljava/lang/String;", "getAllowAsSecret", "()Z", "OurStatus", "Global", "Illustration", "Demographics", "Rankings", "Charts", "Replay", "getContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
    private static final abstract class VictoryTabs
    extends Enum<VictoryTabs> {
        private final char key;
        @Nullable
        private final String caption;
        private final boolean allowAsSecret;
        public static final /* enum */ VictoryTabs OurStatus = new OurStatus("OurStatus", 0);
        public static final /* enum */ VictoryTabs Global = new Global("Global", 1);
        public static final /* enum */ VictoryTabs Illustration = new Illustration("Illustration", 2);
        public static final /* enum */ VictoryTabs Demographics = new Demographics("Demographics", 3);
        public static final /* enum */ VictoryTabs Rankings = new Rankings("Rankings", 4);
        public static final /* enum */ VictoryTabs Charts = new Charts("Charts", 5);
        public static final /* enum */ VictoryTabs Replay = new Replay("Replay", 6);
        private static final /* synthetic */ VictoryTabs[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VictoryTabs(char key, String caption, boolean allowAsSecret) {
            this.key = key;
            this.caption = caption;
            this.allowAsSecret = allowAsSecret;
        }

        /* synthetic */ VictoryTabs(String string, int n, char c, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(c, string2, bl);
        }

        public final char getKey() {
            return this.key;
        }

        @Nullable
        public final String getCaption() {
            return this.caption;
        }

        public final boolean getAllowAsSecret() {
            return this.allowAsSecret;
        }

        @NotNull
        public abstract Table getContent(@NotNull VictoryScreen var1);

        public boolean isHidden(@NotNull Civilization playerCiv) {
            Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
            return false;
        }

        public static VictoryTabs[] values() {
            return (VictoryTabs[])$VALUES.clone();
        }

        public static VictoryTabs valueOf(String value) {
            return Enum.valueOf(VictoryTabs.class, value);
        }

        @NotNull
        public static EnumEntries<VictoryTabs> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = victoryTabsArray = new VictoryTabs[]{VictoryTabs.OurStatus, VictoryTabs.Global, VictoryTabs.Illustration, VictoryTabs.Demographics, VictoryTabs.Rankings, VictoryTabs.Charts, VictoryTabs.Replay};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreen.VictoryTabs.Charts", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCharts;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Charts
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Charts() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenCharts getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenCharts(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !playerCiv.isSpectator() && playerCiv.getStatsHistory().size() < 2;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreen.VictoryTabs.Demographics", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenDemographics;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Demographics
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Demographics() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenDemographics getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenDemographics(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !UncivGame.Companion.getCurrent().getSettings().getUseDemographics();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreen.VictoryTabs.Global", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenGlobalVictory;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "core"})
        static final class Global
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Global() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenGlobalVictory getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenGlobalVictory(parent.worldScreen);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreen.VictoryTabs.Illustration", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Illustration
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Illustration() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenIllustrations getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenIllustrations(parent, parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !VictoryScreenIllustrations.Companion.enablePage$core(playerCiv.getGameInfo());
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreen.VictoryTabs.OurStatus", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenOurVictory;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class OurStatus
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            OurStatus() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenOurVictory getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenOurVictory(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return playerCiv.isSpectator();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreen.VictoryTabs.Rankings", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivRankings;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Rankings
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Rankings() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenCivRankings getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenCivRankings(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return UncivGame.Companion.getCurrent().getSettings().getUseDemographics();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreen.VictoryTabs.Replay", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenReplay;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Replay
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Replay() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenReplay getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenReplay(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !playerCiv.isSpectator() && playerCiv.getGameInfo().getVictoryData() == null && playerCiv.isAlive() && playerCiv.getGameInfo().getTurns() < 5;
            }
        }
    }
}

