/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.Constants;
import com.unciv.logic.MultiFilter;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ModConstants;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0012H\u0017J\u0012\u0010#\u001a\u00020\t2\b\b\u0002\u0010$\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/unciv/logic/battle/CityCombatant;", "Lcom/unciv/logic/battle/ICombatant;", "city", "Lcom/unciv/logic/city/City;", "<init>", "(Lcom/unciv/logic/city/City;)V", "getCity", "()Lcom/unciv/logic/city/City;", "getMaxHealth", "", "getHealth", "getCivInfo", "Lcom/unciv/logic/civilization/Civilization;", "getTile", "Lcom/unciv/logic/map/tile/Tile;", "getName", "", "isDefeated", "", "isInvisible", "to", "canAttack", "matchesFilter", "filter", "multiFilter", "getAttackSound", "Lcom/unciv/models/UncivSound;", "takeDamage", "", "damage", "getUnitType", "Lcom/unciv/models/ruleset/unit/UnitType;", "getAttackingStrength", "getDefendingStrength", "attackedByRanged", "getCityStrength", "combatAction", "Lcom/unciv/logic/battle/CombatAction;", "toString", "core"})
public final class CityCombatant
implements ICombatant {
    @NotNull
    private final City city;

    public CityCombatant(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        this.city = city;
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @Override
    public int getMaxHealth() {
        return this.city.getMaxHealth$core();
    }

    @Override
    public int getHealth() {
        return this.city.getHealth();
    }

    @Override
    @Readonly
    @NotNull
    public Civilization getCivInfo() {
        return this.city.getCiv();
    }

    @Override
    @NotNull
    public Tile getTile() {
        return this.city.getCenterTile();
    }

    @Override
    @NotNull
    public String getName() {
        return this.city.getName();
    }

    @Override
    @Readonly
    public boolean isDefeated() {
        return this.city.getHealth() == 1;
    }

    @Override
    public boolean isInvisible(@NotNull Civilization to) {
        Intrinsics.checkNotNullParameter(to, "to");
        return false;
    }

    @Override
    public boolean canAttack() {
        return this.city.canBombard();
    }

    @Override
    public boolean matchesFilter(@NotNull String filter2, boolean multiFilter) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return multiFilter ? MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> CityCombatant.matchesFilter$lambda$0(this, arg_0), false, 4, null) : Intrinsics.areEqual(filter2, "City") || Constants.INSTANCE.getAll().contains(filter2) || City.matchesFilter$default(this.city, filter2, null, false, 2, null);
    }

    @Override
    @NotNull
    public UncivSound getAttackSound() {
        return UncivSound.Companion.getBombard();
    }

    @Override
    public void takeDamage(int damage) {
        City city = this.city;
        city.setHealth(city.getHealth() - damage);
        if (this.city.getHealth() < 1) {
            this.city.setHealth(1);
        }
    }

    @Override
    @NotNull
    public UnitType getUnitType() {
        return UnitType.Companion.getCity();
    }

    @Override
    public int getAttackingStrength() {
        return MathKt.roundToInt((double)this.getCityStrength(CombatAction.Attack) * 0.75);
    }

    @Override
    @Readonly
    public int getDefendingStrength(boolean attackedByRanged) {
        if (this.isDefeated()) {
            return 1;
        }
        return CityCombatant.getCityStrength$default(this, null, 1, null);
    }

    @Readonly
    public final int getCityStrength(@NotNull CombatAction combatAction) {
        Intrinsics.checkNotNullParameter((Object)combatAction, "combatAction");
        ModConstants modConstants = this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants();
        double strength = modConstants.getCityStrengthBase();
        strength += (double)this.city.getPopulation().getPopulation() * modConstants.getCityStrengthPerPop();
        Tile cityTile = this.city.getCenterTile();
        Iterator iterator2 = SequencesKt.flatMap(cityTile.getAllTerrains(), CityCombatant::getCityStrength$lambda$0).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            strength += (double)Integer.parseInt(unique.getParams().get(0));
        }
        int techCount = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().size();
        float techsPercentKnown = techCount > 0 ? (float)this.city.getCiv().getTech().getTechsResearched().size() / (float)techCount : 0.5f;
        strength += Math.pow((double)techsPercentKnown * modConstants.getCityStrengthFromTechsMultiplier(), modConstants.getCityStrengthFromTechsExponent()) * modConstants.getCityStrengthFromTechsFullMultiplier();
        if (cityTile.getMilitaryUnit() != null) {
            MapUnit mapUnit = cityTile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            float f = mapUnit.getBaseUnit().getStrength();
            MapUnit mapUnit2 = cityTile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit2);
            strength += (double)(f * ((float)mapUnit2.getHealth() / 100.0f)) * modConstants.getCityStrengthFromGarrison();
        }
        float buildingsStrength = this.city.getStrength();
        GameContext gameContext = new GameContext(this.getCivInfo(), this.city, null, null, this, null, null, combatAction, null, null, false, 1900, null);
        Iterator<Unique> iterator3 = this.getCivInfo().getMatchingUniques(UniqueType.BetterDefensiveBuildings, gameContext).iterator();
        while (iterator3.hasNext()) {
            Unique unique = iterator3.next();
            buildingsStrength *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return MathKt.roundToInt(strength += (double)buildingsStrength);
    }

    public static /* synthetic */ int getCityStrength$default(CityCombatant cityCombatant, CombatAction combatAction, int n, Object object) {
        if ((n & 1) != 0) {
            combatAction = CombatAction.Defend;
        }
        return cityCombatant.getCityStrength(combatAction);
    }

    @NotNull
    public String toString() {
        return this.city.getName();
    }

    private static final boolean matchesFilter$lambda$0(CityCombatant this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, "City") || Constants.INSTANCE.getAll().contains(it) || City.matchesFilter$default(this$0.city, it, null, false, 2, null);
    }

    private static final Sequence getCityStrength$lambda$0(Terrain it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IHasUniques.getMatchingUniques$default(it, UniqueType.GrantsCityStrength, null, 2, null);
    }
}

