/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.IdChecker;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.newgamescreen.FriendSelectionPopup;
import com.unciv.ui.screens.newgamescreen.IPreviousScreen;
import com.unciv.ui.screens.newgamescreen.NationPickerPopup;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.utils.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020$J\b\u0010(\u001a\u00020$H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u0010-\u001a\u00020$*\u00020\u00012\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010.\u001a\u00020\u00012\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010/\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u00100\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J$\u00101\u001a\r\u0012\t\u0012\u000703\u00a2\u0006\u0002\b4022\n\b\u0002\u00105\u001a\u0004\u0018\u00010&H\u0000\u00a2\u0006\u0002\b6J\u0013\u00107\u001a\b\u0012\u0004\u0012\u00020802H\u0000\u00a2\u0006\u0002\b9R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/unciv/ui/screens/newgamescreen/PlayerPickerTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "previousScreen", "Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "blockWidth", "", "<init>", "(Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;Lcom/unciv/models/metadata/GameParameters;F)V", "getPreviousScreen", "()Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "getGameParameters", "()Lcom/unciv/models/metadata/GameParameters;", "setGameParameters", "(Lcom/unciv/models/metadata/GameParameters;)V", "playerListTable", "getPlayerListTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civBlocksWidth", "getCivBlocksWidth", "()F", "randomNumberLabel", "Lcom/unciv/ui/components/widgets/WrappableLabel;", "locked", "", "getLocked", "()Z", "setLocked", "(Z)V", "noRandom", "getNoRandom", "setNoRandom", "friendList", "Lcom/unciv/logic/multiplayer/FriendList;", "update", "", "desiredCiv", "", "updateRandomNumberLabel", "reassignRemovedModReferences", "assignDesiredCiv", "getPlayerTable", "player", "Lcom/unciv/models/metadata/Player;", "addPlayerTableMultiplayerControls", "getNationTable", "popupFriendPicker", "popupNationPicker", "getAvailablePlayerCivs", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/nation/Nation;", "Lkotlin/jvm/internal/EnhancedNullability;", "dontSkipNation", "getAvailablePlayerCivs$core", "getAvailableFriends", "Lcom/unciv/logic/multiplayer/FriendList$Friend;", "getAvailableFriends$core", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerPickerTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerPickerTable.kt\ncom/unciv/ui/screens/newgamescreen/PlayerPickerTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,404:1\n1#2:405\n205#3,4:406\n1788#4,4:410\n1788#4,4:414\n1761#4,3:418\n295#4,2:421\n2746#4,3:423\n*S KotlinDebug\n*F\n+ 1 PlayerPickerTable.kt\ncom/unciv/ui/screens/newgamescreen/PlayerPickerTable\n*L\n93#1:406,4\n109#1:410,4\n128#1:414,4\n171#1:418,3\n173#1:421,2\n341#1:423,3\n*E\n"})
public final class PlayerPickerTable
extends Table {
    @NotNull
    private final IPreviousScreen previousScreen;
    @NotNull
    private GameParameters gameParameters;
    @NotNull
    private final Table playerListTable;
    private final float civBlocksWidth;
    @Nullable
    private WrappableLabel randomNumberLabel;
    private boolean locked;
    private boolean noRandom;
    @NotNull
    private final FriendList friendList;

    /*
     * WARNING - void declaration
     */
    public PlayerPickerTable(@NotNull IPreviousScreen previousScreen, @NotNull GameParameters gameParameters, float blockWidth) {
        void $this$_init__u24lambda_u241;
        Object player;
        Intrinsics.checkNotNullParameter(previousScreen, "previousScreen");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        this.previousScreen = previousScreen;
        this.gameParameters = gameParameters;
        this.playerListTable = new Table();
        this.civBlocksWidth = blockWidth <= 10.0f ? this.previousScreen.getStage().getWidth() / (float)3 - 5.0f : blockWidth;
        this.friendList = new FriendList();
        Iterator<Player> iterator2 = this.gameParameters.getPlayers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Object object = iterator2;
        while (object.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(object.next(), "next(...)");
            ((Player)player).setPlayerId("");
        }
        this.top();
        this.gameParameters.setShufflePlayerOrder(false);
        this.add((Actor)Scene2dExtensionsKt.toCheckBox("Shuffle Civ Order at Start", false, arg_0 -> PlayerPickerTable._init_$lambda$0(this, arg_0))).padTop(5.0f).padBottom(5.0f).row();
        player = object = new AutoScrollPane((Actor)this.playerListTable, null, 2, null);
        PlayerPickerTable playerPickerTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u241.setOverscroll(false, false);
        playerPickerTable.add((Actor)object).width(this.civBlocksWidth);
        PlayerPickerTable.update$default(this, null, 1, null);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/PlayerPickerTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
    }

    public /* synthetic */ PlayerPickerTable(IPreviousScreen iPreviousScreen, GameParameters gameParameters, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.0f;
        }
        this(iPreviousScreen, gameParameters, f);
    }

    @NotNull
    public final IPreviousScreen getPreviousScreen() {
        return this.previousScreen;
    }

    @NotNull
    public final GameParameters getGameParameters() {
        return this.gameParameters;
    }

    public final void setGameParameters(@NotNull GameParameters gameParameters) {
        Intrinsics.checkNotNullParameter(gameParameters, "<set-?>");
        this.gameParameters = gameParameters;
    }

    @NotNull
    public final Table getPlayerListTable() {
        return this.playerListTable;
    }

    public final float getCivBlocksWidth() {
        return this.civBlocksWidth;
    }

    public final boolean getLocked() {
        return this.locked;
    }

    public final void setLocked(boolean bl) {
        this.locked = bl;
    }

    public final boolean getNoRandom() {
        return this.noRandom;
    }

    public final void setNoRandom(boolean bl) {
        this.noRandom = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull String desiredCiv) {
        block15: {
            boolean bl;
            int newRulesetPlayableCivs;
            int n;
            Iterator<Player> $this$count$iv;
            Intrinsics.checkNotNullParameter(desiredCiv, "desiredCiv");
            this.playerListTable.clear();
            Ruleset gameBasics = this.previousScreen.getRuleset();
            this.reassignRemovedModReferences();
            Map map2 = this.previousScreen.getRuleset().getNations();
            boolean $i$f$count = false;
            if ($this$count$iv.isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator2 = $this$count$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry;
                    Map.Entry it = entry = iterator2.next();
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it.getKey(), "Barbarians") && !IHasUniques.hasUnique$default((IHasUniques)it.getValue(), UniqueType.WillNotBeChosenForNewGames, null, 2, null))) continue;
                    ++count$iv;
                }
                n = newRulesetPlayableCivs = count$iv;
            }
            if (this.gameParameters.getPlayers().size() > newRulesetPlayableCivs) {
                this.gameParameters.setPlayers(new ArrayList<Player>((Collection)this.gameParameters.getPlayers().subList(0, newRulesetPlayableCivs)));
            }
            if (((CharSequence)desiredCiv).length() > 0) {
                this.assignDesiredCiv(desiredCiv);
            }
            Iterator<Player> iterator3 = this.gameParameters.getPlayers().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            $this$count$iv = iterator3;
            while ($this$count$iv.hasNext()) {
                Player player;
                Intrinsics.checkNotNullExpressionValue($this$count$iv.next(), "next(...)");
                this.playerListTable.add((Actor)this.getPlayerTable(player)).width(this.civBlocksWidth).padBottom(20.0f).row();
            }
            boolean isRandomNumberOfPlayers = this.gameParameters.getRandomNumberOfPlayers();
            if (isRandomNumberOfPlayers) {
                Color color = Color.GOLD;
                Intrinsics.checkNotNullExpressionValue(color, "GOLD");
                this.randomNumberLabel = new WrappableLabel("", this.civBlocksWidth - 20.0f, color, 0, false, 24, null);
                this.playerListTable.add((Actor)this.randomNumberLabel).fillX().pad(0.0f, 10.0f, 20.0f, 10.0f).row();
                this.updateRandomNumberLabel();
            }
            if (!this.locked) {
                int n2;
                int n3;
                void $this$count$iv2;
                int n4 = this.gameParameters.getPlayers().size();
                Collection<Nation> collection = gameBasics.getNations().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Iterable player = collection;
                int n5 = n4;
                boolean $i$f$count2 = false;
                if (((Collection)$this$count$iv2).isEmpty()) {
                    n3 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv2) {
                        Nation it = (Nation)element$iv;
                        boolean bl3 = false;
                        if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = n2 = count$iv;
                }
                if (n5 < n2) {
                    Label $this$update_u24lambda_u242 = $i$f$count2 = Scene2dExtensionsKt.toLabel$default("+", ImageGetter.INSTANCE.getCHARCOAL(), 30, 0, false, 12, null);
                    boolean iPreviousScreen = false;
                    $this$update_u24lambda_u242.setAlignment(1);
                    Actor addPlayerButton = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.surroundWithCircle$default($i$f$count2, 50.0f, false, null, null, 14, null), () -> PlayerPickerTable.update$lambda$3(this, isRandomNumberOfPlayers));
                    this.playerListTable.add(addPlayerButton).pad(10.0f);
                }
            }
            Iterable $this$count$iv3 = this.gameParameters.getPlayers();
            boolean $i$f$count3 = false;
            if ($this$count$iv3 instanceof Collection && ((Collection)$this$count$iv3).isEmpty()) {
                bl = false;
            } else {
                void var8_20;
                boolean bl4 = false;
                for (Object element$iv : $this$count$iv3) {
                    Player it = (Player)element$iv;
                    boolean bl5 = false;
                    if (!(it.getPlayerType() == PlayerType.Human) || ++var8_20 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                bl = var8_20;
            }
            boolean humanPlayerCount = bl;
            boolean isValid = humanPlayerCount >= true && (isRandomNumberOfPlayers || this.gameParameters.getPlayers().size() >= 2);
            IPreviousScreen iPreviousScreen = this.previousScreen;
            PickerScreen pickerScreen = iPreviousScreen instanceof PickerScreen ? (PickerScreen)((Object)iPreviousScreen) : null;
            if (pickerScreen == null) break block15;
            pickerScreen.setRightSideButtonEnabled(isValid);
        }
    }

    public static /* synthetic */ void update$default(PlayerPickerTable playerPickerTable, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        playerPickerTable.update(string);
    }

    public final void updateRandomNumberLabel() {
        block0: {
            WrappableLabel wrappableLabel = this.randomNumberLabel;
            if (wrappableLabel == null) break block0;
            WrappableLabel $this$updateRandomNumberLabel_u24lambda_u240 = wrappableLabel;
            boolean bl = false;
            String playerRange = this.gameParameters.getMinNumberOfPlayers() == this.gameParameters.getMaxNumberOfPlayers() ? TranslationsKt.tr(this.gameParameters.getMinNumberOfPlayers()) : this.gameParameters.getMinNumberOfPlayers() + " - " + this.gameParameters.getMaxNumberOfPlayers();
            String numberOfExplicitPlayersText = this.gameParameters.getPlayers().size() == 1 ? "The number of players will be adjusted" : "These [" + this.gameParameters.getPlayers().size() + "] players will be adjusted";
            String text2 = '[' + numberOfExplicitPlayersText + "] to [" + playerRange + "] actual players by adding random AI's or by randomly omitting AI's.";
            $this$updateRandomNumberLabel_u24lambda_u240.setWrap(false);
            this.align(1);
            $this$updateRandomNumberLabel_u24lambda_u240.setText(TranslationsKt.tr$default(text2, false, false, 3, null));
            $this$updateRandomNumberLabel_u24lambda_u240.setWrap(true);
        }
    }

    private final void reassignRemovedModReferences() {
        Iterator<Player> iterator2 = this.gameParameters.getPlayers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Player player;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (this.previousScreen.getRuleset().getNations().containsKey(player.getChosenCiv())) {
                Nation nation = this.previousScreen.getRuleset().getNations().get(player.getChosenCiv());
                Intrinsics.checkNotNull(nation);
                if (!nation.isCityState()) {
                    Nation nation2 = this.previousScreen.getRuleset().getNations().get(player.getChosenCiv());
                    Intrinsics.checkNotNull(nation2);
                    if (!IHasUniques.hasUnique$default(nation2, UniqueType.WillNotBeChosenForNewGames, null, 2, null)) continue;
                }
            }
            player.setChosenCiv("Random");
        }
    }

    private final void assignDesiredCiv(String desiredCiv) {
        block7: {
            Object v1;
            block6: {
                boolean bl;
                block5: {
                    Iterable $this$any$iv = this.gameParameters.getPlayers();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Player it = (Player)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getChosenCiv(), desiredCiv)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                Iterable $this$firstOrNull$iv = this.gameParameters.getPlayers();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Player it = (Player)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual(it.getChosenCiv(), "Random") && it.getPlayerType() == PlayerType.Human)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            Player player = v1;
            if (player == null) break block7;
            player.setChosenCiv(desiredCiv);
        }
    }

    private final Table getPlayerTable(Player player) {
        Table playerTable = new Table();
        playerTable.pad(5.0f);
        playerTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/PlayerPickerTable/PlayerTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.8f), 2, null));
        Table nationTable = this.getNationTable(player);
        playerTable.add((Actor)nationTable).left();
        TextButton playerTypeTextButton = Scene2dExtensionsKt.toTextButton$default(player.getPlayerType().name(), null, false, 3, null);
        playerTable.add((Actor)playerTypeTextButton).width(100.0f).pad(5.0f).right();
        PlayerPickerTable.getPlayerTable$updatePlayerTypeButtonEnabled(playerTypeTextButton, player, this);
        ActivationExtensionsKt.onClick(nationTable, () -> PlayerPickerTable.getPlayerTable$lambda$0(this, player, playerTypeTextButton));
        ActivationExtensionsKt.onClick(playerTypeTextButton, () -> PlayerPickerTable.getPlayerTable$lambda$1(player, this));
        if (!this.locked) {
            playerTable.add(ActivationExtensionsKt.onClick(Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.toLabel$default("-", ImageGetter.INSTANCE.getCHARCOAL(), 30, 1, false, 8, null), 40.0f, false, null, null, 14, null), () -> PlayerPickerTable.getPlayerTable$lambda$2(this, player))).pad(5.0f).right();
        }
        if (this.gameParameters.isOnlineMultiplayer() && player.getPlayerType() == PlayerType.Human) {
            this.addPlayerTableMultiplayerControls(playerTable, player);
        }
        return playerTable;
    }

    private final void addPlayerTableMultiplayerControls(Table $this$addPlayerTableMultiplayerControls, Player player) {
        $this$addPlayerTableMultiplayerControls.row();
        UncivTextField playerIdTextField = new UncivTextField("Please input Player ID!", player.getPlayerId(), null, 4, null);
        $this$addPlayerTableMultiplayerControls.add((Actor)playerIdTextField).colspan(2).fillX().pad(5.0f);
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        Label errorLabel = Scene2dExtensionsKt.toLabel$default("\u2718", color, 0, 0, false, 14, null);
        $this$addPlayerTableMultiplayerControls.add((Actor)errorLabel).pad(5.0f).row();
        PlayerPickerTable.addPlayerTableMultiplayerControls$onPlayerIdTextUpdated(playerIdTextField, player, errorLabel);
        playerIdTextField.addListener(arg_0 -> PlayerPickerTable.addPlayerTableMultiplayerControls$lambda$2(playerIdTextField, player, errorLabel, arg_0));
        String currentUserId = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId();
        TextButton setCurrentUserButton = Scene2dExtensionsKt.toTextButton$default("Set current user", null, false, 3, null);
        ActivationExtensionsKt.onClick(setCurrentUserButton, () -> PlayerPickerTable.addPlayerTableMultiplayerControls$lambda$3(playerIdTextField, currentUserId, player, errorLabel));
        $this$addPlayerTableMultiplayerControls.add((Actor)setCurrentUserButton).colspan(3).fillX().pad(5.0f).row();
        TextButton copyFromClipboardButton = Scene2dExtensionsKt.toTextButton$default("Player ID from clipboard", null, false, 3, null);
        ActivationExtensionsKt.onClick(copyFromClipboardButton, () -> PlayerPickerTable.addPlayerTableMultiplayerControls$lambda$4(playerIdTextField, player, errorLabel));
        $this$addPlayerTableMultiplayerControls.add((Actor)copyFromClipboardButton).right().colspan(3).fillX().pad(5.0f).row();
        if (!((Collection)this.friendList.getListOfFriends()).isEmpty()) {
            TextButton selectPlayerFromFriendsList = Scene2dExtensionsKt.toTextButton$default("Player ID from friends list", null, false, 3, null);
            ActivationExtensionsKt.onClick(selectPlayerFromFriendsList, () -> PlayerPickerTable.addPlayerTableMultiplayerControls$lambda$5(this, player));
            $this$addPlayerTableMultiplayerControls.add((Actor)selectPlayerFromFriendsList).left().colspan(3).fillX().pad(5.0f);
        }
    }

    private final Table getNationTable(Player player) {
        Table nationTable = new Table();
        Nation nationImageName = this.previousScreen.getRuleset().getNations().get(player.getChosenCiv());
        Portrait nationImage = nationImageName == null ? ImageGetter.INSTANCE.getRandomNationPortrait(40.0f) : ImageGetter.INSTANCE.getNationPortrait(nationImageName, 40.0f);
        nationTable.add((Actor)nationImage).pad(5.0f);
        nationTable.add((Actor)Scene2dExtensionsKt.toLabel$default(player.getChosenCiv(), null, 0, 0, true, 7, null)).pad(5.0f);
        nationTable.setTouchable(Touchable.enabled);
        return nationTable;
    }

    private final void popupFriendPicker(Player player) {
        IPreviousScreen iPreviousScreen = this.previousScreen;
        Intrinsics.checkNotNull(iPreviousScreen, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.BaseScreen");
        Popup.open$default(new FriendSelectionPopup(this, player, (BaseScreen)((Object)iPreviousScreen)), false, 1, null);
        PlayerPickerTable.update$default(this, null, 1, null);
    }

    private final void popupNationPicker(Player player, boolean noRandom) {
        Popup.open$default(new NationPickerPopup(this, player, noRandom), false, 1, null);
        PlayerPickerTable.update$default(this, null, 1, null);
    }

    @NotNull
    public final Sequence<Nation> getAvailablePlayerCivs$core(@Nullable String dontSkipNation) {
        Collection<Nation> collection = this.previousScreen.getRuleset().getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filter(SequencesKt.filterNot(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), PlayerPickerTable::getAvailablePlayerCivs$lambda$0), PlayerPickerTable::getAvailablePlayerCivs$lambda$1), arg_0 -> PlayerPickerTable.getAvailablePlayerCivs$lambda$2(dontSkipNation, this, arg_0));
    }

    public static /* synthetic */ Sequence getAvailablePlayerCivs$core$default(PlayerPickerTable playerPickerTable, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return playerPickerTable.getAvailablePlayerCivs$core(string);
    }

    @NotNull
    public final Sequence<FriendList.Friend> getAvailableFriends$core() {
        List friendListWithRemovedFriends = CollectionsKt.toMutableList((Collection)this.friendList.getListOfFriends());
        int n = ((Collection)this.gameParameters.getPlayers()).size();
        for (int index = 0; index < n; ++index) {
            String currentFriendId = this.previousScreen.getGameSetupInfo().getGameParameters().getPlayers().get(index).getPlayerId();
            Collection collection = friendListWithRemovedFriends;
            FriendList.Friend friend = this.friendList.getFriendById(currentFriendId);
            TypeIntrinsics.asMutableCollection(collection).remove(friend);
        }
        return CollectionsKt.asSequence(friendListWithRemovedFriends);
    }

    private static final Unit _init_$lambda$0(PlayerPickerTable this$0, boolean it) {
        this$0.gameParameters.setShufflePlayerOrder(it);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3(PlayerPickerTable this$0, boolean $isRandomNumberOfPlayers) {
        Nation availableCiv;
        Player player = this$0.noRandom || $isRandomNumberOfPlayers ? ((availableCiv = (Nation)SequencesKt.firstOrNull(PlayerPickerTable.getAvailablePlayerCivs$core$default(this$0, null, 1, null))) != null ? new Player(availableCiv.getName(), null, null, 6, null) : new Player("Spectator", PlayerType.Human, null, 4, null)) : new Player(null, null, null, 7, null);
        this$0.gameParameters.getPlayers().add(player);
        PlayerPickerTable.update$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final void getPlayerTable$updatePlayerTypeButtonEnabled(TextButton playerTypeTextButton, Player $player, PlayerPickerTable this$0) {
        Scene2dExtensionsKt.setEnabled(playerTypeTextButton, $player.getPlayerType() == PlayerType.AI ? true : (Intrinsics.areEqual($player.getChosenCiv(), "Spectator") ? false : !this$0.gameParameters.getRandomNumberOfPlayers() || !Intrinsics.areEqual($player.getChosenCiv(), "Random")));
    }

    private static final Unit getPlayerTable$lambda$0(PlayerPickerTable this$0, Player $player, TextButton $playerTypeTextButton) {
        if (this$0.locked) {
            return Unit.INSTANCE;
        }
        boolean noRandom = this$0.noRandom || this$0.gameParameters.getRandomNumberOfPlayers() && $player.getPlayerType() == PlayerType.AI;
        this$0.popupNationPicker($player, noRandom);
        PlayerPickerTable.getPlayerTable$updatePlayerTypeButtonEnabled($playerTypeTextButton, $player, this$0);
        return Unit.INSTANCE;
    }

    private static final Unit getPlayerTable$lambda$1(Player $player, PlayerPickerTable this$0) {
        $player.setPlayerType($player.getPlayerType() == PlayerType.AI ? PlayerType.Human : PlayerType.AI);
        PlayerPickerTable.update$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getPlayerTable$lambda$2(PlayerPickerTable this$0, Player $player) {
        this$0.gameParameters.getPlayers().remove($player);
        PlayerPickerTable.update$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final void addPlayerTableMultiplayerControls$onPlayerIdTextUpdated(UncivTextField playerIdTextField, Player $player, Label errorLabel) {
        String string = playerIdTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String string2 = IdChecker.INSTANCE.checkAndReturnPlayerUuid(string);
        if (string2 != null ? StringExtensionsKt.isUUID(string2) : false) {
            Label label;
            String string3 = playerIdTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
            $player.setPlayerId(((Object)StringsKt.trim((CharSequence)string3)).toString());
            Label $this$addPlayerTableMultiplayerControls_u24onPlayerIdTextUpdated_u24lambda_u240 = label = errorLabel;
            boolean bl = false;
            $this$addPlayerTableMultiplayerControls_u24onPlayerIdTextUpdated_u24lambda_u240.setText("\u2714");
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            Scene2dExtensionsKt.setFontColor($this$addPlayerTableMultiplayerControls_u24onPlayerIdTextUpdated_u24lambda_u240, color);
        } else {
            Label label;
            Label $this$addPlayerTableMultiplayerControls_u24onPlayerIdTextUpdated_u24lambda_u241 = label = errorLabel;
            boolean bl = false;
            $this$addPlayerTableMultiplayerControls_u24onPlayerIdTextUpdated_u24lambda_u241.setText("\u2718");
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            Scene2dExtensionsKt.setFontColor($this$addPlayerTableMultiplayerControls_u24onPlayerIdTextUpdated_u24lambda_u241, color);
        }
    }

    private static final boolean addPlayerTableMultiplayerControls$lambda$2(UncivTextField $playerIdTextField, Player $player, Label $errorLabel, Event it) {
        PlayerPickerTable.addPlayerTableMultiplayerControls$onPlayerIdTextUpdated($playerIdTextField, $player, $errorLabel);
        return true;
    }

    private static final Unit addPlayerTableMultiplayerControls$lambda$3(UncivTextField $playerIdTextField, String $currentUserId, Player $player, Label $errorLabel) {
        $playerIdTextField.setText($currentUserId);
        PlayerPickerTable.addPlayerTableMultiplayerControls$onPlayerIdTextUpdated($playerIdTextField, $player, $errorLabel);
        return Unit.INSTANCE;
    }

    private static final Unit addPlayerTableMultiplayerControls$lambda$4(UncivTextField $playerIdTextField, Player $player, Label $errorLabel) {
        $playerIdTextField.setText(Gdx.app.getClipboard().getContents());
        PlayerPickerTable.addPlayerTableMultiplayerControls$onPlayerIdTextUpdated($playerIdTextField, $player, $errorLabel);
        return Unit.INSTANCE;
    }

    private static final Unit addPlayerTableMultiplayerControls$lambda$5(PlayerPickerTable this$0, Player $player) {
        this$0.popupFriendPicker($player);
        return Unit.INSTANCE;
    }

    private static final boolean getAvailablePlayerCivs$lambda$0(Nation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }

    private static final boolean getAvailablePlayerCivs$lambda$1(Nation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IHasUniques.hasUnique$default(it, UniqueType.WillNotBeChosenForNewGames, null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getAvailablePlayerCivs$lambda$2(String $dontSkipNation, PlayerPickerTable this$0, Nation it) {
        Player player;
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(it.getName(), $dontSkipNation)) return true;
        Iterable $this$none$iv = this$0.gameParameters.getPlayers();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            player = (Player)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual(player.getChosenCiv(), it.getName()));
        return false;
    }
}

