/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.chat;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.AlternatingStateManager;
import com.unciv.logic.multiplayer.chat.Chat;
import com.unciv.logic.multiplayer.chat.ChatStore;
import com.unciv.logic.multiplayer.chat.ChatWebSocket;
import com.unciv.logic.multiplayer.chat.Message;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.chat.ChatButtonKt;
import com.unciv.ui.screens.worldscreen.chat.ChatPopup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/screens/worldscreen/chat/ChatButton;", "Lcom/unciv/ui/images/IconTextButton;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "chat", "Lcom/unciv/logic/multiplayer/chat/Chat;", "badge", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "flash", "Lcom/unciv/logic/AlternatingStateManager;", "updateBadge", "", "triggerChatIndication", "refreshVisibility", "updatePosition", "core"})
public final class ChatButton
extends IconTextButton {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Chat chat;
    @NotNull
    private final TextButton badge;
    @NotNull
    private final AlternatingStateManager flash;

    /*
     * WARNING - void declaration
     */
    public ChatButton(@NotNull WorldScreen worldScreen) {
        void $this$badge_u24lambda_u240;
        TextButton textButton;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super("Chat", (Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Chat", null, 2, null), 23, null, 8, null);
        this.worldScreen = worldScreen;
        this.chat = ChatStore.INSTANCE.getChatByGameId(this.worldScreen.getGameInfo().getGameId());
        TextButton textButton2 = textButton = Scene2dExtensionsKt.toTextButton$default("", ChatButtonKt.access$getSmallButtonStyle$p(), false, 2, null);
        ChatButton chatButton = this;
        boolean bl = false;
        Scene2dExtensionsKt.disable((Button)$this$badge_u24lambda_u240);
        $this$badge_u24lambda_u240.getLabel().setColor(Color.WHITE);
        $this$badge_u24lambda_u240.getLabel().setAlignment(1);
        $this$badge_u24lambda_u240.getLabel().setFontScale(0.2f);
        chatButton.badge = textButton;
        this.flash = new AlternatingStateManager("ChatButton color flash", () -> ChatButton.flash$lambda$0(this), () -> ChatButton.flash$lambda$1(this));
        this.setWidth(95.0f);
        this.getIconCell().pad(3.0f).center();
        this.addActor(this.badge);
        this.updateBadge();
        ActivationExtensionsKt.onClick(this, () -> ChatButton._init_$lambda$0(this));
        this.refreshVisibility();
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    private final void updateBadge() {
        this.badge.setHeight(this.getHeight() / (float)3);
        this.badge.setPosition(this.getWidth() - this.badge.getWidth() / 1.5f, this.getHeight() - this.badge.getHeight() / 1.5f);
        this.badge.setVisible(this.chat.getUnreadCount() > 0 || ChatStore.INSTANCE.getHasGlobalMessage());
        if (this.badge.isVisible()) {
            String text2 = String.valueOf(this.chat.getUnreadCount());
            if (ChatStore.INSTANCE.getHasGlobalMessage()) {
                text2 = text2 + '+';
            }
            this.badge.setText(text2);
        } else {
            this.flash.stop();
        }
    }

    public final void triggerChatIndication() {
        this.updateBadge();
        AlternatingStateManager.start-QTBD994$default(this.flash, 0L, 0L, 3, null);
    }

    public final void refreshVisibility() {
        boolean bl;
        if (this.worldScreen.getGameInfo().getGameParameters().isOnlineMultiplayer() && UncivGame.Companion.getCurrent().getOnlineMultiplayer().getMultiplayerServer().getFeatureSet().getChatVersion() > 0) {
            ChatWebSocket.INSTANCE.requestMessageSend(new Message.Join(CollectionsKt.listOf(this.worldScreen.getGameInfo().getGameId())));
            this.updatePosition();
            this.updateBadge();
            bl = true;
        } else {
            ChatWebSocket.INSTANCE.stop();
            bl = false;
        }
        this.setVisible(bl);
    }

    public final void updatePosition() {
        this.setPosition(RangesKt.coerceAtLeast(this.worldScreen.getTechPolicyAndDiplomacy$core().getX(), 1.0f), this.worldScreen.getTechPolicyAndDiplomacy$core().getY() - this.getHeight() - 1.0f);
    }

    private static final Unit flash$lambda$0(ChatButton this$0) {
        Actor actor = this$0.getIcon();
        if (actor != null) {
            actor.setColor(this$0.getFontColor());
        }
        this$0.getLabel().setColor(this$0.getFontColor());
        return Unit.INSTANCE;
    }

    private static final Unit flash$lambda$1(ChatButton this$0) {
        Actor actor = this$0.getIcon();
        if (actor != null) {
            actor.setColor(Color.ORANGE);
        }
        this$0.getLabel().setColor(Color.ORANGE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(ChatButton this$0) {
        this$0.chat.setUnreadCount(0);
        ChatStore.INSTANCE.setHasGlobalMessage(false);
        this$0.updateBadge();
        Popup.open$default(new ChatPopup(this$0.chat, this$0.worldScreen), false, 1, null);
        return Unit.INSTANCE;
    }
}

