/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.unciv.GUI;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityFlags;
import com.unciv.logic.city.CityFocus;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.managers.SpyFleeReason;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/city/managers/CityConquestFunctions;", "", "city", "Lcom/unciv/logic/city/City;", "<init>", "(Lcom/unciv/logic/city/City;)V", "getCity", "()Lcom/unciv/logic/city/City;", "tileBasedRandom", "Lkotlin/random/Random;", "getGoldForCapturingCity", "", "conqueringCiv", "Lcom/unciv/logic/civilization/Civilization;", "destroyBuildingsOnCapture", "", "removeAutoPromotion", "removeBuildingsOnMoveToCiv", "conquerCity", "conqueredCiv", "receivingCiv", "puppetCity", "annexCity", "diplomaticRepercussionsForConqueringCity", "oldCiv", "liberateCity", "diplomaticRepercussionsForLiberatingCity", "moveToCiv", "newCiv", "core"})
@SourceDebugExtension(value={"SMAP\nCityConquestFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityConquestFunctions.kt\ncom/unciv/logic/city/managers/CityConquestFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,353:1\n1788#2,4:354\n827#2:359\n855#2,2:360\n1#3:358\n1321#4,2:362\n*S KotlinDebug\n*F\n+ 1 CityConquestFunctions.kt\ncom/unciv/logic/city/managers/CityConquestFunctions\n*L\n89#1:354,4\n293#1:359\n293#1:360,2\n344#1:362,2\n*E\n"})
public final class CityConquestFunctions {
    @NotNull
    private final City city;
    @NotNull
    private final Random tileBasedRandom;

    public CityConquestFunctions(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        this.city = city;
        this.tileBasedRandom = RandomKt.Random(this.city.getCenterTile().getPosition().hashCode());
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @Readonly
    private final int getGoldForCapturingCity(Civilization conqueringCiv) {
        Object unique;
        int baseGold = 20 + 10 * this.city.getPopulation().getPopulation() + this.tileBasedRandom.nextInt(40);
        float turnModifier = (float)Math.max(0, Math.min(50, this.city.getCiv().getGameInfo().getTurns() - this.city.getTurnAcquired())) / 50.0f;
        float cityModifier = City.containsBuildingUnique$default(this.city, UniqueType.DoublesGoldFromCapturingCity, null, 2, null) ? 2.0f : 1.0f;
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.GoldFromCapturingCity, this.city.getState(), false, 4, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            cityModifier *= FormattingExtensionsKt.toPercent(((Unique)unique).getParams().get(0));
        }
        float conqueringCivModifier = Civilization.hasUnique$default(conqueringCiv, UniqueType.TripleGoldFromEncampmentsAndCities, null, 2, null) ? 3.0f : 1.0f;
        unique = conqueringCiv.getMatchingUniques(UniqueType.GoldFromEncampmentsAndCities, conqueringCiv.getState()).iterator();
        while (unique.hasNext()) {
            Unique unique2 = (Unique)unique.next();
            conqueringCivModifier *= FormattingExtensionsKt.toPercent(unique2.getParams().get(0));
        }
        float goldPlundered = (float)baseGold * turnModifier * cityModifier * conqueringCivModifier;
        return (int)goldPlundered;
    }

    private final void destroyBuildingsOnCapture() {
        Iterator<Building> iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (IHasUniques.hasUnique$default(building, UniqueType.NotDestroyedWhenCityCaptured, null, 2, null) || building.isWonder() || building.hasUnique(UniqueType.IndicatesCapital, this.city.getState())) continue;
            if (IHasUniques.hasUnique$default(building, UniqueType.DestroyedWhenCityCaptured, null, 2, null)) {
                this.city.getCityConstructions().removeBuilding(building);
                continue;
            }
            if (this.tileBasedRandom.nextInt(100) >= 34) continue;
            this.city.getCityConstructions().removeBuilding(building);
        }
    }

    private final void removeAutoPromotion() {
        this.city.setUnitShouldUseSavedPromotion(new HashMap<String, Boolean>());
        this.city.setUnitToPromotions(new HashMap<String, UnitPromotions>());
    }

    /*
     * WARNING - void declaration
     */
    private final void removeBuildingsOnMoveToCiv() {
        for (String string : this.city.getCiv().getCivConstructions().getFreeBuildingNames(this.city)) {
            this.city.getCityConstructions().removeBuilding(string);
        }
        this.city.getCityConstructions().getFreeBuildingsProvidedFromThisCity().clear();
        Iterator<Object> iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Building building = (Building)object;
            if (building.isNationalWonder() && !IHasUniques.hasUnique$default(building, UniqueType.NotDestroyedWhenCityCaptured, null, 2, null)) {
                this.city.getCityConstructions().removeBuilding(building);
            }
            Iterator iterator3 = IHasUniques.getMatchingUniques$default(building, UniqueType.MaxNumberBuildable, null, 2, null).iterator();
            while (iterator3.hasNext()) {
                int n;
                void $this$count$iv;
                Unique unique = (Unique)iterator3.next();
                Iterable iterable = this.city.getCiv().getCities();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        City it = (City)element$iv;
                        boolean bl = false;
                        if (!(it.getCityConstructions().containsBuildingOrEquivalent(building.getName()) || it.getCityConstructions().isBeingConstructedOrEnqueued(building.getName())) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                if (n < Integer.parseInt(unique.getParams().get(0))) continue;
                this.city.getCityConstructions().removeBuilding(building);
            }
        }
    }

    private final void conquerCity(Civilization conqueringCiv, Civilization conqueredCiv, Civilization receivingCiv) {
        this.city.getEspionage().removeAllPresentSpies(SpyFleeReason.CityCaptured);
        int goldPlundered = this.getGoldForCapturingCity(conqueringCiv);
        conqueringCiv.addGold(goldPlundered);
        String[] stringArray = new String[]{"StatIcons/Gold"};
        conqueringCiv.addNotification("Received [" + goldPlundered + "] Gold for capturing [" + this.city.getName() + ']', this.city.getCenterTile().getPosition(), Notification.NotificationCategory.General, stringArray);
        boolean reconqueredCityWhileStillInResistance = Intrinsics.areEqual(this.city.getPreviousOwner(), receivingCiv.getCivID()) && this.city.isInResistance();
        this.destroyBuildingsOnCapture();
        this.city.moveToCiv(receivingCiv);
        Battle.INSTANCE.destroyIfDefeated(conqueredCiv, conqueringCiv, this.city.getLocation().toHexCoord());
        this.city.setHealth(this.city.getMaxHealth$core() / 2);
        this.city.setAvoidGrowth(false);
        this.city.setCityFocus(CityFocus.NoFocus);
        if (this.city.getPopulation().getPopulation() > 1) {
            this.city.getPopulation().addPopulation(-1 - this.city.getPopulation().getPopulation() / 4);
        }
        this.city.reassignAllPopulation();
        if (!reconqueredCityWhileStillInResistance && !Intrinsics.areEqual(this.city.getFoundingCivObject(), receivingCiv)) {
            this.city.setFlag(CityFlags.Resistance, this.city.getPopulation().getPopulation());
        } else {
            this.city.removeFlag(CityFlags.Resistance);
        }
        Iterator iterator2 = Civilization.getTriggeredUniques$default(conqueredCiv, UniqueType.TriggerUponLosingCity, new GameContext(conqueredCiv, null, null, null, null, null, null, null, null, null, false, 2046, null), null, 4, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, conqueredCiv, null, null, null, null, null, 124, null);
        }
    }

    public final void puppetCity(@NotNull Civilization conqueringCiv) {
        Intrinsics.checkNotNullParameter(conqueringCiv, "conqueringCiv");
        Civilization oldCiv = this.city.getCiv();
        this.diplomaticRepercussionsForConqueringCity(oldCiv, conqueringCiv);
        this.conquerCity(conqueringCiv, oldCiv, conqueringCiv);
        this.city.setPuppet(true);
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, false, 31, null);
        this.city.getCityConstructions().setCurrentConstructionIsUserSet(false);
        this.city.getCityConstructions().getInProgressConstructions().clear();
        this.city.getCityConstructions().getConstructionQueue().clear();
        this.city.getCityConstructions().chooseNextConstruction();
    }

    public final void annexCity() {
        this.city.setPuppet(false);
        if (!this.city.isInResistance()) {
            this.city.setShouldReassignPopulation(true);
        }
        this.city.setAvoidGrowth(false);
        this.city.setCityFocus(CityFocus.NoFocus);
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, false, 31, null);
        GUI.INSTANCE.setUpdateWorldOnNextRender();
    }

    /*
     * WARNING - void declaration
     */
    private final void diplomaticRepercussionsForConqueringCity(Civilization oldCiv, Civilization conqueringCiv) {
        int n;
        int currentPopulation = this.city.getPopulation().getPopulation();
        Iterable iterable = oldCiv.getCities();
        float f = (float)currentPopulation * 100.0f;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            City city = (City)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getPopulation().getPopulation();
            n2 = n + n3;
        }
        n = n2;
        float percentageOfCivPopulationInThatCity = f / (float)n;
        float aggroGenerated = 10.0f + (float)MathKt.roundToInt(percentageOfCivPopulationInThatCity);
        if (!conqueringCiv.knows(oldCiv)) {
            DiplomacyFunctions.makeCivilizationsMeet$default(conqueringCiv.getDiplomacyFunctions(), oldCiv, false, 2, null);
        }
        DiplomacyManager diplomacyManager = oldCiv.getDiplomacyManager(conqueringCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager.addModifier$default(diplomacyManager, DiplomaticModifiers.CapturedOurCities, -aggroGenerated, null, 4, null);
        Iterator<Civilization> iterator2 = SequencesKt.filter(conqueringCiv.getKnownCivs(), CityConquestFunctions::diplomaticRepercussionsForConqueringCity$lambda$1).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdPartyCiv = iterator2.next();
            float aggroGeneratedForOtherCivs = MathKt.roundToInt(aggroGenerated / (float)10);
            if (thirdPartyCiv.isAtWarWith(oldCiv)) {
                DiplomacyManager diplomacyManager2 = thirdPartyCiv.getDiplomacyManager(conqueringCiv);
                Intrinsics.checkNotNull(diplomacyManager2);
                DiplomacyManager.addModifier$default(diplomacyManager2, DiplomaticModifiers.SharedEnemy, aggroGeneratedForOtherCivs, null, 4, null);
                continue;
            }
            DiplomacyManager diplomacyManager3 = thirdPartyCiv.getDiplomacyManager(conqueringCiv);
            Intrinsics.checkNotNull(diplomacyManager3);
            DiplomacyManager.addModifier$default(diplomacyManager3, DiplomaticModifiers.WarMongerer, -aggroGeneratedForOtherCivs, null, 4, null);
        }
    }

    public final void liberateCity(@NotNull Civilization conqueringCiv) {
        Intrinsics.checkNotNullParameter(conqueringCiv, "conqueringCiv");
        if (this.city.getFoundingCivObject() == null) {
            this.puppetCity(conqueringCiv);
            this.annexCity();
            return;
        }
        Civilization civilization = this.city.getFoundingCivObject();
        Intrinsics.checkNotNull(civilization);
        Civilization foundingCiv = civilization;
        if (foundingCiv.isDefeated()) {
            Iterator<DiplomacyManager> iterator2 = foundingCiv.getDiplomacy().values().iterator();
            while (iterator2.hasNext()) {
                DiplomacyManager diploManager;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                if (diploManager.getDiplomaticStatus() != DiplomaticStatus.War) continue;
                diploManager.makePeace();
            }
        }
        Civilization oldCiv = this.city.getCiv();
        this.diplomaticRepercussionsForLiberatingCity(conqueringCiv, oldCiv);
        this.conquerCity(conqueringCiv, oldCiv, foundingCiv);
        if (foundingCiv.getCities().size() == 1) {
            Building capitalCityIndicator = conqueringCiv.capitalCityIndicator(this.city);
            if (capitalCityIndicator != null) {
                CityConstructions.addBuilding$default(this.city.getCityConstructions(), capitalCityIndicator, false, 2, null);
            }
            Iterator<Civilization> iterator2 = this.city.getCiv().getGameInfo().getCivilizations().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Civilization> iterator4 = iterator2;
            while (iterator4.hasNext()) {
                String[] stringArray;
                Civilization civ;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                if (Intrinsics.areEqual(civ, foundingCiv) || Intrinsics.areEqual(civ, conqueringCiv)) continue;
                if (civ.knows(conqueringCiv) && civ.knows(foundingCiv)) {
                    stringArray = new String[]{foundingCiv.getCivName(), "OtherIcons/Diplomacy", conqueringCiv.getCivName()};
                    civ.addNotification("" + '[' + conqueringCiv + "] has liberated [" + foundingCiv + ']', Notification.NotificationCategory.Diplomacy, stringArray);
                    continue;
                }
                if (civ.knows(conqueringCiv) && !civ.knows(foundingCiv)) {
                    stringArray = new String[]{"OtherIcons/Diplomacy", conqueringCiv.getCivName()};
                    civ.addNotification("" + '[' + conqueringCiv + "] has liberated [an unknown civilization]", Notification.NotificationCategory.Diplomacy, stringArray);
                    continue;
                }
                if (civ.knows(conqueringCiv) || !civ.knows(foundingCiv)) continue;
                stringArray = new String[]{"OtherIcons/Diplomacy", foundingCiv.getCivName()};
                civ.addNotification("[An unknown civilization] has liberated [" + foundingCiv + ']', Notification.NotificationCategory.Diplomacy, stringArray);
            }
        }
        this.city.setPuppet(false);
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, false, 31, null);
        for (MapUnit unit : SequencesKt.toList(this.city.getCenterTile().getUnits())) {
            unit.getMovement().teleportToClosestMoveableTile();
        }
        for (MapUnit unit : SequencesKt.toList(SequencesKt.flatMap(this.city.getTiles(), CityConquestFunctions::liberateCity$lambda$0))) {
            if (UnitMovement.canPassThrough$default(unit.getMovement(), unit.getCurrentTile(), false, 2, null)) continue;
            unit.getMovement().teleportToClosestMoveableTile();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void diplomaticRepercussionsForLiberatingCity(Civilization conqueringCiv, Civilization conqueredCiv) {
        int n;
        Civilization civilization = this.city.getFoundingCivObject();
        Intrinsics.checkNotNull(civilization);
        Civilization foundingCiv = civilization;
        Iterable iterable = foundingCiv.getCities();
        float f = (float)this.city.getPopulation().getPopulation() * 100.0f;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            City city = (City)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getPopulation().getPopulation();
            n2 = n + n3;
        }
        n = n2;
        float percentageOfCivPopulationInThatCity = f / (float)(n + this.city.getPopulation().getPopulation());
        float respectForLiberatingOurCity = 10.0f + (float)MathKt.roundToInt(percentageOfCivPopulationInThatCity);
        if (foundingCiv.isMajorCiv()) {
            DiplomacyManager.addModifier$default(foundingCiv.getDiplomacyManagerOrMeet(conqueringCiv), DiplomaticModifiers.CapturedOurCities, respectForLiberatingOurCity, null, 4, null);
            TradeLogic openBordersTrade = new TradeLogic(foundingCiv, conqueringCiv);
            openBordersTrade.getCurrentTrade().getOurOffers().add(new TradeOffer("Open Borders", TradeOfferType.Agreement, 0, conqueringCiv.getGameInfo().getSpeed(), 4, null));
            openBordersTrade.acceptTrade(false);
        } else {
            foundingCiv.getDiplomacyManagerOrMeet(conqueringCiv).setInfluence(90.0f);
            if (foundingCiv.isAtWarWith(conqueringCiv)) {
                TradeLogic tradeLogic = new TradeLogic(foundingCiv, conqueringCiv);
                tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, conqueringCiv.getGameInfo().getSpeed(), 4, null));
                tradeLogic.getCurrentTrade().getTheirOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, conqueringCiv.getGameInfo().getSpeed(), 4, null));
                tradeLogic.acceptTrade(false);
            }
        }
        float otherCivsRespectForLiberating = MathKt.roundToInt(respectForLiberatingOurCity / (float)10);
        Iterator<Object> iterator2 = SequencesKt.filter(conqueringCiv.getKnownCivs(), arg_0 -> CityConquestFunctions.diplomaticRepercussionsForLiberatingCity$lambda$1(conqueredCiv, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdPartyCiv = (Civilization)iterator2.next();
            DiplomacyManager diplomacyManager = thirdPartyCiv.getDiplomacyManager(conqueringCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            DiplomacyManager.addModifier$default(diplomacyManager, DiplomaticModifiers.LiberatedCity, otherCivsRespectForLiberating, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void moveToCiv(@NotNull Civilization newCiv) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(newCiv, "newCiv");
        Civilization oldCiv = this.city.getCiv();
        if (this.city.isCapital()) {
            oldCiv.moveCapitalToNextLargest(this.city);
        }
        oldCiv.setCities((List<City>)CollectionExtensionsKt.withoutItem(oldCiv.getCities(), this.city));
        newCiv.setCities((List<City>)CollectionExtensionsKt.withItem(newCiv.getCities(), this.city));
        this.city.setCiv(newCiv);
        this.city.setState(new GameContext(this.city));
        this.city.setHasJustBeenConquered(false);
        this.city.setTurnAcquired(this.city.getCiv().getGameInfo().getTurns());
        this.city.setPreviousOwner(oldCiv.getCivID());
        Iterable $this$filterNot$iv = this.city.getWorkedTiles();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            HexCoord it = (HexCoord)element$iv$iv;
            boolean bl = false;
            if (this.city.getTiles().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (HexCoord workedTile : (List)destination$iv$iv) {
            this.city.getPopulation().stopWorkingTile(workedTile);
            this.city.getPopulation().autoAssignPopulation$core();
        }
        this.city.resetWLTKD();
        this.removeBuildingsOnMoveToCiv();
        this.removeAutoPromotion();
        this.city.getEspionage().removeAllPresentSpies(SpyFleeReason.Other);
        if (newCiv.getCities().size() == 1) {
            newCiv.moveCapitalTo(this.city, null);
        }
        this.city.getCiv().getCivConstructions().tryAddFreeBuildings();
        this.city.setBeingRazed(false);
        Iterator<Object> iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Building building = (Building)object;
            Building civEquivalentBuilding = newCiv.getEquivalentBuilding(building);
            if (Intrinsics.areEqual(building, civEquivalentBuilding)) continue;
            this.city.getCityConstructions().removeBuilding(building);
            CityConstructions.addBuilding$default(this.city.getCityConstructions(), civEquivalentBuilding, false, 2, null);
        }
        if (this.city.getCiv().getGameInfo().isReligionEnabled()) {
            this.city.getReligion().removeUnknownPantheons();
        }
        if (Civilization.hasUnique$default(newCiv, UniqueType.MayNotAnnexCities, null, 2, null)) {
            this.city.setPuppet(true);
            this.city.getCityConstructions().setCurrentConstructionIsUserSet(false);
            this.city.getCityConstructions().getConstructionQueue().clear();
            this.city.getCityConstructions().chooseNextConstruction();
        }
        this.city.tryUpdateRoadStatus$core();
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, false, 31, null);
        this.city.getCiv().updateProximity(oldCiv, Civilization.updateProximity$default(oldCiv, this.city.getCiv(), null, 2, null));
        Sequence<Tile> $this$forEach$iv = this.city.getTiles();
        boolean $i$f$forEach = false;
        Iterator<Tile> iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            Tile element$iv;
            Tile tile = element$iv = iterator3.next();
            boolean bl = false;
            tile.getHistory().recordTakeOwnership(tile);
        }
        newCiv.getCache().updateOurTiles();
        oldCiv.getCache().updateOurTiles();
    }

    private static final boolean diplomaticRepercussionsForConqueringCity$lambda$1(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }

    private static final Sequence liberateCity$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnits();
    }

    private static final boolean diplomaticRepercussionsForLiberatingCity$lambda$1(Civilization $conqueredCiv, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv() && !Intrinsics.areEqual(it, $conqueredCiv);
    }
}

