/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.mapregions.MapGenTileData;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapgenerator.mapregions.StartNormalizer;
import com.unciv.logic.map.mapgenerator.mapregions.TileDataMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u008a\u0001\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0013j\b\u0012\u0004\u0012\u00020\f`\u0015H\u0002J$\u0010\u001a\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0002J$\u0010\u001b\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\u001c\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0002Jv\u0010\u001d\u001a\u00020\u00052\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0013j\b\u0012\u0004\u0012\u00020\f`\u00152\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J<\u0010\u001f\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\t\u001a\u00020\n2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0003J0\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006'"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MinorCivPlacer;", "", "<init>", "()V", "placeMinorCivs", "", "regions", "", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "civs", "Lcom/unciv/logic/civilization/Civilization;", "tileData", "Lcom/unciv/logic/map/mapgenerator/mapregions/TileDataMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "spreadCityStatesBetweenHabitedAndUninhabited", "uninhabitedCoastal", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/ArrayList;", "uninhabitedHinterland", "unassignedCivs", "", "civAssignedToUninhabited", "assignCityStatesToRegionsWithCommonLuxuries", "spreadCityStatesEvenlyBetweenRegions", "assignRemainingCityStatesToWorstFertileRegions", "placeAssignedMinorCivs", "assignMinorCivsDirectlyToRegions", "tryPlaceMinorCivsInTiles", "civsToPlace", "tileList", "canPlaceMinorCiv", "", "tile", "placeMinorCiv", "civ", "core"})
@SourceDebugExtension(value={"SMAP\nMinorCivPlacer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinorCivPlacer.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MinorCivPlacer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,243:1\n536#2:244\n521#2,2:245\n523#2,4:250\n2746#3,3:247\n774#3:254\n865#3:255\n1788#3,4:256\n866#3:260\n1869#3,2:261\n1869#3,2:263\n1056#3:265\n1869#3,2:266\n1869#3,2:268\n2275#4,2:270\n*S KotlinDebug\n*F\n+ 1 MinorCivPlacer.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MinorCivPlacer\n*L\n68#1:244\n68#1:245,2\n68#1:250,4\n70#1:247,3\n105#1:254\n105#1:255\n106#1:256,4\n105#1:260\n112#1:261,2\n127#1:263,2\n143#1:265\n144#1:266,2\n199#1:268,2\n229#1:270,2\n*E\n"})
public final class MinorCivPlacer {
    @NotNull
    public static final MinorCivPlacer INSTANCE = new MinorCivPlacer();

    private MinorCivPlacer() {
    }

    public final void placeMinorCivs(@NotNull List<Region> regions, @NotNull TileMap tileMap, @NotNull List<Civilization> civs, @NotNull TileDataMap tileData, @NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(regions, "regions");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(civs, "civs");
        Intrinsics.checkNotNullParameter(tileData, "tileData");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        if (civs.isEmpty()) {
            return;
        }
        List<Civilization> unassignedCivs = this.assignMinorCivsDirectlyToRegions(civs, regions);
        ArrayList<Tile> uninhabitedCoastal = new ArrayList<Tile>();
        ArrayList<Tile> uninhabitedHinterland = new ArrayList<Tile>();
        ArrayList<Civilization> civAssignedToUninhabited = new ArrayList<Civilization>();
        if (!tileMap.usingArchipelagoRegions()) {
            this.spreadCityStatesBetweenHabitedAndUninhabited(tileMap, regions, tileData, uninhabitedCoastal, uninhabitedHinterland, civs, unassignedCivs, civAssignedToUninhabited);
        }
        this.assignCityStatesToRegionsWithCommonLuxuries(regions, unassignedCivs);
        this.spreadCityStatesEvenlyBetweenRegions(unassignedCivs, regions);
        this.assignRemainingCityStatesToWorstFertileRegions(regions, unassignedCivs);
        this.placeAssignedMinorCivs(civAssignedToUninhabited, tileMap, uninhabitedCoastal, tileData, ruleset, uninhabitedHinterland, regions);
    }

    /*
     * Unable to fully structure code
     */
    private final void spreadCityStatesBetweenHabitedAndUninhabited(TileMap tileMap, List<Region> regions, TileDataMap tileData, ArrayList<Tile> uninhabitedCoastal, ArrayList<Tile> uninhabitedHinterland, List<Civilization> civs, List<Civilization> unassignedCivs, ArrayList<Civilization> civAssignedToUninhabited) {
        $this$filter$iv = tileMap.getContinentSizes();
        $i$f$filter = false;
        var12_12 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var15_17 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var15_17.hasNext()) {
            block8: {
                it = element$iv$iv = var15_17.next();
                $i$a$-filter-MinorCivPlacer$spreadCityStatesBetweenHabitedAndUninhabited$uninhabitedContinents$1 = false;
                if (((Number)it.getValue()).intValue() < 4) ** GOTO lbl-1000
                $this$none$iv = regions;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        region = (Region)element$iv;
                        $i$a$-none-MinorCivPlacer$spreadCityStatesBetweenHabitedAndUninhabited$uninhabitedContinents$1$1 = false;
                        if (!(region.getContinentID() == ((Number)it.getKey()).intValue())) continue;
                        v0 = false;
                        break block8;
                    }
                    v0 = true;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        uninhabitedContinents = destination$iv$iv.keySet();
        numInhabitedTiles = 0;
        numUninhabitedTiles = 0;
        for (Tile tile : tileMap.getValues()) {
            if (!this.canPlaceMinorCiv(tile, tileData)) continue;
            continent = tile.getContinent();
            if (uninhabitedContinents.contains(continent)) {
                v2 = tile.isCoastalTile() != false ? uninhabitedCoastal.add(tile) : uninhabitedHinterland.add(tile);
                ++numUninhabitedTiles;
                continue;
            }
            ++numInhabitedTiles;
        }
        maxByUninhabited = 3 * civs.size() * numUninhabitedTiles / (numInhabitedTiles + numUninhabitedTiles);
        maxByRatio = (civs.size() + 1) / 2;
        targetForUninhabited = Math.min(maxByRatio, maxByUninhabited);
        civsToAssign = CollectionsKt.take((Iterable)unassignedCivs, targetForUninhabited);
        unassignedCivs.removeAll((Collection)civsToAssign);
        civAssignedToUninhabited.addAll((Collection<Civilization>)civsToAssign);
    }

    /*
     * WARNING - void declaration
     */
    private final void assignCityStatesToRegionsWithCommonLuxuries(List<Region> regions, List<Civilization> unassignedCivs) {
        void $this$filterTo$iv$iv;
        if (unassignedCivs.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = regions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int n;
            Region it = (Region)element$iv$iv;
            boolean bl = false;
            Iterable $this$count$iv = regions;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Region other = (Region)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(other.getLuxury(), it.getLuxury()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (!(n >= 3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List regionsWithCommonLuxuries = (List)destination$iv$iv;
        if (!((Collection)regionsWithCommonLuxuries).isEmpty() && regionsWithCommonLuxuries.size() <= unassignedCivs.size()) {
            Iterable $this$forEach$iv = regionsWithCommonLuxuries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Region it = (Region)element$iv;
                boolean bl = false;
                Civilization civToAssign = CollectionsKt.first(unassignedCivs);
                unassignedCivs.remove(civToAssign);
                it.getAssignedMinorCivs().add(civToAssign);
            }
        }
    }

    private final void spreadCityStatesEvenlyBetweenRegions(List<Civilization> unassignedCivs, List<Region> regions) {
        if (unassignedCivs.isEmpty()) {
            return;
        }
        while (unassignedCivs.size() >= regions.size()) {
            Iterable $this$forEach$iv = regions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Region it = (Region)element$iv;
                boolean bl = false;
                Civilization civToAssign = CollectionsKt.first(unassignedCivs);
                unassignedCivs.remove(civToAssign);
                it.getAssignedMinorCivs().add(civToAssign);
            }
        }
    }

    private final void assignRemainingCityStatesToWorstFertileRegions(List<Region> regions, List<Civilization> unassignedCivs) {
        if (unassignedCivs.isEmpty()) {
            return;
        }
        Iterable $this$sortedBy$iv = regions;
        boolean $i$f$sortedBy = false;
        List worstRegions = CollectionsKt.take(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Region it = (Region)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTotalFertility());
                it = (Region)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTotalFertility());
            }
        }), unassignedCivs.size());
        Iterable $this$forEach$iv = worstRegions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Region it = (Region)element$iv;
            boolean bl = false;
            Civilization civToAssign = CollectionsKt.first(unassignedCivs);
            unassignedCivs.remove(civToAssign);
            it.getAssignedMinorCivs().add(civToAssign);
        }
    }

    private final void placeAssignedMinorCivs(ArrayList<Civilization> civAssignedToUninhabited, TileMap tileMap, ArrayList<Tile> uninhabitedCoastal, TileDataMap tileData, Ruleset ruleset, ArrayList<Tile> uninhabitedHinterland, List<Region> regions) {
        this.tryPlaceMinorCivsInTiles((List<Civilization>)civAssignedToUninhabited, tileMap, (List<Tile>)uninhabitedCoastal, tileData, ruleset);
        this.tryPlaceMinorCivsInTiles((List<Civilization>)civAssignedToUninhabited, tileMap, (List<Tile>)uninhabitedHinterland, tileData, ruleset);
        Iterator<Civilization> iterator2 = civAssignedToUninhabited.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization unplacedCiv;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            ((Region)CollectionsKt.random((Collection)regions, Random.Default)).getAssignedMinorCivs().add(unplacedCiv);
        }
        for (Region region : regions) {
            this.tryPlaceMinorCivsInTiles((List<Civilization>)region.getAssignedMinorCivs(), tileMap, CollectionsKt.toMutableList((Collection)region.getTiles()), tileData, ruleset);
        }
    }

    private final List<Civilization> assignMinorCivsDirectlyToRegions(List<Civilization> civs, List<Region> regions) {
        float minorCivRatio = (float)civs.size() / (float)regions.size();
        int minorCivPerRegion = minorCivRatio > 14.0f ? 10 : (minorCivRatio > 11.0f ? 8 : (minorCivRatio > 8.0f ? 6 : (minorCivRatio > 5.7f ? 4 : (minorCivRatio > 4.35f ? 3 : (minorCivRatio > 2.7f ? 2 : (minorCivRatio > 1.35f ? 1 : 0))))));
        List<Civilization> unassignedCivs = CollectionsKt.toMutableList(CollectionsKt.shuffled((Iterable)civs));
        if (minorCivPerRegion > 0) {
            Iterable $this$forEach$iv = regions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Region it = (Region)element$iv;
                boolean bl = false;
                List civsToAssign = CollectionsKt.take((Iterable)unassignedCivs, minorCivPerRegion);
                it.getAssignedMinorCivs().addAll(civsToAssign);
                unassignedCivs.removeAll(civsToAssign);
            }
        }
        return unassignedCivs;
    }

    private final void tryPlaceMinorCivsInTiles(List<Civilization> civsToPlace, TileMap tileMap, List<Tile> tileList, TileDataMap tileData, Ruleset ruleset) {
        while (!((Collection)tileList).isEmpty() && !((Collection)civsToPlace).isEmpty()) {
            Tile chosenTile = (Tile)CollectionsKt.random((Collection)tileList, Random.Default);
            tileList.remove(chosenTile);
            Object object = tileData.get((Object)chosenTile.getPosition());
            Intrinsics.checkNotNull(object);
            MapGenTileData data = (MapGenTileData)object;
            if (data.getImpacts().containsKey((Object)MapRegions.ImpactType.MinorCiv)) continue;
            Civilization civToAdd = CollectionsKt.first(civsToPlace);
            civsToPlace.remove(civToAdd);
            this.placeMinorCiv(civToAdd, tileMap, chosenTile, tileData, ruleset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean canPlaceMinorCiv(Tile tile, TileDataMap tileData) {
        if (tile.isWater()) return false;
        if (tile.isImpassible()) return false;
        Object object = tileData.get((Object)tile.getPosition());
        Intrinsics.checkNotNull(object);
        if (((MapGenTileData)object).isJunk()) return false;
        Sequence $this$none$iv = IHasUniques.getMatchingUniques$default(tile.getBaseTerrain(), UniqueType.HasQuality, null, 2, null);
        boolean $i$f$none = false;
        Iterator iterator2 = $this$none$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Unique it = (Unique)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getParams().get(0), "Undesirable")) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (SequencesKt.count(tile.getNeighbors()) != 6) return false;
        return true;
    }

    private final void placeMinorCiv(Civilization civ, TileMap tileMap, Tile tile, TileDataMap tileData, Ruleset ruleset) {
        TileMap.addStartingLocation$default(tileMap, civ.getCivID(), tile, null, 4, null);
        tileData.placeImpact(MapRegions.ImpactType.MinorCiv, tile, 4);
        tileData.placeImpact(MapRegions.ImpactType.Luxury, tile, 3);
        tileData.placeImpact(MapRegions.ImpactType.Strategic, tile, 0);
        tileData.placeImpact(MapRegions.ImpactType.Bonus, tile, 3);
        StartNormalizer.INSTANCE.normalizeStart(tile, tileMap, tileData, ruleset, true);
    }
}

