// SPDX-FileCopyrightText: 2024 Manuel Schneider
// SPDX-License-Identifier: MIT

#pragma once

#define ALBERT_PLUGIN_IID "org.albert.PluginInterface/34.0"

///
/// @brief Declare a class as Qt Plugin providing an Albert plugin interface
///
/// For convenience also contains the Q_OBJECT macro, since it is a hard requirement anyway.
///
/// Sets the interface identifier to #ALBERT_PLUGIN_IID and uses the metadata file named
/// 'metadata.json' located at CMAKE_CURRENT_SOURCE_DIR.
///
/// This macro has to be put into the plugin class body. There must be exactly one occurrence of
/// this macro in the source code for a plugin. The class this macro appears on must be
/// default-constructible and inherit \ref albert::PluginInstance.
///
#define ALBERT_PLUGIN Q_OBJECT Q_PLUGIN_METADATA(IID ALBERT_PLUGIN_IID FILE "metadata.json")
