// WARNING! All changes made in this file will be lost!
// Created from 'chat_helpers.style' by 'codegen_style'
//
// This file is part of Desktop App Toolkit,
// a set of libraries for developing nice desktop applications.
//
// For license and copyright information please follow this link:
// https://github.com/desktop-app/legal/blob/master/LEGAL
//
#pragma once

#include "ui/style/style_core.h"

#include "styles/style_widgets.h"
#include "styles/style_basic.h"
#include "styles/style_premium.h"

namespace style {
namespace internal {

void init_style_chat_helpers(int scale);

} // namespace internal

struct TextStyle;
struct Menu;
struct RoundButton;
struct FlatLabel;
struct IconButton;
struct SettingsSlider;
struct PeerListItem;
struct ScrollArea;
struct PanelAnimation;
struct CrossButton;
struct InputField;
struct Toast;
struct InnerDropdown;
struct TextPalette;
struct FlatButton;
struct UserpicButton;
struct TwoIconButton;
struct QuoteStyle;
struct IconButtonWithText;
struct ImportantTooltip;
struct SettingsButton;
struct InfiniteRadialAnimation;
struct PeerList;
struct Box;

struct GroupCallUserpics {
	int size;
	int shift;
	int stroke;
	style::align align;
};

struct TabbedSearch {
	style::color outer;
	style::color bg;
	style::color bgActive;
	style::color fg;
	style::color fgActive;
	style::icon fadeLeft;
	style::icon fadeRight;
	style::InputField field;
	style::IconButton search;
	style::IconButton back;
	style::CrossButton cancel;
	int defaultFieldWidth;
	int groupWidth;
	int groupSkip;
	int height;
};

struct ComposeIcons {
	style::icon settings;
	style::icon collectibles;
	style::icon recent;
	style::icon recentActive;
	style::icon people;
	style::icon peopleActive;
	style::icon nature;
	style::icon natureActive;
	style::icon food;
	style::icon foodActive;
	style::icon activity;
	style::icon activityActive;
	style::icon travel;
	style::icon travelActive;
	style::icon objects;
	style::icon objectsActive;
	style::icon symbols;
	style::icon symbolsActive;
	style::icon menuFave;
	style::icon menuUnfave;
	style::icon menuStickerSet;
	style::icon menuRecentRemove;
	style::icon menuGifAdd;
	style::icon menuGifRemove;
	style::icon menuMute;
	style::icon menuUnmute;
	style::icon menuSchedule;
	style::icon menuWhenOnline;
	style::icon menuSpoiler;
	style::icon menuSpoilerOff;
	style::icon menuBelow;
	style::icon menuAbove;
	style::icon menuPrice;
	style::icon menuEditStars;
	style::icon stripBubble;
	style::icon stripExpandPanel;
	style::icon stripExpandDropdown;
};

struct EmojiSuggestions {
	style::InnerDropdown dropdown;
	style::color bg;
	style::color overBg;
	style::color textFg;
	style::icon fadeLeft;
	style::icon fadeRight;
};

struct EmojiPan {
	style::margins margin;
	style::margins padding;
	style::PanelAnimation showAnimation;
	int desiredSize;
	int verticalSizeSub;
	int header;
	int headerLeft;
	int headerLockLeft;
	int headerLockedLeft;
	int headerTop;
	int footer;
	int iconSkip;
	int iconWidth;
	int iconArea;
	style::color bg;
	style::color headerFg;
	style::color trendingHeaderFg;
	style::color trendingSubheaderFg;
	style::color trendingUnreadFg;
	style::color overBg;
	style::color pathBg;
	style::color pathFg;
	style::color textFg;
	style::color categoriesBg;
	style::color categoriesBgOver;
	style::icon fadeLeft;
	style::icon fadeRight;
	style::PopupMenu menu;
	style::MenuSeparator expandedSeparator;
	style::SettingsSlider tabs;
	style::TabbedSearch search;
	style::margins searchMargin;
	style::IconButton colorAll;
	style::FlatLabel colorAllLabel;
	style::IconButton removeSet;
	style::FlatLabel boxLabel;
	style::ComposeIcons icons;
	style::FlatLabel about;
	style::margins aboutPadding;
	int autocompleteBottomSkip;
};

struct MessageBar {
	style::TextStyle title;
	style::color titleFg;
	style::TextStyle text;
	style::color textFg;
	style::TextPalette textPalette;
	int duration;
};

struct EmojiButton {
	style::IconButton inner;
	style::color bg;
	style::color lineFg;
	style::color lineFgOver;
};

struct SendButton {
	style::point sendIconPosition;
	int sendIconFillPadding;
	style::IconButton inner;
	style::RoundButton stars;
	style::icon record;
	style::icon recordOver;
	style::icon round;
	style::icon roundOver;
	style::color sendDisabledFg;
};

struct RecordBarLock {
	style::RippleAnimation ripple;
	style::icon originTop;
	style::icon originBottom;
	style::icon originBody;
	style::icon shadowTop;
	style::icon shadowBottom;
	style::icon shadowBody;
	style::icon arrow;
	style::color fg;
};

struct RecordBar {
	int radius;
	style::color bg;
	style::color durationFg;
	style::color cancel;
	style::color cancelActive;
	style::RippleAnimation cancelRipple;
	style::RecordBarLock lock;
	style::IconButton remove;
};

struct ComposeFiles {
	style::Check check;
	style::Checkbox checkbox;
	style::IconButton menu;
	style::InputField caption;
	style::EmojiButton emoji;
	style::color confirmBg;
	style::IconButton buttonFile;
	style::icon buttonFileEdit;
	style::icon buttonFileDelete;
	style::color iconBg;
	style::icon iconPlay;
	style::icon iconImage;
	style::icon iconDocument;
	style::color nameFg;
	style::color statusFg;
};

struct SendAsButton {
	int width;
	int height;
	int size;
	style::color activeBg;
	style::color activeFg;
	style::CrossAnimation cross;
	int duration;
};

struct ChooseSendAs {
	style::SendAsButton button;
	style::FlatLabel label;
	style::PeerList list;
};

struct ComposeControls {
	style::color bg;
	int radius;
	style::margins padding;
	style::InputField field;
	int fieldLeft;
	style::SendButton send;
	style::IconButton attach;
	style::EmojiButton emoji;
	style::IconButton like;
	style::icon liked;
	style::IconButton editStars;
	style::IconButton commentsShow;
	style::icon commentsShown;
	int commentsSkip;
	int commentsUnreadSize;
	int commentsUnreadMargin;
	style::point commentsUnreadPosition;
	style::RoundButton starsReactionCounter;
	int starsSkip;
	style::EmojiSuggestions suggestions;
	style::EmojiPan tabbed;
	int tabbedHeightMin;
	int tabbedHeightMax;
	style::RecordBar record;
	style::ComposeFiles files;
	style::PremiumLimits premium;
	style::InputField boxField;
	style::FlatLabel restrictionLabel;
	style::ComposePremiumRequired premiumRequired;
	style::ChooseSendAs chooseSendAs;
};

struct ReportBox {
	style::SettingsButton button;
	style::SettingsButton noIconButton;
	style::FlatLabel label;
	style::InputField field;
	style::DividerLabel divider;
	style::icon spam;
	style::icon fake;
	style::icon violence;
	style::icon children;
	style::icon pornography;
	style::icon copyright;
	style::icon drugs;
	style::icon personal;
	style::icon other;
};

struct WhoRead {
	style::GroupCallUserpics userpics;
	int photoLeft;
	int photoSize;
	int photoSkip;
	int nameLeft;
	style::point iconPosition;
	style::margins itemPadding;
};

} // namespace style

namespace st {
extern const style::WhoRead &defaultWhoRead;
extern const style::TextStyle &whenReadStyle;
extern const style::margins &whenReadPadding;
extern const style::point &whenReadIconPosition;
extern const int &whenReadSkip;
extern const style::margins &whenReadShowPadding;
extern const style::Menu &whoSentItem;
extern const style::RoundButton &switchPmButton;
extern const style::FlatLabel &stickersRestrictedLabel;
extern const int &stickersTrendingHeader;
extern const int &stickersTrendingSkip;
extern const style::font &stickersTrendingHeaderFont;
extern const style::color &stickersTrendingHeaderFg;
extern const int &stickersTrendingHeaderTop;
extern const style::font &stickersTrendingSubheaderFont;
extern const style::color &stickersTrendingSubheaderFg;
extern const int &stickersTrendingSubheaderTop;
extern const style::font &stickersHeaderBadgeFont;
extern const int &stickersHeaderBadgeFontTop;
extern const int &stickersHeaderBadgeFontSkip;
extern const int &emojiPanButtonRight;
extern const int &emojiPanButtonTop;
extern const style::RoundButton &emojiPanButton;
extern const style::RoundButton &emojiPanExpand;
extern const int &stickersTrendingAddTop;
extern const style::RoundButton &stickersTrendingAdd;
extern const style::RoundButton &stickersTrendingInstalled;
extern const style::IconButton &stickersRemove;
extern const style::RoundButton &stickersUndoRemove;
extern const int &stickersRemoveSkip;
extern const style::icon &stickersReorderIcon;
extern const int &stickersReorderSkip;
extern const style::SettingsSlider &stickersTabs;
extern const style::PeerListItem &stickersRowItem;
extern const int &stickerEmojiSkip;
extern const style::font &stickersFeaturedBadgeFont;
extern const int &stickersFeaturedBadgeSize;
extern const int &stickersFeaturedBadgeTextTop;
extern const int &stickersFeaturedBadgePadding;
extern const int &stickersFeaturedBadgeSkip;
extern const int &stickersFeaturedBadgeTop;
extern const style::color &stickersFeaturedUnreadBg;
extern const int &stickersFeaturedUnreadSize;
extern const int &stickersFeaturedUnreadSkip;
extern const int &stickersFeaturedUnreadTop;
extern const int &stickersMaxHeight;
extern const style::margins &stickersPadding;
extern const style::size &stickersSize;
extern const style::margins &emojiSetPadding;
extern const int &emojiSetMaxHeight;
extern const style::size &emojiSetSize;
extern const style::ScrollArea &stickersScroll;
constexpr double stickersRowDisabledOpacity = 0.4;
constexpr int stickersRowDuration = 200;
extern const style::icon &emojiStatusDefault;
extern const style::IconButton &filtersRemove;
extern const style::margins &emojiPanMargins;
extern const style::SettingsSlider &emojiTabs;
extern const int &emojiCategoryIconTop;
extern const style::PanelAnimation &emojiPanAnimation;
extern const int &emojiPanWidth;
extern const int &emojiPanMinHeight;
extern const int &emojiPanMaxHeight;
constexpr double emojiPanHeightRatio = 0.75;
constexpr int emojiPanShowDuration = 200;
constexpr int emojiPanDuration = 200;
extern const style::color &emojiPanHover;
constexpr int emojiPanSlideDuration = 200;
extern const style::size &emojiPanArea;
extern const int &emojiPanRadius;
extern const style::margins &emojiPanReactionsPreviewPadding;
extern const int &emojiPanEmojiPreviewMinHeight;
extern const int &emojiPanEmojiPreviewRadius;
extern const style::CrossButton &defaultTabbedSearchCancel;
extern const style::InputField &defaultTabbedSearchField;
extern const style::IconButton &defaultTabbedSearchButton;
extern const style::IconButton &defaultTabbedSearchBack;
extern const style::TabbedSearch &defaultTabbedSearch;
extern const int &inlineResultsMinHeight;
extern const int &inlineResultsMaxHeight;
extern const style::font &emojiPanHeaderFont;
extern const int &emojiPanRemoveSkip;
extern const int &emojiPanRemoveTop;
extern const int &emojiPanColorAllSkip;
extern const int &emojiColorsPadding;
extern const int &emojiColorsSep;
extern const style::color &emojiColorsSepColor;
extern const int &emojiIconSelectSkip;
extern const style::icon &emojiPremiumRequired;
extern const style::IconButton &hashtagClose;
extern const int &stickerPanWidthMin;
extern const style::size &stickerPanSize;
extern const int &stickerEffectWidthMin;
extern const int &stickerPanPadding;
extern const style::icon &stickerPanDeleteIconBg;
extern const style::icon &stickerPanDeleteIconFg;
constexpr double stickerPanDeleteOpacityBg = 0.3;
constexpr double stickerPanDeleteOpacityBgOver = 0.5;
constexpr double stickerPanDeleteOpacityFg = 0.8;
constexpr double stickerPanDeleteOpacityFgOver = 1;
extern const style::IconButton &stickerPanRemoveSet;
constexpr int stickerIconMove = 400;
constexpr int stickerPreviewDuration = 150;
constexpr double stickerPreviewMin = 0.1;
extern const style::IconButton &emojiPanColorAll;
extern const style::FlatLabel &emojiPanColorAllLabel;
extern const style::margins &emojiPanColorAllPadding;
extern const int &stickerGroupCategorySize;
extern const style::TextStyle &stickerGroupCategoryAbout;
extern const style::margins &stickerGroupCategoryAddMargin;
extern const style::RoundButton &stickerGroupCategoryAdd;
extern const style::Toast &stickersToast;
extern const style::icon &stickersEmpty;
extern const style::icon &emojiEmpty;
extern const int &editMediaButtonSize;
extern const style::icon &editMediaButtonIconFile;
extern const style::IconButton &editMediaButton;
extern const int &sendBoxAlbumGroupEditInternalSkip;
extern const int &sendBoxAlbumGroupSkipRight;
extern const int &sendBoxAlbumGroupSkipTop;
extern const int &sendBoxAlbumGroupRadius;
extern const style::size &sendBoxAlbumGroupSize;
extern const style::size &sendBoxAlbumGroupSizeVertical;
extern const style::size &sendBoxAlbumSmallGroupSize;
extern const int &sendBoxFileGroupSkipTop;
extern const int &sendBoxFileGroupSkipRight;
extern const int &sendBoxFileGroupEditInternalSkip;
extern const style::IconButton &sendBoxAlbumGroupButtonFile;
extern const style::icon &sendBoxAlbumGroupEditButtonIconFile;
extern const style::icon &sendBoxAlbumGroupDeleteButtonIconFile;
extern const style::icon &sendBoxAlbumButtonMediaEdit;
extern const style::icon &sendBoxAlbumGroupButtonMediaEdit;
extern const style::icon &sendBoxAlbumGroupButtonMediaDelete;
extern const style::ComposeIcons &defaultComposeIcons;
extern const style::FlatLabel &defaultEmojiPanAbout;
extern const style::EmojiPan &defaultEmojiPan;
extern const style::EmojiPan &statusEmojiPan;
extern const style::EmojiPan &backgroundEmojiPan;
extern const style::ScrollArea &inlineBotsScroll;
extern const style::margins &gifsPadding;
extern const style::InnerDropdown &emojiSuggestionsDropdown;
extern const int &emojiSuggestionSize;
extern const int &emojiSuggestionsScrolledWidth;
extern const style::margins &emojiSuggestionsPadding;
extern const int &emojiSuggestionsFadeAfter;
extern const style::EmojiSuggestions &defaultEmojiSuggestions;
extern const int &mentionHeight;
extern const style::margins &mentionPadding;
extern const int &mentionTop;
extern const style::font &mentionFont;
extern const style::color &mentionNameFg;
extern const style::color &mentionNameFgOver;
extern const int &mentionPhotoSize;
extern const style::color &mentionBg;
extern const style::color &mentionBgOver;
extern const style::color &mentionFg;
extern const style::color &mentionFgOver;
extern const style::color &mentionFgActive;
extern const style::color &mentionFgOverActive;
extern const style::margins &autocompleteSearchPadding;
extern const style::margins &autocompleteRowPadding;
extern const style::TextStyle &autocompleteRowTitle;
extern const style::TextStyle &autocompleteRowKeys;
extern const style::TextStyle &autocompleteRowAnswer;
extern const int &manageEmojiPreview;
extern const int &manageEmojiPreviewWidth;
extern const int &manageEmojiPreviewHeight;
extern const style::margins &manageEmojiPreviewPadding;
extern const int &manageEmojiMarginRight;
extern const int &manageEmojiNameTop;
extern const int &manageEmojiStatusTop;
extern const int &inlineRadialSize;
extern const int &inlineFileSize;
extern const int &inlineResultsLeft;
extern const int &inlineResultsSkip;
extern const int &inlineMediaHeight;
extern const int &inlineThumbSize;
extern const int &inlineThumbSkip;
extern const style::color &inlineTitleFg;
extern const style::color &inlineDescriptionFg;
extern const int &inlineRowMargin;
extern const int &inlineRowBorder;
extern const style::color &inlineRowBorderFg;
extern const int &inlineRowFileNameTop;
extern const int &inlineRowFileDescriptionTop;
extern const int &inlineResultsMinWidth;
extern const int &inlineDurationMargin;
extern const style::icon &stickersPremiumLock;
extern const style::icon &emojiPremiumLock;
extern const style::margins &reactStripExtend;
extern const int &reactStripHeight;
extern const int &reactStripSize;
extern const int &reactStripMinWidth;
extern const int &reactStripImage;
extern const int &reactStripSkip;
extern const int &reactStripBubbleRight;
extern const style::EmojiPan &userpicBuilderEmojiPan;
extern const style::EmojiPan &reactPanelEmojiPan;
extern const style::ScrollArea &emojiScroll;
extern const style::ScrollArea &reactPanelScroll;
extern const style::ScrollArea &reactPanelScrollRounded;
extern const int &selfForwardsTaggerStripSkip;
extern const style::size &selfForwardsTaggerIcon;
extern const style::Toast &selfForwardsTaggerToast;
extern const style::Toast &joinChatAddToFilterToast;
extern const style::IconButton &joinChatAddToFilterToastButton;
extern const style::icon &choosePeerGroupIcon;
extern const style::icon &choosePeerChannelIcon;
extern const int &choosePeerCreateIconLeft;
extern const style::GroupCallUserpics &historyRequestsUserpics;
extern const int &historyRequestsHeight;
extern const style::margins &historySlowmodeCounterMargins;
extern const style::TextPalette &historyComposeAreaPalette;
extern const style::MessageBar &defaultMessageBar;
extern const style::FlatButton &historyComposeButton;
extern const style::FlatLabel &historyComposeButtonText;
extern const style::IconButton &historyGiftToChannel;
extern const style::IconButton &historyDirectMessage;
extern const style::FlatButton &historyUnblock;
extern const style::FlatButton &historyContactStatusButton;
extern const style::FlatButton &historyContactStatusBlock;
extern const style::FlatLabel &historyContactStatusLabel;
extern const style::FlatLabel &historyEmojiStatusInfoLabel;
extern const int &historyContactStatusMinSkip;
extern const style::UserpicButton &historyBusinessBotPhoto;
extern const style::FlatLabel &historyBusinessBotName;
extern const style::FlatLabel &historyBusinessBotStatus;
extern const style::RoundButton &historyBusinessBotToggle;
extern const style::IconButton &historyBusinessBotSettings;
extern const style::FlatLabel &paysStatusLabel;
extern const style::icon &historyReplyCancelIcon;
extern const style::icon &historyReplyCancelIconOver;
extern const int &historyReplySkip;
extern const style::color &historyReplyNameFg;
extern const int &historyReplyHeight;
extern const style::point &historyReplyIconPosition;
extern const style::icon &historyReplyIcon;
extern const style::icon &historyLinkIcon;
extern const style::icon &historyQuoteIcon;
extern const style::icon &historyForwardIcon;
extern const style::icon &historyEditIcon;
extern const style::IconButton &historyReplyCancel;
extern const style::IconButton &historyPinnedShowAll;
extern const style::RoundButton &historyPinnedBotButton;
extern const style::FlatLabel &historyPinnedBotLabel;
extern const int &historyPinnedBotButtonMaxWidth;
extern const style::point &historyToDownPosition;
extern const style::icon &historyToDownAbove;
extern const style::icon &historyToDownAboveOver;
extern const int &historyToDownPaddingTop;
extern const style::icon &historyToDownBelow;
extern const style::icon &historyToDownBelowOver;
extern const style::TwoIconButton &historyToDown;
extern const style::font &historyToDownBadgeFont;
extern const int &historyToDownBadgeSize;
extern const int &historyToDownShownAfter;
constexpr int historyToDownDuration = 150;
extern const style::icon &dialogsToUpAbove;
extern const style::icon &dialogsToUpAboveOver;
extern const style::TwoIconButton &dialogsToUp;
extern const style::TwoIconButton &historyUnreadMentions;
extern const style::TwoIconButton &historyUnreadReactions;
extern const int &historyUnreadThingsSkip;
extern const style::QuoteStyle &historyQuoteStyle;
extern const style::TextStyle &historyTextStyle;
extern const style::InputField &historyComposeField;
extern const int &historyComposeFieldMaxHeight;
extern const int &historyComposeFieldFadeHeight;
extern const int &historySendRight;
extern const int &historySendPadding;
extern const style::IconButton &historyAttach;
extern const style::IconButtonWithText &historyMessagesTTL;
extern const style::IconButton &historyReplaceMedia;
extern const style::IconButton &historyAddMedia;
extern const style::icon &historyAttachEmojiActive;
extern const style::size &historyEmojiCircle;
constexpr double historyEmojiCircleLine = 1.5;
extern const style::color &historyEmojiCircleFg;
extern const style::color &historyEmojiCircleFgOver;
extern const style::IconButton &historyBotKeyboardShow;
extern const style::IconButton &historyBotKeyboardHide;
extern const style::IconButton &historyBotCommandStart;
extern const style::IconButton &historyScheduledToggle;
extern const style::IconButton &historyGiftToUser;
extern const style::IconButton &historySuggestPostToggle;
extern const style::point &historySuggestIconPosition;
extern const style::icon &historySuggestIconActive;
extern const style::InputField &suggestOptionsPrice;
extern const style::IconButton &historyAttachEmojiInner;
extern const style::EmojiButton &historyAttachEmoji;
extern const style::EmojiButton &boxAttachEmoji;
extern const int &boxAttachEmojiTop;
extern const style::icon &historySendIcon;
extern const style::icon &historySendIconOver;
extern const style::size &historySendSize;
extern const style::icon &historyScheduleIcon;
extern const style::point &historyScheduleIconPosition;
extern const style::icon &historyEditSaveIcon;
extern const style::icon &historyEditSaveIconOver;
extern const style::color &historyEditMediaBg;
extern const style::icon &historyEditMedia;
extern const int &historyMessagesTTLPickerHeight;
extern const int &historyMessagesTTLPickerItemHeight;
extern const style::FlatLabel &historyMessagesTTLLabel;
extern const style::FlatLabel &historyCharsLimitationLabel;
extern const style::color &historyRecordVoiceFg;
extern const style::color &historyRecordVoiceFgOver;
extern const style::color &historyRecordVoiceFgInactive;
extern const style::color &historyRecordVoiceFgActive;
extern const style::color &historyRecordVoiceFgActiveIcon;
extern const style::icon &historyRecordVoice;
extern const style::icon &historyRecordVoiceOver;
extern const style::icon &historyRecordVoiceOnceBg;
extern const style::icon &historyRecordVoiceOnceBgOver;
extern const style::icon &historyRecordVoiceOnceFg;
extern const style::icon &historyRecordVoiceOnceFgOver;
extern const style::icon &historyRecordVoiceOnceInactive;
extern const style::icon &historyRecordVoiceActive;
extern const style::icon &historyRecordRound;
extern const style::icon &historyRecordRoundOver;
extern const style::icon &historyRecordRoundActive;
extern const style::point &historyRecordRoundIconPosition;
extern const style::point &historyRecordSendIconPosition;
extern const style::color &historyRecordVoiceRippleBgActive;
extern const int &historyRecordSignalRadius;
extern const style::color &historyRecordCancel;
extern const style::color &historyRecordCancelActive;
extern const style::font &historyRecordFont;
extern const int &historyRecordDurationSkip;
extern const style::color &historyRecordDurationFg;
extern const int &historyRecordTTLLineWidth;
extern const int &historyRecordMainBlobMinRadius;
extern const int &historyRecordMainBlobMaxRadius;
extern const int &historyRecordMinorBlobMinRadius;
extern const int &historyRecordMinorBlobMaxRadius;
extern const int &historyRecordMajorBlobMinRadius;
extern const int &historyRecordMajorBlobMaxRadius;
extern const style::TextStyle &historyRecordTextStyle;
extern const int &historyRecordTextWidthForWrap;
extern const int &historyRecordTextLeft;
extern const int &historyRecordTextRight;
constexpr int historyRecordLockShowDuration = 150;
extern const style::size &historyRecordLockSize;
extern const style::size &historyRecordLockIconSize;
extern const int &historyRecordLockIconBottomHeight;
extern const int &historyRecordLockIconLineHeight;
extern const int &historyRecordLockIconLineSkip;
extern const int &historyRecordLockIconLineWidth;
extern const int &historyRecordLockIconArcHeight;
extern const int &historyRecordStopIconWidth;
extern const style::icon &historyRecordLockTopShadow;
extern const style::icon &historyRecordLockTop;
extern const style::icon &historyRecordLockBottomShadow;
extern const style::icon &historyRecordLockBottom;
extern const style::icon &historyRecordLockBodyShadow;
extern const style::icon &historyRecordLockBody;
extern const style::margins &historyRecordLockMargin;
extern const style::icon &historyRecordLockArrow;
extern const style::icon &historyRecordLockInput;
extern const style::icon &historyRecordLockRound;
extern const style::margins &historyRecordLockRippleMargin;
extern const style::IconButton &historyRecordDelete;
extern const int &historyRecordWaveformRightSkip;
extern const style::margins &historyRecordWaveformBgMargins;
extern const int &historyRecordWaveformBar;
extern const style::point &historyRecordLockPosition;
extern const int &historyRecordCancelButtonWidth;
extern const style::color &historyRecordCancelButtonFg;
extern const int &historyRecordTooltipSkip;
extern const style::ImportantTooltip &historyRecordTooltip;
extern const style::IconButton &historySilentToggle;
extern const style::icon &historySilentToggleOn;
extern const style::icon &historySilentToggleOnOver;
extern const style::RecordBarLock &defaultRecordBarLock;
extern const style::RecordBar &defaultRecordBar;
extern const style::SendButton &historySend;
extern const style::IconButton &defaultComposeFilesMenu;
extern const style::InputField &defaultComposeFilesField;
extern const style::ComposeFiles &defaultComposeFiles;
extern const style::FlatLabel &defaultRestrictionLabel;
extern const style::SendAsButton &defaultSendAsButton;
extern const style::ChooseSendAs &defaultChooseSendAs;
extern const style::ComposeControls &defaultComposeControls;
extern const int &moreChatsBarHeight;
extern const style::point &moreChatsBarTextPosition;
extern const style::point &moreChatsBarStatusPosition;
extern const style::IconButton &moreChatsBarClose;
extern const int &reportReasonTopSkip;
extern const style::SettingsButton &reportReasonButton;
extern const style::ReportBox &defaultReportBox;
extern const style::font &dragFont;
extern const style::font &dragSubfont;
extern const style::color &dragColor;
extern const style::color &dragDropColor;
extern const style::margins &dragMargin;
extern const style::margins &dragPadding;
extern const int &dragHeight;
extern const style::FlatLabel &ttlMediaImportantTooltipLabel;
extern const style::RoundButton &ttlMediaButton;
extern const int &ttlMediaButtonBottomSkip;
extern const style::FlatLabel &editTagAbout;
extern const style::InputField &editTagField;
extern const style::InputField &editStickerSetNameField;
extern const style::InfiniteRadialAnimation &editStickerSetNameLoading;
extern const style::icon &paidStarIcon;
extern const int &paidStarIconTop;
extern const style::FlatLabel &paidAmountAbout;
extern const style::FlatLabel &paidTagLabel;
extern const style::margins &paidTagPadding;
extern const style::size &pickLocationWindow;
extern const int &pickLocationMapHeight;
extern const int &pickLocationCollapsedHeight;
extern const int &pickLocationRowHeight;
extern const style::FlatButton &pickLocationButton;
extern const style::FlatLabel &pickLocationButtonText;
extern const style::FlatLabel &pickLocationButtonStatus;
extern const int &pickLocationButtonSkip;
extern const style::icon &pickLocationSendIcon;
extern const style::PeerListItem &pickLocationVenueItem;
extern const style::PeerList &pickLocationVenueList;
extern const int &pickLocationIconSkip;
extern const style::InfiniteRadialAnimation &pickLocationLoading;
extern const int &pickLocationPromoHeight;
extern const style::RoundButton &pickLocationChooseOnMap;
extern const style::Box &sendGifBox;
extern const int &processingVideoTipMaxWidth;
extern const int &processingVideoTipShift;
extern const style::Toast &processingVideoToast;
extern const int &processingVideoPreviewSkip;
extern const style::RoundButton &processingVideoView;
extern const style::FlatLabel &frozenBarTitle;
extern const style::FlatLabel &frozenRestrictionTitle;
extern const style::FlatLabel &frozenBarSubtitle;
extern const style::FlatLabel &frozenRestrictionSubtitle;
extern const style::Box &frozenInfoBox;
extern const style::margins &menuTranscribeItemPadding;
extern const style::IconButton &menuTranscribeDummyButton;
extern const style::font &roundVideoFont;
} // namespace st
