# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_bcachefs_global_optspecs
	string join \n h/help
end

function __fish_bcachefs_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_bcachefs_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_bcachefs_using_subcommand
	set -l cmd (__fish_bcachefs_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c bcachefs -n "__fish_bcachefs_needs_command" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "list" -d 'List filesystem metadata in textual form'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "mount" -d 'Mount a bcachefs filesystem by its UUID'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "subvolume" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "subvol" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "set-file-option" -d 'Set attributes on files in a bcachefs filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "reflink-option-propagate" -d 'Propagate IO options to reflinked extents'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "reset-counters" -d 'Reset filesystem counters'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "version" -d 'Display version'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "data" -d 'Manage filesystem data'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "device" -d 'Manage devices within a filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "dump" -d 'Dump filesystem metadata to a qcow2 image'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "format" -d 'Format a new filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "mkfs" -d 'Format a new filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "fs" -d 'Manage a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "fsck" -d 'Check an existing filesystem for errors'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "image" -d 'Filesystem image commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "migrate" -d 'Migrate an existing ext2/3/4 filesystem to bcachefs in place'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "reconcile" -d 'Reconcile filesystem data'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "recovery-pass" -d 'Run a specific recovery pass'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "set-fs-option" -d 'Set a filesystem option'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "set-passphrase" -d 'Change passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "remove-passphrase" -d 'Remove passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "show-super" -d 'Print superblock information to stdout'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "unlock" -d 'Unlock an encrypted filesystem prior to running/mounting'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s m -l mode -r -f -a "{keys\t'',formats\t'',nodes\t'',nodes-ondisk\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s b -l btree -d 'Btree to list from' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s k -l bkey-type -d 'Bkey type to list' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s l -l level -d 'Btree depth to descend to (0 == leaves)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s s -l start -d 'Start position to list from' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s e -l end -d 'End position' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s c -l colorize -d 'Force color on/off. Default: autodetect tty' -r -f -a "{true\t'',false\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s f -l fsck -d 'Check (fsck) the filesystem first'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s v -l verbose -d 'Verbose mode'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s f -l passphrase-file -d 'Path to passphrase file' -r -F
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s k -l key_location -d 'Passphrase policy to use in case of an encrypted filesystem. If not specified, the password will be searched for in the keyring. If not found, the password will be prompted or read from stdin, depending on whether the stdin is connected to a terminal or not' -r -f -a "{fail\t'Don\'t ask for passphrase, if the key cannot be found in the keyring just fail',wait\t'Wait for passphrase to become available before mounting',ask\t'Interactively prompt the user for a passphrase',stdin\t'Try to read the passphrase from `stdin` without prompting'}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s o -d 'Mount options' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s t -l type -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s c -l colorize -d 'Force color on/off. Autodetect tty is used to define default:' -r -f -a "{true\t'',false\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s v -l verbose -d 'Verbose mode'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s V -l version -d 'Print version'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand completions" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "new"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "del"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snap"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from del" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snapshot" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snapshot" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snap" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "list"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "new"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "del"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snap"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from del" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snapshot" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snapshot" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snap" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "list"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l data_replicas -l data-replicas -d 'Number of data replicas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l data_checksum -l data-checksum -r -f -a "{none\t'',crc32c\t'',crc64\t'',xxhash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l background_compression -l background-compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l foreground_target -l foreground-target -d 'Device or label for foreground writes' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l background_target -l background-target -d 'Device or label to move data to in the background' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l promote_target -l promote-target -d 'Device or label to promote data to on read' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l erasure_code -l erasure-code -d 'Enable erasure coding (DO NOT USE YET)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l casefold -d 'Dirent lookups are casefolded' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l inodes_32bit -l inodes-32bit -d 'Constrain inode numbers to 32 bits' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l project -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l nocow -d 'Nocow mode: Writes will be done in place when possible. Snapshots and reflink will still caused writes to be COW Implicitly disables data checksumming, compression and encryption' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l remove-all -d 'Remove all file options'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reflink-option-propagate" -l set-may-update -d 'Enable option propagation on old reflink_p extents that predate the may_update_options flag. Requires CAP_SYS_ADMIN. Only needed once per file for filesystems with reflinks created before the flag was introduced.'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reflink-option-propagate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reset-counters" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand version" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and not __fish_seen_subcommand_from scrub help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and not __fish_seen_subcommand_from scrub help" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and not __fish_seen_subcommand_from scrub help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from scrub" -s m -l metadata -d 'Check metadata only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from scrub" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from help" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "online" -d 'Re-add a device to a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "offline" -d 'Take a device offline, without removing it'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "remove" -d 'Remove a device from a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "evacuate" -d 'Migrate data off a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "set-state" -d 'Change the state of a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "resize" -d 'Resize the filesystem on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "resize-journal" -d 'Resize the journal on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from online offline remove evacuate set-state resize resize-journal help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from online" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from offline" -s f -l force -d 'Force, if data redundancy will be degraded'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from offline" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from remove" -s f -l force -d 'Force removal, even if some data couldn\'t be migrated'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from remove" -s F -l force-metadata -d 'Force removal, even if some metadata couldn\'t be migrated'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from evacuate" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from set-state" -s f -l force -d 'Force if data redundancy will be degraded'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from set-state" -s F -l force-if-data-lost -d 'Force even if data will be lost'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from set-state" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from resize" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from resize-journal" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "online" -d 'Re-add a device to a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "offline" -d 'Take a device offline, without removing it'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a device from a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "evacuate" -d 'Migrate data off a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "set-state" -d 'Change the state of a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "resize" -d 'Resize the filesystem on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "resize-journal" -d 'Resize the journal on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand format" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mkfs" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "usage" -d 'Display detailed filesystem usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "top" -d 'Display runtime performance info'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "timestats" -d 'Display bcachefs time statistics'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -s f -l fields -d 'Comma-separated list of fields' -r -f -a "{replicas\t'',btree\t'',compression\t'',rebalance_work\t'',devices\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -s a -l all -d 'Print all accounting fields'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -s h -l human-readable -d 'Human-readable units'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from top" -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from top" -s h -l human-readable -d 'Human-readable units'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s s -l sort -d 'Sort by column' -r -f -a "{name\t'',count\t'',dur-min\t'',dur-max\t'',dur-total\t'',mean-since\t'',mean-recent\t'',stddev-since\t'',stddev-recent\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s i -l interval -d 'Refresh interval in seconds (interactive mode)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s a -l all -d 'Show stats with zero count'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -l json -d 'Output raw JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -l no-device-stats -d 'Skip per-device IO latency stats'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -l once -d 'One-shot output (no interactive TUI)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "usage" -d 'Display detailed filesystem usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "top" -d 'Display runtime performance info'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "timestats" -d 'Display bcachefs time statistics'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand migrate" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recovery-pass" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-passphrase" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand remove-passphrase" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand show-super" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s k -l keyring -d 'Keyring to add to' -r -f -a "{session\t'',user\t'',user_session\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s f -l file -d 'Passphrase file to read from (disables passphrase prompt)' -r -F
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s c -l check -d 'Check if a device is encrypted'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "list" -d 'List filesystem metadata in textual form'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "mount" -d 'Mount a bcachefs filesystem by its UUID'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "completions" -d 'Generate shell completions'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "subvolume" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "set-file-option" -d 'Set attributes on files in a bcachefs filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "reflink-option-propagate" -d 'Propagate IO options to reflinked extents'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "reset-counters" -d 'Reset filesystem counters'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "version" -d 'Display version'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "data" -d 'Manage filesystem data'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "device" -d 'Manage devices within a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "dump" -d 'Dump filesystem metadata to a qcow2 image'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "format" -d 'Format a new filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "fs" -d 'Manage a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "fsck" -d 'Check an existing filesystem for errors'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "image" -d 'Filesystem image commands'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "migrate" -d 'Migrate an existing ext2/3/4 filesystem to bcachefs in place'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "reconcile" -d 'Reconcile filesystem data'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "recovery-pass" -d 'Run a specific recovery pass'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "set-fs-option" -d 'Set a filesystem option'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "set-passphrase" -d 'Change passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "remove-passphrase" -d 'Remove passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "show-super" -d 'Print superblock information to stdout'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "unlock" -d 'Unlock an encrypted filesystem prior to running/mounting'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image migrate reconcile recovery-pass set-fs-option set-passphrase remove-passphrase show-super unlock help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "create"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "delete"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "snapshot"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "list"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from data" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "online" -d 'Re-add a device to a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "offline" -d 'Take a device offline, without removing it'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "remove" -d 'Remove a device from a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "evacuate" -d 'Migrate data off a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "set-state" -d 'Change the state of a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "resize" -d 'Resize the filesystem on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "resize-journal" -d 'Resize the journal on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from fs" -f -a "usage" -d 'Display detailed filesystem usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from fs" -f -a "top" -d 'Display runtime performance info'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from fs" -f -a "timestats" -d 'Display bcachefs time statistics'
