// Auto-generated from BCH_BKEY_TYPES() — do not edit

pub enum BkeyValC<'a> {
    deleted(&'a c::bch_deleted),
    whiteout(&'a c::bch_whiteout),
    error(&'a c::bch_error),
    cookie(&'a c::bch_cookie),
    hash_whiteout(&'a c::bch_hash_whiteout),
    btree_ptr(&'a c::bch_btree_ptr),
    extent(&'a c::bch_extent),
    reservation(&'a c::bch_reservation),
    inode(&'a c::bch_inode),
    inode_generation(&'a c::bch_inode_generation),
    dirent(&'a c::bch_dirent),
    xattr(&'a c::bch_xattr),
    alloc(&'a c::bch_alloc),
    quota(&'a c::bch_quota),
    stripe(&'a c::bch_stripe),
    reflink_p(&'a c::bch_reflink_p),
    reflink_v(&'a c::bch_reflink_v),
    inline_data(&'a c::bch_inline_data),
    btree_ptr_v2(&'a c::bch_btree_ptr_v2),
    indirect_inline_data(&'a c::bch_indirect_inline_data),
    alloc_v2(&'a c::bch_alloc_v2),
    subvolume(&'a c::bch_subvolume),
    snapshot(&'a c::bch_snapshot),
    inode_v2(&'a c::bch_inode_v2),
    alloc_v3(&'a c::bch_alloc_v3),
    set(&'a c::bch_set),
    lru(&'a c::bch_lru),
    alloc_v4(&'a c::bch_alloc_v4),
    backpointer(&'a c::bch_backpointer),
    inode_v3(&'a c::bch_inode_v3),
    bucket_gens(&'a c::bch_bucket_gens),
    snapshot_tree(&'a c::bch_snapshot_tree),
    logged_op_truncate(&'a c::bch_logged_op_truncate),
    logged_op_finsert(&'a c::bch_logged_op_finsert),
    accounting(&'a c::bch_accounting),
    inode_alloc_cursor(&'a c::bch_inode_alloc_cursor),
    extent_whiteout(&'a c::bch_extent_whiteout),
    unknown(u8),
}

impl<'a> BkeyValC<'a> {
    /// Convert a raw bkey type tag and value reference to a typed variant.
    ///
    /// # Safety
    /// `val` must point to valid data for the bkey type indicated by `type_`.
    #[allow(clippy::missing_transmute_annotations)]
    pub(crate) unsafe fn from_raw(type_: u8, val: &'a c::bch_val) -> Self {
        match type_ as u32 {
            0 => BkeyValC::deleted(std::mem::transmute(val)),
            1 => BkeyValC::whiteout(std::mem::transmute(val)),
            2 => BkeyValC::error(std::mem::transmute(val)),
            3 => BkeyValC::cookie(std::mem::transmute(val)),
            4 => BkeyValC::hash_whiteout(std::mem::transmute(val)),
            5 => BkeyValC::btree_ptr(std::mem::transmute(val)),
            6 => BkeyValC::extent(std::mem::transmute(val)),
            7 => BkeyValC::reservation(std::mem::transmute(val)),
            8 => BkeyValC::inode(std::mem::transmute(val)),
            9 => BkeyValC::inode_generation(std::mem::transmute(val)),
            10 => BkeyValC::dirent(std::mem::transmute(val)),
            11 => BkeyValC::xattr(std::mem::transmute(val)),
            12 => BkeyValC::alloc(std::mem::transmute(val)),
            13 => BkeyValC::quota(std::mem::transmute(val)),
            14 => BkeyValC::stripe(std::mem::transmute(val)),
            15 => BkeyValC::reflink_p(std::mem::transmute(val)),
            16 => BkeyValC::reflink_v(std::mem::transmute(val)),
            17 => BkeyValC::inline_data(std::mem::transmute(val)),
            18 => BkeyValC::btree_ptr_v2(std::mem::transmute(val)),
            19 => BkeyValC::indirect_inline_data(std::mem::transmute(val)),
            20 => BkeyValC::alloc_v2(std::mem::transmute(val)),
            21 => BkeyValC::subvolume(std::mem::transmute(val)),
            22 => BkeyValC::snapshot(std::mem::transmute(val)),
            23 => BkeyValC::inode_v2(std::mem::transmute(val)),
            24 => BkeyValC::alloc_v3(std::mem::transmute(val)),
            25 => BkeyValC::set(std::mem::transmute(val)),
            26 => BkeyValC::lru(std::mem::transmute(val)),
            27 => BkeyValC::alloc_v4(std::mem::transmute(val)),
            28 => BkeyValC::backpointer(std::mem::transmute(val)),
            29 => BkeyValC::inode_v3(std::mem::transmute(val)),
            30 => BkeyValC::bucket_gens(std::mem::transmute(val)),
            31 => BkeyValC::snapshot_tree(std::mem::transmute(val)),
            32 => BkeyValC::logged_op_truncate(std::mem::transmute(val)),
            33 => BkeyValC::logged_op_finsert(std::mem::transmute(val)),
            34 => BkeyValC::accounting(std::mem::transmute(val)),
            35 => BkeyValC::inode_alloc_cursor(std::mem::transmute(val)),
            36 => BkeyValC::extent_whiteout(std::mem::transmute(val)),
            _ => BkeyValC::unknown(type_),
        }
    }
}
